<?php

add_theme_support( 'post-thumbnails' );
add_theme_support( 'menus' );

add_filter('body_class', 'mbe_body_class');

add_action( 'init', 'create_post_type_banner' );
add_action( 'init', 'create_post_type_vantagem' );
add_action('wp_head', 'mbe_wp_head');

add_action('after_setup_theme', 'remove_admin_bar');



remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);

function remove_admin_bar() {
  if (!current_user_can('administrator') && !is_admin()) {
    show_admin_bar(false);
  }
}

add_action('woocommerce_before_main_content', 'my_theme_wrapper_start', 10);
add_action('woocommerce_after_main_content', 'my_theme_wrapper_end', 10);

function my_theme_wrapper_start() {
  echo '<section id="main">';
}

function my_theme_wrapper_end() {
  echo '</section>';
}

add_action( 'after_setup_theme', 'woocommerce_support' );
function woocommerce_support() {
    add_theme_support( 'woocommerce' );
}


/**
 * Sem informações de erro de senha ou login.
 */
add_filter('login_errors',create_function('$a', "return null;"));

/*remove_filter( 'the_content', 'wpautop' );*/
remove_filter( 'the_excerpt', 'wpautop' );

/**
 * Custom more [...]
 */
function custom_excerpt_more($more) {
return '…';
}
add_filter('excerpt_more', 'custom_excerpt_more');

/* custom excerpt ellipses for 2.8-
function custom_excerpt_more($excerpt) {
return str_replace('[...]', '…', $excerpt);
}
add_filter('wp_trim_excerpt', 'custom_excerpt_more');
*/


/**
 * Filters wp_title to print a neat <title> tag based on what is being viewed.
 *
 * @param string $title Default title text for current view.
 * @param string $sep Optional separator.
 * @return string The filtered title.
 */
function theme_name_wp_title( $title, $sep ) {
	if ( is_feed() ) {
		return $title;
	}
	
	global $page, $paged;

	// Add the blog name
	$title .= get_bloginfo( 'name', 'display' );

	// Add the blog description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) ) {
		$title .= " $sep $site_description";
	}

	// Add a page number if necessary:
	if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() ) {
		$title .= " $sep " . sprintf( __( 'Page %s', '_s' ), max( $paged, $page ) );
	}

	return $title;
}
add_filter( 'wp_title', 'theme_name_wp_title', 10, 2 );

add_filter( 'wp_title', 'baw_hack_wp_title_for_home' );
function baw_hack_wp_title_for_home( $title )
{
  if( empty( $title ) && ( is_home() || is_front_page() ) ) {
    return __( 'Home', 'theme_domain' ) . ' | ' . get_bloginfo( 'description' );
  }
  return $title;
}

/**
 * Informações adicionais Autores.
 */

function my_new_contactmethods( $contactmethods ) {
// Add Twitter
$contactmethods['twitter'] = 'Twitter';
//add Facebook
$contactmethods['facebook'] = 'Facebook';

return $contactmethods;
}
add_filter('user_contactmethods','my_new_contactmethods',10,1);


/**
 * This theme uses wp_nav_menu() in four locations.
 */
register_nav_menus( array(
    'social' => __( 'Redes Sociais', 'basics' ),
    'principal' => __( 'Principal', 'basics' ),
    'auxiliar' => __( 'Auxiliar', 'basics' ),
    'mobile' => __( 'Mobile', 'basics' ),
    'rodape' => __( 'Rodapé', 'basics' )

) );


if ( function_exists('register_sidebar') )
register_sidebar(array('name'=>'Interna',
'before_widget' => '',
'after_widget' => '',
'before_title' => '',
'after_title' => '',
));



function wp_infinitepaginate(){
    $cat = $_POST['val'];

    query_posts(array('category_name' => $cat ));
    get_template_part('custom','loop');

    exit;
}

add_action('wp_ajax_infinite_scroll', 'wp_infinitepaginate');           // for logged in user
add_action('wp_ajax_nopriv_infinite_scroll', 'wp_infinitepaginate');    // if user not logged in


/**
 * Custom Excerpt Length.
 */
function my_excerpt($limit) {
	$excerpt = explode(' ', get_the_excerpt(), $limit);
if (count($excerpt)>=$limit) {
array_pop($excerpt);
	$excerpt = implode(" ",$excerpt).'...';
} else {
	$excerpt = implode(" ",$excerpt);
}	
	$excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
return $excerpt;
}
 
function content($limit) {
	$content = explode(' ', get_the_content(), $limit);
if (count($content)>=$limit) {
array_pop($content);
	$content = implode(" ",$content).'...';
} else {
	$content = implode(" ",$content);
}	
$content = preg_replace('/\[.+\]/','', $content);
$content = apply_filters('the_content', $content);
$content = str_replace(']]>', ']]&gt;', $content);
return $content;
}



//CUSTOM CATS

/**
 * Esta é a função que é chamada pelo add_action()
 */
function create_post_type_banner() {

    /**
     * Labels customizados para o tipo de post
     * 
     */
    $labels = array(
      'name' => _x('Banner', 'post type general name'),
      'singular_name' => _x('Banner', 'post type singular name'),
      'add_new' => _x('Adicionar novo', 'banner'),
      'add_new_item' => __('Adicionar novo banner'),
      'edit_item' => __('Editar banner'),
      'new_item' => __('Novo banner'),
      'all_items' => __('Todos banners'),
      'view_item' => __('Ver banner'),
      'search_items' => __('Buscar banners'),
      'not_found' =>  __('Nenhum banner encontrado'),
      'not_found_in_trash' => __('Nenhum banner na lixeira'),
      'parent_item_colon' => '',
      'menu_name' => 'Banners'
    );

    /**
     * Registamos o tipo de post banner através desta função
     * passando-lhe os labels e parâmetros de controlo.
     */
    register_post_type( 'banner', array(
      'labels' => $labels,
      'public' => true,
      'publicly_queryable' => true,
      'show_ui' => true,
      'show_in_menu' => true,
      'has_archive' => 'banners',
      'rewrite' => array(
     'slug' => 'banners',
     'with_front' => false,
      ),
      'capability_type' => 'post',
      'has_archive' => true,
      'hierarchical' => false,
      'menu_position' => null,
      'taxonomies' => array('post_tag'),
      'supports' => array('title','editor', 'custom-fields', 'plugins','author','thumbnail','excerpt','comments')
      )
    );
    
    /**
     * Registamos a categoria de banneres para o tipo de post banner
     */
    register_taxonomy( 'banner_category', array( 'banner' ), array(
        'hierarchical' => true,
        'label' => __( 'banner Category' ),
        'labels' => array( // Labels customizadas
      'name' => _x( 'Categories', 'taxonomy general name' ),
      'singular_name' => _x( 'Category', 'taxonomy singular name' ),
      'search_items' =>  __( 'Search Categories' ),
      'all_items' => __( 'All Categories' ),
      'parent_item' => __( 'Parent Category' ),
      'parent_item_colon' => __( 'Parent Category:' ),
      'edit_item' => __( 'Edit Category' ),
      'update_item' => __( 'Update Category' ),
      'add_new_item' => __( 'Add New Category' ),
      'new_item_name' => __( 'New Category Name' ),
      'menu_name' => __( 'Categoria' ),
  ),
        'show_ui' => true,
        'show_in_tag_cloud' => true,
        'query_var' => true,
        'rewrite' => array(
            'slug' => 'banners/categories',
            'with_front' => false,
        ),
        )
    );
    
    /** 
     * Esta função associa tipos de categorias com tipos de posts.
     * Aqui associamos as tags ao tipo de post banner.
     */
    register_taxonomy_for_object_type( 'tags', 'banners' );
    
}


//CUSTOM CATS

/**
 * Esta é a função que é chamada pelo add_action()
 */
function create_post_type_vantagem() {

    /**
     * Labels customizados para o tipo de post
     * 
     */
    $labels = array(
      'name' => _x('vantagem', 'post type general name'),
      'singular_name' => _x('vantagem', 'post type singular name'),
      'add_new' => _x('Adicionar novo', 'vantagem'),
      'add_new_item' => __('Adicionar novo vantagem'),
      'edit_item' => __('Editar vantagem'),
      'new_item' => __('Novo vantagem'),
      'all_items' => __('Todos vantagens'),
      'view_item' => __('Ver vantagem'),
      'search_items' => __('Buscar vantagens'),
      'not_found' =>  __('Nenhuma vantagem encontrado'),
      'not_found_in_trash' => __('Nenhuma vantagem na lixeira'),
      'parent_item_colon' => '',
      'menu_name' => 'Vantagens'
    );

    /**
     * Registamos o tipo de post vantagem através desta função
     * passando-lhe os labels e parâmetros de controlo.
     */
    register_post_type( 'vantagem', array(
      'labels' => $labels,
      'public' => true,
      'publicly_queryable' => true,
      'show_ui' => true,
      'show_in_menu' => true,
      'has_archive' => 'vantagens',
      'rewrite' => array(
     'slug' => 'vantagens',
     'with_front' => false,
      ),
      'capability_type' => 'post',
      'has_archive' => true,
      'hierarchical' => false,
      'menu_position' => null,
      'taxonomies' => array('post_tag'),
      'supports' => array('title','editor', 'custom-fields', 'plugins','author','thumbnail','excerpt','comments')
      )
    );
    
    /**
     * Registamos a categoria de vantagemes para o tipo de post vantagem
     */
    register_taxonomy( 'vantagem_category', array( 'vantagem' ), array(
        'hierarchical' => true,
        'label' => __( 'vantagem Category' ),
        'labels' => array( // Labels customizadas
      'name' => _x( 'Categories', 'taxonomy general name' ),
      'singular_name' => _x( 'Category', 'taxonomy singular name' ),
      'search_items' =>  __( 'Search Categories' ),
      'all_items' => __( 'All Categories' ),
      'parent_item' => __( 'Parent Category' ),
      'parent_item_colon' => __( 'Parent Category:' ),
      'edit_item' => __( 'Edit Category' ),
      'update_item' => __( 'Update Category' ),
      'add_new_item' => __( 'Add New Category' ),
      'new_item_name' => __( 'New Category Name' ),
      'menu_name' => __( 'Categoria' ),
  ),
        'show_ui' => true,
        'show_in_tag_cloud' => true,
        'query_var' => true,
        'rewrite' => array(
            'slug' => 'vantagens/categories',
            'with_front' => false,
        ),
        )
    );
    
    /** 
     * Esta função associa tipos de categorias com tipos de posts.
     * Aqui associamos as tags ao tipo de post vantagem.
     */
    register_taxonomy_for_object_type( 'tags', 'vantagens' );
    
}


// The following function goes into your functions.php
function get_tag_id_by_name($tag_name) {
  global $wpdb;
  return $wpdb->get_var("SELECT term_id FROM ".$wpdb->terms." WHERE `name` =  '".$tag_name."'");
}

function get_cat_slug($cat_id) {
  $cat_id = (int) $cat_id;
  $category = &get_category($cat_id);
  return $category->slug;
}

function get_category_id($cat_name){
  $term = get_term_by('name', $cat_name, 'category');
  return $term->term_id;
}



function post_pagination($pages = '', $range = 2)
{
     $showitems = ($range * 2)+1;  

     global $paged;
     if(empty($paged)) $paged = 1;

     if($pages == '')
     {
         global $wp_query;
         $pages = $wp_query->max_num_pages;
         if(!$pages)
         {
             $pages = 1;
         }
     }   

     if(1 != $pages)
     {
         echo "<div class='paginacao'><span>P&aacute;ginas</span>";
         if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a href='".get_pagenum_link($paged - 1)."' class='current'>&laquo;</a>";
         if($paged > 6 && $showitems < $pages) echo "<a href='".get_pagenum_link(1)."'>1</a> <span class='current'>...</span>";

         for ($i=1; $i <= $pages; $i++)
         {
             if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
             {
                 echo ($paged == $i)? "<span class='current'>".$i."</span>":"<a href='".get_pagenum_link($i)."' class='inactive' >".$i."</a>";
             }
         }

         if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<span class='current'>...</span> <a href='".get_pagenum_link($pages)."'>$pages</a>";
         if ($paged < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($paged + 1)."' class='current'>&raquo;</a>";
         echo "</div>\n";
     }
}



global $query_string;
global $wp_query;


function mbe_body_class($classes){
    if(is_user_logged_in()){
        $classes[] = 'body-logged-in';
    } else{
        $classes[] = 'body-logged-out';
    }
    return $classes;
}

function mbe_wp_head(){
    echo '<style>'.PHP_EOL;
    echo 'body{ padding-top: 70px !important; }'.PHP_EOL;
    // Using custom CSS class name.
    echo 'body.body-logged-in .navbar-fixed-top{ top: 28px !important; }'.PHP_EOL;
    // Using WordPress default CSS class name.
    echo 'body.logged-in .navbar-fixed-top{ top: 28px !important; }'.PHP_EOL;
    echo '</style>'.PHP_EOL;
}



