<?php
/**
 * The Header.
 *
 * Displays all of the <head>
 *
 * @package smd
 * @since smd 2.0
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>



<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>" />
  <title><?php bloginfo( 'name' ); ?> - <?php bloginfo( 'description' ); ?></title>
  <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
  <meta name="generator" content="WordPress <?php bloginfo( 'version' ); ?>"/>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="description" content="<?php bloginfo( 'description' ); ?>">
  <meta name="author" content="<?php bloginfo( 'author' ); ?>">

  <!-- Le styles -->
  <link rel="stylesheet" href="<?php echo bloginfo('template_directory') . '/css/bootstrap-custom.min.css';?>" type="text/css" media="screen" />
  <link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
  <!-- <link rel="stylesheet" href="<?php bloginfo('stylesheet_url').'/jquery.mCustomScrollbar.css'; ?>" type="text/css" media="screen" /> -->

  <!-- Le HTML5 shim, for IE6-8 support of HTML5 elements -->
  <!--[if lt IE 9]>
  <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
  <![endif]-->

  <!-- css3-mediaqueries.js for IE less than 9 -->
  <!--[if lt IE 9]>
  <script src="http://css3-mediaqueries-js.googlecode.com/svn/trunk/css3-mediaqueries.js"></script>
  <![endif]-->

  <!-- Le fav and touch icons -->
  <link rel="shortcut icon" href="<?php echo bloginfo('template_directory') . '/ico/favicon.ico';?>">

  <!-- js from google -->
  <script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.2/jquery.min.js"></script>

  <script src="<?php echo bloginfo('template_directory') . '/js/jpages-min.js';?>"></script>


  <link rel="apple-touch-icon" sizes="60x60" href="<?php bloginfo('template_directory' ) . '/ico/apple-icon-60x60.png'; ?>">
  <link rel="apple-touch-icon" sizes="72x72" href="<?php bloginfo('template_directory' ) . '/ico/apple-icon-72x72.png'; ?>">
  <link rel="apple-touch-icon" sizes="76x76" href="<?php bloginfo('template_directory' ) . '/ico/apple-icon-76x76.png'; ?>">
  <link rel="apple-touch-icon" sizes="114x114" href="<?php bloginfo('template_directory' ) . '/ico/apple-icon-114x114.png'; ?>">
  <link rel="apple-touch-icon" sizes="120x120" href="<?php bloginfo('template_directory' ) . '/ico/apple-icon-120x120.png'; ?>">
  <link rel="apple-touch-icon" sizes="144x144" href="<?php bloginfo('template_directory' ) . '/ico/apple-icon-144x144.png'; ?>">
  <link rel="apple-touch-icon" sizes="152x152" href="<?php bloginfo('template_directory' ) . '/ico/apple-icon-152x152.png'; ?>">
  <link rel="apple-touch-icon" sizes="180x180" href="<?php bloginfo('template_directory' ) . '/ico/apple-icon-180x180.png'; ?>">
  <link rel="icon" type="image/png" sizes="192x192"  href="<?php bloginfo('template_directory' ) . '/ico/android-icon-192x192.png'; ?>">
  <link rel="icon" type="image/png" sizes="32x32" href="<?php bloginfo('template_directory' ) . '/ico/favicon-32x32.png'; ?>">
  <link rel="icon" type="image/png" sizes="96x96" href="<?php bloginfo('template_directory' ) . '/ico/favicon-96x96.png'; ?>">
  <link rel="icon" type="image/png" sizes="16x16" href="<?php bloginfo('template_directory' ) . '/ico/favicon-16x16.png'; ?>">
  <link rel="manifest" href="<?php bloginfo('template_directory' ) . '/ico/manifest.json'; ?>">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="msapplication-TileImage" content="<?php bloginfo('template_directory' ) . '/ico//ms-icon-144x144.png'; ?>">
  <meta name="theme-color" content="#ffffff">


  <!-- /.Js for css nth-child/last-child selectors on Ie8/7 -->
  <script src="<?php echo bloginfo('template_directory') . '/js/select.js';?>"></script>
  <!--[if (gte IE 6)&(lte IE 8)]>
  <script type="text/javascript" src="<?php echo bloginfo('template_directory') . '/js/select.js';?>"></script>
  <noscript><link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" /></noscript>
  <![endif]-->
   
  <link href='http://fonts.googleapis.com/css?family=Roboto:400,500,700' rel='stylesheet' type='text/css'>

  <script src="<?php echo bloginfo('template_directory') . '/js/bootstrap-tooltip.min.js';?>"></script>
  <script src="<?php echo bloginfo('template_directory') . '/js/bootstrap-popover.min.js';?>"></script>

  <script src='https://www.google.com/recaptcha/api.js'></script>


  <?php /*wp_head();*/ ?>

  <?php show_admin_bar( false ); ?>

  </head>

<body>

<!-- /* ===================================== /
/  =NAVIGATION /
/ ===================================== */ -->

  <div class="open-mobile-menu visible-midsmall">
    <span class="opener"><i class="glyphicon glyphicon-align-justify"></i></span>

    <nav class="main-nav2 mobileX col-md-9 my-menu">
      <?php
        wp_nav_menu(
          array(
            'theme_location' => 'principal',
            'container'      => false,
            'before'         => '',
            'after'          => '',
            'menu_class'     => 'clearfix'
          )
        );
      ?>
    </nav>
    <!-- /.main-nav -->

  </div>
  <!-- /.open-mobile-menu -->

  <nav class="main-nav hidden-midsmall">

    <div class="container">

      <?php
        wp_nav_menu(
          array(
            'theme_location' => 'principal',
            'container'      => false,
            'before'         => '<span class="icon-ball"></span>',
            'after'          => '',
            'menu_class'     => 'clearfix my-menux'
          )
        );
      ?>

    </div>
    <!-- /.container -->

  </nav>
  <!-- /.main-nav -->
