DROP TABLE IF EXISTS `wp_commentmeta`;
CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
DROP TABLE IF EXISTS `wp_comments`;
CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
DROP TABLE IF EXISTS `wp_links`;
CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `wp_links` VALUES (1,'http://codex.wordpress.org/','Documentation','','','','Y',1,0,'0000-00-00 00:00:00','','',''),(2,'http://wordpress.org/development/','WordPress Blog','','','','Y',1,0,'0000-00-00 00:00:00','','','http://wordpress.org/development/feed/'),(3,'http://wordpress.org/extend/ideas/','Suggest Ideas','','','','Y',1,0,'0000-00-00 00:00:00','','',''),(4,'http://wordpress.org/support/','Support Forum','','','','Y',1,0,'0000-00-00 00:00:00','','',''),(5,'http://wordpress.org/extend/plugins/','Plugins','','','','Y',1,0,'0000-00-00 00:00:00','','',''),(6,'http://wordpress.org/extend/themes/','Themes','','','','Y',1,0,'0000-00-00 00:00:00','','',''),(7,'http://planet.wordpress.org/','WordPress Planet','','','','Y',1,0,'0000-00-00 00:00:00','','','');
DROP TABLE IF EXISTS `wp_options`;
CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=1755 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `wp_options` VALUES (1,'siteurl','http://www.linhafacil.com.br/v2','yes'),(2,'blogname','Facil Auto Prote&ccedil;&atilde;o Veicular','yes'),(3,'blogdescription','Associa&ccedil;&atilde;o de Prote&ccedil;&atilde;o veicular e seguros para fam&iacute;lias.','yes'),(4,'users_can_register','0','yes'),(5,'admin_email','marketinglinhafacil@gmail.com','yes'),(6,'start_of_week','1','yes'),(7,'use_balanceTags','0','yes'),(8,'use_smilies','1','yes'),(9,'require_name_email','1','yes'),(10,'comments_notify','1','yes'),(11,'posts_per_rss','10','yes'),(12,'rss_use_excerpt','0','yes'),(13,'mailserver_url','mail.example.com','yes'),(14,'mailserver_login','login@example.com','yes'),(15,'mailserver_pass','password','yes'),(16,'mailserver_port','110','yes'),(17,'default_category','1','yes'),(18,'default_comment_status','open','yes'),(19,'default_ping_status','open','yes'),(20,'default_pingback_flag','0','yes'),(22,'posts_per_page','10','yes'),(23,'date_format','F j, Y','yes'),(24,'time_format','g:i a','yes'),(25,'links_updated_date_format','F j, Y g:i a','yes'),(29,'comment_moderation','0','yes'),(30,'moderation_notify','1','yes'),(31,'permalink_structure','/%category%/%postname%/','yes'),(33,'hack_file','0','yes'),(34,'blog_charset','UTF-8','yes'),(35,'moderation_keys','','no'),(36,'active_plugins','a:15:{i:0;s:31:\"acf-accordion/acf-accordion.php\";i:1;s:33:\"addthis/addthis_social_widget.php\";i:2;s:55:\"advanced-custom-fields-contact-form-7-field/acf-cf7.php\";i:3;s:34:\"advanced-custom-fields-pro/acf.php\";i:4;s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";i:5;s:43:\"comments-from-facebook/facebook-comment.php\";i:6;s:36:\"contact-form-7/wp-contact-form-7.php\";i:7;s:28:\"favicon-xt-manager/index.php\";i:8;s:43:\"google-analytics-dashboard-for-wp/gadwp.php\";i:9;s:36:\"google-sitemap-generator/sitemap.php\";i:10;s:38:\"integracao-rd-station/rdstation-wp.php\";i:11;s:45:\"limit-login-attempts/limit-login-attempts.php\";i:12;s:23:\"wordfence/wordfence.php\";i:13;s:41:\"wordpress-importer/wordpress-importer.php\";i:14;s:25:\"zopim-live-chat/zopim.php\";}','yes'),(37,'home','http://www.linhafacil.com.br/v2','yes'),(38,'category_base','/categoria','yes'),(39,'ping_sites','http://rpc.pingomatic.com/','yes'),(41,'comment_max_links','2','yes'),(42,'gmt_offset','0','yes'),(43,'default_email_category','1','yes'),(44,'recently_edited','a:3:{i:0;s:108:\"/home/linhafacilcom/public_html/v2/wp-content/plugins/advanced-custom-fields-contact-form-7-field/readme.txt\";i:1;s:109:\"/home/linhafacilcom/public_html/v2/wp-content/plugins/advanced-custom-fields-contact-form-7-field/acf-cf7.php\";i:2;s:0:\"\";}','no'),(45,'template','lfacil','yes'),(46,'stylesheet','lfacil','yes'),(47,'comment_whitelist','1','yes'),(48,'blacklist_keys','','no'),(49,'comment_registration','0','yes'),(51,'html_type','text/html','yes'),(52,'use_trackback','0','yes'),(53,'default_role','subscriber','yes'),(54,'db_version','38590','yes'),(55,'uploads_use_yearmonth_folders','1','yes'),(56,'upload_path','/home/linhafacilcom/public_html/v2/wp-content/uploads','yes'),(57,'blog_public','1','yes'),(58,'default_link_category','2','yes'),(59,'show_on_front','posts','yes'),(60,'tag_base','/tag','yes'),(61,'show_avatars','1','yes'),(62,'avatar_rating','G','yes'),(63,'upload_url_path','','yes'),(64,'thumbnail_size_w','150','yes'),(65,'thumbnail_size_h','150','yes'),(66,'thumbnail_crop','1','yes'),(67,'medium_size_w','300','yes'),(68,'medium_size_h','300','yes'),(69,'avatar_default','mystery','yes'),(72,'large_size_w','1024','yes'),(73,'large_size_h','1024','yes'),(74,'image_default_link_type','file','yes'),(75,'image_default_size','','yes'),(76,'image_default_align','','yes'),(77,'close_comments_for_old_posts','0','yes'),(78,'close_comments_days_old','14','yes'),(79,'thread_comments','1','yes'),(80,'thread_comments_depth','5','yes'),(81,'page_comments','0','yes'),(82,'comments_per_page','50','yes'),(83,'default_comments_page','newest','yes'),(84,'comment_order','asc','yes'),(85,'sticky_posts','a:0:{}','yes'),(86,'widget_categories','a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}','yes'),(87,'widget_text','a:0:{}','yes'),(88,'widget_rss','a:0:{}','yes'),(89,'timezone_string','','yes'),(91,'embed_size_w','','yes'),(92,'embed_size_h','600','yes'),(93,'page_for_posts','0','yes'),(94,'page_on_front','0','yes'),(95,'wp_user_roles','a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:63:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:16:\"aiosp_manage_seo\";b:1;s:12:\"access_zopim\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}','yes'),(96,'widget_search','a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}','yes'),(97,'widget_recent-posts','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(98,'widget_recent-comments','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(99,'widget_archives','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(1739,'_site_transient_timeout_browser_88337cd9fed317d029aaa03191c0be0b','1490972827','no'),(100,'widget_meta','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(101,'sidebars_widgets','a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:2:{i:0;s:8:\"search-2\";i:1;s:12:\"categories-2\";}s:13:\"array_version\";i:3;}','yes'),(102,'ftp_credentials','a:3:{s:8:\"hostname\";s:9:\"localhost\";s:8:\"username\";N;s:15:\"connection_type\";s:3:\"ftp\";}','yes'),(103,'widget_pages','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(104,'widget_calendar','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(105,'widget_links','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(106,'widget_tag_cloud','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(107,'widget_nav_menu','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(108,'rewrite_rules','a:158:{s:14:\"sitemap.xml.gz\";s:60:\"index.php?aiosp_sitemap_gzipped=1&aiosp_sitemap_path=root.gz\";s:25:\"sitemap_(.+)_(\\d+).xml.gz\";s:74:\"index.php?aiosp_sitemap_path=$matches[1].gz&aiosp_sitemap_page=$matches[2]\";s:19:\"sitemap_(.+).xml.gz\";s:43:\"index.php?aiosp_sitemap_path=$matches[1].gz\";s:11:\"sitemap.xml\";s:33:\"index.php?aiosp_sitemap_path=root\";s:22:\"sitemap_(.+)_(\\d+).xml\";s:71:\"index.php?aiosp_sitemap_path=$matches[1]&aiosp_sitemap_page=$matches[2]\";s:16:\"sitemap_(.+).xml\";s:40:\"index.php?aiosp_sitemap_path=$matches[1]\";s:34:\"sitemap(-+([a-zA-Z0-9_-]+))?\\.xml$\";s:40:\"index.php?xml_sitemap=params=$matches[2]\";s:38:\"sitemap(-+([a-zA-Z0-9_-]+))?\\.xml\\.gz$\";s:49:\"index.php?xml_sitemap=params=$matches[2];zip=true\";s:35:\"sitemap(-+([a-zA-Z0-9_-]+))?\\.html$\";s:50:\"index.php?xml_sitemap=params=$matches[2];html=true\";s:38:\"sitemap(-+([a-zA-Z0-9_-]+))?\\.html.gz$\";s:59:\"index.php?xml_sitemap=params=$matches[2];html=true;zip=true\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:10:\"banners/?$\";s:26:\"index.php?post_type=banner\";s:40:\"banners/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=banner&feed=$matches[1]\";s:35:\"banners/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=banner&feed=$matches[1]\";s:27:\"banners/page/([0-9]{1,})/?$\";s:44:\"index.php?post_type=banner&paged=$matches[1]\";s:12:\"vantagens/?$\";s:28:\"index.php?post_type=vantagem\";s:42:\"vantagens/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=vantagem&feed=$matches[1]\";s:37:\"vantagens/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=vantagem&feed=$matches[1]\";s:29:\"vantagens/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=vantagem&paged=$matches[1]\";s:48:\"categoria/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:43:\"categoria/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:24:\"categoria/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:36:\"categoria/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:18:\"categoria/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:35:\"banners/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"banners/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"banners/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"banners/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"banners/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"banners/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"banners/([^/]+)/embed/?$\";s:39:\"index.php?banner=$matches[1]&embed=true\";s:28:\"banners/([^/]+)/trackback/?$\";s:33:\"index.php?banner=$matches[1]&tb=1\";s:48:\"banners/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?banner=$matches[1]&feed=$matches[2]\";s:43:\"banners/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?banner=$matches[1]&feed=$matches[2]\";s:36:\"banners/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?banner=$matches[1]&paged=$matches[2]\";s:43:\"banners/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?banner=$matches[1]&cpage=$matches[2]\";s:32:\"banners/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?banner=$matches[1]&page=$matches[2]\";s:24:\"banners/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"banners/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"banners/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"banners/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"banners/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"banners/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"banners/categories/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?banner_category=$matches[1]&feed=$matches[2]\";s:54:\"banners/categories/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?banner_category=$matches[1]&feed=$matches[2]\";s:35:\"banners/categories/([^/]+)/embed/?$\";s:48:\"index.php?banner_category=$matches[1]&embed=true\";s:47:\"banners/categories/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?banner_category=$matches[1]&paged=$matches[2]\";s:29:\"banners/categories/([^/]+)/?$\";s:37:\"index.php?banner_category=$matches[1]\";s:37:\"vantagens/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"vantagens/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"vantagens/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"vantagens/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"vantagens/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"vantagens/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"vantagens/([^/]+)/embed/?$\";s:41:\"index.php?vantagem=$matches[1]&embed=true\";s:30:\"vantagens/([^/]+)/trackback/?$\";s:35:\"index.php?vantagem=$matches[1]&tb=1\";s:50:\"vantagens/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?vantagem=$matches[1]&feed=$matches[2]\";s:45:\"vantagens/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?vantagem=$matches[1]&feed=$matches[2]\";s:38:\"vantagens/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?vantagem=$matches[1]&paged=$matches[2]\";s:45:\"vantagens/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?vantagem=$matches[1]&cpage=$matches[2]\";s:34:\"vantagens/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?vantagem=$matches[1]&page=$matches[2]\";s:26:\"vantagens/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"vantagens/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"vantagens/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"vantagens/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"vantagens/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"vantagens/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:61:\"vantagens/categories/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?vantagem_category=$matches[1]&feed=$matches[2]\";s:56:\"vantagens/categories/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?vantagem_category=$matches[1]&feed=$matches[2]\";s:37:\"vantagens/categories/([^/]+)/embed/?$\";s:50:\"index.php?vantagem_category=$matches[1]&embed=true\";s:49:\"vantagens/categories/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?vantagem_category=$matches[1]&paged=$matches[2]\";s:31:\"vantagens/categories/([^/]+)/?$\";s:39:\"index.php?vantagem_category=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:31:\".+?/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\".+?/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\".+?/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\".+?/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\".+?/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\".+?/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"(.+?)/([^/]+)/embed/?$\";s:63:\"index.php?category_name=$matches[1]&name=$matches[2]&embed=true\";s:26:\"(.+?)/([^/]+)/trackback/?$\";s:57:\"index.php?category_name=$matches[1]&name=$matches[2]&tb=1\";s:46:\"(.+?)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:41:\"(.+?)/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:34:\"(.+?)/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[1]&name=$matches[2]&paged=$matches[3]\";s:41:\"(.+?)/([^/]+)/comment-page-([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[1]&name=$matches[2]&cpage=$matches[3]\";s:30:\"(.+?)/([^/]+)(?:/([0-9]+))?/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&page=$matches[3]\";s:20:\".+?/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:30:\".+?/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:50:\".+?/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\".+?/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\".+?/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:26:\".+?/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:33:\"(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:14:\"(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:26:\"(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:33:\"(.+?)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&cpage=$matches[2]\";s:8:\"(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";}','yes'),(109,'uninstall_plugins','a:1:{s:43:\"google-analytics-dashboard-for-wp/gadwp.php\";a:2:{i:0;s:15:\"GADWP_Uninstall\";i:1;s:9:\"uninstall\";}}','no'),(110,'default_post_format','0','yes'),(111,'link_manager_enabled','1','yes'),(112,'finished_splitting_shared_terms','1','yes'),(113,'site_icon','0','yes'),(114,'medium_large_size_w','768','yes'),(115,'medium_large_size_h','0','yes'),(116,'initial_db_version','15260','yes'),(1499,'WPLANG','pt_BR','yes'),(118,'cron','a:15:{i:1490378342;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1490392698;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1490393373;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1490399920;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1490451811;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1490452810;a:1:{s:13:\"sm_ping_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1490453942;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1490537129;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1490624601;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1490630400;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1490709643;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1490797017;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1490884320;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1490969526;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}','yes'),(119,'db_upgraded','','yes'),(121,'_transient_update_plugins','O:8:\"stdClass\":1:{s:12:\"last_checked\";i:0;}','yes'),(170,'fresh_site','0','yes'),(523,'category_children','a:0:{}','yes'),(172,'banner_category_children','a:0:{}','yes'),(123,'_transient_update_themes','O:8:\"stdClass\":1:{s:12:\"last_checked\";i:0;}','yes'),(1753,'_site_transient_timeout_theme_roots','1490379757','no'),(1754,'_site_transient_theme_roots','a:5:{s:8:\"__MACOSX\";s:7:\"/themes\";s:6:\"lfacil\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}','no'),(212,'nav_menu_options','a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}','yes'),(213,'_site_transient_timeout_browser_3724cf524ce46cd3376f6aebb4c04837','1485865682','no'),(214,'_site_transient_browser_3724cf524ce46cd3376f6aebb4c04837','a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"55.0.2883.87\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}','no'),(133,'limit_login_retries','a:1:{s:15:\"186.222.185.254\";i:2;}','no'),(134,'limit_login_retries_valid','a:1:{s:15:\"186.222.185.254\";i:1487987968;}','no'),(129,'theme_mods_twentyseventeen','a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1485209675;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:19:\"primary-widget-area\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:21:\"secondary-widget-area\";a:0:{}s:24:\"first-footer-widget-area\";a:0:{}s:25:\"second-footer-widget-area\";a:0:{}s:24:\"third-footer-widget-area\";a:0:{}s:25:\"fourth-footer-widget-area\";a:0:{}}}}','yes'),(199,'_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca','1485260820','no'),(135,'_site_transient_timeout_browser_1d0a65b87cf2e562f838ad982a35dd84','1485814173','no'),(136,'_site_transient_browser_1d0a65b87cf2e562f838ad982a35dd84','a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"56.0.2924.67\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}','no'),(138,'can_compress_scripts','1','no'),(198,'_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca','1485304020','no'),(196,'_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca','1485304020','no'),(197,'_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca','a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 14 Jan 2017 00:21:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=4.8-alpha-39943\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.7.1 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2017/01/wordpress-4-7-1-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 03:53:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4650\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:375:\"WordPress 4.7 has been downloaded over 10 million times since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.7 and earlier are affected by eight security issues: [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6520:\"<p>WordPress 4.7 has been <a href=\"https://wordpress.org/download/counter/\">downloaded over 10 million times</a> since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.7 and earlier are affected by eight security issues:</p>\n<ol>\n<li>Remote code execution (RCE) in PHPMailer &#8211; <em>No specific issue appears to affect WordPress</em> or any of the major plugins we investigated but, out of an abundance of caution, we updated PHPMailer in this release. This issue was fixed in PHPMailer thanks to <a href=\"https://legalhackers.com/\">Dawid Golunski</a> and <a href=\"https://twitter.com/Zenexer\">Paul Buonopane</a>.</li>\n<li>The REST API exposed user data for all users who had authored a post of a public post type. WordPress 4.7.1 limits this to only post types which have specified that they should be shown within the REST API. Reported by <a href=\"https://poststatus.com/\">Krogsgard</a> and <a href=\"https://ithemes.com/\">Chris Jean</a>.</li>\n<li>Cross-site scripting (XSS) via the plugin name or version header on <code>update-core.php</code>. Reported by <a href=\"https://dominikschilling.de/\">Dominik Schilling</a> of the WordPress Security Team.</li>\n<li>Cross-site request forgery (CSRF) bypass via uploading a Flash file. Reported by <a href=\"https://twitter.com/Abdulahhusam\">Abdullah Hussam</a>.</li>\n<li>Cross-site scripting (XSS) via theme name fallback. Reported by <a href=\"https://pentest.blog/\">Mehmet Ince</a>.</li>\n<li>Post via email checks <code>mail.example.com</code> if default settings aren&#8217;t changed. Reported by John Blackbourn of the WordPress Security Team.</li>\n<li>A cross-site request forgery (CSRF) was discovered in the accessibility mode of widget editing. Reported by <a href=\"https://dk.linkedin.com/in/ronni-skansing-36143b65\">Ronnie Skansing</a>.</li>\n<li>Weak cryptographic security for multisite activation key. Reported by <a href=\"https://itsjack.cc/\">Jack</a>.</li>\n</ol>\n<p>Thank you to the reporters for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p>In addition to the security issues above, WordPress 4.7.1 fixes 62 bugs from 4.7. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.7.1\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/query?milestone=4.7.1\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.7.1</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.7.1.</p>\n<p>Thanks to everyone who contributed to 4.7.1: <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/chandrapatel/\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/christian1012/\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dreamon11/\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/chopinbach/\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella van Dorpe</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/hristo-sg/\">Hristo Pandjarov</a>, <a href=\"https://profiles.wordpress.org/jnylen0/\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver/\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/mattyrob/\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/monikarao/\">monikarao</a>, <a href=\"https://profiles.wordpress.org/natereist/\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nikschavan/\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nullvariable/\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/sirbrillig/\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/sanketparmar/\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sfpt/\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom/\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/sstoqnov/\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/stevenkword/\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/timph/\">timph</a>, <a href=\"https://profiles.wordpress.org/voldemortensen/\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a>, and <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4650\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n	\n\n\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"WordPress 4.7 “Vaughan”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wordpress.org/news/2016/12/vaughan/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Dec 2016 19:27:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4596\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:240:\"Version 4.7 of WordPress, named “Vaughan” in honor of legendary jazz vocalist Sarah \"Sassy\" Vaughan, is available for download or update in your WordPress dashboard. New features in 4.7 help you get your site set up the way you want it.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:3:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2016/12/starter-content.mp4\";s:6:\"length\";s:7:\"3736020\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:59:\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4\";s:6:\"length\";s:7:\"1127483\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:58:\"https://wordpress.org/news/files/2016/12/video-headers.mp4\";s:6:\"length\";s:7:\"1549803\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:45492:\"<p>Version 4.7 of WordPress, named “Vaughan” in honor of legendary jazz vocalist Sarah &#8220;Sassy&#8221; Vaughan, is available for download or update in your WordPress dashboard. New features in 4.7 help you get your site set up the way you want it.</p>\n<div id=\"v-AHz0Ca46-1\" class=\"video-player\"><video id=\"v-AHz0Ca46-1-video\" width=\"632\" height=\"354\" poster=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_scruberthumbnail_0.jpg\" controls=\"true\" preload=\"metadata\" dir=\"ltr\" lang=\"en\"><source src=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_dvd.mp4\" type=\"video/mp4; codecs=&quot;avc1.64001E, mp4a.40.2&quot;\" /><source src=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_fmt1.ogv\" type=\"video/ogg; codecs=&quot;theora, vorbis&quot;\" /><div><img alt=\"Introducing WordPress 4.7\" src=\"https://i1.wp.com/videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_scruberthumbnail_0.jpg?resize=632%2C354&#038;ssl=1\" data-recalc-dims=\"1\" /></div><p>Introducing WordPress 4.7</p></video></div>\n<hr />\n<h2 style=\"text-align:center\">Presenting Twenty Seventeen</h2>\n<p>A brand new default theme brings your site to life with immersive featured images and video headers.</p>\n<p><img class=\"alignnone wp-image-4618 size-large\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=632%2C356&#038;ssl=1\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=300%2C169&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=768%2C432&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?w=1600&amp;ssl=1 1600w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>Twenty Seventeen focuses on business sites and features a customizable front page with multiple sections. Personalize it with widgets, navigation, social menus, a logo, custom colors, and more. Our default theme for 2017 works great in many languages, on any device, and for a wide range of users.</p>\n<hr />\n<h2 style=\"text-align:center\">Your Site, Your Way</h2>\n<p>WordPress 4.7 adds new features to the customizer to help take you through the initial setup of a theme, with non-destructive live previews of all your changes in one uninterrupted workflow.</p>\n<h3>Theme Starter Content</h3>\n<div style=\"width: 632px;\" class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<video class=\"wp-video-shortcode\" id=\"video-4596-1\" width=\"632\" height=\"346\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/starter-content.mp4?_=1\" /><a href=\"https://wordpress.org/news/files/2016/12/starter-content.mp4\">https://wordpress.org/news/files/2016/12/starter-content.mp4</a></video></div>\n<p>To help give you a solid base to build from, individual themes can provide starter content that appears when you go to customize your brand new site. This can range from placing a business information widget in the best location to providing a sample menu with social icon links to a static front page complete with beautiful images. Don’t worry &#8211; nothing new will appear on the live site until you’re ready to save and publish your initial theme setup.</p>\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>Edit Shortcuts</h3>\n<div style=\"width: 300px;\" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-4596-2\" width=\"300\" height=\"173\" poster=\"https://wordpress.org/news/files/2016/12/4.7-—-Edit-Shortcuts.jpg\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4?_=2\" /><a href=\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4\">https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4</a></video></div>\n<p>Visible icons appear to show you which parts of your site can be customized while live previewing. Click on a shortcut and get straight to editing. Paired with starter content, getting started with customizing your site is faster than ever.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Video Headers</h3>\n<div style=\"width: 300px;\" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-4596-3\" width=\"300\" height=\"173\" poster=\"https://wordpress.org/news/files/2016/12/4.7-—-Header-Video.jpg\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/video-headers.mp4?_=3\" /><a href=\"https://wordpress.org/news/files/2016/12/video-headers.mp4\">https://wordpress.org/news/files/2016/12/video-headers.mp4</a></video></div>\n<p>Sometimes a big atmospheric video as a moving header image is just what you need to showcase your wares; go ahead and try it out with Twenty Seventeen. Need some video inspiration? Try searching for sites with video headers available for download and use.</p>\n</div>\n<div style=\"clear: both\"></div>\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>Smoother Menu Building</h3>\n<p><img class=\"wp-image-4606 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Many menus for sites contain links to the pages of your site, but what happens when you don’t have any pages yet? Now you can add new pages while building menus instead of leaving the customizer and abandoning your changes. Once you’ve published your customizations, you’ll have new pages ready for you to fill with content.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Custom CSS</h3>\n<p><img class=\"wp-image-4607 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Sometimes you just need a few visual tweaks to make your site perfect. WordPress 4.7 allows you to add custom CSS and instantly see how your changes affect your site. The live preview allows you to work quickly without page refreshes slowing you down.</p>\n</div>\n<div style=\"clear: both\"></div>\n<hr />\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>PDF Thumbnail Previews</h3>\n<p><img class=\"wp-image-4609 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Managing your document collection is easier with WordPress 4.7. Uploading PDFs will generate thumbnail images so you can more easily distinguish between all your documents.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Dashboard in your language</h3>\n<p><img class=\"wp-image-4608 size-medium alignright\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?resize=300%2C158&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Just because your site is in one language doesn’t mean that everybody helping manage it prefers that language for their admin. Add more languages to your site and a user language option will show up in your user’s profiles.</p>\n</div>\n<div style=\"clear: both\"></div>\n<hr />\n<h2 style=\"text-align:center\">Introducing REST API Content Endpoints</h2>\n<p>WordPress 4.7 comes with REST API endpoints for posts, comments, terms, users, meta, and settings.</p>\n<p><img class=\"size-large wp-image-4600 alignnone\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=632%2C205&#038;ssl=1\" alt=\"\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=1024%2C332&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=300%2C97&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=768%2C249&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?w=1264&amp;ssl=1 1264w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>Content endpoints provide machine-readable external access to your WordPress site with a clear, standards-driven interface, paving the way for new and innovative methods of interacting with sites through plugins, themes, apps, and beyond. Ready to get started with development? <a href=\"https://developer.wordpress.org/rest-api/reference/\">Check out the REST API reference.</a></p>\n<hr />\n<h2 style=\"text-align:center\">Even More Developer Happiness <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f60a.png\" alt=\"?\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>\n<h3><a href=\"https://make.wordpress.org/core/2016/11/03/post-type-templates-in-4-7/\">Post Type Templates</a></h3>\n<p>By opening up the page template functionality to all post types, theme developers have even more flexibility with the WordPress template hierarchy.</p>\n<h3>More Theme API Goodies</h3>\n<p>WordPress 4.7 includes <a href=\"https://make.wordpress.org/core/2016/09/09/new-functions-hooks-and-behaviour-for-theme-developers-in-wordpress-4-7/\">new functions, hooks, and behavior</a> for theme developers.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/10/04/custom-bulk-actions/\">Custom Bulk Actions</a></h3>\n<p>List tables, now with more than bulk edit and delete.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/\"><code>WP_Hook</code></a></h3>\n<p>The code that lies beneath actions and filters has been overhauled and modernized, fixing bugs along the way.</p>\n<h3>Settings Registration API</h3>\n<p>register_setting() <a href=\"https://make.wordpress.org/core/2016/10/26/registering-your-settings-in-wordpress-4-7/\">has been enhanced</a> to include type, description, and REST API visibility.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/10/12/customize-changesets-technical-design-decisions/\">Customize Changesets</a></h3>\n<p>Customize changesets make changes in the customizer persistent, like autosave drafts. They also make exciting new features like starter content possible.</p>\n<hr />\n<h2 style=\"text-align:center\">The Squad</h2>\n<p>This release was led by <a href=\"https://helen.blog\">Helen Hou-Sandí</a>, backed up by <a href=\"https://profiles.wordpress.org/jbpaul17\">Jeff Paul</a> and <a href=\"http://aaron.jorb.in/\">Aaron Jorbin</a> as Release Deputies, and with the help of these fine individuals. There are 482 contributors with props in this release—the most ever—with 205 of them contributing for the first time. Pull up some sassy Sarah Vaughan on your music service of choice, and check out some of their profiles:</p>\n<a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/abrightclearweb\">abrightclearweb</a>, <a href=\"https://profiles.wordpress.org/ibachal\">Achal Jain</a>, <a href=\"https://profiles.wordpress.org/achbed\">achbed</a>, <a href=\"https://profiles.wordpress.org/acmethemes\">Acme Themes</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/adammacias\">adammacias</a>, <a href=\"https://profiles.wordpress.org/mrahmadawais\">Ahmad Awais</a>, <a href=\"https://profiles.wordpress.org/ahmadawais\">ahmadawais</a>, <a href=\"https://profiles.wordpress.org/airesvsg\">airesvsg</a>, <a href=\"https://profiles.wordpress.org/ajoah\">ajoah</a>, <a href=\"https://profiles.wordpress.org/akibjorklund\">Aki Bj&#246;rklund</a>, <a href=\"https://profiles.wordpress.org/akshayvinchurkar\">akshayvinchurkar</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/xavortm\">Alex Dimitrov</a>, <a href=\"https://profiles.wordpress.org/ironpaperweight\">Alex Hon</a>, <a href=\"https://profiles.wordpress.org/alex27\">alex27</a>, <a href=\"https://profiles.wordpress.org/allancole\">allancole</a>, <a href=\"https://profiles.wordpress.org/arush\">Amanda Rush</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andrewp-2\">Andreas Panag</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/rarst\">Andrey \"Rarst\" Savchenko</a>, <a href=\"https://profiles.wordpress.org/andizer\">Andy Meerwaldt</a>, <a href=\"https://profiles.wordpress.org/kelderic\">Andy Mercer</a>, <a href=\"https://profiles.wordpress.org/andy\">Andy Skelton</a>, <a href=\"https://profiles.wordpress.org/aniketpant\">Aniket Pant</a>, <a href=\"https://profiles.wordpress.org/anilbasnet\">Anil Basnet</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/ahortin\">Anthony Hortin</a>, <a href=\"https://profiles.wordpress.org/antisilent\">antisilent</a>, <a href=\"https://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/zuige\">Antti Kuosmanen</a>, <a href=\"https://profiles.wordpress.org/apokalyptik\">apokalyptik</a>, <a href=\"https://profiles.wordpress.org/artoliukkonen\">artoliukkonen</a>, <a href=\"https://profiles.wordpress.org/ideag\">Arunas Liuiza</a>, <a href=\"https://profiles.wordpress.org/attitude\">attitude</a>, <a href=\"https://profiles.wordpress.org/backermann\">backermann</a>, <a href=\"https://profiles.wordpress.org/b-07\">Bappi</a>, <a href=\"https://profiles.wordpress.org/bcole808\">Ben Cole</a>, <a href=\"https://profiles.wordpress.org/kau-boy\">Bernhard Kau</a>, <a href=\"https://profiles.wordpress.org/binarymoon\">BinaryMoon</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bjornw\">BjornW</a>, <a href=\"https://profiles.wordpress.org/bobbingwide\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/boblinthorst\">boblinthorst</a>, <a href=\"https://profiles.wordpress.org/boboudreau\">boboudreau</a>, <a href=\"https://profiles.wordpress.org/gitlost\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/brainstormforce\">Brainstorm Force</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/brianhogg\">Brian Hogg</a>, <a href=\"https://profiles.wordpress.org/krogsgard\">Brian Krogsgard</a>, <a href=\"https://profiles.wordpress.org/bronsonquick\">Bronson Quick</a>, <a href=\"https://profiles.wordpress.org/sixhours\">Caroline Moore</a>, <a href=\"https://profiles.wordpress.org/caseypatrickdriscoll\">Casey Driscoll</a>, <a href=\"https://profiles.wordpress.org/caspie\">Caspie</a>, <a href=\"https://profiles.wordpress.org/chandrapatel\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/chaos-engine\">Chaos Engine</a>, <a href=\"https://profiles.wordpress.org/cheeserolls\">cheeserolls</a>, <a href=\"https://profiles.wordpress.org/chesio\">chesio</a>, <a href=\"https://profiles.wordpress.org/ketuchetan\">chetansatasiya</a>, <a href=\"https://profiles.wordpress.org/choongsavvii\">choong</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chredd\">chredd</a>, <a href=\"https://profiles.wordpress.org/chrisjean\">Chris Jean</a>, <a href=\"https://profiles.wordpress.org/cmmarslender\">Chris Marslender</a>, <a href=\"https://profiles.wordpress.org/chris_d2d\">Chris Smith</a>, <a href=\"https://profiles.wordpress.org/chrisvanpatten\">Chris Van Patten</a>, <a href=\"https://profiles.wordpress.org/chriswiegman\">Chris Wiegman</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/chriseverson\">chriseverson</a>, <a href=\"https://profiles.wordpress.org/christian1012\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/cwpnolen\">Christian Nolen</a>, <a href=\"https://profiles.wordpress.org/needle\">Christian Wach</a>, <a href=\"https://profiles.wordpress.org/christophherr\">Christoph Herr</a>, <a href=\"https://profiles.wordpress.org/clarionwpdeveloper\">Clarion Technologies</a>, <a href=\"https://profiles.wordpress.org/claudiosanches\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/claudiosmweb\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/claudiolabarbera\">ClaudioLaBarbera</a>, <a href=\"https://profiles.wordpress.org/codemovementpk\">codemovement.pk</a>, <a href=\"https://profiles.wordpress.org/coderkevin\">coderkevin</a>, <a href=\"https://profiles.wordpress.org/codfish\">codfish</a>, <a href=\"https://profiles.wordpress.org/coreymcollins\">coreymcollins</a>, <a href=\"https://profiles.wordpress.org/curdin\">Curdin Krummenacher</a>, <a href=\"https://profiles.wordpress.org/cgrymala\">Curtiss Grymala</a>, <a href=\"https://profiles.wordpress.org/cdog\">Cătălin Dogaru</a>, <a href=\"https://profiles.wordpress.org/danhgilmore\">danhgilmore</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber </a>, <a href=\"https://profiles.wordpress.org/danielkanchev\">Daniel Kanchev</a>, <a href=\"https://profiles.wordpress.org/danielpietrasik\">Daniel Pietrasik</a>, <a href=\"https://profiles.wordpress.org/mte90\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/dllh\">Daryl L. L. Houston (dllh)</a>, <a href=\"https://profiles.wordpress.org/davepullig\">Dave Pullig</a>, <a href=\"https://profiles.wordpress.org/goto10\">Dave Romsey (goto10)</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/turtlepod\">David Chandra Purnama</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dglingren\">David Lingren</a>, <a href=\"https://profiles.wordpress.org/davidmosterd\">David Mosterd</a>, <a href=\"https://profiles.wordpress.org/dshanske\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/davidbhayes\">davidbhayes</a>, <a href=\"https://profiles.wordpress.org/folletto\">Davide \'Folletto\' Casali</a>, <a href=\"https://profiles.wordpress.org/deeptiboddapati\">deeptiboddapati</a>, <a href=\"https://profiles.wordpress.org/delphinus\">delphinus</a>, <a href=\"https://profiles.wordpress.org/deltafactory\">deltafactory</a>, <a href=\"https://profiles.wordpress.org/denis-de-bernardy\">Denis de Bernardy</a>, <a href=\"https://profiles.wordpress.org/valendesigns\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/pcfreak30\">Derrick Hammer</a>, <a href=\"https://profiles.wordpress.org/derrickkoo\">Derrick Koo</a>, <a href=\"https://profiles.wordpress.org/dimchik\">dimchik</a>, <a href=\"https://profiles.wordpress.org/dineshc\">Dinesh Chouhan</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dipeshkakadiya\">dipeshkakadiya</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">dmsnell</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/dotancohen\">Dotan Cohen</a>, <a href=\"https://profiles.wordpress.org/dougwollison\">Doug Wollison</a>, <a href=\"https://profiles.wordpress.org/doughamlin\">doughamlin</a>, <a href=\"https://profiles.wordpress.org/dreamon11\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/duncanjbrown\">duncanjbrown</a>, <a href=\"https://profiles.wordpress.org/dungengronovius\">dungengronovius</a>, <a href=\"https://profiles.wordpress.org/dylanauty\">DylanAuty</a>, <a href=\"https://profiles.wordpress.org/hurtige\">Eddie Hurtig</a>, <a href=\"https://profiles.wordpress.org/oso96_2000\">Eduardo Reveles</a>, <a href=\"https://profiles.wordpress.org/chopinbach\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/electricfeet\">ElectricFeet</a>, <a href=\"https://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/elyobo\">elyobo</a>, <a href=\"https://profiles.wordpress.org/enodekciw\">enodekciw</a>, <a href=\"https://profiles.wordpress.org/enshrined\">enshrined</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/pushred\">Eric Lanehart</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fencer04\">Fencer04</a>, <a href=\"https://profiles.wordpress.org/florianbrinkmann\">Florian Brinkmann</a>, <a href=\"https://profiles.wordpress.org/mista-flo\">Florian TIAR</a>, <a href=\"https://profiles.wordpress.org/foliovision\">FolioVision</a>, <a href=\"https://profiles.wordpress.org/fomenkoandrey\">fomenkoandrey</a>, <a href=\"https://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"https://profiles.wordpress.org/fjarrett\">Frankie Jarrett</a>, <a href=\"https://profiles.wordpress.org/frankiet\">frankiet</a>, <a href=\"https://profiles.wordpress.org/akeif\">Fred</a>, <a href=\"https://profiles.wordpress.org/frozzare\">Fredrik Forsmo</a>, <a href=\"https://profiles.wordpress.org/fuscata\">fuscata</a>, <a href=\"https://profiles.wordpress.org/gma992\">Gabriel Maldonado</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/geekysoft\">Geeky Software</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/goranseric\">Goran &#352;erić</a>, <a href=\"https://profiles.wordpress.org/grahamarmfield\">Graham Armfield</a>, <a href=\"https://profiles.wordpress.org/grantderepas\">Grant Derepas</a>, <a href=\"https://profiles.wordpress.org/tivnet\">Gregory Karpinsky (@tivnet)</a>, <a href=\"https://profiles.wordpress.org/hardeepasrani\">Hardeep Asrani</a>, <a href=\"https://profiles.wordpress.org/henrywright\">Henry Wright</a>, <a href=\"https://profiles.wordpress.org/hiddenpearls\">hiddenpearls</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/hristo-sg\">Hristo Pandjarov</a>, <a href=\"https://profiles.wordpress.org/hugobaeta\">Hugo Baeta</a>, <a href=\"https://profiles.wordpress.org/polevaultweb\">Iain Poulson</a>, <a href=\"https://profiles.wordpress.org/iamjolly\">iamjolly</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianedington\">Ian Edington</a>, <a href=\"https://profiles.wordpress.org/idealien\">idealien</a>, <a href=\"https://profiles.wordpress.org/igmoweb\">Ignacio Cruz Moreno</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/imnok\">Imnok</a>, <a href=\"https://profiles.wordpress.org/implenton\">implenton</a>, <a href=\"https://profiles.wordpress.org/ionutst\">Ionut Stanciu</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/krstarica\">Ivan</a>, <a href=\"https://profiles.wordpress.org/ivdimova\">ivdimova</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jakept\">Jacob Peattie</a>, <a href=\"https://profiles.wordpress.org/whyisjake\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/jnylen0\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jamesacero\">jamesacero</a>, <a href=\"https://profiles.wordpress.org/japh\">Japh</a>, <a href=\"https://profiles.wordpress.org/jaredcobb\">Jared Cobb</a>, <a href=\"https://profiles.wordpress.org/jayarjo\">jayarjo</a>, <a href=\"https://profiles.wordpress.org/jdolan\">jdolan</a>, <a href=\"https://profiles.wordpress.org/jdoubleu\">jdoubleu</a>, <a href=\"https://profiles.wordpress.org/jblz\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/cheffheid\">Jeffrey de Wit</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/jimt\">jimt</a>, <a href=\"https://profiles.wordpress.org/jipmoors\">Jip Moors</a>, <a href=\"https://profiles.wordpress.org/jmusal\">jmusal</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joelcj91\">Joel James</a>, <a href=\"https://profiles.wordpress.org/johanmynhardt\">johanmynhardt</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/zyphonic\">John Dittmar</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/johnpbloch\">John P. Bloch</a>, <a href=\"https://profiles.wordpress.org/johnregan3\">John Regan</a>, <a href=\"https://profiles.wordpress.org/johnpgreen\">johnpgreen</a>, <a href=\"https://profiles.wordpress.org/kenshino\">Jon (Kenshino)</a>, <a href=\"https://profiles.wordpress.org/jonathanbardo\">Jonathan Bardo</a>, <a href=\"https://profiles.wordpress.org/jbrinley\">Jonathan Brinley</a>, <a href=\"https://profiles.wordpress.org/daggerhart\">Jonathan Daggerhart</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jonnyauk\">jonnyauk</a>, <a href=\"https://profiles.wordpress.org/jordesign\">jordesign</a>, <a href=\"https://profiles.wordpress.org/jorritschippers\">JorritSchippers</a>, <a href=\"https://profiles.wordpress.org/joefusco\">Joseph Fusco</a>, <a href=\"https://profiles.wordpress.org/jjeaton\">Josh Eaton</a>, <a href=\"https://profiles.wordpress.org/shelob9\">Josh Pollock</a>, <a href=\"https://profiles.wordpress.org/joshcummingsdesign\">joshcummingsdesign</a>, <a href=\"https://profiles.wordpress.org/joshkadis\">joshkadis</a>, <a href=\"https://profiles.wordpress.org/joyously\">Joy</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/jrgould\">JRGould</a>, <a href=\"https://profiles.wordpress.org/juanfra\">Juanfra Aldasoro</a>, <a href=\"https://profiles.wordpress.org/juhise\">Juhi Saxena</a>, <a href=\"https://profiles.wordpress.org/nukaga\">Junko Nukaga</a>, <a href=\"https://profiles.wordpress.org/justinbusa\">Justin Busa</a>, <a href=\"https://profiles.wordpress.org/justinsainton\">Justin Sainton</a>, <a href=\"https://profiles.wordpress.org/jshreve\">Justin Shreve</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"https://profiles.wordpress.org/kacperszurek\">kacperszurek</a>, <a href=\"https://profiles.wordpress.org/trepmal\">Kailey (trepmal)</a>, <a href=\"https://profiles.wordpress.org/kalenjohnson\">KalenJohnson</a>, <a href=\"https://profiles.wordpress.org/codebykat\">Kat Hagan</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/keesiemeijer\">keesiemeijer</a>, <a href=\"https://profiles.wordpress.org/kellbot\">kellbot</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/wraithkenny\">Ken Newman</a>, <a href=\"https://profiles.wordpress.org/khag7\">Kevin Hagerty</a>, <a href=\"https://profiles.wordpress.org/kwight\">Kirk Wight</a>, <a href=\"https://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/kjbenk\">kjbenk</a>, <a href=\"https://profiles.wordpress.org/knutsp\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/koenschipper\">koenschipper</a>, <a href=\"https://profiles.wordpress.org/kokarn\">kokarn</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/kouratoras\">Konstantinos Kouratoras</a>, <a href=\"https://profiles.wordpress.org/kuchenundkakao\">kuchenundkakao</a>, <a href=\"https://profiles.wordpress.org/kuldipem\">kuldipem</a>, <a href=\"https://profiles.wordpress.org/laurelfulford\">Laurel Fulford</a>, <a href=\"https://profiles.wordpress.org/leewillis77\">Lee Willis</a>, <a href=\"https://profiles.wordpress.org/leobaiano\">Leo Baiano</a>, <a href=\"https://profiles.wordpress.org/littlebigthing\">LittleBigThings (Csaba)</a>, <a href=\"https://profiles.wordpress.org/lucasstark\">Lucas Stark</a>, <a href=\"https://profiles.wordpress.org/lukecavanagh\">Luke Cavanagh</a>, <a href=\"https://profiles.wordpress.org/lgedeon\">Luke Gedeon</a>, <a href=\"https://profiles.wordpress.org/lukepettway\">lukepettway</a>, <a href=\"https://profiles.wordpress.org/lyubomir_popov\">lyubomir_popov</a>, <a href=\"https://profiles.wordpress.org/mageshp\">mageshp</a>, <a href=\"https://profiles.wordpress.org/mahesh901122\">Mahesh Waghmare</a>, <a href=\"https://profiles.wordpress.org/mangeshp\">Mangesh Parte</a>, <a href=\"https://profiles.wordpress.org/manishsongirkar36\">Manish Songirkar</a>, <a href=\"https://profiles.wordpress.org/mantismamita\">mantismamita</a>, <a href=\"https://profiles.wordpress.org/mbootsman\">Marcel Bootsman</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/mariovalney\">Mario Valney</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/mrwweb\">Mark Root-Wiley</a>, <a href=\"https://profiles.wordpress.org/mapk\">Mark Uraine</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/markshep\">markshep</a>, <a href=\"https://profiles.wordpress.org/matrixik\">matrixik</a>, <a href=\"https://profiles.wordpress.org/mjbanks\">Matt Banks</a>, <a href=\"https://profiles.wordpress.org/jaworskimatt\">Matt Jaworski</a>, <a href=\"https://profiles.wordpress.org/mattking5000\">Matt King</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/veraxus\">Matt van Andel</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mattheu\">Matthew Haines-Young</a>, <a href=\"https://profiles.wordpress.org/mattyrob\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/maxcutler\">Max Cutler</a>, <a href=\"https://profiles.wordpress.org/maximeculea\">Maxime Culea</a>, <a href=\"https://profiles.wordpress.org/mayukojpn\">Mayo Moriyama</a>, <a href=\"https://profiles.wordpress.org/mbelchev\">mbelchev</a>, <a href=\"https://profiles.wordpress.org/mckernanin\">mckernanin</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mhowell\">mhowell</a>, <a href=\"https://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michaelarestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michalzuber\">michalzuber</a>, <a href=\"https://profiles.wordpress.org/mauteri\">Mike Auteri</a>, <a href=\"https://profiles.wordpress.org/mihai2u\">Mike Crantea</a>, <a href=\"https://profiles.wordpress.org/mdgl\">Mike Glendinning</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikelittle\">Mike Little</a>, <a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/mikeviele\">Mike Viele</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/modemlooper\">modemlooper</a>, <a href=\"https://profiles.wordpress.org/batmoo\">Mohammad Jangda</a>, <a href=\"https://profiles.wordpress.org/deremohan\">Mohan Dere</a>, <a href=\"https://profiles.wordpress.org/monikarao\">monikarao</a>, <a href=\"https://profiles.wordpress.org/morettigeorgiev\">morettigeorgiev</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/mor10\">Morten Rand-Hendriksen</a>, <a href=\"https://profiles.wordpress.org/mt8biz\">moto hachi ( mt8.biz )</a>, <a href=\"https://profiles.wordpress.org/mrbobbybryant\">mrbobbybryant</a>, <a href=\"https://profiles.wordpress.org/nnaimov\">Naim Naimov</a>, <a href=\"https://profiles.wordpress.org/natereist\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/natewr\">NateWr</a>, <a href=\"https://profiles.wordpress.org/nathanrice\">nathanrice</a>, <a href=\"https://profiles.wordpress.org/nazgul\">Nazgul</a>, <a href=\"https://profiles.wordpress.org/greatislander\">Ned Zimmerman</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey </a>, <a href=\"https://profiles.wordpress.org/nikeo\">Nicolas GUILLAUME</a>, <a href=\"https://profiles.wordpress.org/nikschavan\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nikv\">Nikhil Vimal</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/rabmalin\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/noplanman\">noplanman</a>, <a href=\"https://profiles.wordpress.org/nullvariable\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/odie2\">odie2</a>, <a href=\"https://profiles.wordpress.org/odysseygate\">odyssey</a>, <a href=\"https://profiles.wordpress.org/hideokamoto\">Okamoto Hidetaka</a>, <a href=\"https://profiles.wordpress.org/orvils\">orvils</a>, <a href=\"https://profiles.wordpress.org/oskosk\">oskosk</a>, <a href=\"https://profiles.wordpress.org/ottok\">Otto Kek&#228;l&#228;inen</a>, <a href=\"https://profiles.wordpress.org/ovann86\">ovann86</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/patilvikasj\">patilvikasj</a>, <a href=\"https://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/sirbrillig\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/pdufour\">pdufour</a>, <a href=\"https://profiles.wordpress.org/piewp\">Perdaan</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/phh\">phh</a>, <a href=\"https://profiles.wordpress.org/php\">php</a>, <a href=\"https://profiles.wordpress.org/delawski\">Piotr Delawski</a>, <a href=\"https://profiles.wordpress.org/pippinsplugins\">pippinsplugins</a>, <a href=\"https://profiles.wordpress.org/pjgalbraith\">pjgalbraith</a>, <a href=\"https://profiles.wordpress.org/pkevan\">pkevan</a>, <a href=\"https://profiles.wordpress.org/pratikchaskar\">Pratik</a>, <a href=\"https://profiles.wordpress.org/pressionate\">Pressionate</a>, <a href=\"https://profiles.wordpress.org/presskopp\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/procodewp\">procodewp</a>, <a href=\"https://profiles.wordpress.org/quasel\">quasel</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rahulsprajapati\">Rahul Prajapati</a>, <a href=\"https://profiles.wordpress.org/superpoincare\">Ramanan</a>, <a href=\"https://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/ramiabraham\">ramiabraham</a>, <a href=\"https://profiles.wordpress.org/ranh\">ranh</a>, <a href=\"https://profiles.wordpress.org/redsand\">Red Sand Media Group</a>, <a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rianrietveld\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/iamfriendly\">Richard Tape</a>, <a href=\"https://profiles.wordpress.org/rpayne7264\">Robert D Payne</a>, <a href=\"https://profiles.wordpress.org/rnoakes3rd\">Robert Noakes</a>, <a href=\"https://profiles.wordpress.org/d4z_c0nf\">Rocco Aliberti</a>, <a href=\"https://profiles.wordpress.org/rodrigosprimo\">Rodrigo Primo</a>, <a href=\"https://profiles.wordpress.org/rommelxcastro\">Rommel Castro</a>, <a href=\"https://profiles.wordpress.org/fronaldaraujo\">Ronald Ara&#250;jo</a>, <a href=\"https://profiles.wordpress.org/magicroundabout\">Ross Wintle</a>, <a href=\"https://profiles.wordpress.org/guavaworks\">Roy Sivan</a>, <a href=\"https://profiles.wordpress.org/ryankienstra\">Ryan Kienstra</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/ryanplas\">Ryan Plas</a>, <a href=\"https://profiles.wordpress.org/welcher\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/samikeijonen\">Sami Keijonen</a>, <a href=\"https://profiles.wordpress.org/solarissmoke\">Samir Shah</a>, <a href=\"https://profiles.wordpress.org/samuelsidler\">Samuel Sidler</a>, <a href=\"https://profiles.wordpress.org/sandesh055\">Sandesh</a>, <a href=\"https://profiles.wordpress.org/smyoon315\">Sang-Min Yoon</a>, <a href=\"https://profiles.wordpress.org/sanketparmar\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/pollyplummer\">Sarah Gooding</a>, <a href=\"https://profiles.wordpress.org/sayedwp\">Sayed Taqui</a>, <a href=\"https://profiles.wordpress.org/schlessera\">schlessera</a>, <a href=\"https://profiles.wordpress.org/schrapel\">schrapel</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/scrappyhuborg\">scrappy@hub.org</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/seancjones\">seancjones</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sgr33n\">Sergio De Falco</a>, <a href=\"https://profiles.wordpress.org/sfpt\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shayanys\">shayanys</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/shprink\">shprink</a>, <a href=\"https://profiles.wordpress.org/simonlampen\">simonlampen</a>, <a href=\"https://profiles.wordpress.org/skippy\">skippy</a>, <a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>, <a href=\"https://profiles.wordpress.org/snacking\">snacking</a>, <a href=\"https://profiles.wordpress.org/soean\">Soeren Wrede</a>, <a href=\"https://profiles.wordpress.org/solal\">solal</a>, <a href=\"https://profiles.wordpress.org/sstoqnov\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/metodiew\">Stanko Metodiev</a>, <a href=\"https://profiles.wordpress.org/sharkomatic\">Steph</a>, <a href=\"https://profiles.wordpress.org/sswells\">Steph Wells</a>, <a href=\"https://profiles.wordpress.org/sillybean\">Stephanie Leary</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"https://profiles.wordpress.org/stevenkword\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/stevenlinx\">stevenlinx</a>, <a href=\"https://profiles.wordpress.org/stubgo\">stubgo</a>, <a href=\"https://profiles.wordpress.org/sudar\">Sudar Muthu</a>, <a href=\"https://profiles.wordpress.org/patilswapnilv\">Swapnil V. Patil</a>, <a href=\"https://profiles.wordpress.org/swapnild\">swapnild</a>, <a href=\"https://profiles.wordpress.org/szaqal21\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/takahashi_fumiki\">Takahashi Fumiki</a>, <a href=\"https://profiles.wordpress.org/miyauchi\">Takayuki Miyauchi</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tapsboy\">tapsboy</a>, <a href=\"https://profiles.wordpress.org/tlovett1\">Taylor Lovett</a>, <a href=\"https://profiles.wordpress.org/team\">team</a>, <a href=\"https://profiles.wordpress.org/tg29359\">tg29359</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/the\">the</a>, <a href=\"https://profiles.wordpress.org/themeshaper\">themeshaper</a>, <a href=\"https://profiles.wordpress.org/thenbrent\">thenbrent</a>, <a href=\"https://profiles.wordpress.org/thomaswm\">thomaswm</a>, <a href=\"https://profiles.wordpress.org/tfrommen\">Thorsten Frommen</a>, <a href=\"https://profiles.wordpress.org/tierra\">tierra</a>, <a href=\"https://profiles.wordpress.org/tnash\">Tim Nash</a>, <a href=\"https://profiles.wordpress.org/timmydcrawford\">Timmy Crawford</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/timph\">timph</a>, <a href=\"https://profiles.wordpress.org/tkama\">Tkama</a>, <a href=\"https://profiles.wordpress.org/tnegri\">tnegri</a>, <a href=\"https://profiles.wordpress.org/tomauger\">Tom Auger</a>, <a href=\"https://profiles.wordpress.org/tjnowell\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/tomdxw\">tomdxw</a>, <a href=\"https://profiles.wordpress.org/toro_unit\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/zodiac1978\">Torsten Landsiedel</a>, <a href=\"https://profiles.wordpress.org/transl8or\">transl8or</a>, <a href=\"https://profiles.wordpress.org/traversal\">traversal</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/nmt90\">Triet Minh</a>, <a href=\"https://profiles.wordpress.org/trishasalas\">Trisha Salas</a>, <a href=\"https://profiles.wordpress.org/tristangemus\">tristangemus</a>, <a href=\"https://profiles.wordpress.org/truongwp\">Truong Giang</a>, <a href=\"https://profiles.wordpress.org/tsl143\">tsl143</a>, <a href=\"https://profiles.wordpress.org/tywayne\">Ty Carlson</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich\">Ulrich</a>, <a href=\"https://profiles.wordpress.org/utkarshpatel\">Utkarsh</a>, <a href=\"https://profiles.wordpress.org/valeriutihai\">Valeriu Tihai</a>, <a href=\"https://profiles.wordpress.org/vishalkakadiya\">Vishal Kakadiya</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/vrundakansara-1\">Vrunda Kansara</a>, <a href=\"https://profiles.wordpress.org/webbgaraget\">webbgaraget</a>, <a href=\"https://profiles.wordpress.org/webmandesign\">WebMan Design &#124; Oliver Juhas</a>, <a href=\"https://profiles.wordpress.org/websupporter\">websupporter</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/earnjam\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/williampatton\">williampatton</a>, <a href=\"https://profiles.wordpress.org/wolly\">Wolly aka Paolo Valenti</a>, <a href=\"https://profiles.wordpress.org/yale01\">yale01</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/yogasukma\">Yoga Sukma</a>, <a href=\"https://profiles.wordpress.org/oxymoron\">Zach Wills</a>, <a href=\"https://profiles.wordpress.org/tollmanz\">Zack Tollman</a>, <a href=\"https://profiles.wordpress.org/vanillalounge\">Ze Fontainhas</a>, <a href=\"https://profiles.wordpress.org/zhildzik\">zhildzik</a>, and <a href=\"https://profiles.wordpress.org/zsusag\">zsusag</a>.\n<p>&nbsp;<br />\nSpecial thanks go to <a href=\"https://ramiabraham.com/\">Rami Abraham</a> for producing the release video and the many fine haiku we saw in the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">beta</a> and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-release-candidate/\">RC</a> announcement posts.</p>\n<p>Finally, thanks to all the community translators who worked on WordPress 4.7. Their efforts bring WordPress 4.7 fully translated to 52 languages at release time with more on the way. Additionally, the WordPress 4.7 release video has been captioned into 44 languages.</p>\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>. Thanks for choosing WordPress &#8211; we hope you enjoy!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4596\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Moving Toward SSL\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/2016/12/moving-toward-ssl/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Dec 2016 17:20:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4588\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:327:\"We’re at a turning point: 2017 is going to be the year that we’re going to see features in WordPress which require hosts to have HTTPS available. Just as JavaScript is a near necessity for smoother user experiences and more modern PHP versions are critical for performance, SSL just makes sense as the next hurdle [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1627:\"<p>We’re at a turning point: 2017 is going to be the year that we’re going to see features in WordPress which require hosts to have HTTPS available. Just as JavaScript is a near necessity for smoother user experiences and more modern PHP versions are critical for performance, SSL just makes sense as the next hurdle our users are going to face.</p>\n<p>SSL basically means the link between your browser and the server is encrypted. SSL used to be difficult to implement, and often expensive or slow. Modern browsers, and the incredible success of projects like <a href=\"https://letsencrypt.org/\">Let&#8217;s Encrypt</a> have made getting a certificate to secure your site fast, free, and something we think every host should support by default, especially in a post-Snowden era. Google also weighs <a href=\"https://security.googleblog.com/2014/08/https-as-ranking-signal_6.html\">SSL as a search engine ranking factor</a> and will begin <a href=\"http://motherboard.vice.com/read/google-will-soon-shame-all-websites-that-are-unencrypted-chrome-https\">flagging unencrypted sites in Chrome</a>.</p>\n<p>First, early in 2017, we will only promote hosting partners that provide a SSL certificate by default in their accounts. Later we will begin to assess which features, such as API authentication, would benefit the most from SSL and make them only enabled when SSL is there.</p>\n<p>Separately, I also think the performance improvements in PHP7 are particularly impressive, and major kudos to everyone who worked on that. We will consider whether hosts use PHP7 by default for new accounts next year as well.</p>\n<p>&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4588\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.7 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2016/11/wordpress-4-7-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 24 Nov 2016 04:26:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4579\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:328:\"The release candidate for WordPress 4.7 is now available. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.7 on Tuesday, December 6, but we need your help to get there. If you haven’t tested 4.7 yet, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4331:\"<p>The release candidate for WordPress 4.7 is now available.</p>\n<p>RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.7 on <strong>Tuesday, December 6</strong>, but we need <em>your</em> help to get there. If you haven’t tested 4.7 yet, now is the time! To test WordPress 4.7, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.7-RC1.zip\">download the release candidate here</a> (zip).</p>\n<p>WordPress 4.7 is a jam-packed release, with a number of features focused on getting a theme set up for the first time. Highlights include a <a href=\"http://2017.wordpress.net/\">new default theme</a>, video headers, custom CSS, customizer edit shortcuts, PDF thumbnail previews, user admin languages, REST API content endpoints, post type templates, and more.</p>\n<p>We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39353&amp;stop_rev=39263&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">quite a few refinements</a> since releasing Beta 4 a week ago, including usability and accessibility enhancements for video headers, media and page template support in starter content, and polishing of how custom CSS can be migrated to and extended by plugins and themes. The REST API endpoints saw a number of bugfixes and notably now have anonymous comment off by default.</p>\n<p>Not sure where to start with testing? Try setting up a fresh site on a new installation with Twenty Seventeen (hint: head into customizing your site before touching any pages or widgets) and taking notes on what you enjoyed and what got you stuck. For more details about what&#8217;s new in version 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a>, <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\">Beta 3</a>, and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-4/\">Beta 4</a> blog posts.</p>\n<p><strong>Think you’ve found a bug?</strong> Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta support forum</a>. If any known issues come up, you’ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.7 and update your plugin’s <em>Tested up to</em> version in the readme to 4.7. If you find compatibility problems please be sure to post to the support forums so we can figure those out before the final release – we work hard to avoid breaking things. An in-depth field guide to developer-focused changes is coming soon on the <a href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a> And if you haven&#8217;t yet done so, now is a great time to <a href=\"https://wordpressdotorg.polldaddy.com/s/wordpress-2016-survey\">take the Annual WordPress Survey</a> and send it on to your friends.</p>\n<p>Happy testing! And now for another <a href=\"https://profiles.wordpress.org/ramiabraham\">Rami Abraham</a> haiku break.</p>\n<p><em>Select your language</em><br />\n<em>Then let your users choose theirs</em><br />\n<em><code>get_user_locale()</code></em></p>\n<p><em>Theme authors rejoice</em><br />\n<em>Any option may employ</em><br />\n<em>Selective refresh</em></p>\n<p><em>Custom header video</em><br />\n<em>Make sure to <code>add_theme_support</code></em><br />\n<em>Bling above the fold</em></p>\n<p><em>A new template dawns</em><br />\n<em>A hierarchy member</em><br />\n<em>Post-type templates live</em></p>\n<p><em>PDF updates</em><br />\n<em>Pack a parade of polish</em><br />\n<em>Prettier previews</em></p>\n<p><em>Template Post Type: New</em><br />\n<em>Template Post Type: And Useful</em><br />\n<em>Template Post Type: Thing</em></p>\n<p><em>Let lists live lively</em><br />\n<em>Laud <code>wp_list_sort()</code></em><br />\n<em>Less laconic lists</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4579\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Nov 2016 01:51:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4576\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 4 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2019:\"<p>WordPress 4.7 Beta 4 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta4.zip\">download the beta here</a> (zip).</p>\n<p>For more information on what’s new in 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1,</a> <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a>, and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\">Beta 3</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-7+dev-notes/\">in-depth developer guides on make/core</a>. We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39262&amp;stop_rev=39201&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">about 60 changes</a> in the last few days for beta 4, including tweaks to Twenty Seventeen, custom CSS, and the REST API content endpoints.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p><em>We are almost there<br />\nPlease test your plugins and themes<br />\nRC coming soon<br />\n</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4576\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordCamp US 2017-2018 in Nashville\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2016/11/wordcamp-us-2017-2018-in-nashville/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Nov 2016 23:24:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4571\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:330:\"The title says it all. We had some great applications for cities to host WordCamp US after we finish up in Philadelphia this year, and the city chosen for 2017-2018 is Nashville, Tennessee. Based on the other great applications we got I&#8217;m also excited about the pipeline of communities that could host it in future [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1022:\"<p><img class=\"aligncenter\" src=\"https://i0.wp.com/wpdotorg.files.wordpress.com/2008/07/27492741871_c6fcebcad3_k-e1479248587522.jpg?resize=632%2C253&#038;ssl=1\" data-recalc-dims=\"1\" /></p>\n<p>The title says it all. We had some great applications for cities to host <a href=\"http://us.wordcamp.org/\">WordCamp US</a> after we finish up in Philadelphia this year, and the city chosen for 2017-2018 is <strong>Nashville, Tennessee</strong>.</p>\n<p>Based on the other great applications we got I&#8217;m also excited about the pipeline of communities that could host it in future years as WordCamp US travels across the United States and gives us an opportunity to learn and love a new city, as we have with Philadelphia.</p>\n<p>By the way, if you haven&#8217;t yet, now is a great time to <a href=\"https://wordpressdotorg.polldaddy.com/s/wordpress-2016-survey\">take the Annual WordPress Survey</a> and ask your friends to as well.</p>\n<p><a href=\"https://www.flickr.com/photos/143951935@N07/27492741871\">Photo Credit</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4571\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Nov 2016 03:30:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4566\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 3 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3120:\"<p>WordPress 4.7 Beta 3 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta3.zip\">download the beta here</a> (zip).</p>\n<p>For more information on what’s new in 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1</a> and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-7+dev-notes/\">in-depth field guides on make/core</a>. Some of the changes in Beta 3 include:</p>\n<ul>\n<li><strong>REST API:</strong> The <code>unfiltered_html</code> capability is now respected and <code>rest_base</code> has been added to response objects of <code>wp/v2/taxonomies</code> and <code>wp/v2/types</code>, while <code>get_allowed_query_vars()</code> and the <code>rest_get_post</code> filter have been removed.</li>\n<li><strong>Roles/Capabilities:</strong> Added meta-caps for comment, term, and user meta, which are currently only used in the REST API.</li>\n<li><strong>I18N:</strong> Added the ability to change user&#8217;s locale back to site&#8217;s locale. (<a href=\"https://core.trac.wordpress.org/ticket/38632\">#38632</a>)</li>\n<li><strong>Custom CSS:</strong> Renamed the <code>unfiltered_css</code> meta capability to <code>edit_css</code> and added revisions support to the <code>custom_css</code> post type.</li>\n<li><strong>Edit shortcuts:</strong> Theme authors should take a look at <a href=\"https://make.wordpress.org/core/2016/11/10/visible-edit-shortcuts-in-the-customizer-preview/\">the developer guide to the customizer preview&#8217;s visible edit shortcuts</a> and update their themes to take advantage of them if not already implementing selective refresh.</li>\n<li><strong>Various bug fixes:</strong> We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39200&amp;stop_rev=39143&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">over 50 changes</a> in the last week.</li>\n</ul>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p><em>Building the future</em><br />\n<em>A global community</em><br />\n<em>Stronger together</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4566\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 04 Nov 2016 17:39:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4552\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 2 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4240:\"<p>WordPress 4.7 Beta 2 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta2.zip\">download the beta here</a> (zip).</p>\n<p>Notable changes since WordPress 4.7 Beta 1:</p>\n<ul>\n<li><strong>Twenty Seventeen:</strong> The theme wasn&#8217;t being installed on upgrades &#8211; sorry about that! Now you should see it if you&#8217;re upgrading an existing site. There are also plenty of fixes, especially for the header and small screen views.</li>\n<li><strong>Edit shortcuts:</strong> These are always visible while editing (hide them on bigger screens by collapsing the controls) and should now work properly in Firefox. (<a href=\"https://core.trac.wordpress.org/ticket/27403\">#27403</a> and <a href=\"https://core.trac.wordpress.org/ticket/38532\">#38532</a>)</li>\n<li><strong>REST API endpoints:</strong> There have been a number of changes over the past week; your attention is requested on the following:\n<ul>\n<li>The <code>DELETE</code> response format has changed and may need to be accounted for. (<a href=\"https://core.trac.wordpress.org/ticket/38494\">#38494</a>)</li>\n<li>Enabled querying by multiple post statuses. (<a href=\"https://core.trac.wordpress.org/ticket/38420\">#38420</a>)</li>\n<li>Return an error when JSON decoding fails. (<a href=\"https://core.trac.wordpress.org/ticket/38547\">#38547</a>)</li>\n</ul>\n</li>\n<li><strong>More developer notes</strong>\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2016/10/28/fine-grained-capabilities-for-taxonomy-terms-in-4-7/\">Fine grained capabilities for taxonomy terms</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/10/29/wp_taxonomy-in-4-7/\"><code>WP_Taxonomy</code></a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/02/wp_list_sort-and-wp_list_util-in-4-7/\"><code>wp_list_sort()</code> and <code>WP_List_Util</code></a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/post-type-templates-in-4-7/\">Post type templates</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/new-post-type-labels-in-4-7/\">New post type labels</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/attributes-for-resource-hints-in-4-7/\">Attributes for resource hints</a></li>\n</ul>\n</li>\n<li><strong>Various bug fixes:</strong> We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39142&amp;stop_rev=38995&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">almost 150 changes</a> in the last week.</li>\n</ul>\n<p>For more of what’s new in version 4.7, <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">check out the Beta 1 blog post</a>.</p>\n<p>If you want a more in-depth view of what major changes have made it into 4.7, <a href=\"https://make.wordpress.org/core/tag/4-7/\">check out posts tagged with 4.7 on the main development blog</a>, or look at a <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=4.7&amp;group=component&amp;order=priority\">list of everything</a> that’s changed. There will be more developer notes to come, so keep an eye out for those as well.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p>Happy testing!</p>\n<p><em>Ya es la hora</em><br />\n<em> Time for another beta</em><br />\n请您帮下忙!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4552\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Oct 2016 04:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4535\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 1 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6895:\"<p>WordPress 4.7 Beta 1 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta1.zip\">download the beta here</a> (zip).</p>\n<p>WordPress 4.7 is slated for release on <a href=\"https://make.wordpress.org/core/4-7/\">December 6</a>, but we need your help to get there. We&#8217;ve been working on a lot of things, many of them to make getting your site set up the way you want it much easier. Here are some of the bigger items to test and help us find as many bugs as possible in the coming weeks:</p>\n<ul>\n<li><a href=\"http://2017.wordpress.net/\"><strong>Twenty Seventeen</strong></a> &#8211; A brand new default theme brings your site to life with immersive featured images, video headers, and subtle animations. With a focus on business sites, it features multiple sections on the front page as well as widgets, navigation and social menus, a logo, and more. Personalize its asymmetrical grid with a custom color scheme and showcase your multimedia content with post formats. Our default theme for 2017 works great in many languages, for any abilities, and on any device.</li>\n<li><strong>Video Headers</strong> &#8211; Sometimes a big atmospheric video as a moving header image is just what you need to showcase your wares; go ahead and try it out with Twenty Seventeen. Need some video inspiration? Try searching for sites with video headers available for download and use.</li>\n<li><strong>Set up your site in one flow</strong> &#8211; From finding and installing themes right inside the customizer, to automatically staged theme-specific starter content, to clickable shortcuts that jump directly to editing an item from the preview pane, to adding pages while you&#8217;re building a nav menu or setting a static front page: getting a new site spun up and ready to share with a friend or a coworker is faster and easier than it&#8217;s ever been. Note: starter content appears when live previewing brand new sites and is currently only available in Twenty Seventeen. We&#8217;ll be expanding this to other bundled themes very soon, and perhaps to sites with existing content in future releases of WordPress.</li>\n<li><strong>Custom CSS with live previews</strong> &#8211; Ever needed to hide or tweak the look of something in your theme or from a plugin? Now you can do it with CSS and live preview the results while customizing your site. CSS can be a powerful tool; you may find that you won&#8217;t need the theme editor or child themes anymore.</li>\n<li><strong>User admin languages</strong> &#8211; Just because your site is in one language doesn&#8217;t mean that everybody helping manage it prefers that language for their admin. To try this out, you&#8217;ll need to have more than one language installed, which will make a user language option available in your profile.</li>\n<li><strong>PDF thumbnail previews</strong> &#8211; Uploading PDFs will now generate thumbnail images so you can more easily distinguish between all your documents.</li>\n</ul>\n<p>As always, there have been exciting changes for developers to explore as well, such as:</p>\n<ul>\n<li><strong>REST API content endpoints</strong> &#8211; If you only test one thing as a developer, please test these. This phase is particularly helpful for people building plugins, themes, and in-admin interfaces. Can you build the things you need? Are these ready for release, and is the world ready for them? (<a href=\"https://core.trac.wordpress.org/ticket/38373\">#38373</a>)</li>\n<li><strong><code>WP_Hook</code></strong> &#8211; The code that lies beneath actions and filters has been overhauled. You likely aren&#8217;t affected, but if you&#8217;ve done things to the <code>$wp_filter</code> global or experienced funky recursion bugs in the past, <a href=\"https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/\">please take a moment to read the dev note</a> and test your code.</li>\n<li><a href=\"https://make.wordpress.org/core/2016/10/04/custom-bulk-actions/\"><strong>Custom bulk actions</strong></a> &#8211; List tables, now with more than bulk edit and delete.</li>\n<li>Expanded <a href=\"https://make.wordpress.org/core/2016/10/26/registering-your-settings-in-wordpress-4-7/\"><strong>Settings Registration API</strong></a> via <code>register_setting()</code>.</li>\n<li>For theme developers: <strong>Post type templates</strong> (<a href=\"https://core.trac.wordpress.org/ticket/18375\">#18375</a>)</li>\n<li><strong><a href=\"https://make.wordpress.org/core/2016/09/09/new-functions-hooks-and-behaviour-for-theme-developers-in-wordpress-4-7/\">More goodies for theme developers!</a></strong></li>\n<li><strong>Locale switching</strong> (<a href=\"https://core.trac.wordpress.org/ticket/26511\">#26511</a>)</li>\n<li><a href=\"https://make.wordpress.org/core/2016/10/11/comment-allowed-checks-in-wordpress-4-7/\"><strong>Comment allowed checks</strong></a> have the potential for a back-compat break.</li>\n</ul>\n<p>If you want a more in-depth view of what major changes have made it into 4.7, <a href=\"https://make.wordpress.org/core/tag/4-7/\">check out posts tagged with 4.7 on the main development blog</a>, or look at a <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=4.7&amp;group=component&amp;order=priority\">list of everything</a> that’s changed. There will be more developer notes to come, so keep an eye out for those as well.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p>Happy testing, and please enjoy this extended haiku break, courtesy of <a href=\"https://profiles.wordpress.org/ramiabraham\">Rami Abraham</a><em>.</em></p>\n<p><em>Exquisite endpoints</em><br />\n<em>Extol epic exabytes</em><br />\n<em>Enabling earthlings</em></p>\n<p><em>Careful interfaces</em><br />\n<em>Considerately conjured</em><br />\n<em>Customizer chic</em></p>\n<p><em>Ring in the new year</em><br />\n<em>With elegance and balance</em><br />\n<em>Twenty Seventeen</em></p>\n<p><em>Hooks hook healthily</em><br />\n<em>17817</em><br />\n<em>Sane iterations</em></p>\n<p><em>Admin in your tongue<br />\nOne site, many languages<br />\nWe all speak WordPress</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4535\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Join Us Again for Global WordPress Translation Day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wordpress.org/news/2016/10/join-us-again-for-global-wordpress-translation-day/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Oct 2016 13:33:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:19:\"contributor weekend\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:32:\"global wordpress translation day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"polyglots\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:12:\"translations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4516\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:373:\"The WordPress Polyglots team is organizing the second Global WordPress Translation Day on November 12th. Everyone is invited to join – from anywhere in the world! Translating is one of the easiest ways to get involved with WordPress and contribute to the project. Global WordPress Translation Day is your chance to learn more about translating WordPress, meet [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Petya Raykovska\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4273:\"<p>The WordPress Polyglots team is organizing the second <a href=\"https://wptranslationday.org/\">Global WordPress Translation Day</a> on November 12th. Everyone is invited to join – from anywhere in the world!</p>\n<p>Translating is one of the easiest ways to get involved with WordPress and contribute to the project. Global WordPress Translation Day is your chance to learn more about translating WordPress, meet people from all over the world, and <a href=\"https://make.wordpress.org/polyglots/teams\">translate WordPress into one of more than 160 languages</a>.</p>\n<h3>Join us on November 12th from anywhere in the world</h3>\n<p>The translation day starts on Saturday, November 12th, 2016, at 0:00 UTC and ends 24 hours later. <a href=\"http://arewemeetingyet.com/UTC/2016-11-12/00:00/Global%20WordPress%20Translation%20Day%202\">See what time that is for you!</a> You can join right from the start, or any time it&#8217;s convenient for you throughout the day.</p>\n<h3>What are we doing?</h3>\n<p>Local contributor days are happening all over the world, and are a great way to get involved. <a href=\"https://www.google.com/maps/d/viewer?mid=12Gni4JMfShyWHPqGNwh5-PMneMM&amp;usp=sharing\">Check out this map</a> to see if there&#8217;s already a local event happening near you. Can&#8217;t find one? <a href=\"https://make.wordpress.org/polyglots/2016/09/22/global-wordpress-translation-day-2-on-november-12th-2016/\">Organize a local event!</a></p>\n<p>At the same time, <a href=\"https://www.crowdcast.io/e/gwtd2/register\">join the community for 24 hours of live-streamed, remote sessions</a> in numerous languages. Sessions will cover localization, internationalization, and contributing in your language.</p>\n<h3>Who&#8217;s it for?</h3>\n<p>Whether you&#8217;re new to translating and want to learn how to translate, or an experienced translation editor building a strong team, the translation day is for <i>you</i>. Developers will also enjoy topics from experienced contributors, whether you&#8217;re learning about internationalization and or want to find more translators for your themes and plugins. There&#8217;s a session for everyone!</p>\n<h3>Get Involved</h3>\n<p>Joining is easy! On November 12th, in your own timezone, <a href=\"https://translate.wordpress.org\">translate WordPress</a> or your favorite plugins and themes into your language, while watching live sessions over the course of the day.</p>\n<p>Want to get more involved? <a href=\"https://make.wordpress.org/polyglots/2016/09/22/global-wordpress-translation-day-2-on-november-12th-2016/\">Sign up to organize a local event</a> and invite your local community to translate together on November 12th. Events can be formal or completely informal – grab your laptop and a couple of friends, and head to a local coffee shop to translate for an hour or two.</p>\n<h3>Can you get involved if you only speak English?</h3>\n<p>Absolutely! Even if you only speak English, there are great sessions about internationalization that can benefit every developer. There&#8217;s also lots of English variants that need your help! For example, English is spoken and written differently in Australia, Canada, New Zealand, South Africa, and the United Kingdom. You can learn about these differences and why these variants are important during the sessions.</p>\n<p>And if you’re feeling fun, try translating WordPress into emoji! Yep, we have a translation of WordPress in emoji! <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f30e.png\" alt=\"?\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f30d.png\" alt=\"?\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f30f.png\" alt=\"?\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n<h3>Questions?</h3>\n<p>If you have any questions, the polyglots team and the event organizers hang out in <a href=\"http://wordpress.slack.com/messages/polyglots/\">#polyglots in Slack</a> and are happy to help! (Get an invite to Slack at <a href=\"https://chat.wordpress.org\">chat.wordpress.org</a>.)</p>\n<p>Sign up to take part in the event on the <a href=\"https://wptranslationday.org/\">official website</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4516\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 24 Jan 2017 12:26:59 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Sat, 14 Jan 2017 00:21:27 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}}s:5:\"build\";s:14:\"20130911040210\";}','no');
INSERT INTO `wp_options` VALUES (202,'_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9','1485304021','no'),(200,'_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9','1485304021','no'),(201,'_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9','a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: Wix Removes GPL-Licensed WordPress Code from Mobile App, Forks Original MIT Library\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65143\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://wptavern.com/wix-removes-gpl-licensed-wordpress-code-from-mobile-app-forks-original-mit-library\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14743:\"<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/ForkedFeaturedImage.png?ssl=1\"><img /></a>photo credit: <a href=\"http://www.flickr.com/photos/winterofdiscontent/3301816514/\">winterofdiscontent</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p>In October 2016, <a href=\"https://ma.tt/2016/10/wix-and-the-gpl/\" target=\"_blank\">Matt Mullenweg called out Wix</a> for using GPL-licensed code from the WordPress mobile app and distributing it in its proprietary app. After identifying a path for Wix to comply with the license, Mullenweg <a href=\"https://wptavern.com/mullenweg-takes-aim-at-wix-over-gpl-abuses-wix-response-fails-to-address-licensing-issue\" target=\"_blank\">confirmed he would be willing to go to court to protect the GPL</a>.</p>\n<p>Wix CEO Avishai Abrahami&#8217;s <a href=\"http://www.wix.com/blog/2016/10/dear-matt-mullenweg-an-open-letter-from-wix-coms-ceo-avishai-abrahami/\" target=\"_blank\">response</a> to the allegations failed to address the issue of licensing, dodging the question with references to other open source contributions. Abrahami seemed to indicate that Wix would open source its mobile app but was not clear whether it would be GPL licensed:</p>\n<p>&#8220;We always shared and admired your commitment to give back, which is exactly why we have those 224 open source projects, and thousands more bugs/improvements available to the open source community and we will release the app you saw as well,&#8221; Abrahami said.</p>\n<p>The Wix Twitter account also gave the impression that the entire app would be released under the GPL:</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/yairwein\">@yairwein</a> We\'ll release the code on Github, where we also shared our previous projects: <a href=\"https://t.co/FBhp2Kd5wn\">https://t.co/FBhp2Kd5wn</a></p>\n<p>&mdash; Wix.com (@Wix) <a href=\"https://twitter.com/Wix/status/792656290854174721\">October 30, 2016</a></p></blockquote>\n<p></p>\n<p>Publicly communicating these intentions bought the company time to educate its developers on the implications of the GPL and find another path forward for the app.</p>\n<p>The app has not been released under the GPL and Wix has discontinued development on the GPL-licensed repositories. On November 1, 2016, Wix changed the license on the <a href=\"https://github.com/wix/react-native-wordpress-editor\" target=\"_blank\">react-native-wordpress-editor</a>, the repository that was forked from the WordPress mobile app, to GPLv2. The next day, they began work on <a href=\"https://github.com/wix/react-native-zss-rich-text-editor/\" target=\"_blank\">react-native-zss-rich-text-editor</a>, a new repository forked from the original MIT-licensed library that the WordPress mobile app code built upon.</p>\n<p>It appears that Wix never planned on complying with the GPL, since the company immediately began working on an alternative approach. Wix has since released updates to its mobile apps and presumably has incorporated its own editor component that is based on the original MIT-licensed library.</p>\n<p>It is not clear whether Wix completely started over with its fork or if the company&#8217;s developers incorporated some of the commits previously made in the WordPress mobile app&#8217;s GPL-licensed fork. Wix has not responded to numerous attempts to contact them for an official statement.</p>\n<h3>Wix Invents Its Own &#8220;Enhanced&#8221; MIT License for the Forked Library</h3>\n<p>Here&#8217;s where the story takes an odd turn. Instead of distributing the new editor code under a <a href=\"https://opensource.org/licenses\" target=\"_blank\">standard open source library</a>, Wix has written its own license, which it is calling the <a href=\"https://github.com/wix/react-native-zss-rich-text-editor/blob/master/LICENSE\" target=\"_blank\">&#8220;Enhanced&#8221; MIT license (EMIT)</a>. It explicitly prohibits relicensing under the GPL and requires the developer to license modifications under the EMIT:</p>\n<blockquote><p>This license is exactly like the MIT License, with one exception – Any distribution of this source code or any modification thereof in source code format, must be done under the Enhanced MIT license and not under any other licenses, such as GPL.</p></blockquote>\n<p>Furthermore, the license prohibits the code being redistributed under any copyleft license:</p>\n<blockquote><p>when the Software is distributed as source code, the licensee is prohibited to change the license of the Software to any “viral” copyleft-type license, such as, inter alia: GPL, LGPL, EPL, MPL, etc.</p></blockquote>\n<p>Wix explained the reason behind the creation of the new license in its introduction, citing what it calls a &#8220;bug&#8221; in the MIT license. The MIT permits developers to re-license their modifications as GPL. The text of the &#8220;Enhanced&#8221; MIT license characterizes this practice as bullying:</p>\n<blockquote><p>We believe MIT license has a bug since it allows others to use it against its nature. Our belief is that the MIT license is intended to make source code available to anyone who wants to use it without additional obligations, but we have found cases where someone takes a project licensed under MIT license, adds a few lines of source code to it, and then changes the licensing to a different, more restrictive license which is against the nature and the intent of the MIT license. By doing so, the source code released under the original MIT is no longer a true “free/open” source code, thus undermining the intention of the original creator of the source code.</p>\n<p>The concept of this Enhanced MIT license is simple and more robust – you can do what you want with this source code, exactly like any other MIT license, but if you release it again as open source (even if modified), you must release it under this Enhanced MIT license – to be clear, this is not a “viral” license, it only refers to the actual source code released under this license and not to other components interacting with it. If GPL is a viral license, this license can be described as a “robust” one as it prevents licensing changes that are against its nature and it defends its own licensing principles. The essence of the Enhanced MIT license is to prevent bullies from using open source code that is truly free and open under the MIT License and turning it into other viral and more restrictive licenses – such as GPL.</p></blockquote>\n<p>The license has only ever been used in this particular instance and does not appear to have been written by a lawyer or someone who has studied copyright and licensing issues professionally. I contacted the Free Software Foundation&#8217;s <a href=\"http://www.fsf.org/licensing\" target=\"_blank\">licensing and compliance team</a> regarding the legitimacy of Wix&#8217;s &#8220;Enhanced&#8221; MIT license. FSF copyright and licensing associate Donald Robertson III said the team is currently reviewing it and may require legal counsel before making a definitive comment. When they have completed the review, they will publish a statement and list the license in the <a href=\"https://www.gnu.org/licenses/license-list.html\" target=\"_blank\">FSF directory of free and non-free software licenses</a>. These are also broken down into copyleft and GPL-compatible classifications.</p>\n<p>&#8220;As you can see from the <a href=\"https://www.gnu.org/licenses/license-list.html#GPLIncompatibleLicenses\" target=\"_blank\">GPL-incompatible licenses</a>, there are plenty of free software licenses that are incompatible with the GPL, and many of those licenses would be incompatible with other copyleft licenses on the same basis,&#8221; Robertson said. &#8220;So it is possible for a license to be free even if it doesn&#8217;t work well with the GPL. We&#8217;ll have to do some review on this particular license before we can make any comment specific to it.&#8221;</p>\n<p>Wix has not submitted its EMIT license to the Open Source Initiative, a community-recognized organization that acts as stewards of the Open Source Definition (OSD) and also reviews and approves licenses as OSD-conformant. OSI has not yet responded to my inquiry about the legitimacy of the license, but I spoke with <a href=\"https://opentechstrategies.com/\" target=\"_blank\">Karl Fogel</a>, an open source specialist who consults with organizations on open source licensing and the implications of using it in business.</p>\n<p>&#8220;This so-called &#8216;Enhanced MIT&#8217; license is poorly drafted and internally inconsistent,&#8221; Fogel said. &#8220;I feel on safe ground in saying that were it ever submitted to the OSI for approval, it would be rejected quickly.&#8221;</p>\n<p>Fogel also commented on the inherent contradictions in the license&#8217;s introduction and permissions.</p>\n<p>&#8220;An obvious internal inconsistency is that in the Introduction, it says that redistribution in source code format &#8216;must be done under the Enhanced MIT license and not under any other licenses, such as GPL,\'&#8221; Fogel said. &#8220;But then later, in point (2) of the conditional permissions grant, it says &#8216;when the Software is distributed as source code, the licensee is prohibited to change the license of the Software to any &#8216;viral&#8217; copyleft-type license, such as, inter alia: GPL, LGPL, EPL, MPL, etc.&#8217;</p>\n<p>&#8220;So the Introduction is saying that redistribution is not permitted under <strong>any</strong> other open source license, but then the permissions grant section only bars redistribution under copyleft licenses, leaving open the possibility to distribute under other non-copyleft licenses. Which is it?&#8221;</p>\n<p>According to OSI, <a href=\"https://opensource.org/faq#copyleft\" target=\"_blank\">copyleft</a> &#8220;refers to licenses that allow derivative works but require them to use the same license as the original work.&#8221; In requiring the EMIT to be used for derivative works, the license adopts the viral nature Wix ostensibly wanted to avoid with the GPL. This emasculates the MIT, robbing it of its essential freedoms. For this reason and many others, the EMIT appears to be an illegitimate variant of the MIT.</p>\n<p>&#8220;A larger issue is that the reasoning in the Introduction about how the standard MIT license supposedly has a &#8216;bug&#8217; makes no sense,&#8221; Fogel said. &#8221; It asserts that redistribution under an open source copyleft license would somehow be more restrictive than not doing source redistribution at all (e.g., as with a standard proprietary license).  There is no sensible definition of the word &#8216;restrictive; in which releasing code under a copyleft license would restrict someone&#8217;s use of that code more than <em>not having the code in the first place</em> would restrict them.&#8221;</p>\n<p>Fogel does not think the EMIT is a valid derivative of the MIT license and is not convinced that it can be considered a license at all.</p>\n<p>&#8220;It is very clear that a lawyer did not write this license,&#8221; Fogel said. &#8220;I think Abrahami must have written it himself. I hesitate to even call it a license; it&#8217;s not clear what a judge would do with it, except perhaps sell tickets.&#8221;</p>\n<h3>Wix&#8217;s EMIT License is a Hostile Reaction to the Call for GPL Compliance</h3>\n<p>The EMIT license not only takes shots at the GPL but also injects a moral pronouncement against all those who subscribe to the tenets of copyleft licensing. The restrictions in the EMIT effectively &#8220;weaponize the license&#8221; against other open source projects, as one Reddit user said in a<a href=\"https://www.reddit.com/r/opensource/comments/5n7km9/wix_abandons_the_wordpress_editor_forks_original/\" target=\"_blank\">comment</a> on the situation. This encompasses a large portion of the open source community.</p>\n<p>Wix may not be able to publicly admit its violation of the GPL, as it has not yet answered for the past infringement of distributing the code in its mobile app. In looking back over the timeline of events, Wix&#8217;s public communication that implied it would comply with the GPL was disingenuous, as the team was scrambling behind the scenes to fork the original library and slap a new &#8220;anti-copyleft&#8221; license on it. The company has no respect for the GPL and, in fact, has communicated its disdain for the license in the language of its new EMIT license.</p>\n<p>&#8220;I remember reading this exchange when it happened,&#8221; Fogel said. &#8220;This is not a case of gray areas or &#8216;the truth lies somewhere in the middle.&#8217; Matt Mullenweg of WordPress is 100% right, and Wix CEO Avishai Abrahami is, quite simply, wrong. Mullenweg was extremely direct about what the problem was and how to fix it. Abrahami&#8217;s response was an evasive mishmash of brazen non sequiturs and willful refusal to acknowledge Mullenweg&#8217;s point, which was simply that if Wix is going to use WordPress code that is distributed under the GNU General Public License, then Wix has to follow the terms of the GPL like anyone else.</p>\n<p>&#8220;Abrahami&#8217;s poor behavior could only have been intentional,&#8221; Fogel said. &#8220;I just don&#8217;t see any other way to interpret it, given how easy to understand Mullenweg&#8217;s letter is, and how clear the issues are here.&#8221;</p>\n<p>Wix&#8217;s illegal use of GPL code in a proprietary app could easily be chalked up to ignorance or an oversight if the company had simply attempted to comply. Instead, they wrote a license that swipes back at copyleft proponents everywhere. The EMIT actually manages to trivialize both the GPL and the MIT in one fell swoop.</p>\n<p>&#8220;The GPL is not a disease,&#8221; said <a href=\"http://www.rosenlaw.com/\" target=\"_blank\">Lawrence Rosen</a> in a document titled <a href=\"http://www.rosenlaw.com/html/GPL.pdf\" target=\"_blank\">The Unreasonable Fear of Infection</a>. &#8220;It is designed to satisfy certain philosophical and economic objectives that are widely shared by many members of the open source community.&#8221;</p>\n<p>In writing its own &#8220;Enhanced&#8221; MIT license Wix has demonstrated a careless disregard for open source licensing and  hostility towards those who use copyleft licenses to guarantee user freedoms.</p>\n<p>Although some onlookers in the open source community disapproved of the two CEO&#8217;s handling the disagreement in open letters, there are plenty more who appreciate that the issue is being hammered out in public. Fogel said he hopes the situation &#8220;will draw some attention to the fact that the GPL actually means something and can be enforced.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 21 Jan 2017 00:04:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: Obama Foundation Launches New Website Powered by WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/obama-foundation-launches-new-website-powered-by-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1987:\"<p>The <a href=\"https://www.obama.org/\" target=\"_blank\">Obama Foundation</a> launched its new WordPress-powered website today. The future presidential center, which will be located in Chicago, will manage projects both in the city and other places around the world.</p>\n<p>&#8220;More than a library or a museum, it will be a living, working center for citizenship,&#8221; President Obama said. &#8220;That&#8217;s why we want to hear from you. Tell us what you want this project to be and tell us what&#8217;s on your mind.&#8221;</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/obama-foundation-screenshot-e1484927287947.png?ssl=1\"><img /></a></p>\n<p>The website integrates the <a href=\"https://www.typeform.com/\" target=\"_blank\">Typeform</a> service for collecting feedback from citizens on their hopes and dreams, as well as the people and organizations that inspire them.</p>\n<p>WordPress developers were excited to see that the former President is using the WP REST API introduced in WordPress 4.7.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"in\" dir=\"ltr\">Oh hai WP REST API <a href=\"https://t.co/EBGDexNwRA\">pic.twitter.com/EBGDexNwRA</a></p>\n<p>&mdash; Daniel Bachhuber (@danielbachhuber) <a href=\"https://twitter.com/danielbachhuber/status/822459669104889856\">January 20, 2017</a></p></blockquote>\n<p></p>\n<p>The custom theme for the Obama Foundation is built using <a href=\"http://foundation.zurb.com/\" target=\"_blank\">ZURB&#8217;s Foundation</a> as its front-end framework. It integrates the <a href=\"http://jquery.malsup.com/cycle/\" target=\"_blank\">jQuery Cycle Plugin</a> for galleries.</p>\n<p>The website was created by <a href=\"http://www.bluestatedigital.com\" target=\"_blank\">Blue State Digital</a>, an agency that got its start on the campaign trail and now focuses on serving causes and brands.</p>\n<p>President Obama is the first president to select WordPress for his presidential center website.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Jan 2017 17:39:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"BuddyPress: BuddyPress 2.8.0 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=263023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://buddypress.org/2017/01/buddypress-2-8-0-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2965:\"<p>BuddyPress 2.8.0 Beta 1 is packed with new features and enhancements and is now available for testing. You can download the <a href=\"https://downloads.wordpress.org/plugin/buddypress.2.8.0-beta1.zip\">BP 2.8.0-beta1</a> zip or get a copy via our Subversion repository. We&#8217;d love to have your feedback and testing help.</p>\n<p>BuddyPress 2.8.0 requires PHP 5.3+, and will not be activated on a server with a lower version of PHP. We also remind you that BuddyPress 2.8.0 will require <a href=\"https://bpdevel.wordpress.com/2016/11/17/2349/\" target=\"_blank\">at least WordPress 4.3</a>.</p>\n<p>A detailed changelog will be part of our official release notes, but, until then, here’s a list of some of our favorite changes. (Check out <a href=\"https://buddypress.trac.wordpress.org/query?status=closed&group=resolution&milestone=2.8\">this report</a> on Trac for the full list.)</p>\n<ul>\n<li>BP Email: Allow end user to specify which PHPMailer should be used <a href=\"https://buddypress.trac.wordpress.org/ticket/7286\">#7286</a></li>\n<li>Companion Stylesheet &#8211; Twentyseventeen <a href=\"https://buddypress.trac.wordpress.org/ticket/7338\">#7338</a></li>\n<li>Minimum PHP version is 5.3 <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/7325\">#7325</a>, <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/7299\">#7299</a></li>\n<li>Support List-Unsubscribe header in emails <a href=\"https://buddypress.trac.wordpress.org/ticket/7390\">#7390</a></li>\n<li>Make group search more flexible <a href=\"https://buddypress.trac.wordpress.org/ticket/7418\">#7418</a> and other groups improvements, like <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/7419\">#7419</a>, <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/7399\">#7399</a>, <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/7388\">#7388</a>, <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/7386\">#7386</a>, <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/7375\">#7375</a></li>\n<li>Lots of new filters in various parts of the code, like <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/6667\">#6667</a>, <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/5193\">#5193</a></li>\n<li>Lots of inline documentation tweaks and other fixes and improvements</li>\n</ul>\n<p>BP 2.8.0 is almost ready, but please do not run it in a production environment just yet. Let us know of any issues you find in the <a href=\"https://buddypress.org/support/\">support forums</a> and/or <a href=\"https://buddypress.trac.wordpress.org/\">development tracker</a>.</p>\n<p>Thanks everyone for all your help to date. We are excited to release BuddyPress 2.8.0 in February!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jan 2017 23:03:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Slava Abakumov\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"Post Status: Shaping a vision of success\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=32469\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://poststatus.com/shaping-success-wordcamps/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14728:\"<p><em><strong>Editor&#8217;s note</strong></em>: This guest post is written by <a href=\"https://poststatus.com/profiles/jenny-beaumont/\">Jenny Beaumont</a>, a co-organizer of WordCamp Paris and WordCamp Europe. She&#8217;s spent the last two decades building things in and around the web, writes a <a href=\"http://www.jennybeaumont.com/subscribe/\">terrific newsletter</a>, and lives in France.</p>\n<p>One of the highlights of my year, and a fitting end to 2016 as my <a href=\"http://www.jennybeaumont.com/celebrating-15-years-of-freelancingwith-a-sabbatical/\">sabbatical</a> drew to a close, was attending the 2nd annual <a href=\"https://poststatus.com/photos-post-status-publish-wordcamp-us-2016/\">WordCamp US</a>, held December 2-4 in Philadelphia, Pennsylvania.</p>\n<p>The trip met my expectations in every way, from the warm-hearted nature of the locals to the super-sized portions at every delicious meal, and from the diversity of attendees to all of the extraordinary conversations I had during that short week I was in town.</p>\n<p>“You might have noticed that this year’s programming at WordCamp US had some more of a human side, in addition to just the technical that we’ve had before,” said Matt Mullenweg, co-founder of WordPress and CEO of Automattic, during his much-anticipated <a href=\"https://poststatus.com/matt-mullenweg-state-word-2016/\">State of the Word</a>.</p>\n<p>“I think that a lot of our opportunities to grow over the coming year are on the human side, and understanding the humanity of an open source project and working together and creating the code that’s going to touch humanity as well.”</p>\n<p>Moving into 2017, ready for new opportunities and with the next edition of <a href=\"https://2017.europe.wordcamp.org/\">WordCamp Europe</a> on the horizon, I find myself thinking about growth past and present, and about what success might look like for all of us in this new year.</p>\n<h3>Growth and competition for WordPress</h3>\n<p>“It’s really all about pie,” replied Mullenweg when asked about the future of a WordPress entrepreneur, stating that as long as the pie continues to grow, everyone can get a piece.</p>\n<p>He talked about how the new focuses of the WordPress project—the REST API, the Editor and the Customizer—along with an inclusive design-lead approach, should allow WordPress to reach new audiences.</p>\n<p>WordPress has seen incredible growth in recent years, now representing over <a href=\"https://w3techs.com/technologies/overview/content_management/all\">27% of websites</a>, a full 20% ahead of competing platforms. This translates to 58.5% market share of all monitored content management systems, <a href=\"https://www.rarst.net/wordpress/powers-internet/\">when looking</a> at the top 10 million sites.</p>\n<p>This doesn’t mean that the competition isn’t trying to close the gap. Mullenweg reported that the top proprietary platforms, such as Squarespace and Wix, spent upwards of 320 million in advertising dollars in 2016, often directly targeting search engine queries for WordPress.</p>\n<p>“I think that in the past WordPress got by on a lot of sort marketing by happenstance,” he said, admitting the need to look at the marketing of WordPress in new ways, and hopefully pooling the resources of the community to do so.</p>\n<p>“I think we have a real opportunity especially as the businesses around WordPress grow larger and larger, to actually coordinate a bit […] there’s no one company in the WordPress ecosystem that’s large enough to match 300 million dollars, and spend on telling people the WordPress story. But no one company needs to be large enough, because we’re a community.”</p>\n<p>All in all, he painted a bright picture for the future for the WordPress ecosystem, the community of people who come together around a common purpose and ideal—the WordPress project and its mission to democratize publishing—and in so doing create a new paradigm for work and the web, the byproduct of which is a flourishing economy.</p>\n<p>I can’t help but wonder, how big can the pie get? And while we concentrate on growth and competition, how do we measure the success of our mission? How will we know when we’ve democratized publishing? Can or should WordPress achieve this goal alone?</p>\n<h3>The numbers game for WordCamps</h3>\n<p>“We must tilt our hat and bow down to Europe, which beat us this year,” Mullenweg capitulated as he wrapped up his report on community growth, expressed in the number of events and event attendance worldwide.</p>\n<p>Growth is an indication that we’re doing something right. An increase in the numbers tells us that more people are interested and getting involved. This is what an open source project needs to reach a wider audience, stay competitive and accomplish its mission: people to make it happen.</p>\n<p>But should success be measured solely in numbers? Is it healthy to think that there can be winners and losers when it comes to the success of our community as a whole?</p>\n<p>In its first three years, WordCamp Europe grew at a slow and predictable rate. Then last year, for some reason, it exploded. We sold our initial batch of 1500 tickets practically overnight, and ended up selling nearly 2200 tickets in total.</p>\n<p>What happened? Did WordCamp Europe’s reputation catch up with itself, creating this burgeoning interest? Was Vienna simply an incredibly attractive destination for a lot of people? Or was it the organizing team that did an outstanding job at marketing and outreach?</p>\n<p>WordCamp US was in its second year, and we can ask similar questions about why they didn’t see the growth they were expecting. Is the event, with its transition from the long-standing WordCamp San Francisco, still in its infancy, so that slow growth is to be expected? Was going to the same destination two years in a row not as appealing to attendees? Did the team do an adequate job of communicating around the event?</p>\n<p>In my mind, both WordCamp Europe and WordCamp US were successful events. Each did a lot of things well, and some other things less well. Attendees I encountered, whether speakers, sponsors, volunteers or the general public, seemed to have a rewarding experience and their expectations met.</p>\n<p>Because that’s why we put these events on, right? Not to “get the numbers” or “win”, but to create an enriching experience.</p>\n<h3>Bigger is not necessarily better</h3>\n<p>So, how big do we let ourselves get? This has been an ongoing question for us on the WordCamp Europe team since things took on a new dimension in Vienna.</p>\n<p>When I asked <a href=\"https://paolo.blog/\">Paolo Belcastro</a>, WordCamp Europe local team lead in 2016 and global team lead for 2017, what he thought about growth he said, “For me a successful event is when we have one ticket left over. It should be our goal to make sure that everyone who wants to attend, can.”</p>\n<p>This is a philosophy that I stand beside. It reflects our focus on attendees and on inclusiveness, so that it doesn’t matter whether we have 1000, 2000 or 3000 people, it only matters that we do our best to accommodate everyone and put on a great event for however many show up.</p>\n<p>It does not, however, answer the question.</p>\n<p>It’s exciting to run a popular event, and it’s easy to get carried away with that excitement and sense of accomplishment knowing that so many people want to attend, that so many people are being impacted in positive ways. When we focus solely on the numbers, and adopt a “bigger is better” mentality, it’s also easy to lose sight of some important consequences of growth.</p>\n<h4>Professional level of production</h4>\n<p>Keep in mind that we didn’t originally plan an event for 2200 people last year, and so we had to improvise, which meant a significant budget increase and a lot of extra work for the organizing team.</p>\n<p>It also catapulted us into a new level of production. Putting on a large event is not the same as putting on a smaller one, and once you get up above 2000 attendees, it has a trickle down effect. It means organizing a speakers dinner for upwards of 300 volunteers, and an after party for 1500. These are events in and of themselves. We’re brought to collaborate with professionals in the events world—caterers, vendors, venues—while we’re still volunteers working in our “spare time”, some of us with more experience than others at making this all happen.</p>\n<h4>Increased cost of WordCamps</h4>\n<p>While the average ticket price per day has gone down, from $20 to $15.79, the cost of putting on a WordCamp has increased. Mullenweg reported that the cost of WordCamp US was $516 per person, while attendees continue to pay a mere $40 for entry to the two-day event, including lunch both days, free-flowing coffee, access to the contributor day and after party, not to mention the <a href=\"https://poststatus.com/photos-post-status-publish-wordcamp-us-2016/#jp-carousel-31176\">great swag</a>, which included both a t-shirt and an adorable Wapuu plushy this year.</p>\n<p>The additional 90% of this cost falls to sponsors. Sponsors are not volunteers running a non-profit, they are businesses. As we ask more and more of them, they understandably are <a href=\"https://wptavern.com/the-value-of-sponsoring-a-wordcamp-from-a-business-perspective\">starting to question</a> what they get in return. Our response has typically been, “you’re supporting the community and gaining exposure,” but is that enough and for how long? How much is too much to ask?</p>\n<h4>Setting expectations for sponsors and attendees</h4>\n<p>How much is too much to ask of anyone? As we ask more of sponsors they expect more in return. As we grow, try to predict growth and to outdo ourselves every year, the task for organizers becomes more demanding. As we create bigger and better events, attendees expect to find the same elsewhere.</p>\n<p>An event with 10,000 attendees would be amazing. We probably couldn’t call it a WordCamp, though. It would be a WordPalooza, and would require a full-time staff and a new approach to programming, sponsorship and organization on the whole. Does an event have to grow into order to be successful? Can maintaining a certain level of participation and quality also be considered a success?</p>\n<p>Because it’s also possible that WordCamp US and WordCamp Europe will simply plateau at a certain capacity. The world may not be ready for a WordPalooza.</p>\n<h3>Competition and success</h3>\n<p>“One of the reasons why I think WordPress has such a collaborative community, when you see competitors hanging out with each other and getting drinks […] is that it’s a growing pie. So everyone’s slice of that pie can grow alongside. If it were shrinking or a static pie, the only way to grow would be taking some pie from someone else.”</p>\n<p>Competition is widely considered good for business. It pushes companies to innovate and guard against complacency. It encourages a focus on customer service and helps protect consumers through competitive pricing. Competition in the marketplace confirms there is a market to be had, that demand is strong for the products or services being offered. It seeks to establish a basis for fairness, while letting companies vie for market share, sales and profit margins.</p>\n<p>The friendly, collaborative nature of the WordPress community is born out of the open source philosophy of contribution and sharing. It is, in my mind, our greatest strength. Support within the community is unparalleled. We consistently root for one another, learn from one another, share our triumphs and our difficulties, through mergers, acquisitions, hirings, firings, career changes and even the occasional drama.</p>\n<p>How big can WordPress get? Arriving at 100% market share is neither a likely nor a desirable scenario, if you believe in the benefits of competition and fair trade. The pie is not likely to grow exponentially, but rather will turn into something else entirely as the technology, the world and the web evolve, and the project along with them.</p>\n<h3>Success and expectations</h3>\n<p>“When we are candid about our shortcoming, it allows us to be better towards going to the future,” Mullenweg said in talking about the WordPress Editor.</p>\n<p>This is a sentiment we can apply across the board, to ensure that our philosophy and our mission are reflected in our words and actions as we bring new users to our platform and welcome newcomers to our community.</p>\n<p>Healthy competition, whether inside or outside of the community, helps us strive to be the best we can be. Raising the bar can produce some extraordinary results, allowing us to be inspired by one another, taking on ideas that we might find valuable for our audiences, customers, clients. Healthy competition allows us to learn, have fun, grow and share that wealth of knowledge around us.</p>\n<p>Unhealthy competition causes us to lose sight of our goals, focusing on numbers instead of the people affected by them. In a community such as ours that prides itself on inclusiveness, we can only succeed or fail together.</p>\n<p>In this coming year I’d like to see success shaped through managing expectations and staying true to our purpose. I’d like to see it shaped by people, not numbers, by the humanity of this open source project that brings us together, allows us to create, to innovate, to provide for ourselves and our families.</p>\n<p>I’d like to think that a future vision of success could be when growth is neither the goal, nor our limitation, when we’re no longer looking to a growing pie, but rather to a renewable spring or self-sustaining garden. I’d like to think that one day we will be able to say that we’ve succeeded in democratizing publishing, and if and when we do, I doubt that we will have done it alone. And that’s a good thing.</p>\n<h3>See you in Paris</h3>\n<p>I have no idea how many people will show up to WordCamp Europe in June, but I do know that it will be another fantastic event. I also know that you can help make it a success by participating. You can apply to <a href=\"https://2017.europe.wordcamp.org/2016/11/28/join-us-as-a-speaker-at-wordcamp-europe/\">speak</a>, to <a href=\"https://2017.europe.wordcamp.org/2016/10/06/wordcamp-europe-2017-call-for-volunteers-is-now-open/\">volunteer</a>, to <a href=\"https://2017.europe.wordcamp.org/2016/12/29/wordcamp-europe-2017-call-for-sponsors-is-now-open-wceu/\">sponsor</a>, and/or <a href=\"https://2017.europe.wordcamp.org/tickets/\">buy a ticket</a>. So many ways to be a part of making it happen. So, see you there? Wait, let me rephrase: see you there!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jan 2017 06:02:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Jenny Beaumont\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Jetpack 4.5 Expands Monetization with WordAds Integration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65273\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/jetpack-4-5-expands-monetization-with-wordads-integration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16477:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/wordads.jpg?ssl=1\"><img /></a></p>\n<p>Jetpack is starting 2017 with a major release that is heavy on enhancements and improvements. <a href=\"https://jetpack.com/2017/01/17/jetpack-4-5-monetize-your-site-brand-new-videopress-and-many-many-new-shortcodes/#comments\" target=\"_blank\">Version 4.5</a> includes more than a dozen new shortcodes and widgets, along with revamped support for VideoPress. One of the most intriguing new features announced in this release, however, is the integration with <a href=\"https://wordads.co/\" target=\"_blank\">WordAds</a>, WordPress.com&#8217;s advertising program.</p>\n<p>Jetpack users are required to be on the <a href=\"https://wordpress.com/jetpack/connect/premium\" target=\"_blank\">Premium plan</a> ($9.00/month or $99/year) in order to sign on with WordAds. The feature is then available within the Engagement tab along with settings for adjusting ad placement.</p>\n<p>Eligibility for WordAds was previously limited to sites that had thousands of page views per month, but this requirement is lifted for those who have purchased a Premium or Professional Jetpack plan. Unlike Adsense, which pays for clicks, WordAds pays based on the number of impressions combined with many other factors. According to Derek Springer, an Automattic employee who has worked on WordAds for several years, the traffic requirement was given to set earnings expectations and to ensure support resources were adequately available.</p>\n<h3>How Much Can Publishers Earn through WordAds?</h3>\n<p>It&#8217;s difficult to to gauge how much a publisher can earn using WordAds, and Automattic doesn&#8217;t publish any sample earnings. The WordAds network has <a href=\"https://wordads.co/2016/10/14/google-adsense-facebook-ads-and-dozens-more-buying-from-wordads/\" target=\"_blank\">more than 60 partners</a> bidding for advertising space in realtime, including Google&#8217;s AdSense, Google, AdX, Facebook Ads, AOL, Yahoo, and Amazon. <a href=\"https://dailypost.wordpress.com/2013/02/14/wordads/\" target=\"_blank\">WordPress.com&#8217;s Daily Post blog</a> likened the network to a stock market with prices rising and falling as available space changes.</p>\n<p>When asked about the average return for every 1,000 impressions, Derek Springer said it&#8217;s challenging to estimate due to the complex set of factors influencing the revenue publishers can earn. These include location and number of ads, geography of viewer, percentage of viewers with ad blockers, and other factors.</p>\n<p>&#8220;Generally speaking, a site with majority US views with high-quality content can expect to earn the most, while non-English language, low-quality (copied content, nsfw, spam, purchased traffic) sites can expect to earn very little (if anything),&#8221; Springer said. &#8220;Our network over the past year or so has gotten pretty good at appropriately rewarding high-quality sites with high-quality traffic (and penalizing the inverse).&#8221;</p>\n<p>For years, bloggers have traded stats and earning records, speculating on what influences WordAds&#8217; unpredictable payouts. In 2014, the Human Breed Blog <a href=\"https://humanbreeds.com/2014/10/13/wordads-advertising-on-wordpress/\" target=\"_blank\">published</a> a collection of data from blogs that made their WordAds earnings publicly available. The data demonstrated inconsistency in earnings for many publishers, including the author&#8217;s own blog, where earnings varied wildly from 2014-2015:</p>\n<blockquote><p>My earnings have dropped down to half (From $22.55 in October 2014 to $11.77 in May 2015) despite my page views being higher than 20,000 views per month. The return per 1,000 Ad Impression (CPM) has dropped from $2.25 in October 2014 to $1.17 in May 2015 and the return per 1,000 Page views (CPV) has dropped from $1.39 in October 2014 to $0.51 in May 2015.</p></blockquote>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/the-human-breed-blog-wordads-earnings.png?ssl=1\"><img /></a>The Human Breed Blog 2014-2015 WordAds Earnings\n<p>This example is representative of the experience of many WordAds publishers in 2014-2016.</p>\n<p>&#8220;On my blog SQLwithManoj.com, for the months May, June, and July, the &#8216;Ad Impressions&#8217; were around ~10k and earnings were in the range of $25 to $48 respectively each month,&#8221; <a href=\"https://humanbreeds.com/2014/10/13/wordads-advertising-on-wordpress/#comment-4468\" target=\"_blank\">said</a> Manoj Pandey, blogger at SQLwithManoj.com. &#8220;But in the month of August the &#8216;Ad Impressions&#8217; were showing ~100k, i.e. ~10 times the previous months, but earnings are still in the same range.&#8221;</p>\n<p>For many publishers participating in WordAds, there seems to be little correlation between impressions and payouts from month to month. Numerous publishers have reported progressively lower earnings despite having higher traffic numbers than previous months. Clarissa&#8217;s Blog, included in the collection of public earnings above, <a href=\"https://clarissasblog.com/2016/01/30/wordad-earnings-an-important-update/\" target=\"_blank\">published stats</a> from June 2014 to December 2015 that show a dramatic decrease in the amount paid for impressions.</p>\n<p>&#8220;You have no way of knowing where the &#8216;ad impressions&#8217; figure comes from and why it varies from one month to another,&#8221; Clarissa said. &#8220;You will have to trust WordPress on that. I experimented with placing the maximum amount of ads as opposed to a moderate amount of ads and that had absolutely no impact on the number of ad impressions.&#8221;</p>\n<p>Things started changing in 2016 for Clarissa who now <a href=\"https://clarissasblog.com/2016/01/30/wordad-earnings-an-important-update/#comment-289600\" target=\"_blank\">reports</a> that earnings are increasing. &#8220;I have no idea why but the payments seem to have returned to the higher rates,&#8221; Clarissa said. &#8220;Right now is a good time to do WordAds.&#8221;</p>\n<p>Others continue to <a href=\"https://en.forums.wordpress.com/topic/is-wordads-on-decline?replies=3#post-2842453\" target=\"_blank\">report</a> declines on the WordPress.com forums as recently as this week.</p>\n<p>&#8220;I used to get $800 for 800K impressions,&#8221; said the owner of rebirthonlineworld.com. &#8220;A few months ago I got $100 for more than 2 million impressions. Last month, only $90 for 500K impressions. This is a big problem for me.&#8221;</p>\n<h3>WordAds Vastly Overpaid for Low-Quality Traffic During Its First Years</h3>\n<p>In 2013 WordAds paid out $1 million to publishers on its network. According to Derek Springer, earnings since then have been &#8220;pretty flat the past year&#8221; due to industry-wide declining ad rates.</p>\n<p>&#8220;We’ve been slowly clawing our way back from the trough of early 2015, which was a historical low for us,&#8221; Springer said. &#8220;So more folks were paid out, but rates as a whole were at their lowest point in 2015. We’ve been steadily increasing our rates and paying out less to low-quality content/traffic, so if you’re a high quality site it’s likely your rates haven’t fallen too much.&#8221;</p>\n<p>Behind the scenes, WordAds was quietly evolving its network to better distinguish sites that would deliver more value to its advertising partners, which accounts for many of the dramatic declines in earnings.</p>\n<p>&#8220;Pre-<a href=\"https://wordads.co/2015/11/02/introducing-wordads-2-0/\" target=\"_blank\">WordAds 2.0</a> our network didn&#8217;t have the precision to distinguish between high-quality and low-quality (spam, nsfw, bot views, etc) traffic and we had to make some coarse estimations on how to chop the earnings value up,&#8221; Springer said. &#8220;The net effect was that we vastly overpaid low-quality traffic for the first handful of years.&#8221;</p>\n<p>Since WordAds 2.0 the program is gotten better at paying users for high-quality content and traffic. The team has more information on the traffic the network is getting and buyers have more information about the content they are bidding on.</p>\n<p>&#8220;The net effect is that advertisers refuse to bid on low-quality content and traffic and those sites that were previously earning lots are now getting pennies on the dollar,&#8221; Springer said. &#8220;I would estimate that after investigation 95% of the time the folks complaining about low payout have something kinda scammy going on, usually copied content or paid traffic (and frequently both).&#8221;</p>\n<p>&#8220;Paid traffic&#8221; in this instance refers to users who have paid a service to send bots to a page to refresh constantly in order to artificially inflate pageviews. One recent highly publicized incident of this kind of fraud is a case where <a href=\"http://www.wsj.com/articles/russian-hackers-stole-millions-from-video-advertisers-ad-fraud-company-says-1482272717\" target=\"_blank\">Russian hackers stole more than $3 million per day from video advertisers</a> using nonhuman bot traffic. Similar tactics have been used on WordAds, motivated by a misconception that pageviews are equal to ad views.</p>\n<h3>The Decline of the Advertising Industry</h3>\n<p>Another factor contributing to lower earnings over the past few years is the general decline of the advertising industry. A 2015 <a href=\"http://www.cjr.org/analysis/reuters_digital_news_report.php\" target=\"_blank\">Reuters Institute Digital News survey</a> indicates that nearly half of US internet users have some form of ad blocking software installed. Reuters Institute&#8217;s latest predictions <a href=\"http://www.digitalnewsreport.org/publications/2017/journalism-media-technology-predictions-2017/\" target=\"_blank\">forecast a 24% increase</a> in US users with ad blocking in 2017. Advertisers have to fight harder to get the attention of the remaining half of consumers and many companies have decided to allocate those funds elsewhere.</p>\n<p>According to the Interactive Advertising Bureau&#8217;s latest Internet Advertising Revenue report, <a href=\"http://adage.com/article/digital/iab-digital-ad-revenue-breaks-record/306557/\" target=\"_blank\">search advertising on desktop declined for the first time in 2016</a>, falling 12% to $8.9 billion. However, mobile advertising grew 105% from $3.6 billion to $7.4 billion. Mobile search is having an increasingly strong impact in shaping a site&#8217;s traffic.</p>\n<p>These factors are outside of WordAds&#8217; control but they weigh heavily on how many impressions publishers will receive. If the vast majority of a site&#8217;s visitors are using ad-blockers and the site isn&#8217;t easily found via mobile search, it is likely to suffer earning declines on any ad network.</p>\n<p>&#8220;Ad rates industry wide have fallen over the past few years,&#8221; Springer said. &#8220;Ad buyers just aren&#8217;t paying what they used to and more users are using ad blockers. They heyday of the late aughts/early twenty-teens may never return as ad buyers realized they just aren&#8217;t getting the return they were expecting.&#8221;</p>\n<h3>WordAds Needs More Transparency Around Partners and Reporting</h3>\n<p>It is difficult for publishers to improve their strategies for generating ad revenue when earnings fluctuate wildly without any explanation beyond changes in advertising rates. After reviewing the product&#8217;s forums, many are requesting more transparency around why their earnings have dropped despite higher numbers of impressions. They want to know if advertising rates have dropped for the month, if partners have dropped out of the network, or if their content failed to connect with visitors on certain days.</p>\n<p>WordAds users have experienced <a href=\"https://en.forums.wordpress.com/topic/earnings-from-wordads-account?replies=111\" target=\"_blank\">problems</a> with incorrect reporting, record low payouts, and blank banner displays. In the past there have also been considerable delays in publishers receiving their monthly earnings. Springer said improving the reporting process is a top priority for the team this year.</p>\n<p>&#8220;The flip-side/challenge of working with dozens of networks is that none of them pay us very consistently,&#8221; Springer said. &#8220;In the past there was no unified collection process on our end, so we would have to wait to collect from each partner and then split it up and send folks earnings out in one batch. However, for the past year and a half or so we&#8217;ve been working with a company called <a href=\"http://www.iponweb.com/\" target=\"_blank\">IPONWEB</a> to unify our earnings, reporting, and ad buying process (this is what powers WordAds 2.0). We&#8217;re at the point where we can begin to provide closer to real-time earnings reporting.&#8221;</p>\n<h3>Automattic is Optimistic about Expanding the <br />WordAds Program with Jetpack</h3>\n<p>The number of WordAds sites are up 111% year over year. WordAds currently has a few thousand self-hosted sites running <a href=\"https://wordpress.org/plugins/radcontrol/\" target=\"_blank\">AdControl/Jetpack Ads</a> and Springer said the team is expecting that number to grow considerably now that integration has been added to Jetpack. The AdControl plugin is still available for non-Premium Jetpack users but the standard application and traffic requirements apply. Springer said they plan to phase out the plugin at some point in the future but there are no definite plans yet.</p>\n<p>&#8220;Tens of thousands of WP.com sites are approved WordAds (meaning they applied and were approved) out of many tens of thousands more total applications,&#8221; Springer said. &#8220;Additionally, every freemium WordPress.com site is running our ad network, though we naturally keep all the revenue from those sites.&#8221;</p>\n<p>With a gaggle of new publishers joining WordAds through Jetpack, one might imagine that rates and payouts for existing users would decrease as more advertising space becomes available. However, this isn&#8217;t how advertising networks work.</p>\n<p>&#8220;Generally speaking, advertisers want to display more ads than most publishers are able to provide (known as inventory), so adding more publishers/inventory to a network is a net benefit to advertisers and is what attracts the bigger, higher paying ad buyers,&#8221; Springer said. &#8220;If we can tell our ad partners &#8216;We have 10,000,000,000 pageviews available this month across our network,&#8221; then that attracts much more lucrative buyers than if a user has to try to attract them on their own. Advertisers also like that they can cut one deal for a million sites as opposed to having to cut them piecemeal and are generally willing to give us better deals. The whole &#8216;powers 27% of the web&#8217; is a pretty tasty morsel for ad networks.&#8221;</p>\n<h3>Advice for Publishers New to WordAds: Keep Expectations Realistic</h3>\n<p>Seamless advertising is a major incentive for Jetpack users to sign up for the Premium plan, which also includes backups, one-click restores, security scanning, and 13GB video storage. The prospect of being able to flip the switch to turn on ads and potentially start earning money is very compelling, especially for users who have struggled with other forms of advertising that were not WordPress-compatible.</p>\n<p>The general outlook for WordAds is improving, as the product has evolved to reward higher quality content. As advertisers receive a better return on their investments, their confidence in bidding should increase. However, most publishers should expect to see fluctuations on earnings.</p>\n<p>WordPress.com&#8217;s <a href=\"https://dailypost.wordpress.com/2013/02/14/wordads/\" target=\"_blank\">Daily Post Blog</a> advises new publishers to temper their expectations with the knowledge that they would need &#8220;hundreds of thousands of pageviews to generate meaningful earnings.&#8221; For most average bloggers, the ad revenue may not buy more than a decent cup of coffee.</p>\n<p>Mortiz Linder, an owner of traveluxblog.com, <a href=\"https://traveluxblog.com/2016/10/29/my-experience-with-wordads/\" target=\"_blank\">published his earnings</a> and described his experience as &#8220;rather average.&#8221;</p>\n<p>&#8220;It&#8217;s a nice idea to gain something without effort, to get at least something back for all the work we put into traveluxblog each day,&#8221; Moritz said.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jan 2017 01:40:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: WPWeekly Episode 260 – SiteGround, Affiliate Summit Recap, and New Security Czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=65327&preview=true&preview_id=65327\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://wptavern.com/wpweekly-episode-260-siteground-affiliate-summit-recap-and-new-security-czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2802:\"<p>In this episode of WordPress Weekly, <a href=\"http://www.marcuscouch.com/\">Marcus Couch</a> recaps his trip to Affiliate Summit 2017 held in Las Vegas, Nevada last weekend. Based on the vendors that were on the expo floor, mobile is the e-commerce platform of the future. We discuss the news of the week and share how you can get involved in the <a href=\"http://make.wordpress.org/marketing\">WordPress Marketing Group</a>. We end the show with Marcus&#8217; plugin picks of the week.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/aaron-d-campbell-replaces-nikolay-bachiyski-as-wordpress-security-czar\">Aaron D. Campbell Replaces Nikolay Bachiyski as WordPress’ Security Czar</a><br />\n<a href=\"https://wptavern.com/postmatic-basic-rebrands-as-replyable-moves-two-way-email-commenting-to-saas-product\">Postmatic Basic Rebrands as Replyable, Moves Two-Way Email Commenting to SaaS Product</a><br />\n<a href=\"https://wptavern.com/siteground-auto-issues-lets-encrypt-certificates-for-new-domains\">SiteGround Auto-Issues Let’s Encrypt Certificates for New Domains</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/background-image-cropper/\">Background Image Cropper</a> adds cropping to background images for parity with header images. This feature is starting out as a plugin to gauge user interest and to determine if it improves the user experience of background images.</p>\n<p><a href=\"https://wordpress.org/plugins/woo-product-remover/\">Woo Product Remover</a> allows you to remove all WooCommerce products from your site. It removes products, their metadata, relationships, as well as product variations and their related meta data from the database.</p>\n<p><a href=\"https://wordpress.org/plugins/wp-tasks-after-install/\">WP Tasks After Install</a> completes a series of tasks most commonly performed after WordPress is installed. These tasks include, removing the default Hello World post, setting permalinks to %postname%, activating Akismet, and more. The plugin will automatically deactivate itself when the tasks are completed.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, January 25th 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #260:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Jan 2017 22:59:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"HeroPress: Living A Better Life Thanks To WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1571\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://heropress.com/essays/living-better-life-thanks-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:12009:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/01/011817-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"My experience as a remote worker lets me have greater foreight which in turn allows me to carry out so many activities.\" /><p>To me, as well as many others, WordPress is more than a technical choice, it’s a lifestyle choice. I didn’t see it as such right away. Looking at the last 4 years of my life, I can fully appreciate its impact.</p>\n<p>Aspiring to a life full of adventures and whimsy; I never really fit the mold. American TV series and movies that taught me my dreams could be achieved if I worked hard enough. Armed with that knowledge (and without a fancy diploma to my name), I worked bank, police, IT, supply chain jobs until I discovered the joy of making websites.</p>\n<p>My newfound passion (and many sleepless nights of work) helped me become a webdesigner. At the time, Joomla!, Spip and Typo 3 were the big names out there (in France). After achieving the role of Artistic Director as a freelancer; it took me a few years to open my own web agency. That moment changed my thinking: it was no longer ME but WE. And when a client asked us to use WordPress, we got to experience the CMS and its community.</p>\n<h3>Focusing on WordPress</h3>\n<p>Our team quickly realized that WordPress could do much more than “just blogs”. In France, the CMS kept having a reputation as a blog only platform. Complex websites were not made in WordPress. Our agency decided to convince clients otherwise. To achieve our mission and hone our skills, we decided to get closer to the WordPress community. I naively offered my help in evangelization efforts to the Paris WordCamp organizers. Except that there was one clear hurdle in our path: we had never contributed anything to the community before! This meant that we were relatively unknown. Needless to say that the feedback we received wasn’t what we expected.</p>\n<h3>Contributions: It’s About Helping Others</h3>\n<p>Contributing meant one thing: bring something to the WordPress ecosystem to help improve it. The WordCamp association’s president asked us to answer questions on the French forum as a token of our goodwill, to show our commitment.</p>\n<p>I started to answer questions right away but felt like an imposter. All the questions on the forum seemed so technical. I didn’t know how to contribute since I wasn’t a developer. It wasn’t like I was going to create a theme or plugin anytime soon. I kept obsessing over ways I could provide value to the community. I thought about my skills but couldn’t come up with something that would make a real difference.</p>\n<blockquote><p>Sure I could speak English, but translating documents was not something I felt comfortable doing.</p></blockquote>\n<p>So I turned to the previous WordCamp Paris conference and took a closer look at the participants. There, I found my first clue: a marketing expert! I reached out to him to see if I could interview him. As Marketing Director of a press group, he had lead a big WordPress project for his company. Interviewing him brought me two things: an article for our blog discussing what could be done with WordPress and a solid understanding of how the inner workings of the French WordPress community. He gave me an idea of the path one would take to end up giving a conference at the WordCamp. I didn’t realize it at the time, but by picking a name on a conference program, I would meet one of the key players in my WordPress story: Benjamin.</p>\n<p>Meanwhile, I continued to write articles about projects made with WordPress, sometimes ours, sometimes the competition’s. Good WordPress knows no bounds so it was necessary for me to showcase all the amazing websites made with this CMS. It’s also how I discovered my main competitors (before meeting them in the flesh later at various events).</p>\n<p>A white paper detailing the success of WordPress as a CMS got my name out. This allowed me to gain the courage to pitch my first conference. Providing feedback on projects allowed me to find my place in the WordPress community. Focusing on my experience and helping others didn’t require developer skills. My contribution was in writing and not in coding.</p>\n<h3>My First WordPress Conference As A Speaker</h3>\n<p>My first conference topic was on how to create a multilingual, multi-site project with WordPress in 3 months. Needless to say that I was nervous. I mean, speaking in front of 300 people is not something I had done while working at a bank, or in the police force or in any other job really. Adventure: here I come!</p>\n<blockquote><p>The WordPress community was very kind to me and my first conference experience was a memorable one.</p></blockquote>\n<p>During this conference, I wanted to highlight the plugins we used for this project. I mentioned a French startup that had launched a premium plugin as its first product. I found their approach interesting, so I thought I would give them a little visibility. Showcasing good WordPress websites, themes and plugins was already a habit of mine by then. The French team were happy to be mentioned and happened to be present at the event. They came to talk to me after my conference. Turns out, we had a lot to talk about. The company’s name: WP Media. They would open a new chapter of my WordPress story.</p>\n<p>During the closing night, I also met a lot of people. Some of them, just like Benjamin were going to have a big impact on my life. Many became great friends as well as mentors like Jenny Beaumont.</p>\n<p>Once I got started, there was no stopping me! I continued to speak at events (WordCamp Lyon, WP Tech Nantes), attended meetups, continued writing articles to highlight WordPress projects.</p>\n<p>The following year, I joined the organizing team of WordCamp Paris.</p>\n<p>Meanwhile, I go to my first WordCamp Europe which was a major new turn.</p>\n<h3>WordCamp Europe 2014 Changed My Life</h3>\n<p>Going to the WordCamp Europe changed my life. It’s an experience I highly recommend. If you can, go to the next WordCamp Europe!</p>\n<p>The organizers managed to pack so many international speakers that my head was spinning. Speakers were coming from all over the world. The quality of the talks (and speakers) along with the breadth of subjects covered open so many possibilities. You could end up changing your approach to WordPress or finding a new method of working with your peers.</p>\n<p>I attended a conference by Noel Tock named Beyond the code where he explained how he managed his life working in remote while traveling at the same time. He also gave insights as to how to monitor your time and how to optimize it.</p>\n<blockquote><p>Realizing that such a life was possible; that you could achieve this time of freedom by reclaiming your time was a massive discovery.</p></blockquote>\n<p>The second eye-opening conference for me was Simon&#8217;s lecture on Running an open source. He explained that that undertaking Open Source also meant contributing and collaborating with a community, including your competitors. Simon showed us for 30 minutes that working with competitors was not only beneficial for us agencies, but also for the customer, and for the WordPress community as a whole.</p>\n<h3>Professional WordPress</h3>\n<p>Becoming a strong voice in the professionalisation of WordPress in France and encouraging web agencies to contribute and to exchange more had become priority subjects.</p>\n<p>I have launched a WP Next association for professionals</p>\n<ul>\n<li>To ensure the promotion of WordPress, mainly with professionals, managers of information system, internet director, new media, &#8230; and more generally all IT decision makers.</li>\n<li>To enhance the skills of WordPress professionals with decision-makers,</li>\n<li>Promote French know-how around the WordPress CMS, associated technologies and services</li>\n</ul>\n<p>I also launched with Deborah Donnier a documentary project Think WP to make known WordPress and its community.</p>\n<h3>A new turn</h3>\n<p>With these activities I gradually moved away from the creation of websites. Having so many opportunities tied to WordPress available to me, I decided to take a new turn. During the Wordcamps across Europe, I took great pleasure in exchanging with WP Media. We had kept contact since our first meeting. My profile and experience seemed to like a great fit for a new role in the WP Media adventure. I took a leap and became COO of the startup about a year ago. I manage my agency in parallel.</p>\n<p>I now work 100% remotely and so does a great portion of my agency. As for WP Media, everyone works remotely. Being a remote worker frees me from constraints that are inherent when you live in the Paris region (it’s a city and province in France). Time spent on commuting is used for other activities.</p>\n<p>My experience as a remote worker lets me have greater foresight which in turn allows me to carry out so many activities.</p>\n<p>Today, I can proudly say that I attended the US WordCamp last year and am helping organize this year’s WordCamp Europe with Jenny and Benjamin.I feel like I belong in a global community that thrives thanks to its members and their desire to improve WordPress.</p>\n<p>WordPress helped me along the path to a life full of adventures and long lasting friendships. It offers so many opportunities to forge beautiful projects, stories and more.</p>\n<p>I hope that my story will inspire someone else to get started and find the courage to persevere on the way to a life full of adventures (with or without WordPress). Give yourself time and open yourself to other points of view to help build the life you aspire to.</p>\n<p>Thank you for reading my story and see you at WordCamp Europe 2017!</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Living A Better Life Thanks To WordPress\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Living%20A%20Better%20Life%20Thanks%20To%20WordPress&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fliving-better-life-thanks-wordpress%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Living A Better Life Thanks To WordPress\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fliving-better-life-thanks-wordpress%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fliving-better-life-thanks-wordpress%2F&title=Living+A+Better+Life+Thanks+To+WordPress\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Living A Better Life Thanks To WordPress\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/living-better-life-thanks-wordpress/&media=https://heropress.com/wp-content/uploads/2017/01/011817-150x150.jpg&description=Living A Better Life Thanks To WordPress\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Living A Better Life Thanks To WordPress\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/living-better-life-thanks-wordpress/\" title=\"Living A Better Life Thanks To WordPress\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/living-better-life-thanks-wordpress/\">Living A Better Life Thanks To WordPress</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Jan 2017 12:00:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Emilie Lebrun\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WPTavern: How to Add Users to BuddyPress Groups in Bulk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65283\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://wptavern.com/how-to-add-users-to-buddypress-groups-in-bulk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3220:\"<p>On a site I&#8217;m working on that runs BuddyPress, I created a new group and wanted to add nearly 400 registered users to it. Unfortunately, adding users to BuddyPress groups in bulk is not a core feature. I searched Google for a solution and while the <a href=\"http://www.youngtechleads.com/buddypress-members-import/\">BuddyPress Members Import</a> plugin is recommended in many of the support threads, the feature alone is not worth spending $49.</p>\n<p>Continuing my search, I discovered a <a href=\"https://gist.github.com/rohmann/6151699\">code snippet</a> published by <a href=\"https://premium.wpmudev.org/profile/alexander_rohmann/\">Alexander</a> on the <a href=\"https://premium.wpmudev.org/forums/topic/bulk-adding-buddypress-group-members?replies=14&utm_expid=3606929-94.Ie3dH-CaRwe6MU3VrZsdvw.0&utm_referrer=https%3A%2F%2Fwordpress.org%2Fsupport%2Ftopic%2Fimport-with-buddypress-groups%2F#post-484834\">WPMU DEV forums</a> that works perfectly. To use it, copy the code and add it to a custom WordPress plugin or paste it to your theme&#8217;s functions.php file. I added the code to the top of my theme&#8217;s functions.php file.</p>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/CodeSnippetInThemeFunctionsPHPFile.png?ssl=1\"><img /></a>Code Snippet at the Top of my Theme&#8217;s Functions.php File\n<p>The JavaScript portion of the snippet adds a new item to the Bulk Actions drown-down menu named Add to BP Group.</p>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/AddToBPGroup.png?ssl=1\"><img /></a>Add to BP Group Bulk Action Menu Item\n<p>Select the users you want to add to a group and select Add to BP Group. A prompt appears asking for the Buddy Group ID you want to assign the users to.</p>\n<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/EnterBuddyPressGroupIDPrompt.png?ssl=1\"><img /></a>BuddyPress Group ID Prompt\n<p>To locate the Group ID, click on the Groups admin menu and click on the group&#8217;s name. The URL will look something like this admin.php?page=bp-groups&amp;gid=357&amp;action=edit and the ID is the number that appears after gid=. After entering the ID number, click the Ok button. All of the users you selected will be assigned to that group.</p>\n<p>In the comments of the code snippet on GitHub, <a href=\"https://gist.github.com/rohmann/6151699#gistcomment-1580235\">Strand-C said</a> he wasn&#8217;t able to move 165 users at a time and had to move 50 instead. I tested this theory by moving nearly 400 registered users at the same time to a new BuddyPress group and didn&#8217;t encounter any issues. Keep in mind that the site I&#8217;m working on is relatively new, is running WordPress 4.7, and has very little traffic which could explain why I didn&#8217;t have a problem.</p>\n<p>Being able to manage BuddyPress groups in bulk should be a core feature. There is at least one <a href=\"https://buddypress.trac.wordpress.org/ticket/6161\">open ticket on BuddyPress trac</a> to add Bulk Edit options to Groups. Until these features make their way into BuddyPress, the code snippet above is a free work-around that makes adding users to groups in bulk a lot more convenient.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jan 2017 22:23:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: SiteGround Auto-Issues Let’s Encrypt Certificates for New Domains\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/siteground-auto-issues-lets-encrypt-certificates-for-new-domains\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3373:\"<p>SiteGround is now <a href=\"https://www.siteground.com/blog/https-2017/\" target=\"_blank\">auto-issuing Let&#8217;s Encrypt certificates</a> for every domain hosted on its shared servers. The company has also begun issuing and installing certificates on new accounts automatically after customers register domains or direct new domains to SiteGround&#8217;s servers. This also includes add-on domains added in cPanel. The certificates are also auto-renewed as long as the domains are pointed to the host&#8217;s servers.</p>\n<p>&#8220;Since the launch of Let’s Encrypt our customers have installed nearly 40,000 such certificates,&#8221; said Hristo Pandjarov, WordPress specialist at SiteGround. &#8220;This is less than 10% of the 500,000 domains we host. Together with the paid certificates we may say that 15% of the domains we host were using the HTTPS protocol before we started the auto-issuing procedure.&#8221;</p>\n<p>SiteGround is a sponsor of Let&#8217;s Encrypt and one of the first to auto-issue certificates to self-hosted WordPress customers. Let&#8217;s Encrypt <a href=\"https://wptavern.com/lets-encrypt-passes-20-million-active-certificates-in-2016\" target=\"_blank\">passed 20 million active certificates in 2016</a> and the pressure is on for more sites to adopt SSL in 2017 with Google marking insecure sites in Chrome and using HTTPS as a ranking signal.</p>\n<p>&#8220;What prompted this decision is that we truly believe HTTPS is the future standard for web protocol and we also believe it is the better protocol,&#8221; Pandjarov said. &#8220;This is a good enough motivation for us to take the step of installing it automatically. We have decided to automate the SSL issuance and setup almost right after the appearance of the Let’s Encrypt initiative. Matt Mullenweg’s statement at WordCamp US that issuing SSL certificates will be a very important factor in evaluating a web host, was one more validation that this planned automation was a decision in the right direction.&#8221;</p>\n<p>According to Pandjarov, the vast majority of SiteGround&#8217;s customers are running WordPress. Respondents to the company&#8217;s 2016 client survey indicated that more than two thirds of them use WordPress, which Pandjarov said is a 10% increase in the popularity of WordPress among SiteGround users.</p>\n<h3>Next Step for SiteGround: Pre-Configuring WordPress Installs to Use SSL with One Click </h3>\n<p>Auto-issuing certificates does not guarantee that SiteGround customers will jump through the hoops to configure their sites to use the certificates. Installing a certificate on an existing WordPress site is not as straightforward as a simple click in most cases. SiteGround is working on fully automating this process for its WordPress customers.</p>\n<p>&#8220;If we really want to get closer to 100% HTTPS usage, we need to do more than just automatically issue the certificate,&#8221; Pandjarov said. &#8220;Our next step is to provide a way to pre-configure an active WordPress site, hosted on our servers, to work with the already issued SSL with one click. Additionally, our auto-installer is being updated to install all new WordPress sites as https-ready.&#8221;</p>\n<p>SiteGround doesn&#8217;t yet have an ETA for one-click SSL configuration but Pandjarov said the announcement will be coming soon.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jan 2017 21:52:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: Postmatic Basic Rebrands as Replyable, Moves Two-Way Email Commenting to SaaS Product\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65245\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/postmatic-basic-rebrands-as-replyable-moves-two-way-email-commenting-to-saas-product\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5935:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/replyable.png?ssl=1\"><img /></a></p>\n<p>Postmatic is rebranding its WordPress.org <a href=\"https://wordpress.org/plugins/postmatic/\" target=\"_blank\">Postmatic Basic</a> plugin as Replyable and pushing the two-way email commenting feature into <a href=\"https://replyable.com/\" target=\"_blank\">a new SaaS product</a>. After discovering that many users simply want email commenting, without additional post delivery and newsletter features, Postmatic launched <a href=\"https://replyable.com/\" target=\"_blank\">Replyable</a> to offer this starting at $3/month.</p>\n<p>&#8220;Replyable was born out of user feedback,&#8221; founder Jason Lemieux said. &#8220;Postmatic does more than most sites need and the price is squarely mid-market. From the beginning we’ve heard from users that they already use another newsletter service and just want Postmatic to handle comment subscriptions &#8211; but that alone isn’t worth $20 to too many people. With Replyable we can offer it for $3.&#8221;</p>\n<p>Lemieux and his team have now transitioned Postmatic to be purely a Saas product without a presence in the WordPress.org directory.</p>\n<p>&#8220;Postmatic will continue to grow as a complete engagement system and, if anything, become even more complex and go further up market,&#8221; Lemieux said. &#8220;Sites which use Postmatic tend to dive in deeply. It is meant to function as a package. Grow a list, deliver to it, get them talking about your ideas, monetize the results.&#8221;</p>\n<p>The <a href=\"https://wordpress.org/plugins/postmatic/\" target=\"_blank\">Replyable plugin on WordPress.org</a> now simply covers comment subscriptions with all other features available in the commercial products.</p>\n<p>Ripping an existing feature out of a free plugin and making it paid is fairly unusual and can have a negative impact on how users perceive the plugin. However, Postmatic has a plan to allow legacy users to continue using the features they had before by switching to <a href=\"http://docs.replyable.com/article/284-switching-from-postmatic-basic-to-replyable\" target=\"_blank\">Postmatic Labs</a>. It&#8217;s an inconvenient change but is required for those who don&#8217;t want to upgrade to a commercial plan.</p>\n<p>Although WordPress.org says Postmatic has approximately 1,000 active installs, Lemieux estimates there are 8,000 users including those using the commercial plugin or the Labs plugin. He would not share any specific revenue figures but said he learned some important pricing lessons in leading the bootstrapped startup for the past two years.</p>\n<p>&#8220;We aren’t a runaway WordPress success story but we’re alive and loving our jobs,&#8221; Lemieux said. &#8220;About six months ago it became apparent that we needed to get out of the mid market. We had a huge group of people saying, &#8216;I just want email commenting and will totally pay you 5 bucks a month for it,&#8217; and another group saying, &#8216;We pay $6,000 a month sending Mailchimp RSS campaigns but yours are better for only $1500. Why so cheap?&#8217; That’s been a frustrating reality and a big lesson in knowing your audience and pricing appropriately.&#8221;</p>\n<h3>Next on Postmatic&#8217;s Roadmap: Epoch 2</h3>\n<p>In July 2015, <a href=\"https://wptavern.com/postmatic-brings-100-realtime-commenting-to-wordpress-with-epoch-plugin\" target=\"_blank\">Postmatic introduced Epoch</a> as a Disqus alternative, offering 100% realtime commenting for WordPress. The plugin submits comments via AJAX so that they appear instantly without refreshing the page. Lemieux and the team have been working on the second version for nearly a year.</p>\n<p>&#8220;Epoch 2 is a huge step forward,&#8221; Lemieux said. &#8220;We built it on top of the REST API and Angular. It’s fast and incredibly light. Commenting isn’t sexy &#8211; I don’t think it will ever be, but comments are great for SEO, community, and for building brands and authority. Comments aren’t going away. In fact, they are vitally important to keeping the web as a place for discourse, conversation, and the sharing of ideas. We need to continue to make them a better experience. Epoch isn’t groundbreaking in its functionality but it does the job of making sure sites of any size can still run native WordPress comments.&#8221;</p>\n<p>Postmatic continues to innovate with native comments, an aspect of WordPress that doesn&#8217;t have as many commercial players as something like forms or e-commerce. Lemieux attributes this underserved area to the poor reputation of previous non-native solutions.</p>\n<p>&#8220;I think it is because of the rise and fall of third party commenting system,&#8221; Lemieux said. &#8220;Early in WordPress history services like Disqus and Livefyre grabbed huge parts of the comment traffic on WordPress sites by offering more features, better speed, and improved moderation tools (with the hidden cost of selling your users down the river). It was certainly a siren song. But most all of them stagnated, violated user trust, or just plain didn’t work well. And commenting got a bad name. Naturally came the trend in disabling comments and, well, now here we are and people are trying to have conversations 140 characters at a time.&#8221;</p>\n<p>Lemieux said the innovation he sees happening outside WordPress makes him believe that comments can overcome their past reputation.</p>\n<p>&#8220;Things are getting better &#8211; and hopefully more folks will begin to innovate,&#8221; Lemieux said. &#8220;Lucky for us other blogging and publishing platforms are innovating and coming up with interesting ideas all the time. Some of them, like <a href=\"https://wordpress.org/plugins/inline-comments/\" target=\"_blank\">inline commenting</a> from Medium, do make their way back over to WordPress. That makes me optimistic.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Jan 2017 15:49:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: Aaron D. Campbell Replaces Nikolay Bachiyski as WordPress’ Security Czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65102\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://wptavern.com/aaron-d-campbell-replaces-nikolay-bachiyski-as-wordpress-security-czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2535:\"<p><a href=\"https://aarondcampbell.com/\">Aaron D. Campbell</a>, WordPress Core Contributor at GoDaddy, is replacing <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a> as WordPress&#8217; Security Czar or WordPress Core Security Team Lead. The role was <a href=\"https://wptavern.com/short-interview-with-nikolay-bachiyski-wordpress-security-czar\">created in 2015</a> to provide more structure and focus around incident responses.</p>\n<p>&#8220;The responsibilities of the position include, organizing the security team and making sure all security concerns and reports get triaged and ultimately fixed, coordinating the security side of releases, and being a point of contact for any security related things that need one,&#8221; Campbell said.</p>\n<p>Matt Mullenweg, co-creator of the WordPress project, <a href=\"https://make.wordpress.org/core/2017/01/09/aaron-campbell-leading-security/\">thanked Bachiyski</a> for being the first to accept the role and putting the foundation in place for future team leads, &#8220;This is also a good time to thank the dozens of volunteers who participate in the security group, and the researchers and reporters who bring issues to our attention,&#8221; he said.</p>\n<p>Campbell says he plans to finish what Bachiyski started by getting WordPress.org onto HackerOne. &#8220;Nikolay did a lot of work around expanding our team as well as getting the foundation laid for moving over to <a href=\"https://hackerone.com/\">HackerOne</a>,&#8221; he said.</p>\n<p>&#8220;We aren&#8217;t quite ready to make the move completely, but I hope to phase out the security@ E-Mail address in favor of HackerOne in the near future.&#8221;</p>\n<p>In late 2016, GoDaddy <a href=\"https://aarondcampbell.com/2016/09/joining-godaddy-as-a-full-time-wordpress-core-contributor/\">hired Campbell</a> to contribute to WordPress core full-time. The company continues to back his involvement in WordPress, &#8220;The role is completely voluntary,&#8221; Campbell said. &#8220;GoDaddy has truly been extremely hands off while funding me to do all this, and I&#8217;m grateful to have that continue.&#8221;</p>\n<p>If you think you&#8217;ve discovered a security vulnerability with the self-hosted version of WordPress, you&#8217;re encouraged to <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsibly disclose</a> it to the security team by emailing security @ wordpress.org and include as much detail as possible.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 14 Jan 2017 23:53:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: Automattic Releases Free Plugin for Exporting Photos from Lightroom to WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65177\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://wptavern.com/automattic-releases-free-plugin-for-exporting-photos-from-lightroom-to-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2493:\"<p>Yesterday Automattic <a href=\"https://en.blog.wordpress.com/2017/01/12/wordpress-com-lightroom/\" target=\"_blank\">released</a> a new free plugin the makes it easy for Lightroom users to export their photos to WordPress. <a href=\"http://www.adobe.com/products/photoshop-lightroom.html\" target=\"_blank\">Lightroom</a> is an Adobe product for managing and editing photos, and the plugin works with the software on MacOS and Windows. It is compatible with both WordPress.com and Jetpack-powered sites.</p>\n<p>The <a href=\"https://apps.wordpress.com/lightroom/\" target=\"_blank\">Lightroom plugin</a> requires a WordPress.com account to install. Users can then select photos in Lightroom and export them to a WordPress site with all the standard settings available, such as image resizing, watermarking, output sharpening, and more. The plugin automatically exports titles and captions. A large number of photos can take awhile to export, but once the upload is finished users can find their images in the WordPress media library.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/wp-lightroom.png?ssl=1\"><img /></a></p>\n<p>When asked for tips on suggested upload size and compression, Automattic representative John Godley said, &#8220;WordPress.com can handle pretty much anything you throw at it! I personally go for a high quality and large size so it looks good on a HiDPI screen, and then let WordPress resize as necessary to fit the viewers device.&#8221;</p>\n<p>It&#8217;s not yet clear how the release of Automattic&#8217;s free plugin will affect the commercial products that exist for a similar purpose. <a href=\"https://flothemes.com/flo-plugins/\" target=\"_blank\">FloLight</a>, <a href=\"https://meowapps.com/wplr-sync/buy/\" target=\"_blank\">WPLR Sync</a>, and other solutions will need to offer more features with a quicker setup if they want to compete with the new free Lightroom plugin.</p>\n<p>Those who want to use the plugin must already have a Lightroom license (standalone or subscription). Although this is a relatively small subset of overall WordPress users, it saves a great deal of time for photobloggers and those who process a large number of photos with Lightroom before posting online. For most, this <a href=\"https://apps.wordpress.com/lightroom/\" target=\"_blank\">plugin</a> simplifies what was previously a tedious, multi-step process of manually uploading the photos after working with them in Lightroom.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 14 Jan 2017 00:13:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: Wes Bos Launches JavaScript30, a Free 30-Day Vanilla JS Coding Course\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65209\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wptavern.com/wes-bos-launches-javascript30-a-free-30-day-vanilla-js-coding-course\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2601:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/javascript30.png?ssl=1\"><img /></a></p>\n<p>For those who failed to &#8220;learn JavaScript deeply&#8221; last year, 2017 offers a clean slate for restarting your JavaScript learning goals. <a href=\"http://wesbos.com/\" target=\"_blank\">Wes Bos</a>, a developer and educator known for his high quality video tutorials, recently launched a free 30-day vanilla JS coding challenge course that provides structure for developing a new habit of daily learning.</p>\n<p><a href=\"https://javascript30.com/\" target=\"_blank\">JavaScript30</a> walks users through building 30 things in 30 days with no frameworks, no compilers, no libraries, and no boilerplate. The course is suitable for beginner to intermediate developers and designers who want to get a solid grasp of JavaScript fundamentals. It purposely steers clear of abstractions like frameworks to help students gain a better understanding of browser APIs while working in the DOM without a library.</p>\n<p>Bos designed the course to help students gain competence through building things, the advice he gives to anyone wanting to improve their JavaScript skills.</p>\n<p>&#8220;So, you&#8217;ve done a few courses and read a few books but still don&#8217;t feel great about your relationship with JavaScript,&#8221; Bos said. &#8220;How do you get better? Build things. Lots of things. Build 1,000 things. Keep it up and don&#8217;t stop.&#8221; The course is packed full of quick, interesting, and practical projects.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/javascript30-lessons.png?ssl=1\"><img /></a></p>\n<p>JavaScript30 includes access to 30 videos, 30 days of starter files, and completed HTML, CSS, and JS Solutions for each day. The videos are accessible and ESL-friendly with closed captions provided.</p>\n<p>Bos said he spent more than 300 hours creating the videos as a thank-you to those who have supported his paid courses.</p>\n<p>&#8220;I see a huge need for these videos and I really think it will help many&#8230;become comfortable creating with JavaScript,&#8221; he said.</p>\n<p>Bos is also the author of the free <a href=\"https://wptavern.com/wes-bos-launches-free-react-js-redux-online-course\" target=\"_blank\">Learn Redux</a> course, which includes 2.5 hours of videos that help students get started with React.js, Redux, and React Router. Some of his other popular <a href=\"http://wesbos.com/courses/\" target=\"_blank\">courses</a> include React for Beginners, Learn Redux, and ES6 for Everyone.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 Jan 2017 22:05:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WPTavern: WPWeekly Episode 259 – 2016 Year in Review Part 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=65198&preview=true&preview_id=65198\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wptavern.com/wpweekly-episode-259-2016-year-in-review-part-2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1040:\"<p>In this episode, <a href=\"http://www.marcuscouch.com/\">Marcus Couch</a> and I recap the news that made headlines during the second half of 2016. I explain why there wasn&#8217;t a show last week and we close out the episode with our predictions for 2017. We&#8217;ll be back to our regular show format on Wednesday, January 18th.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, January 18th 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #259:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 Jan 2017 09:37:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: 2nd Edition of Producing Open Source Software Now Available for Free\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65181\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wptavern.com/2nd-edition-of-producing-open-source-software-now-available-for-free\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3579:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/producing-oss.png?ssl=1\"><img /></a></p>\n<p>The second edition of <a href=\"http://www.red-bean.com/kfogel/\" target=\"_blank\">Karl Fogel</a>&#8216;s &#8220;Producing Open Source Software: How to Run a Successful Free Software Project&#8221; is now available for download. Fogel, a partner at <a href=\"https://opentechstrategies.com/\" target=\"_blank\">Open Tech Strategies</a> and OSS contributor since 1997, was a founding developer in the Subversion project. He has worked for more than a decade as an open source specialist, helping businesses and organizations evaluate, launch, and manage open source projects.</p>\n<p><a href=\"http://producingoss.com/\" target=\"_blank\">Producing Open Source Software</a> version 2 was released for free this week under the Attribution-ShareAlike 4.0 International license. The first edition was published in 2005 but the landscape of OSS has changed drastically over the past 12 years. In 2013, Fogel <a href=\"https://www.kickstarter.com/projects/kfogel/updating-producing-open-source-software-for-2nd-ed/description\" target=\"_blank\">successfully raised $15,376</a> towards his $10,000 Kickstarter goal to fund the revision.</p>\n<p>The book includes topics like &#8216;Free&#8217; Versus &#8216;Open Source,&#8217; choosing a license, version control, social and political infrastructure, the economics of open source, culture, and communication. It was written for managers and software developers but can also be informative for newcomers to open source projects.</p>\n<p>Fogel originally planned on finishing the second edition by the end of 2013 but experienced delays due to starting his company. Some chapters also took longer to revise than he anticipated.</p>\n<p>&#8220;In retrospect, if I had understood what the pressures of a young and growing company would be, I would not have started the 2nd edition when I did,&#8221; Fogel said. &#8220;It has been a lesson.&#8221; Fortunately, for the 314 Kickstarter backers  who might have been waiting on his work for four years, progress was immediately available in the public repository for the book. Fogel didn&#8217;t keep any private version of the book elsewhere.</p>\n<p>&#8220;While there are substantial changes throughout the book, the most expanded chapter is probably Chapter 5, &#8216;Participating as a Business, Non-Profit, or Government Agency,\'&#8221; Fogel said. &#8220;That chapter&#8217;s title used to be just &#8216;Money,&#8217; so that gives you some idea of what the new material is.&#8221;</p>\n<p>He also found the third chapter on technical infrastructure to be more time consuming than the others due to all of the changes in the past decade. It took roughly four and a half months to revise it to include modern development tools.</p>\n<p>One of the central focuses of the book is the value of collaboration and the direct benefits it provides to an open source software project.</p>\n<p>&#8220;Competence at cooperation itself is one of the most highly valued skills in free software,&#8221; Fogel wrote in the preface. &#8220;Good free software is a worthy goal in itself&#8230; But beyond that I also hope to convey something of the sheer pleasure to be had from working with a motivated team of open source developers, and from interacting with users in the wonderfully direct way that open source encourages. Participating in a successful free software project is a deep pleasure, and ultimately that&#8217;s what keeps the whole system going.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Jan 2017 23:13:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"Post Status: New Year’s resolutions for WordPress developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=32188\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://poststatus.com/new-years-resolutions-wordpress-developers/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15739:\"<p><em><strong>Editor&#8217;s Note:</strong></em> This is a guest post by <a href=\"https://poststatus.com/profiles/jack-lenox/\">Jack Lenox</a>. Jack is a developer at Automattic and hails from the United Kingdom.</p>\n<p>For just over a year now, I have been working on the <a href=\"https://vip.wordpress.com/\">WordPress.com VIP</a> team at Automattic. I had been working at Automattic for the two years prior to this – and had been developing sites with PHP and WordPress for almost ten years prior to that. So you might imagine that I had a pretty good handle on developing stuff with WordPress.</p>\n<p>And you would be wrong. Getting started with the VIP team was an eye-opening and occasionally terrifying learning experience, occasionally resulting in me thinking: &#8220;please excuse me for a moment while I go and fix some horrible vulnerability in all of my WordPress sites.&#8221;</p>\n<p>Recently, I have cautiously found myself feeling slightly more comfortable with my position on the team. For some time, I have been wanting to document the most interesting and impactful things that I have learned in the past year.</p>\n<p>As some readers may know, a significant part of a developer&#8217;s job on the VIP team is reviewing code. Thus, with us being at the start a new year, I have hereby compiled some of the most interesting best practices I have discovered as a list of New Year&#8217;s Resolutions:</p>\n<h3>1. Use strict comparison operators</h3>\n<p>One of the many quirks of PHP is that it enjoys juggling. In particular, it enjoys <a href=\"http://php.net/manual/en/language.types.type-juggling.php\">juggling types</a>. This means that without explicit instruction, PHP doesn&#8217;t see a difference between a string of &#8220;string&#8221;, an integer of 0, and a boolean value of <code>true</code>.</p>\n<p>So for example this:</p>\n<pre><code>$var = 0;\nif ( $var == \'safe_string\' ) {\n    return true;\n}\n</code></pre>\n<p>Will return true. I know, what?! The easy solution here is to simply use strict comparison operators.</p>\n<p>So that&#8217;s <code>===</code> instead of <code>==</code>, and <code>!==</code> instead of <code>!=</code>. This pops up in a few other places too. By default the <a href=\"http://php.net/manual/en/function.in-array.php\"><code>in_array()</code></a> function has its strict parameter set to false.</p>\n<p>So:</p>\n<pre><code>in_array( 0, [\'safe_value\', \'another string\'] );\n</code></pre>\n<p>Will return true. To fix this, simply pass a third parameter of <code>true</code>.</p>\n<p>While we&#8217;re here, there&#8217;s one other form of comparison we should be aware of, and that&#8217;s <a href=\"http://php.net/manual/en/function.hash-equals.php\"><code>hash_equals()</code></a>. This provides a string comparison that prevents timing attacks.</p>\n<p>While a relatively uncommon form of attack on the web, it&#8217;s worth being aware of a timing attack. What is it? Well, when PHP compares two strings, it compares them one character at a time.</p>\n<p>So in the case of something like this:</p>\n<pre><code>$submitted_password = $_POST[\'password\']; // For argument\'s sake, let\'s say it\'s \"pa45word\"\n$password = \"pa55word\";\n\nif ( $submitted password === $password ) {\n    go_forth();\n}\n</code></pre>\n<p>PHP&#8217;s thought process in human terms is: Is the first character of each string p? Yes it is. Is the second character of each string a? Yes it is. And so on.</p>\n<p>It will do this until it realizes that the third characters differ and at that point it will bail. Thus, with sophisticated timing software, a password can gradually be worked out by calculating how long the process is taking. If the process takes slightly longer with one character than it does with every other character, an attacker will know that they have worked out the first character.</p>\n<p>Automated processes can keep doing this until the entire password is worked out. <code>hash_equals()</code> will compare two values, but will not bail early if it detects a difference.</p>\n<p>In conclusion, if you&#8217;re comparing sensitive values, use <code>hash_equals()</code>!</p>\n<h3>2. Use Yoda condition checks, you must</h3>\n<p>The <a href=\"https://make.wordpress.org/core/handbook/best-practices/coding-standards/php/#yoda-conditions\">WordPress PHP Coding Standards</a> suggest that you should: &#8220;always put the variable on the right side and put constants, literals or function calls on the left side.&#8221; Initially, this might just sound like a bit of pedantry, but it actually has a very practical application.</p>\n<p>Consider how catastrophic the following typo could be:</p>\n<pre><code>if ( $session_authorized = true ) {\n    unleash_the_secrets();\n}\n</code></pre>\n<p>Oh dear, instead of checking that <code>$session_authorized</code> is true, I am instead assigning the value of true to that variable.</p>\n<p>Now the secrets are being unleashed to whoever wants them. This could easily be missed when checking the code for bugs, even by a reviewer.</p>\n<p>Now imagine if the first line was expressed as:</p>\n<pre><code>if ( true = $session_authorized ) {\n</code></pre>\n<p>Well, it doesn&#8217;t. We can&#8217;t assign a variable to the static boolean value of <code>true</code>.</p>\n<p>Hopefully it won&#8217;t take us too long to work out why our code is still broken, but the secrets remain safe. So we&#8217;re good! <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f600.png\" alt=\"?\" class=\"wp-smiley\" /></p>\n<h3>3. ABE. A Always, B Be, E Escaping. Always Be Escaping. ALWAYS Be Escaping.</h3>\n<p>Not having a firm grasp of the concepts of validation, sanitization and escaping can make you a very dangerous developer indeed.</p>\n<p>To the extent that libraries like React escape all output by default and to bypass this functionality, you have to use the attribute: <code>dangerouslySetInnerHTML</code></p>\n<p>Validation is checking that what your code is being passed is even vaguely what it&#8217;s expecting. So for instance, if we&#8217;re expecting an integer, we can use something like: <code>$zipcode = intval( $_POST[\'my-zipcode\'] )</code></p>\n<p>The <code>intval()</code> function returns its input as an integer and defaults to zero if the input was a non-numeric value. So while this won&#8217;t prevent our code from being passed zipcodes that aren&#8217;t valid, it does protect our code from being passed anything that isn&#8217;t a number.</p>\n<p>Naturally, we could go a step further to see if the zipcode actually appears to be valid. For example, 1111111111111 is not a valid zip code, but <code>intval()</code> doesn&#8217;t know that.</p>\n<p>Fortunately, beyond integers, WordPress has <a href=\"https://codex.wordpress.org/Data_Validation#Input_Validation\">a bunch of handy helper functions for almost every data type</a> including my favourite: <code>is_email().</code></p>\n<p>Sanitization is cleaning input to make sure that it&#8217;s safe in the context where we want to use it. This prevents one of the most common forms of security vulnerability, an <a href=\"https://www.owasp.org/index.php/SQL_injection\">SQL injection attack</a>.</p>\n<p>We also sanitize to fix practical things, like checking for invalid UTF-8 characters. WordPress has a class of <a href=\"https://codex.wordpress.org/Data_Validation#Input_Validation\"><code>sanitize_*()</code> helper functions</a>; here&#8217;s an example of how one looks in the wild:</p>\n<pre><code>$title = sanitize_text_field( $_POST[\'title\'] );\nupdate_post_meta( $post-&gt;ID, \'title\', $title );\n</code></pre>\n<p>Therefore no matter what garbage we might have been passed in <code>$_POST[\'title\']</code>, it won&#8217;t cause any real problems.</p>\n<p>Escaping is similar to sanitization, but instead it is cleaning what we&#8217;re sending out, rather than what we&#8217;re taking in. A major reason for doing this is to prevent another of the most common forms of security vulnerability, a <a href=\"https://www.owasp.org/index.php/XSS\">Cross-site Scripting (or XSS) attack</a>.</p>\n<p>We want to clean our output to ensure we aren&#8217;t accidentally echoing out something very dangerous that we didn&#8217;t realize we were inadvertently storing in our database (or perhaps fetched from an API).</p>\n<p>WordPress has <a href=\"https://codex.wordpress.org/Data_Validation#Output_Sanitization\">a bunch of very useful helper functions here</a>. Some common examples of these in the wild are:</p>\n<pre><code>&lt;h4&gt;&lt;?php echo esc_html( $title ); ?&gt;&lt;/h4&gt;\n</code></pre>\n<pre><code>&lt;img alt=\"\" src=\"&lt;?php echo esc_url( $great_user_picture_url ); ?&gt;\" /&gt;\n</code></pre>\n<pre><code>&lt;ul class=\"&lt;?php echo esc_attr( $stored_class ); ?&gt;\"&gt;\n</code></pre>\n<p>There is also <a href=\"https://developer.wordpress.org/reference/functions/wp_kses/\"><code>wp_kses()</code></a> which can be used on everything that is expected to contain HTML, and will filter out elements that are not explicitly allowed.</p>\n<p>As a general rule, the <code>the_*()</code> and <code>get_the_*()</code> theme functions are already escaped. However, the <code>get_bloginfo()</code> function, for example, is not escaped.</p>\n<p>For further information here, I highly recommend checking out the VIP team&#8217;s documentation on <a href=\"https://vip.wordpress.com/documentation/vip/best-practices/security/validating-sanitizing-escaping/\">Validating, Sanitizing, and Escaping</a>.</p>\n<h3>4. Stop trusting everything</h3>\n<p>Don&#8217;t trust user input. Don&#8217;t trust what&#8217;s in your database. Don&#8217;t trust any variables.</p>\n<p>Treat every variable with contempt.</p>\n<p>This way, even if, for example, someone sneaks some dodgy XSS code into your database, it&#8217;ll still get escaped on output and your site will be better protected.</p>\n<h3>5. Avoid inserting HTML directly into the document (when using JavaScript)</h3>\n<p>Doing something like this is dangerous because the data that we&#8217;re using could include many more DOM elements that dramatically alter the anticipated behavior of this code, and make it vulnerable to XSS attacks:</p>\n<pre><code>jQuery.ajax({\n    url: \'http://any-site.com/endpoint.json\'\n}).done( function( data ) {\n    var link = \'&lt;a href=\"\' + data.url + \'\"&gt;\' + data.title + \'&lt;/a&gt;\';\n\njQuery( \'#my-div\' ).html( link );\n});\n</code></pre>\n<p>Instead, we should programmatically create DOM nodes and append them to the DOM. So the above instead becomes this:</p>\n<pre><code>jQuery.ajax({\n    url: \'http://any-site.com/endpoint.json\'\n}).done( function( data ) {\n    var a = jQuery( \'&lt;a /&gt;\' );\n    a.attr( \'href\', data.url );\n    a.text( data.title );\n\njQuery( \'#my-div\' ).append( a );\n});\n</code></pre>\n<p>This is how a library like React does things behind the scenes. You can read more about this in <a href=\"https://vip.wordpress.com/2015/03/25/preventing-xss-in-javascript/\">a wonderful post about preventing XSS attacks in JavaScript</a> by my colleague, Nick Daugherty.</p>\n<h3>6. Review code</h3>\n<p>Have you ever reviewed a plugin before using it? I know, who&#8217;s got time for that right? I&#8217;ll tell you who: you.</p>\n<p>I have come to realize that reviewing code is possibly one of the best exercises for improving as a developer. Even if you&#8217;re quite new to programming or development, and you still feel pretty green, you really should give it a go.</p>\n<p>A great way to start is to review the next plugin you decide to use on your website. Before activating it, pop it open in your text editor of choice, and just spend some time scanning through it to understand what it does.</p>\n<p>A method I like to use here is to interpret each line of the code in simple English. You can even say it loud if you like – assuming you&#8217;re not sitting in a café or co-working space where people might become worried about you.</p>\n<p>You might be surprised at how often you find bugs and quirks in the code, or that the code isn&#8217;t conforming to the best practices outlined above. And if you discover issues, why not create a patch? Or if the plugin is on GitHub, create a pull request.</p>\n<p>You can also review your own code. A great method for doing this is to never deploy code straight into production. Instead, leave it on the day you finish it, and review it line by line in the morning. This method is easiest to adopt if you&#8217;re using something like GitHub where you can create a pull request with the changes, then review the pull request yourself the next day before merging it.</p>\n<p>In this vein, I highly recommend watching my colleague, Ryan Markel&#8217;s, <a href=\"http://wordpress.tv/2016/12/10/ryan-markel-code-review-keeping-things-secure-clean-and-performant/\">fantastic talk on this topic from WordCamp US 2016</a>.</p>\n<h3>7. Upgrade your tools (or at least use PHP_CodeSniffer)</h3>\n<p>There are lots of tools that help make web development easier, but if you&#8217;re doing a lot of WordPress development, the most valuable is probably <a href=\"https://github.com/squizlabs/PHP_CodeSniffer\">PHP<em>CodeSniffer</em></a>. It reads your code and automatically reviews it for bugs and coding standards inconsistencies while you type.</p>\n<p>It&#8217;s kind of like a spell checker, but for code. No matter how good your English is, you still use spell check right? So why wouldn&#8217;t you spell check your code?</p>\n<p>Here&#8217;s a bonus for you: the WordPress VIP Coding Standards are available by default with the <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards\">WordPress Coding Standards for PHPCodeSniffer</a>. So with that, it&#8217;ll check if you&#8217;re following most of the above resolutions.</p>\n<p>As you might imagine, using PHP_CodeSniffer also really helps highlight potential problems when you&#8217;re reviewing plugins and other people&#8217;s code.</p>\n<h3>8. Be curious</h3>\n<p>Far too often, I&#8217;m guilty of searching to try to find out what a particular WordPress function does, or scanning Stack Overflow to see if someone&#8217;s having the same problem as me.</p>\n<p>I have historically had a bad habit of seeing much of what WordPress does as magic, and avoiding getting too deep in the inner workings. But actually, it can be very beneficial to find out answers for yourself, instead of trying to find others who have already done the work.</p>\n<p>In essence, WordPress is quite simple. The code largely consists of functions taking arguments, and doing things with those arguments, and passing the results onto other functions taking arguments, and so on.</p>\n<p>It doesn&#8217;t take much to start unpicking something, and working out exactly what&#8217;s happening behind the scenes. So next time you&#8217;re struggling with a function, try going straight to looking at what the function actually does.</p>\n<p>Personally I find the <a href=\"https://github.com/wordpress/wordpress\">WordPress GitHub repo</a> that mirrors the core SVN repo to be a very useful way of doing this.</p>\n<p>The WordPress strapline is that &#8220;code is poetry&#8221;, and for its flaws I find that on the most part, the WordPress codebase is very readable, if nothing else! <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f609.png\" alt=\"?\" class=\"wp-smiley\" /></p>\n<p>I&#8217;ll conclude by taking this opportunity to wish you a very happy and prosperous new year!</p>\n<p><strong><em>Note</em>:</strong> Some of the above has been gleefully plagiarized from <a href=\"https://vip.wordpress.com/documentation/vip/code-review-what-we-look-for/\">WordPress.com VIP&#8217;s Code Review documentation</a>. It&#8217;s an Aladdin&#8217;s cave of useful advice, and I highly recommend working your way through it as and when you can.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Jan 2017 21:26:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Jack Lenox\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"WPTavern: Tom McFarlin to Launch Marketplace for Blogging Plugins, Finds New Maintainer for WordPress.org Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64899\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"https://wptavern.com/tom-mcfarlin-to-launch-marketplace-for-blogging-plugins-finds-new-maintainer-for-wordpress-org-plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5189:\"<p>Daily blogger and plugin author Tom McFarlin has found a new maintainer for five of his WordPress.org plugins. Within two days of <a href=\"https://tommcfarlin.com/wordpress-plugin-adoption/\" target=\"_blank\">putting the plugins up for adoption</a>, McFarlin <a href=\"https://tommcfarlin.com/wordpress-plugins-adopted/\" target=\"_blank\">announced</a> that <a href=\"https://twitter.com/philip_arthur\" target=\"_blank\">Philip Arthur Moore</a> will be taking over Category Sticky Post, Comment Tweets, Single Post Message, Tag Sticky Post, and Tipsy Social Icons. Moore, who is currently working as CTO at <a href=\"https://professionalthemes.nyc/\" target=\"_blank\">Professional Themes</a>, has inherited roughly 10,000 users overnight in the transfer of maintainership.</p>\n<p>WordPress.org plugin adoption stories are few and far between. The most common scenario for an orphaned plugin is to languish in the directory until it disappears from search results (with the exception of exact matches) after two years of no updates. In McFarlin&#8217;s case, he was looking to tie up some loose ends before shifting Pressware&#8217;s focus to launching Blogging Plugins, a marketplace for extensions that streamline WordPress for regular bloggers.</p>\n<p>&#8220;Last year, I had a few false starts when trying to launch what was originally called Pressware Plugins,&#8221; McFarlin said. &#8220;Fast-forward a few months and we’re going to focus on something called Blogging Plugins. We already have two free plugins available, though there’s an entire set of plugins, marketplace, and more coming.&#8221;</p>\n<p>Moore&#8217;s adoption of the plugins, which includes the first plugin McFarlin ever wrote, allows Pressware to move forward with its <a href=\"https://tommcfarlin.com/2017-plans/\" target=\"_blank\">2017 objectives</a>. McFarlin said he selected Moore based on the quality of his open source projects and reputation in the WordPress community.</p>\n<p>&#8220;For those of you who aren’t familiar with Philip’s side projects, you may be familiar with <a href=\"https://wordpress.org/plugins/subtitles/\" target=\"_blank\">Subtitles</a>,&#8221; McFarlin said. &#8220;It’s a plugin that falls right in line with my personal ethos of how things should work with WordPress: You activate it, it’s ready to go, and it feels native within the application.&#8221;</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Why would I adopt <a href=\"https://twitter.com/tommcfarlin\">@tommcfarlin</a>\'s work? Because I owe him. He\'s ethical, an amazing man, and a stellar coder: <a href=\"https://t.co/WM66Xu1vm1\">https://t.co/WM66Xu1vm1</a></p>\n<p>&mdash; Philip Arthur Moore (@philip_arthur) <a href=\"https://twitter.com/philip_arthur/status/817399604698173440\">January 6, 2017</a></p></blockquote>\n<p></p>\n<p>The <a href=\"https://wordpress.org/plugins/tags/adopt-me\" target=\"_blank\">adopt-me</a> tag is used on WordPress.org to indicate plugins where the author is looking for a new maintainer. With just two pages of listings, it&#8217;s not yet widely used. Most developers find it easier to fork an open source plugin and WordPress.org has recently made it easier than ever for authors to <a href=\"https://make.wordpress.org/plugins/2016/12/22/want-to-close-your-plugins-email/\" target=\"_blank\">close a plugin</a> by simply emailing the plugin team.</p>\n<p>However, not all orphaned plugins are ready for end of life measures. Circumstances change in plugin authors&#8217; lives, but the strength of the user base is one of the primary indicators of a project that could thrive in new hands. The built-in user base is also one of the main advantages of adopting a plugin as opposed to forking it.</p>\n<p>Developer and ZDNet columnist David Gewirtz discovered the full weight of adopting a plugin&#8217;s users when he <a href=\"http://www.zdnet.com/article/a-year-later-what-happens-when-you-adopt-an-open-source-project/\" target=\"_blank\">took on 10 plugins</a> from the adopt-me section of the directory. Gewirtz, who inherited approximately 50,000 users, said the experience helped him reconnect with real users.</p>\n<p>&#8220;The value I&#8217;ve gained as a columnist, advisor, and educator that has come from interacting with users from so many nations with so many different skill sets and missions has been off the charts,&#8221; Gewirtz said. &#8220;I thought I&#8217;d keep my programming chops up, and I&#8217;ve certainly done that. But I never expected I&#8217;d gain a much broader perspective that I&#8217;d be able to apply to all of the areas of my professional life and meet so many cool people.&#8221;</p>\n<p>Adoption is arguably the healthiest outcome for any orphaned project &#8211; not just for the sake of reducing plugin abandonment but also for continuing support for users. Many of them blindly depend on plugins with no understanding of how they work.</p>\n<p>Once a plugin is downloaded and installed on users&#8217; sites, it gains a life of its own. Adoption strengthens a project&#8217;s history by proving it can weather storms that might otherwise cause the plugin to become obsolete and wipe out the user base.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Jan 2017 07:59:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Thirty-Three\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47034\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2017/01/thirty-three/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4279:\"<p>I&#8217;m taking it easy this week, nothing too crazy &#8212; just sharing good meals and wine with friends. Which is probably a good example of my goals for the year: putting family and loved ones first, slowing down (<a href=\"https://ma.tt/2014/10/run-better/\">to go further</a>), and deliciousness. (<a href=\"https://www.singlethreadfarms.com/\">Single Thread Farms</a> blew me away.)</p>\n<p>2016 was a year of incredible contrasts: it was the saddest and most challenged I&#8217;ve ever been with the <a href=\"https://ma.tt/2016/04/in-memoriam-chuck-mullenweg/\">passing of my father</a>, and while that overshadowed everything there were also bright moments of coming closer to family, deepening friendships, and growing professionally with incredible progress from both WordPress and Automattic. That momentum on the professional side is carrying through and right now I&#8217;m the most optimistic I can recall, and thrilled to wake up and get to work every day with the people I do.</p>\n<p>I talked about trying to spend longer stretches of time in fewer places, and that definitely happened. I flew 162k fewer miles than <a href=\"https://ma.tt/2016/01/thirty-two/\">the year before</a>, and visited 35 fewer cities. My blogging decreased a lot too &#8212; from 252 posts in 2015 to 76 posts in 2016, but the posts I did write were at least 50% longer. I made it to 9 more of the Top 50 restaurants and stand currently at 50% of <a href=\"http://www.theworlds50best.com/list/1-50-winners\">the list</a>. I finished <a href=\"https://www.pinterest.com/saxmatt/books-in-2016/\">22 books</a>, including a lot more fiction including my first few graphic novels like Ex Machina, Y: The Last Man, and Watchmen. I watched 35 movies, 9 of which were from the Marvel universe on a single flight from Cape Town to Dubai.</p>\n<p><a href=\"https://ma.tt/2016/01/thirty-two/\">Last year</a> I said, &#8220;it’s exciting to make the most of the opportunity that the volatility, love, loss, glory, failure, inspirations, and setbacks that 2016 will bring.&#8221; I didn&#8217;t know how right I would be, and wish I hadn&#8217;t been.</p>\n<p>This year doesn&#8217;t start with new plans, but rather three intentions continued from a few months ago. I <a href=\"https://ma.tt/2017/01/rebirth-and-yellow-arrows/\">revealed one yesterday</a>, and promised I would expand today on the others, so here they are:</p>\n<ol>\n<li><strong>Symmetry</strong> &#8212; Balance in all things, including my body which is stronger on my right side and much tighter on my left side. We also need symmetry in WordPress between the .org and .com products which differ too much.</li>\n<li><strong>Stillness</strong> &#8212; In echoes <a href=\"https://www.amazon.com/Art-Stillness-Adventures-Going-Nowhere-ebook/dp/B00JSRQSJS\">of Pico Iyer</a>, so much of my life in my 20s was about movement, and &#8220;going places to be moved.&#8221; In my 30s I&#8217;m looking inward. As Saint Augustine said in Book X, chapter 8 of <em>Confessions</em>: &#8220;Men go forth to wonder at the heights of mountains, the huge waves of the sea, the broad flow of the rivers, the vast compass of the ocean, the courses of the stars, and they pass by themselves without wondering.&#8221;</li>\n<li><strong>Yellow Arrows</strong> &#8212; The idea that there are clear indications of where to go next at every fork in the road, and if not you should paint them. I wrote more <a href=\"https://ma.tt/2017/01/rebirth-and-yellow-arrows/\">on this  yesterday</a>.</li>\n</ol>\n<p>Previously: <a href=\"https://ma.tt/2003/01/bday/\">19</a>, <a href=\"https://ma.tt/2004/01/so-im-20/\">20</a>, <a href=\"https://ma.tt/2005/01/hot-barely-legal-matt/\">21</a>, <a href=\"https://ma.tt/2006/01/matt-22/\">22</a>, <a href=\"https://ma.tt/2007/01/twenty-three/\">23</a>, <a href=\"https://ma.tt/2008/01/twenty-four/\">24</a>, <a href=\"https://ma.tt/2009/01/twenty-five/\">25</a>, <a href=\"https://ma.tt/2010/01/twenty-six/\">26</a>, <a href=\"https://ma.tt/2011/01/twenty-seven/\">27</a>, <a href=\"https://ma.tt/2012/01/twenty-eight/\">28</a>, <a href=\"https://ma.tt/2013/01/twenty-nine/\">29</a>, <a href=\"https://ma.tt/2014/01/matt-3-0/\">30</a>, <a href=\"https://ma.tt/2015/01/thirty-one/\">31</a>, and <a href=\"https://ma.tt/2016/01/thirty-two/\">32</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Jan 2017 07:59:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: WordPress 4.7.1 Fixes Eight Security Issues\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65100\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wptavern.com/wordpress-4-7-1-fixes-eight-security-issues\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2146:\"<p>WordPress 4.7.1 <a href=\"https://wordpress.org/news/2017/01/wordpress-4-7-1-security-and-maintenance-release/\">is available</a> for download and fixes eight security issues that affect WordPress 4.7 and below. The PHPMailer library was updated to patch a remote code execution (RCE) vulnerability. WordFence <a href=\"https://www.wordfence.com/blog/2016/12/phpmailer-vulnerability/\">reported the vulnerability</a> last month as critical and that it affects WordPress core.</p>\n<p>However, in the announcement post for 4.7.1, Aaron Campbell, WordPress&#8217; <a href=\"https://make.wordpress.org/core/2017/01/09/aaron-campbell-leading-security/\">new Security Czar</a> says that, &#8220;No specific issue appears to affect WordPress or any of the major plugins we investigated but, out of an abundance of caution, we updated PHPMailer in this release.&#8221; <a href=\"https://legalhackers.com/\">Dawid Golunski</a> and <a href=\"https://twitter.com/Zenexer\">Paul Buonopane</a> are credited with <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsibly disclosing</a> the vulnerability.</p>\n<p>WordPress 4.7.1 also fixes an issue where the REST API exposed user data for all users who authored a post of a public post type. This release limits this ability to only post types which have specified that they should be shown within the API. <a href=\"https://poststatus.com/\">Brian Krogsgard</a> and <a href=\"https://ithemes.com/\">Chris Jean</a> are credited with <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsibly disclosing</a> the vulnerability.</p>\n<p>In addition to patching eight security issues, this release fixes 62 bugs. To see a full list of changes, visit the <a href=\"https://codex.wordpress.org/Version_4.7.1\">release notes</a> page or you can <a href=\"https://core.trac.wordpress.org/query?milestone=4.7.1\">view them on Trac</a>. Sites should update automatically but if you&#8217;d like to update sooner, visit your site&#8217;s Dashboard, select Updates, and click the Update Now button.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 23:19:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"WPTavern: Facebook Launches Journalism Project, Plans to Expand Monetization of Instant Articles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65121\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"https://wptavern.com/facebook-launches-journalism-project-plans-to-expand-monetization-of-instant-articles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3423:\"<p>After taking heat for the proliferation of &#8220;fake news&#8221; and misinformation on its platform during the US presidential election, Facebook is aiming to strengthen its ties with the news industry.</p>\n<p>&#8220;We care a great deal about making sure that a healthy news ecosystem and journalism can thrive,&#8221; Facebook director of product Fidji Simo said in the <a href=\"https://media.fb.com/2017/01/11/facebook-journalism-project/\" target=\"_blank\">announcement</a> today.</p>\n<p>The new <a href=\"https://www.facebook.com/facebookmedia/get-started/facebook-journalism-project\" target=\"_blank\">Facebook Journalism Project</a> will focus on creating news products with feedback from publishers, providing training and tools for journalists, and promoting news literacy for the public.</p>\n<p>In 2015 Facebook launched Instant Articles to deliver publishers&#8217; content instantly in exchange for advertising revenue. The platform will be expanding the feature to combine multiple Instant Articles in one post, starting January 12, 2017.</p>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/facebook-multiple-instant-articles.png?ssl=1\"><img /></a>image credit: <a href=\"https://media.fb.com/2017/01/11/multiple-instant-articles/\">Facebook</a>\n<p>&#8220;We’ve heard from editors that they want to be able to present packages of stories to their most engaged readers on Facebook,&#8221; Simo said. &#8220;We’re starting to work with several partners on how best to do this. We’re going to start testing this using Instant Articles, so that readers can start to see <a href=\"https://media.fb.com/2017/01/11/multiple-instant-articles/\" target=\"_blank\">multiple stories</a> at a time from their favorite news organizations.&#8221; Facebook is currently testing this feature with BILD, BuzzFeed, El Pais, Fox News, Hindustan Times, The Sun, The Washington Post, and other publishers.</p>\n<p>In April 2016, Automattic partnered with Facebook and VIP-Featured-Partner agency Dekode to develop <a href=\"https://wordpress.org/plugins/fb-instant-articles/\" target=\"_blank\">Instant Articles for WP</a>, a plugin that outputs a compliant feed of posts wrapped in the required markup for Facebook. The plugin passed 10K active installs at the end of 2016, but its star rating continues to plummet due to numerous errors with updates and a lack of support. Only 1 of 42 support threads has been marked resolved in the last two months. Publishers who depend on the plugin may need to have a developer on staff to handle issues with the plugin or select another solution.</p>\n<p>Facebook is also planning to collaborate with publishers on subscription business models for their content. Participation in this feature will require the publisher to make its content available through Instant Articles.</p>\n<p>&#8220;Many of our partners have placed a renewed emphasis on growing their subscription funnel, and we’ve already begun exploring ways we can support these efforts,&#8221; Simo said. &#8220;This month our engineering team in collaboration with the engineering team of the German news organization BILD will launch a test to explore offering free trials to engaged readers, right from within Instant Articles.&#8221; Simo also said they are working on other monetization options for publishing partners, including advertising breaks in regular videos.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 21:49:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"HeroPress: Blogging, Solopreneurship, &amp; Terrorism\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1563\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://heropress.com/essays/blogging-solopreneurship-terrorism/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13067:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/01/011117-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: We will survive this, and this too will pass. You have my word.\" /><p>This story involves me as a blogger, the Prime Minister, me again as a web developer, an Islamic cult attempting a coup d&#8217;état, and me again as a solopreneur. Oh, and WordPress. And ISIS.</p>\n<h2>WordPress: My First Encounter</h2>\n<p>In the beginning of 2006, everyone in Turkey was talking about blogs. It was the hot new thing on the web. Forums were &#8220;out&#8221; and blogs were &#8220;in&#8221;. Anyways, I was getting ready for the ÖSS and studying to get into a university but I was psyched enough to register a blog on WordPress.com, on January 2006. (I moved the blog into a free hosting space the next month, and opened up <a href=\"http://beyn.org\">beyn.org</a> in July 2006.) I was in Kocaeli, the city right next to İstanbul.</p>\n<p>After the registration, I realized that I had nothing to write about. So I wrote about the day I had. The next day, I did the same thing. And the next day. And the next seven and a half years. Of course, I skipped four or five days. But that kind of dedication earned me a reputation and an award for &#8220;Best Personal Blogger of 2008&#8221;.</p>\n<p>But I didn&#8217;t just write about my days. After getting accepted into Ankara University in September 2006, I began to read and think about politics, as nearly all young Turks do in university. Eventually, I started writing about politics as well. Because you know what they say: If you want to learn something, write about it.</p>\n<p>Oh, I learned it pretty well, and I learned it the (somewhat) hard way.</p>\n<h2>Facing Jail Time with a Blog Post</h2>\n<p>2010 was probably my darkest year in my entire life. (2016 is the next candidate.) I was 22 years old, blogging daily, learning about web design and WordPress (more on that later), and keeping up with what&#8217;s going on with the country. Things were crazy back then: A very big prosecution was going on called the Ergenekon Case about military people allegedly planning a coup (Hint: This is not the coup I mentioned in the intro! These guys were all acquitted later.) and a big campaign for a constitutional referandum was more than enough to keep the whole country busy.</p>\n<p>In December 2010, Recep Tayyip Erdoğan, the Prime Minister of the time (and the President since 2014) sued me for one of my blog posts. It was about one of the slogans he used in his referandum rallies (&#8220;The terrorists and the opposition parties are soul mates!&#8221;) and me using the same sentence against him. Like, <em>the exact same sentence</em>. He didn&#8217;t like the way that the slogan was used against him, so he reported me and the state brought charges against me. I was 22 and I was being sued by the most powerful man in the country, because I used his words against him.</p>\n<p>When the Prime Minister sues you, you go to jail. There were little to no instances of winning a case against the government, especially when they were the one suing you. Thankfully, I was one of the few instances: I won the case in my third trial, February 14, 2012. (&#8220;Lovely&#8221; day, isn&#8217;t it?)</p>\n<p>There were one downside though: With the fear of the government suing me, I stopped writing about politics in 2011 and 2012, and even a few months after I won. And to this day, even though that fear is long gone, and even though I&#8217;m writing about politics again on Beyn, I still can&#8217;t write regularly like I did back then.</p>\n<p>Anyways. Moving on with the &#8220;web development&#8221; phase of my life.</p>\n<h2>Learning to Develop WordPress, and Teaching It at the Same Time</h2>\n<p>When I started Beyn, I immediately loved WordPress. I had some experience on HTML and CSS on Dreamweaver (never was a FrontPage guy), and I happily retired DW because I won&#8217;t be able to work on it while I was learning WordPress.</p>\n<p>I don&#8217;t remember trying to learn something with such passion. I loved the idea of plugins and themes extending the core. Beyn became my playground for new tricks, my laboratory for new experiments about WordPress. I installed plugins, edited themes, learned what&#8217;s right and what&#8217;s wrong with what I did&#8230; I probably crashed the website more than a hundred times!</p>\n<p>By 2012, I&#8217;d already started making websites for other people and getting paid. I had developed a few plugins, made a couple of themes from scratch. While still learning what awesome things I&#8217;m able to do with WordPress, I applied for a small writing gig at Wptuts+, which was later renamed <a href=\"https://tutsplus.com/authors/baris-unver\">Tuts+ Code</a>. Because you know what they say: If you want to learn something, write about it.</p>\n<p>That &#8220;small writing gig&#8221; was in fact my biggest source of education. I wasn&#8217;t a WordPress expert, but that gig was the ultimate reason to learn more and more about WordPress. I remember constantly feeling that &#8220;I&#8217;ve finished telling about everything I know about WordPress, so now I have to learn more!&#8221; and doing research on things to write about.</p>\n<p>I was aware that I don&#8217;t have any chance to write a sloppy tutorial, so I nagged my editors (first Japh Thomson, then Tom McFarlin) about my writing style, my choice of topics and of course, my English. They said my English was very good, and my topics are relevant and suitable for publishing on Tuts+. In almost exactly four years (from April 2012 to March 2016), I wrote 134 posts and I&#8217;m very proud of (almost) all my work there.</p>\n<p>While it was sad to leave Tuts+, I had a project in my mind that I put off so long: <a href=\"https://optimocha.com/\">Optimocha</a>.</p>\n<h2>WordPress Speed Optimization with Terrorists, Bombs and Death</h2>\n<p>That title came out grimmer than I expected. Heh. <em>Anyways.</em></p>\n<p>2015 was the year when I first thought about a speed optimization service for WordPress-based websites. Then I thought that I would better use my energy on the upcoming general elections in June. I worked for an NGO called &#8220;Vote and Beyond&#8221; to <a href=\"https://en.wikipedia.org/wiki/Vote_and_Beyond\">ensure transparency in observering of ballot count in the elections</a>.</p>\n<p>2015 was also the year with a whole lot of terrorist attacks. PKK, a terrorist organization <em>pretending</em> to defend Kurds&#8217; rights (while giving a bad name for all Kurds countrywide) and ISIS (you know them) were the most active terrorist organizations in 2015. They killed more than 250 people and injured more than 1000 in a series of shootings and bombings throughout the year.</p>\n<p>Worst year ever, right? <em>Not even close.</em> Let me quickly summarize the hell we&#8217;ve been through:</p>\n<ol>\n<li>ISIS killed 116 people in 5 different attacks.</li>\n<li>PKK killed 176 people in 15 different attacks.</li>\n<li>TAK, PKK&#8217;s even uglier cousin, killed 43 people in 4 different attacks.</li>\n<li>FETO killed 248 people across the country in their coup d&#8217;état attempt on July 15.</li>\n</ol>\n<p>583 people killed in terrorist attacks in 2016. <em>So, just a few more than all those lovely celebrities.</em></p>\n<p>What&#8217;s that FETO sticking out among the others, attempting a coup? That&#8217;s <strong>FE</strong>thullahist <strong>T</strong>errorist <strong>O</strong>rganization: The organization of Fethullah Gülen, an Islamic cult leader comfortably residing in Pennsylvania, plotting to take over the government for (I kid you not) over 40 years. Even I had made peace with the President because of the much needed &#8220;purges&#8221; to scrape his crypto-disciples in the government organizations. FETO is one of the enemies that can let you make peace with the ones against your values.</p>\n<p>(By the way: While celebrating that we got rid off that horror show of 2016, ISIS killed 39 more people with an AK-47 in a New Year party on January 1, in the middle of the night.)</p>\n<p>Still waiting for the part where I founded Optimocha, right? Sorry it took a bit long.</p>\n<p>April 2016 was the month I registered my company by paying for the usual fees to register a sole proprietorship, accountant fees, rent for an office (because by law, you can&#8217;t register a company without an office), some paperwork. All my funds vanished, leaving me with nothing to spend on marketing.</p>\n<p>PayPal halted operations in Turkey on June, because of conflicts with the government. 2CheckOut followed. I was going to use 2CO, so I was left with no payment gateway provider. Along with the terrorist attacks, I decided to spend Ramadan (the holy month for Muslims, passed on June 2016) sleeping, lying and moping around with depression.</p>\n<p>At the beginning of July, I was ready to work again, amped up for success! Except the coup attempt happened. Bombs and sonic booms in my city. Back to depression.</p>\n<p>By October, I was almost ready to go live with <a href=\"https://optimocha.com/\">the website</a>. I didn&#8217;t. I forced myself to finish it in November, before Black Friday. <em>I did!</em> People responded to my emails, said they&#8217;ll publish my deal on their blogs. People who saw the deal also responded and purchased my services. Yay.</p>\n<h2>Conclusion</h2>\n<p>Blogging is hard. Blogging with the most powerful man in your country trying to lock you up is the hardest.</p>\n<p>Solopreneurship is hard. Solopreneurship with several, highly active terrorist organizations killing people next to you is the hardest.</p>\n<p>Yet, <em>and I&#8217;m sure this is going to sound cheesy</em>, I have hope. This is the price we have to pay in order to get rid of the scum in the world. Turkey isn&#8217;t the worst country in the world suffering from terror&#8211;we&#8217;re just a country stuck between Europe, Russia, the Middle East and Africa. (Talk about a rock and a hard place&#8230;) We will survive this, and this too will pass.</p>\n<p>Turkey may be viewed as &#8220;yet another Middle Eastern country&#8221;, but it was founded almost a hundred years ago with the heritage of the Ottoman Empire, but also with a Western, secular mindset. <em>Even today</em>, you can&#8217;t find a sensible person talking trash about Mustafa Kemal Atatürk, who declined the Ottoman monarchy to set the foundation of a democratic republic in a time of dictatorships across Europe and Asia. Emphasis on the words &#8220;even today&#8221;, because the principles of his <em>vision</em> of the Republic of Turkey is in danger, a very large portion of the country has the confidence and equipment to defend those principles.</p>\n<p>Again: We will survive this, and this too will pass. You have my word.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Blogging, Solopreneurship, & Terrorism\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Blogging%2C%20Solopreneurship%2C%20%26%20Terrorism&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fblogging-solopreneurship-terrorism%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Blogging, Solopreneurship, & Terrorism\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fblogging-solopreneurship-terrorism%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fblogging-solopreneurship-terrorism%2F&title=Blogging%2C+Solopreneurship%2C+%26%23038%3B+Terrorism\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Blogging, Solopreneurship, & Terrorism\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/blogging-solopreneurship-terrorism/&media=https://heropress.com/wp-content/uploads/2017/01/011117-150x150.jpg&description=Blogging, Solopreneurship, & Terrorism\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Blogging, Solopreneurship, & Terrorism\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/blogging-solopreneurship-terrorism/\" title=\"Blogging, Solopreneurship, & Terrorism\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/blogging-solopreneurship-terrorism/\">Blogging, Solopreneurship, &#038; Terrorism</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 12:00:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Barış Ünver\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Dev Blog: WordPress 4.7.1 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4650\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2017/01/wordpress-4-7-1-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6519:\"<p>WordPress 4.7 has been <a href=\"https://wordpress.org/download/counter/\">downloaded over 10 million times</a> since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.7 and earlier are affected by eight security issues:</p>\n<ol>\n<li>Remote code execution (RCE) in PHPMailer &#8211; <em>No specific issue appears to affect WordPress</em> or any of the major plugins we investigated but, out of an abundance of caution, we updated PHPMailer in this release. This issue was fixed in PHPMailer thanks to <a href=\"https://legalhackers.com/\">Dawid Golunski</a> and <a href=\"https://twitter.com/Zenexer\">Paul Buonopane</a>.</li>\n<li>The REST API exposed user data for all users who had authored a post of a public post type. WordPress 4.7.1 limits this to only post types which have specified that they should be shown within the REST API. Reported by <a href=\"https://poststatus.com/\">Krogsgard</a> and <a href=\"https://ithemes.com/\">Chris Jean</a>.</li>\n<li>Cross-site scripting (XSS) via the plugin name or version header on <code>update-core.php</code>. Reported by <a href=\"https://dominikschilling.de/\">Dominik Schilling</a> of the WordPress Security Team.</li>\n<li>Cross-site request forgery (CSRF) bypass via uploading a Flash file. Reported by <a href=\"https://twitter.com/Abdulahhusam\">Abdullah Hussam</a>.</li>\n<li>Cross-site scripting (XSS) via theme name fallback. Reported by <a href=\"https://pentest.blog/\">Mehmet Ince</a>.</li>\n<li>Post via email checks <code>mail.example.com</code> if default settings aren&#8217;t changed. Reported by John Blackbourn of the WordPress Security Team.</li>\n<li>A cross-site request forgery (CSRF) was discovered in the accessibility mode of widget editing. Reported by <a href=\"https://dk.linkedin.com/in/ronni-skansing-36143b65\">Ronnie Skansing</a>.</li>\n<li>Weak cryptographic security for multisite activation key. Reported by <a href=\"https://itsjack.cc/\">Jack</a>.</li>\n</ol>\n<p>Thank you to the reporters for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p>In addition to the security issues above, WordPress 4.7.1 fixes 62 bugs from 4.7. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.7.1\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/query?milestone=4.7.1\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.7.1</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.7.1.</p>\n<p>Thanks to everyone who contributed to 4.7.1: <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/chandrapatel/\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/christian1012/\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dreamon11/\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/chopinbach/\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella van Dorpe</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/hristo-sg/\">Hristo Pandjarov</a>, <a href=\"https://profiles.wordpress.org/jnylen0/\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver/\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/mattyrob/\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/monikarao/\">monikarao</a>, <a href=\"https://profiles.wordpress.org/natereist/\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nikschavan/\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nullvariable/\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/sirbrillig/\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/sanketparmar/\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sfpt/\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom/\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/sstoqnov/\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/stevenkword/\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/timph/\">timph</a>, <a href=\"https://profiles.wordpress.org/voldemortensen/\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a>, and <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 03:53:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Matt: Rebirth and Yellow Arrows\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://ma.tt/2017/01/rebirth-and-yellow-arrows/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2464:\"<p>My friend <a href=\"https://www.amazon.com/Rebirth-Fable-Forgiveness-Following-Heart/dp/0316312282/\">Kamal Ravikant has a new book out, Rebirth, which I highly recommend</a>. I had the good fortune to read it a few months ago and the story of the Camino de Santiago touched and inspired me.</p>\n<p>Because of the impact of the book, I ended up adopting a few New Year&#8217;s intentions long before January 1st &#8212; things to ruminate on and keep in mind as the year wound down. The outlook of the world seemed uncertain, and I&#8217;m learning to navigate the world without my father.</p>\n<p><img /></p>\n<h3>Yellow Arrows</h3>\n<p>The Camino de Santiago is a pilgrimage path in Spain that people have walked since the 9th century AD. The 500 mile path winds through mountains, fields, and sometimes cities, and many pilgrims take a month or more on it. In some ways it is similar to <a href=\"http://walkkumano.com/\">the Kumano Kodo walk I did with Dan and Craig last year</a>.</p>\n<p>There are places where the path isn&#8217;t exactly clear, either because the trail isn&#8217;t strong, there&#8217;s been growth, or you might be in a crowded urban area like a city. Over the years pilgrims and people who live on the trail have marked it with yellow arrows pointing the way. If someone gets lost or confused, it&#8217;s an opportunity for an additional sign to bring them back on track.</p>\n<p>When you know the path, is it clear where someone else walking it should go next? It&#8217;s an interesting concept that applies across life. In your relationships, does your friend, loved one, or partner know what to expect, and where you&#8217;re headed together? Even in WordPress I feel like there are too many places where we bring someone to a fork in the road and there is no clear indication which way they should take.</p>\n<p>Give some thought to the yellow arrows in your life, and I&#8217;ll write more about the other two things I&#8217;ve been thinking about tomorrow. Also don&#8217;t forget <a href=\"https://www.amazon.com/Rebirth-Fable-Forgiveness-Following-Heart/dp/0316312282/\">to pick up a copy of Kamal&#8217;s book</a>. I loved it and I think it will be one I&#8217;m recommending to many friends.</p>\n<p><a href=\"https://www.amazon.com/Rebirth-Fable-Forgiveness-Following-Heart/dp/0316312282/\"><img /></a></p>\n<p>(Image from <a href=\"http://caminotravelcenter.com/who-was-elias-valina-follow-the-yellow-arrow/\">Camino Travel Center</a>.)</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 03:48:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: Year in WP Creates a Personalized Review of WordPress Contributions in 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64884\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://wptavern.com/year-in-wp-creates-a-personalized-review-of-wordpress-contributions-in-2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4911:\"<p><a href=\"https://yearinwp.com/\">Year In WP </a>is a new site by <span class=\"DMUpdateName-name DMConversation-name u-textTruncate\"><a href=\"http://jespervanengelen.com/\">Jesper van Engelen</a> that creates a personalized review of a user&#8217;s contributions to WordPress in 2016. Entering the WordPress.org username of a plugin or theme author or a WordPress core contributor into the field generates a list of statistics that includes:</span></p>\n<ul>\n<li>Profile information</li>\n<li>Number of times their plugins and themes were downloaded</li>\n<li>Most downloaded plugins and themes</li>\n<li>Average number of downloads per week</li>\n<li>Plugin and theme review rating average</li>\n<li>Percentage of five-star ratings</li>\n<li>A selection of five-star reviews</li>\n<li>Number of commits, changes, and comments to WordPress core</li>\n<li>Number of WordPress releases contributed to</li>\n</ul>\n<p>Engelen got the idea to create the site in 2014 after Spotify launched its &#8216;<a href=\"https://news.spotify.com/us/2014/12/03/2014-a-year-in-music/\">Year in Music</a>&#8216; that highlighted trends based on what 50 million users listened too.</p>\n<p>&#8220;I’d been active in the WordPress plugin market for about four years at that point, and I figured it would be really cool to get some year-over-year insight into your WordPress plugins,&#8221; Engelen said.</p>\n<p>&#8220;Having become a partner at Admin Columns (a freemium WordPress plugin) in 2014, I found out that I really liked analyzing statistics of downloads, sales and other data, and that, properly grouped and reported, they could have a pretty big influence on decision-making from a business perspective.&#8221;</p>\n<p>Engelen started the site by experimenting with fetching data from WordPress.org through its API that would show the change in the number of downloads to a user&#8217;s plugins.</p>\n<p>&#8220;That is basically what lead to the &#8216;Your most popular plugins&#8217; overview page,&#8221; Engelen said. &#8220;Spending some free hours each week on working on the project, more and more ideas of data to include popped up.&#8221;</p>\n<p><img /></p>\n<p>The site displays a lot of data, but it doesn&#8217;t include everything. Engelen would like to eventually display sections for contributions to WordPress translations, plugins, themes, core, design, etc.</p>\n<h2>The Technical Details</h2>\n<p>The data displayed on Year in WordPress is gathered using the <a href=\"https://codex.wordpress.org/WordPress.org_API\">WordPress.org API</a>, subversion, and web scraping. Engelen would have used the WordPress REST API but it was not available at the time, &#8220;Fetching the reviews and support topics yielded quite a bit of annoyance, as they’re done by scraping,&#8221; he said.</p>\n<p>He uses a Python framework to fetch relevant data in parallel. The data is stored in an SQL database, which is accessed by a front-end tool. The front-end of the site features a design that was reused from <a href=\"https://www.admincolumns.com/\">AdminColumns.com</a>.</p>\n<p>&#8220;jQuery, combined with Chart.js and Fullpage.js power the interactive portion of Year in WordPress. I’ve also written some simple sentiment analysis code for filtering out the most popular reviews to show for each plugin/theme developer,&#8221; Engelen said.</p>\n<h2>Fun Facts about Year in WordPress</h2>\n<p>Engelen provided the Tavern with these fun facts related to Year in WordPress:</p>\n<ul>\n<li>There’s a Year in Review for about 100,000 users on WordPress.org — or all users who have contributed to a plugin or theme, created a review or a support ticket, or contributed to WordPress core.</li>\n<li>The full database takes about 500MB of space.</li>\n<li>There were 364,763,308 plugin/theme downloads in 2015, and 434,865,745 in 2016. That’s 19.2% growth!</li>\n<li>2016 was the first year where the number of new core Trac tickets shrunk (4,044 in 2014; 4,392 in 2015; 4,028 in 2016)</li>\n<li>73% of all plugins received zero reviews in 2016</li>\n</ul>\n<h2>Year in WordPress 2017 Is Not Guaranteed</h2>\n<p>Engelen is not making any promises for continued development in 2017 as it&#8217;s contingent on his free time. However, the main thing he would like to change is to include a wider spectrum of data.</p>\n<p>&#8220;When I pitched the idea of Year in WordPress to a core committer and showed the beta version, he said &#8216;there&#8217;s so much more than core itself&#8217; and that stuck with me,&#8221; he said.</p>\n<p>&#8220;The perfect &#8216;Year in WordPress&#8217; would feature cool statistics about all types of contributions people make to WordPress — whether it’s creating plugins and themes, writing code for core, translating or testing. Furthermore, I’m really looking forward to making use of all of the REST API’s that I can use this time around.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Jan 2017 22:11:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WPTavern: Say What Plugin Passes 10K Active Installs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64778\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wptavern.com/say-what-plugin-passes-10k-active-installs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5220:\"<p>WordPress core doesn&#8217;t make it easy to edit text strings, but a little plugin called <a href=\"https://wordpress.org/plugins/say-what/\" target=\"_blank\">Say What?</a> has been quietly gaining a solid user base by providing this functionality. It allows users to edit text strings without editing WordPress core or plugin code. Lee Willis released Say What in 2013, but the plugin had a significant jump in users in 2016, doubling the number of active installs from 5,000 to 10,000 sites.</p>\n<p>Willis, who is the author of <a href=\"https://profiles.wordpress.org/leewillis77/#content-plugins\" target=\"_blank\">22 plugins</a> hosted on WordPress.org and many more commercial extensions, created Say What while working as a Drupal developer.</p>\n<p>&#8220;One of our must-install Drupal modules was called String Overrides, which inspired Say What?&#8221; he said. &#8220;At the agency I was working at we used it regularly on virtually every site build to override plugin, theme, and core strings in a &#8216;non-hacky&#8217; way. Given that, I knew that the problem was there to be solved on WordPress, and that something that worked well would be useful to people.&#8221;</p>\n<p>Say What adds a new screen for editing text under Tools > Text changes for configuring string replacements. Users enter the current string, text domain, and replacement text.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/say-what-text-edits.png?ssl=1\"><img /></a></p>\n<p>This plugin is a good option for those who are not comfortable sifting through PHP files and adding a filter to change the text. If you just have a handful of strings to replace, it&#8217;s more convenient than using a translation tool like POEDIT to edit the language files. All of the text changes are listed together in the Say What admin panel, so they can be easily changed at any time without editing any files.</p>\n<p>Willis said users don&#8217;t often experience conflicts with themes and plugins, as there is so little frontend functionality included in the plugin.</p>\n<p>&#8220;The main areas of support tend to be around locating particular strings, or issues where broken custom code is breaking the filters that Say What uses,&#8221; Willis said. After speaking with friends at a WordCamp in March 2015, he decided to create a commercial version to address this issue and a number of other feature requests.</p>\n<p>&#8220;The free version was out for about two years before I launched the <a href=\"https://plugins.leewillis.co.uk/downloads/say-what-pro/\" target=\"_blank\">Pro version</a>,&#8221; Willis said. &#8220;The only issue people tended to have with the free version was around finding the information they needed for the &#8216;original string,&#8217; so I decided to build out the String Discovery feature as the first feature of the Pro version. This lets users search for the string using autocomplete functionality, making it much easier to set up replacements without delving through theme or plugin code.&#8221;</p>\n<p>Say What increased in popularity in 2016 and has maintained a 4.6-star rating on WordPress.org. It is becoming more frequently recommended by support teams of other plugins when customers ask about how to change text strings.</p>\n<p>&#8220;It&#8217;s great to know that it&#8217;s being used to help people build more future-proof sites without resorting to hacking plugin or core code just to change strings,&#8221; Willis said. &#8220;Even for people familiar with plugin and theme code, the String Discovery feature makes it a lot easier and quicker to set up replacements. It&#8217;s had a few new features over the last year, including support for multi-line, and single/plural style replacements.&#8221;</p>\n<p>Willis said his Pro version proved to be fairly popular during 2016 and became one of his highest selling plugins. He recently added support for multilingual sites, the most often requested feature, allowing users to set up different replacements for different languages.</p>\n<p>Willis does not have an extensive roadmap for the plugin, as he prefers to keep it uncomplicated and free of clutter. &#8220;I&#8217;m a big believer in plugins that do one thing, and do it well,&#8221; he said.</p>\n<p>Say What is another successful instance of a developer solving one of his own problems and striking upon a successful commercial product. Willis said he didn&#8217;t fully anticipate how popular the plugin would become.</p>\n<p>&#8220;As with most of my plugins it was also built to solve a problem that I personally was having at the time,&#8221; he said. &#8220;That said, I&#8217;m always (pleasantly) surprised when something does get popular.&#8221;</p>\n<p>After testing <a href=\"https://wordpress.org/plugins/say-what/\" target=\"_blank\">Say What</a> I found that Willis&#8217; implementation is the simplest way for non-technical users to make a few simple string changes without the risk of breaking their websites. He is also very responsive on the support forums. The success of the Pro version is a good indication that Willis will be able to continue support and maintenance on the free plugin for the foreseeable future.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Jan 2017 21:26:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: How Laravel Forge Can Help You Run WordPress in the Cloud\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64940\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/how-laravel-forge-can-help-you-run-wordpress-in-the-cloud\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7837:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2015/05/petersuhm.jpeg?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2015/05/petersuhm.jpeg?resize=150%2C150&ssl=1\" alt=\"petersuhm\" class=\"alignright size-thumbnail wp-image-43613\" /></a>This opinion piece was contributed by guest author <a href=\"https://twitter.com/petersuhm\" target=\"_blank\">Peter Suhm</a>. Peter is a web developer from the Land of the Danes. He is the creator of <a href=\"https://wppusher.com/\" target=\"_blank\">WP Pusher</a> and a huge travel addict, bringing his work along with him as he goes.<br />\n&nbsp;</p>\n<hr />\n<p><a href=\"http://forge.laravel.com/\" target=\"_blank\">Laravel Forge</a> is a server and application provisioning tool that was originally built to serve the Laravel PHP crowd. Recently, it has been made available to WordPress developers too, with the introduction of 1-click installs of WordPress on Digital Ocean, Linode and AWS cloud servers. In this post, I&#8217;ll give you a brief introduction to Laravel Forge and show you how you can use it to manage all of your WordPress installations in the cloud.</p>\n<h3>Laravel Forge is good news for WordPress developers</h3>\n<p>Because so many WordPress developers are used to managed hosting, the thought of running their own servers seem quite intimidating. That&#8217;s a shame with so many great cloud server companies offering virtual servers for very low costs. Unless your traffic is very heavy, a small ($5 to $10 per month) server can run quite a few WordPress websites. Laravel Forge takes care of provisioning your servers and can even setup your database and install WordPress for you. This makes cloud hosting much more available to WordPress developers at a low cost (Laravel Forge is $15 per month for unlimited servers), compared to many of the existing options.</p>\n<p>Here are a few reasons why I think Laravel Forge is great for WordPress hosting:</p>\n<ul>\n<li>Your servers are configured in a secure way by default, with SSH authentication, firewalls, automatic security updates and free SSL certificates from Let&#8217;s Encrypt</li>\n<li>Your servers are going to be really fast with PHP 7</li>\n<li>You can run a lot of WordPress installs on 1 single server *</li>\n<li>You can scale your servers if you need more horse power *</li>\n</ul>\n<p><em>* Goes for the cloud in general</em></p>\n<h3>Creating a new server</h3>\n<p>Here is how the &#8220;Create Server&#8221; screen looks in Forge:</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/create-server-e1483980109591.png?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/create-server-e1483980109591.png?resize=1025%2C416&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64946\" /></a></p>\n<p>If you use Digital Ocean, Forge can also create your servers. If you use another provider like Linode or AWS, Forge can only do the provisioning part.</p>\n<p>For Digital Ocean servers, here are the options you can configure:</p>\n<ul>\n<li>Which credentials to use, if you are managing multiple Digital Ocean accounts</li>\n<li>The server name</li>\n<li>The server size</li>\n<li>The server region</li>\n<li>The PHP version</li>\n<li>The default database name</li>\n</ul>\n<p>You can then choose to:</p>\n<ul>\n<li>Configure the server as a load balancer (if you have really heavy traffic and is running WordPress across multiple servers)</li>\n<li>Install <a href=\"https://mariadb.org/\" target=\"_blank\">MariaDB</a> instead of MySQL, which is a drop-in, faster replacement</li>\n<li>Enable weekly backups on Digital Ocean</li>\n</ul>\n<p>When Laravel Forge is done with the provisioning, your server is ready to go.</p>\n<h3>Setting up a database</h3>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/set-up-database-e1483980726266.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/set-up-database-e1483980726266.png?resize=1025%2C484&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64949\" /></a></p>\n<p>Once your server has been created, setting up a database for your WordPress installation is very easy. You can create the user at the same time you&#8217;re creating the database, or you can create the user afterwards.</p>\n<h3>Installing WordPress</h3>\n<p>Before you install WordPress, you need to create a new &#8220;site&#8221; on your server. You can just stick with the defaults:</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/new-site-e1483981223250.png?ssl=1\"><img src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/new-site-e1483981223250.png?resize=1025%2C453&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64951\" /></a></p>\n<p>For the &#8220;Root Domain&#8221;, you need to add the domain name of the site you are setting up. Remember that you need to add a DNS record for your domain that points to the IP address of your newly created server. If you are just testing, you can always add a record in your computer&#8217;s <code>hosts</code> file with a test domain that points to your server. Something like this:</p>\n<p><code># /etc/hosts</code></p>\n<p><code># Replace xx.xx.xx.xx with your server\'s IP address<br />\nxx.xx.xx.xx wordpress-forge.test</code></p>\n<p>Once you click the &#8220;Add Site&#8221; button, you will see a spinning wheel while Forge is setting up your site&#8217;s nginx configuration.</p>\n<p>When the installation is done, you need to click the &#8220;Manage&#8221; icon next to your site in order to install WordPress. The first screen you will be presented with gives you the option to install an &#8220;App&#8221; on your site. Click the &#8220;WordPress&#8221; button, select your database and user from the previous step and relax while Laravel Forge completes the installation. Fun fact: Laravel Forge is actually using WP-CLI to install WordPress on your server.</p>\n<p>When the installation has completed, visit your site in a browser and you&#8217;ll be met with something familiar:</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/wp-install-e1483984375432.png?ssl=1\"><img src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/wp-install-e1483984375432.png?resize=1025%2C625&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64962\" /></a></p>\n<h3>Setting up a free SSL certificate</h3>\n<p>Finally, you should set up SSL for your WordPress site. It&#8217;s more secure and Google likes it!</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/ssl-setup.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/ssl-setup.png?resize=1025%2C288&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64963\" /></a></p>\n<p>Head over on the &#8220;SSL&#8221; tab and click the &#8220;LetsEncrypt (Beta)&#8221; button. Click the &#8220;Obtain Certificate&#8221; button and wait while Forge creates and installs the certificate. Once the certificate is installed, click the &#8220;Activate&#8221; icon and voila! Your site is now all set up and secured with SSL.</p>\n<p>That&#8217;s how easy it is to setup WordPress on a cloud server with Laravel Forge. I hope to see a lot of more products and tools like this that can help us building better, faster, and more secure WordPress websites. In fact, Laravel Forge was the original inspiration for my own product <a href=\"https://wppusher.com/\" target=\"_blank\">WP Pusher</a>. I wanted to create a similar experience, but for WordPress plugins and themes instead.</p>\n<h3>Note on backups and security</h3>\n<p><em>Please note that even though Laravel Forge makes for a great starting point, ultimately you are the one in charge of the security of your servers. You should always try to educate yourself about security and have a backup strategy for your data.</em></p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Jan 2017 18:44:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Post Status: Contributing to Twenty Seventeen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=31886\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://poststatus.com/contributing-to-twenty-seventeen-theme/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11882:\"<p><em><strong>Editor&#8217;s Note</strong>: This is a guest post by <a href=\"https://poststatus.com/profiles/sami-keijonen/\">Sami Keijonen</a>. Sami is a developer, the owner of the <a href=\"https://foxland.fi/\">Foxland theme and plugin shop</a>, and hails from Finland.</em></p>\n<p>Every year since 2010, WordPress has shipped with a new default theme, breaking the cycle of Kubrick being the primary default theme for years before that.</p>\n<p>In 2010, the default theme was called Twenty Ten. In 2011, the default theme was called Twenty Eleven. You get the idea.</p>\n<p>While every default theme has been unique in its own way, <a href=\"https://wordpress.org/themes/twentyseventeen/\">Twenty Seventeen</a> was particularly compelling in a way we haven’t seen in a default theme since Twenty Fourteen.</p>\n<p><a href=\"https://wordpress.org/themes/twentyfourteen/\">Twenty Fourteen</a> was the first theme that really made people think WordPress could be used for more than “just a blog” on a mass scale. It is a magazine theme.</p>\n<p>Twenty Seventeen &#8212; <a href=\"https://poststatus.com/wordpress-4-7-released/\">released with WordPress 4.7</a> &#8212; is the first theme that really made people think WordPress could be used for more than “just publishing content” on a mass scale. It is a business theme.</p>\n<p><img /></p>\n<p>Prior to WordPress 4.7, I contributed by helping out in the support forums and building <a href=\"https://foxland.fi/downloads/category/themes/\">accessible themes</a>. But I had never contributed to core before.</p>\n<p>When I saw the <a href=\"https://make.wordpress.org/core/2016/09/09/say-hello-to-twenty-seventeen-%25F0%259F%2591%258B%25F0%259F%258F%25BD/\">previews</a>, I knew I wanted to contribute, and began to follow development on GitHub to see if there was anything that I could lend my talents to and eventually make my first core contributions.</p>\n<p>When I saw Morten Rand-Hendriksen <a href=\"https://github.com/WordPress/twentyseventeen/issues/60\">open an issue</a> about replacing icon fonts with SVG icons, I knew I had found the perfect “in” to start contributing to core.</p>\n<h3>Contributing SVG icons system to Twenty Seventeen</h3>\n<p><img /></p>\n<p>I had already <a href=\"https://foxland.fi/switch-away-icon-fonts-svg/\">switched from icon fonts to SVG icons</a> in my public themes, so this was something I immediately felt confident in contributing to core.</p>\n<p>Development started in <a href=\"https://github.com/WordPress/twentyseventeen/\">GitHub</a>, where fellow contributors would create issues and submit pull requests.</p>\n<p>Then, everything moved to <a href=\"https://core.trac.wordpress.org/browser/trunk\">WordPress SVN</a>, where new patches were submitted.</p>\n<p>I’ll summarize what I learned in the process.</p>\n<h3>What I learned about contributing</h3>\n<p>I regret not keeping a diary. Not necessarily to keep track of what I contributed, since that’s all documented in the open.</p>\n<p>But rather things like my emotional state. My feelings ranged from despair to overwhelming joy throughout my contribution experience.</p>\n<p>I learned new things about code and collaborating with others in GitHub and SVN. Again, something not necessarily documented in patches and the like.</p>\n<h4>Git workflow</h4>\n<p>I’m not good with Git, and still don’t fully understand how rebasing works. I messed up my commits a couple of times. Not a big deal, but I got different error messages no matter which workflow I tried. I realized that I need to know more about Git, and be more patient.</p>\n<p>Eventually I understood enough to get my contributions through the door, but I’m still confused about <a href=\"https://github.com/edx/edx-platform/wiki/How-to-Rebase-a-Pull-Request\">how to rebase a pull request</a>.</p>\n<h4>Follow the development through to the end, and beyond</h4>\n<p>I started out by replacing only the social link icon fonts to SVG icons. Soon, I realized that a step-by-step process was not going to work because of new related commits coming in all the time that potentially conflicted with my code.</p>\n<p>It was better to replace all icon fonts, not just the social ones, with SVGs, and then work from there. I was also keeping track of style changes in RTL languages and IE8.</p>\n<p>At this point, the work was just getting started.</p>\n<p>Once you start contributing, you shouldn&#8217;t just disappear with no explanation. If you’re running low on time or have other obligations, it’s totally understandable, but be sure to politely inform others you can’t continue anymore, so they can pick up where you left off.</p>\n<p>As the <a href=\"https://geto2.com/\">o2</a> slogan states: &#8220;Communication is oxygen.&#8221;</p>\n<h4>Coding standards and automated tests</h4>\n<p>After several commits and iterations, <a>my first pull request was accepted</a>.</p>\n<p>As you can see in my first commits, I didn’t pass the WordPress coding standards. I needed to be more precise and follow the coding standards to the tee. With enough practice, I’m sure it’s possible to write standards-compliant code “naturally” but I was looking for a way to automate the code checks.</p>\n<p>I tried to get Atom to evaluate my code on the fly, but I just couldn’t get it to work. Like my Git experience, I got different error messages no matter what I tried.</p>\n<p>Eventually, I was able to use <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards\">PHPCS</a> via the command line, and fixed any issues discovered manually. But it would’ve been nice to have those checks automated.</p>\n<h4>Working with batches in SVN</h4>\n<p>Once the development moved to SVN, I began to get a little worried. As I described earlier, not too long ago, I was struggling just to use Git. However, thanks to the following tutorials I quickly got up to speed.</p>\n<ul>\n<li><a href=\"https://make.wordpress.org/core/handbook/tutorials/installing-wordpress-locally/from-svn/\">Installing via SVN</a></li>\n<li><a href=\"https://make.wordpress.org/core/handbook/tutorials/installing-a-vcs/%23installing-tortoisesvn\">Installing TortoiseSVN</a> (I use Windows)</li>\n<li><a href=\"https://make.wordpress.org/core/handbook/tutorials/trac/submitting-a-patch/\">Submitting a Patch</a></li>\n<li><a href=\"https://make.wordpress.org/core/handbook/tutorials/working-with-patches/%23creating-a-patch-with-tortoisesvn\">Creating a Patch with TortoiseSVN</a></li>\n</ul>\n<p>Turns out, it wasn’t much to be worried about. Although I didn’t quite understand the concept of branches and tags in my local environments, and jumping between them like I know how to do with Git.</p>\n<p>Anyway, I eventually got <a href=\"https://core.trac.wordpress.org/changeset/39072\">my first props</a> with the help of others.</p>\n<h3>Technical overview of the SVG icons system</h3>\n<p>I adapted this contribution from the code and concepts first presented by others.</p>\n<ol>\n<li><a href=\"https://webdevstudios.com/\">WebDevStudios</a> has their own starter theme called <a href=\"https://github.com/WebDevStudios/wd_s\">wd_s</a>. I really like how they set up SVG icons and we fine-tuned them in Twenty Seventeen. Perhaps they will integrate those improvements back into their own project. Again, open source rocks.</li>\n<li><a href=\"http://themehybrid.com/\">Justin Tadlock</a> invented the <a href=\"http://justintadlock.com/archives/2013/08/14/social-nav-menus-part-2\">social links menu</a> concept. I just took that concept and applied it to SVG icons rather than icon fonts.</li>\n</ol>\n<p>All the main SVG-related functions can be found in the <a href=\"https://core.trac.wordpress.org/browser/trunk/src/wp-content/themes/twentyseventeen/inc/icon-functions.php\">inc/icon-functions.php file</a>. It’s well-documented in the code, but here’s a summary:</p>\n<ul>\n<li>Include the SVG sprite file via the <code>wp_footer</code> hook.</li>\n<li><code>twentyseventeen_get_svg()</code> function returns the SVG icon markup. In most cases, the SVG icon is injected in template files or via hooks and filters. In some cases, the SVG icon is injected via JavaScript.</li>\n<li>Default markup looks like this: <code>&lt;svg class=\"icon icon-name\" aria-hidden=\"true\" role=\"img\"&gt; &lt;use href=\"#icon-name\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:href=\"#icon-name\"&gt;&lt;/use&gt; &lt;/svg&gt;</code>.</li>\n<li>Note that we could use the absolute path to the SVG file in the <code>href</code> attribute of the use element. In that case:\n<ul>\n<li>there is no need to inject icons via the <code>wp_footer</code> hook.</li>\n<li>The <a href=\"https://github.com/Keyamoon/svgxuse\">svgxuse</a> JS polyfill must be used, because Internet Explorer doesn’t support external files referenced in the <code>&lt;use&gt;</code> element.</li>\n<li>This method helps caching the SVG sprite file.</li>\n</ul>\n</li>\n<li>By default, all icons are decorative, but I insisted we show how to use non-decorative icons in an accessible way. Check the examples in the aforementioned <code>twentyseventeen_get_svg()</code> function.</li>\n<li>We replace the default icon for supported social media links by using the <code>walker_nav_menu_start_el</code> filter.</li>\n</ul>\n<h3>Open source rocks</h3>\n<p>WordPress default themes are one of the best themes out there and they set an example how to use new WordPress features. The reason for this is simple.</p>\n<ul>\n<li>Default themes gets lots of love and attention.</li>\n<li>Many talented people contribute to default themes. <a href=\"https://davidakennedy.com/2016/12/07/dear-twenty-seventeen-contributors/\">Twenty Seventeen had over 100 contributors</a> and we thank you all!</li>\n<li>Default themes are tested before release in many platforms and browsers. And default themes are used on so many sites that any remaining bugs will be found after the release.</li>\n</ul>\n<p>Building default themes really is a community driven project. I&#8217;d like to say extra thanks for couple of people.</p>\n<h4>Special thank you</h4>\n<p>Any web project needs good leadership, design, and code. Those were all covered in Twenty Seventeen.</p>\n<ul>\n<li><a href=\"https://twitter.com/DavidAKennedy\">David A. Kennedy</a> was leading the project and kept everything rolling. He had a really friendly touch and he was open to ideas. At the same time he wasn&#8217;t afraid to make decisions; for example, a flexbox layout was rejected for this theme.</li>\n<li><a href=\"https://twitter.com/melchoyce\">Mel Choyce</a> created the modern, business looking design. She wrote a great article <a href=\"https://choycedesign.com/2016/12/07/behind-the-scenes-of-twenty-seventeen/\">with her behind the scenes take</a>.</li>\n<li><a href=\"https://twitter.com/laurelfulford\">Laurel Fulford</a> was the primary coding lead. She seem to have a solution for every new feature and brought Mel&#8217;s design to life with detailed code.</li>\n</ul>\n<p>Last but not least, remember <a href=\"http://mor10.com/\">Morten Rand-Hendriksen</a>, the one that opened the SVG icon issue that caught my eye?</p>\n<p>He was pretty happy with the end result.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/brad_frost\">@brad_frost</a> the SVG icon system solution by <a href=\"https://twitter.com/samikeijonen\">@samikeijonen</a> embedded in the new Twenty Seventeen theme in <a href=\"https://twitter.com/hashtag/WordPress?src=hash\">#WordPress</a> is pure genius</p>\n<p>&mdash; MortenRandHendriksen (@mor10) <a href=\"https://twitter.com/mor10/status/805808154520883200\">December 5, 2016</a></p></blockquote>\n<p></p>\n<p>Who knows if I would’ve contributed if it wasn’t for him posting that. Remember, reporting issues and bugs is contributing too, and can inspire first-time contributors like me to stop sitting on the sidelines and finally get started with core contributions.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Jan 2017 22:42:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sami Keijonen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WPTavern: Let’s Encrypt Passes 20 Million Active Certificates in 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64815\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/lets-encrypt-passes-20-million-active-certificates-in-2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5050:\"<p>Let&#8217;s Encrypt has just closed out its first full year as a certificate authority with more than <a href=\"https://letsencrypt.org/2017/01/06/le-2016-in-review.html\" target=\"_blank\">20 million active certificates</a>. The free and open certificate authority focuses on lowering the complexity of setting up TLS encryption by making the process more automated. It came <a href=\"https://wptavern.com/lets-encrypt-is-now-out-of-beta\" target=\"_blank\">out of beta</a> in April 2016 and the number of certificates issued per day has grown steadily since then.</p>\n<p>&#8220;At the start of 2016, Let’s Encrypt certificates had been available to the public for less than a month and we were supporting approximately 240,000 active (unexpired) certificates,&#8221; said Josh Aas, Executive Director of the non-profit Internet Security Research Group (ISRG). &#8220;Now we’re frequently issuing that many new certificates in a single day while supporting more than 20,000,000 active certificates in total. We’ve issued more than a million certificates in a single day a few times recently.&#8221;</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/lets-encrypt-2016.png?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/lets-encrypt-2016.png?resize=1025%2C503&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64920\" /></a></p>\n<p>Let&#8217;s Encrypt operates as a 501(c)(3) nonprofit and has received more than three dozen corporate <a href=\"https://letsencrypt.org/sponsors/\" target=\"_blank\">sponsorships</a> and grants, but funds for the coming year have fallen short. In November, Let&#8217;s Encrypt launched a <a href=\"https://www.generosity.com/community-fundraising/make-a-more-secure-web-with-let-s-encrypt\" target=\"_blank\">crowdfunding campaign</a> to cover the cost of one month of operating expenses. So far, the campaign has raised more than $100K towards its $200K fundraising goal.</p>\n<h3>Let&#8217;s Encrypt is Growing Fastest with Smaller, Previously-Unencrypted Sites</h3>\n<p>Let&#8217;s Encrypt is used with some larger organizations, such as WordPress.com, OVH, Shopify, Akamai, and Dreamhost, but the vast majority of users are smaller entities that were not previously encrypted. According to the Electronic Frontier Foundation (EFF), a founding sponsor of the certificate authority, most of Let&#8217;s Encrypt&#8217;s growth has not come from taking customers away from competitors:</p>\n<blockquote><p>\nOne of the ways Let&#8217;s Encrypt has been helping to secure the web is by making it easy and affordable for sites that have never had certs before to turn on secure HTTPS connections, and for software systems to start enabling HTTPS automatically and by default. Our free certificates may be more likely to be left unused than expensive certificates, and less expert webmasters may accidentally duplicate certificates—but that’s part of making HTTPS integration available to more webmasters across a range of resource and skill levels. Statistics suggest that most of our growth has come not at the expense of other CAs, but from giving previously unencrypted sites their first-ever certificates.</p></blockquote>\n<p>EFF analyzed various sources of usage statistics and estimates that <a href=\"https://www.eff.org/deeplinks/2016/10/lets-encrypt-largest-certificate-authority-web\" target=\"_blank\">Let&#8217;s Encrypt is now the largest certificate authority on the web</a>. Its rapid adoption has spurred impressive progress towards getting the entire web encrypted. Let&#8217;s Encrypt tracks progress by measuring the percentage of page loads using HTTPS, as seen by browsers.</p>\n<p>&#8220;According to Firefox Telemetry, the Web has gone from approximately 39% of page loads using HTTPS each day to just about 49% during the past year,&#8221; Aas said in Let&#8217;s Encrypt&#8217;s <a href=\"https://letsencrypt.org/2017/01/06/le-2016-in-review.html\" target=\"_blank\">2016 in Review</a> report. &#8220;We’re incredibly close to a Web that is more encrypted than not.&#8221;</p>\n<p>The proliferation of Let&#8217;s Encrypt <a href=\"https://letsencrypt.org/docs/client-options/\" target=\"_blank\">client options</a> in 2016 puts the certificate authority in an even better position to continue driving web encryption in 2017. Aas attributes last year&#8217;s progress to many organizations advocating for HTTPS and working to get their sites encrypted. His team has grown from four full-time employees to nine, and he anticipates that 2017 will be a year of even greater growth.</p>\n<p>&#8220;Much of the infrastructure and many of the plans necessary for a 100% encrypted Web came into being or solidified in 2016,&#8221; Aas said. &#8220;More and more hosting providers and CDNs are supporting HTTPS with one click or by default, often without additional fees. It has never been easier for people and organizations running their own sites to find the tools, services, and information they need to move to HTTPS.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Jan 2017 21:42:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: How Do You Educate People New to WordPress?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64890\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wptavern.com/how-do-you-educate-people-new-to-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5213:\"<p>When a friend of mine asked for suggestions on what he should use to create a new site, I suggested WordPress. It is well supported, has an amazing community, and a ton of free themes and plugins to choose from. After getting WordPress installed on a new webhosting account, I left him be to see what issues he would run into and how he would configure the site.</p>\n<p>After noticing the site was loading slowly three weeks later, I obtained admin access to try to determine what the problem was. The first thing I did was check which plugins he installed. One of the plugins added the ability to embed YouTube videos on the site using shortcodes. My friend was unaware that WordPress has <a href=\"https://codex.wordpress.org/Embeds\">oEmbed support</a> which allows users to easily embed videos by pasting the URL into the editor.</p>\n<p>He also installed a couple of other plugins that mimicked core functionality. He was unaware that WordPress does most of the things he wants without the need for plugins.</p>\n<h2>Page Builder Shenanigans</h2>\n<p>After activating a theme that was compatible with the <a href=\"https://wordpress.org/plugins/sportspress/\">SportsPress</a> plugin, he installed the <a href=\"http://www.getmotopress.com/plugins/content-editor/\">MotoPress Content Editor</a>. MotoPress Content Editor is a front-end page builder that enables users to visually construct pages. The front page of the site was a long vertical column filled with information that mimicked blog posts.</p>\n<p>Because he didn&#8217;t understand how WordPress works, he forgot to configure the site to display the latest posts instead of using a front page. What he ended up doing is recreating the blog post layout on the static front page using the MotoPress Content Editor. He also added a lot of page builder elements such as YouTube videos to the page which was a contributing factor to the site&#8217;s poor loading times.</p>\n<p>Page builders are a tool that can make building sites and pages more convenient, but in the wrong hands, they can help users <a href=\"https://wptavern.com/wordpress-visual-page-and-website-builders-make-it-easy-to-create-ugly-sites\">ruin their sites</a>. I replaced the video elements with a text widget that displays the latest video from a YouTube channel. Since he was mimicking the blog post layout on a static page, I configured the site to display the latest blog posts first.</p>\n<p>Once I fixed these issues, I removed the page builder and explained to my friend why it was unnecessary. He was recreating WordPress functionality and doing unnecessary work without realizing it.</p>\n<p>This experience makes me wonder how many other newer WordPress users end up in a similar situation. They don&#8217;t know what WordPress is capable of out-of-the-box and they end up installing a myriad of plugins with descriptions that sound similar to the features they want. I spent about a week undoing all of the work my friend did in three. Had I not stepped in, the site would likely not scale and its performance would decrease further.</p>\n<h2>Getting New Users Started on the Right Track</h2>\n<p>In early 2015, a community initiative dubbed <a href=\"https://make.wordpress.org/core/2015/02/05/4-2-community-initiative-nux-working-group/\">NUX Working Group</a> was created to brainstorm ideas on how to improve the new user experiences throughout the WordPress admin. While the group initially had a head of steam, it lost a lot of momentum last year. I&#8217;d like to see it re-emerge and work in concert with the <a href=\"https://wptavern.com/matt-mullenweg-announces-tech-and-design-leads-for-new-focus-based-development-cycle\">focus-based approach</a> to developing WordPress this year.</p>\n<p>How can WordPress explain to new users what its capable of without drowning them in technical information? Is it feasible to create something that caters to the majority without explaining every feature in detail? <a href=\"https://codex.wordpress.org/Version_3.3\">Admin Pointers</a> were introduced in WordPress 3.3 and while they&#8217;re typically used to introduce new features in a release, they don&#8217;t act as a guided tour to what WordPress can do.</p>\n<p>Education is likely a key component to improving the new user experience. WordPress.com has a <a href=\"https://learn.wordpress.com/get-started/\">12-step beginner&#8217;s guide</a> that walks people through the process of configuring and customizing their sites. For self-hosted WordPress users, there&#8217;s a <a href=\"https://codex.wordpress.org/New_To_WordPress_-_Where_to_Start\">New to WordPress &#8211; Where to Start guide</a> that covers what WordPress is, choosing a host, and considerations to keep in mind. However, much of the information is technical in nature.</p>\n<p>If you&#8217;re a consultant or coach who works with people new to WordPress, how do you handle the educational part of your projects? What are the most common roadblocks that they encounter? Do you have a custom-made getting started guide or do you forward them to a site with video tutorials like <a href=\"https://wordpress.tv/\">WordPress.TV</a> or <a href=\"https://www.wp101.com/\">WP101</a>?</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Jan 2017 19:19:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WPTavern: Incubator WordCamp Denpasar a Success\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64903\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com/incubator-wordcamp-denpasar-a-success\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4625:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/taylor-lovett.jpg?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/taylor-lovett.jpg?resize=150%2C150&ssl=1\" alt=\"\" class=\"alignright size-thumbnail wp-image-64907\" /></a>This post was contributed by guest author Taylor Lovett. Lovett is based in the Washington DC area, is the Director of Web Engineering at <a href=\"https://10up.com\" target=\"_blank\">10up</a>, creator of ElasticPress, and general open source enthusiast.<br />\n&nbsp;</p>\n<hr />\n<p>In February 2016, the <a href=\"http://wordpressfoundation.org/\" target=\"_blank\">WordPress Foundation</a> announced the <a href=\"https://wordpress.org/news/2016/02/experiment-wordcamp-incubator/\" target=\"_blank\">WordCamp incubator program</a>, focused on spreading WordPress and open source values to remote areas of the world through extra hands-on support to first time WordCamps. WordCamp Denpasar, which took place in Bali’s capital city, is the first of three camps to be supported as a part of the program — other WordCamps include Harare and Medellín. As Director of Web Engineering at <a href=\"https://10up.com\" target=\"_blank\">10up</a>, I was sent to attend and speak at the inaugural event. Our company values open source projects and the WordPress community, so we’re proud to support emerging communities by attending events like this.</p>\n<p>The incubator program supports WordCamps by providing them with an experienced organizer. In Denpasar’s case, Rocio Valdivia, a Community Wrangler for Automattic, was the WordCamp Incubator sponsored organizer. According to Ivan Kristianto, the lead organizer for WordCamp Denpasar, “Rocio was a hands-on consultant provided by the WordPress Foundation to help incubate the camp. She helped [us] in budgeting, managing the organizers, submission timelines, and more”.</p>\n<p>WordCamp Denpasar attracted 180 attendees, twice the initial goal. Many attendees came from other parts of Indonesia to attend the Camp, which bubbled with an aura of excitement as Indonesia has not had a WordCamp in over three years. The venue, the <a href=\"http://www.sofitel.com/gb/hotel-5551-the-royal-beach-seminyak-bali-mgallery-collection/index.shtml\" target=\"_blank\">Royal Beach Seminyak Hotel</a>, was of ample size and served the crowd well. There was a single session track, mixed with user, business, and developer topics. Lunch included a nice buffet featuring local Balinese cuisine. Overall, the WordCamp attendance, venue, and amenities were quite impressive.</p>\n<p>The speaker lineup was diverse, with speakers from Indonesia, Australia, Europe, Japan, and the United States. Attendees were extremely enthusiastic throughout the sessions and actively engaged in questions. I was last to speak, presenting on <a href=\"https://10up.com/blog/2016/twenty-sixteen-react-nodeifywp/\" target=\"_blank\">NodeifyWP and Twenty Sixteen React</a>. WordCamp Denpasar was the debut presentation of our new isomorphic JavaScript framework. The crowd was extremely excited to hear my presentation and attendees were grateful 10up choose Bali as a first occasion to show the framework. After my talk, I received more questions than could fit in the allotted time slot.</p>\n<p>In the weeks after the Camp, I talked with Rocio about the overall success of the event and Incubator program as a whole. Rocio believed the WordCamp went extremely well. She cited some key events that followed the inaugural camp:</p>\n<ol>\n<li>The local Indonesian meetup group has grown to more than 50 new members across different groups.</li>\n<li>The existing WP Meetup Bekasi group in Indonesia has applied to join the Meetup chapter program.</li>\n<li>The non-active WP Meetup of Jakarta has now two members interested in re-activating the group and have applied to join the chapter program. They are also interested in organizing WordCamp Jakarta 2017.</li>\n<li>The WordPress Foundation has received an application for organizing WordCamp Ubud in 2017 (one hour from Denpasar) which is in pre-planning now.</li>\n<li>A WP Indonesia Slack channel is being created to connect the whole community in the country.</li>\n</ol>\n<p>Clearly, WordCamp Denpasar has had a positive effect on the Indonesian WordPress community. As more areas of the world getting involved contributing to and using WordPress, the project’s internationalization and diversity improves. If Denpasar is any indication, expanding the incubator program to more areas of the world will have long-lasting benefits within the entire WordPress community.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Jan 2017 18:59:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: Matt Mullenweg Announces Tech and Design Leads for New Focus-Based Development Cycle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/matt-mullenweg-announces-tech-and-design-leads-for-new-focus-based-development-cycle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7237:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/sharpened-pencil.jpg?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/sharpened-pencil.jpg?resize=960%2C542&ssl=1\" alt=\"\" class=\"size-full wp-image-64886\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/JLXDNN5BNE\">Angelina Litvin</a>\n<p>WordPress core development is kicking off in 2017 with the new focus-based development process that Matt Mullenweg announced during the <a href=\"https://wptavern.com/state-of-the-word-2016-mullenweg-pushes-calypso-as-future-of-wordpress-interface-proposes-major-changes-to-release-cycle\" target=\"_blank\">2016 State of the Word</a>. The new approach to releases shifts WordPress from the familiar time-based release cycle to one that is more project-based. The idea is that design and user testing will lead the way and upcoming releases will ship when significant user-facing improvements are ready.</p>\n<p>Mullenweg, who will serve as the overall product lead for 2017, <a href=\"https://make.wordpress.org/core/2017/01/04/focus-tech-and-design-leads/\" target=\"_blank\">announced</a> tech and design leads for each of the three focus areas: the REST API, the editor, and the customizer.</p>\n<p>&#8220;For the REST API we’re going to work on getting first party wp-admin usage of the new endpoints, and hopefully replace all of the core places where we still use admin-ajax,&#8221; Mullenweg said. The REST API team nominated Ryan McCue and K.Adam White to take the lead on the objectives Mullenweg outlined, as well as infrastructure and endpoint performance, security, and improvements to authentication options and documentation.</p>\n<p>&#8220;The editor will endeavor to create a new page and post building experience that makes writing rich posts effortless, and has &#8216;blocks&#8217; to make it easy what today might take shortcodes, custom HTML, or &#8216;mystery meat&#8217; embed discovery,&#8221; Mullenweg said. Automattic employees Matias Ventura and Joen Asmussen will be taking point on the editor.</p>\n<p>The <a href=\"https://wordpress.org/plugins/shortcode-ui/\" target=\"_blank\">Shortcake UI</a> feature plugin is one attempt at giving the existing shortcodes feature a more user-friendly interface, but contributors are also exploring other ideas for simplifying the experience of adding rich content to posts. Ella Van Dorpe recently posted an idea for <a href=\"https://make.wordpress.org/core/2016/12/24/idea-uniform-resource-identifiers-as-an-alternative-to-shortcodes/\" target=\"_blank\">using uniform resource identifiers as an alternative to shortcodes</a> in certain use cases. This would work similar to <a href=\"https://codex.wordpress.org/Embeds\" target=\"_blank\">WordPress&#8217; implementation of oEmbed</a> where data is stored elsewhere and embedded in a post using a URL.</p>\n<p>Mullenweg&#8217;s proposed direction for the customizer team is to &#8220;help out the editor at first, then shift to bring those fundamental building blocks into something that could allow customization &#8216;outside of the box&#8217; of post_content, including sidebars and possibly even an entire theme.&#8221; Weston Ruter and Mel Choyce will be taking the lead on the customizer focus.</p>\n<p>Ruter and contributors have been working on a project called <a href=\"https://github.com/xwp/wp-js-widgets\" target=\"_blank\">JS Widgets</a> that uses the Customize API to power the next generation of JavaScript-widgets in core. It opens the door for managing widgets via the REST API and ties in nicely with all three focus areas.</p>\n<p>A preliminary discussion on upcoming Customizer priorities cropped up in the comments. Nick Halsey, co-maintainer of the customize component, <a href=\"https://make.wordpress.org/core/2017/01/04/focus-tech-and-design-leads/#comment-31891\" target=\"_blank\">responded</a> to the proposal of having the customizer help out the editor at first. He believes the best approach is to create the new editor within the Customize API, giving it live previews from the start.</p>\n<p>&#8220;Improving the editor within an &#8216;admin&#8217; interface that lacks live preview doesn’t address the fundamental problems with the current content editing experience and creates something that still has to be entirely rebuilt and reimagined within a live preview context eventually,&#8221; Halsey said. &#8220;If the editor is built on the Customize API first, rather than rethinking the editor and then bringing it into the live preview API, the customize and editor contributors would be able to join forces to focus on improving the content editing experience much more effectively.&#8221;</p>\n<p>It will be interesting to see what direction Mullenweg and the leads decide to take in the foundational task of architecting the new editing experience. Mullenweg made it clear in the State of the Word address that he would like to see Calypso or a similar interface replace wp-admin in the future. However, Calypso was not built using the Customize API, WordPress&#8217; own single page application admin interface that plugins and themes already widely support.</p>\n<p>After WordCamp US, I asked Mullenweg about his intentions for Calypso in relationship to WordPress core. He said the application was &#8220;designed to be in core someday,&#8221; which is one reason they selected the same license and made it open source.</p>\n<p>&#8220;My real hope is that it is something that is ready for core someday &#8211; both Calypso the interface and the concept.&#8221; Mullenweg said. &#8220;That&#8217;s why I said Calypso or something like it. There&#8217;s obviously a lot of WordPress.com stuff in Calypso that will never be in core. If we think of a wp-admin replacement, it would be replacing wp-admin with the parts that Calypso does that are the same thing, kind of more of the my sites section of it. But I do believe the future of a great wp-admin experience is JavaScript &#8211; probably React, talking to APIs, super fast, and maybe even working offline.&#8221;</p>\n<p>Automattic is actively recruiting popular plugin authors to make their plugins Calypso-aware. Demonstrating the application&#8217;s interoperability with the WordPress plugin ecosystem is a must before Calypso can be considered a promising replacement for the WordPress admin. In the meantime, the foundation for a new page and post building experience is being laid with consideration for how the customizer can improve the editor.</p>\n<p>Mullenweg responded to comments on the post indicating that feature plugins or other improvements to WordPress outside of the three focus areas would need to continue on as plugins for the time being. However, performance improvements may be included in minor releases.</p>\n<p>&#8220;What goes in a minor release will broaden a bit, which I know is something we have to approach carefully, but performance is very important and improvements will be something I will consider for being in a minor release,&#8221; Mullenweg said. Contributors are currently working on <a href=\"https://make.wordpress.org/core/tag/4-7-1/\" target=\"_blank\">WordPress 4.7.1</a>, which is planned for release on Tuesday, January 10.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Jan 2017 00:00:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"WPTavern: Micro.blog Surpasses Kickstarter Funding Goal, Set to Launch New Social Network for Independent Microblogs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64805\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"https://wptavern.com/micro-blog-surpasses-kickstarter-funding-goal-set-to-launch-new-social-network-for-independent-microblogs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6754:\"<p>Developer <a href=\"http://www.manton.org/\" target=\"_blank\">Manton Reece</a> is on a mission to take back short form content for the open web by providing better tools for independent microblogging. Most short form content today is posted through centralized social networking sites like Facebook, Twitter, and Instagram, where posts are mixed with promoted content and users have no control of their timelines. There&#8217;s no guarantee that these social networks will be around forever, as many before them have disappeared, eclipsed by new ways to connect online.</p>\n<p>Reece set out to create <a href=\"http://micro.blog/\" target=\"_blank\">Micro.blog</a>, a timeline and publishing platform for the open web, as an alternative social network that encourages more independent writing. He <a href=\"https://www.kickstarter.com/projects/manton/indie-microblogging-owning-your-short-form-writing\" target=\"_blank\">launched a Kickstarter campaign</a> to fund the platform along with his work on a book called Indie Microblogging. The project&#8217;s $10K goal was fully funded on the first day and has passed $22,000 on the second day of the campaign.</p>\n<p>Micro.blog has a timeline experience similar to Twitter with replies and favorites, but the main difference is that it is based on RSS, pulling posts from independent sites. Those who don&#8217;t have their own websites will be able to opt for a hosted microblog and map a custom domain. Users with hosted microblogs can post via a web interface that includes a Markdown editor or use the service&#8217;s iPhone app.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/micro-blog-1.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/micro-blog-1.png?resize=1025%2C590&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64853\" /></a></p>\n<h3>Micro.blog Will Integrate with WordPress</h3>\n<p>Reece, who self-hosts <a href=\"http://manton.org/\" target=\"_blank\">his own blog</a> on WordPress, will be launching Micro.blog with full integration for WordPress users, making it easy to cross post between the two platforms. I asked him about the workflow for publishing from WordPress and he said his Indie Microblogging book will contain a section specifically on WordPress.</p>\n<p>&#8220;After you&#8217;ve told Micro.blog about your WordPress RSS feed, you can continue to post to your blog as you normally would, although I&#8217;ll have some tips for taking the best advantage of it,&#8221; Reece said. &#8220;There&#8217;s also a native iPhone app for Micro.blog that supports direct posting to WordPress. I&#8217;ve found that it really improves the user experience to have a single app with a timeline experience, replies, favorites, as well as easy posting directly to your own site. But there&#8217;s no requirement to use any specific app.&#8221;</p>\n<p>Reece said he plans to implement a very strict, reverse-chronological timeline for content that users are following. He also does not plan to introduce any algorithms or advertising. Basic accounts will be free and the plan is to sustain the platform with revenue from a paid plan that includes extra features like microblog hosting.</p>\n<p>&#8220;One thing that is very important to me is not letting someone you don&#8217;t follow interrupt your timeline with harassment or other replies that aren&#8217;t appropriate,&#8221; Reece said. &#8220;I&#8217;m working on some features around this that I hope will help avoid similar issues that Twitter has faced in its community, for example. So if there are any custom algorithms or curation it will be around trying to deal with abuse before it happens.&#8221;</p>\n<p>The Micro.blog platform is currently built using Ruby, Sinatra, Ember.js, MySQL, and Redis. Reece said he is in the process of rewriting some of the app with a more traditional Ruby on Rails setup.</p>\n<p>&#8220;Ember didn&#8217;t end up being a great fit for the design,&#8221; Reece said. &#8220;There is also a portion of the microblog publishing engine built on Jekyll, so that themes and data files can be more portable.&#8221;</p>\n<p>Micro.blog isn&#8217;t entirely distributed where users host their own &#8220;pods&#8221; like Diaspora, but Reece said he is open to making it more decentralized in the future.</p>\n<p>&#8220;It&#8217;s a good goal to eventually move to something even more distributed, but it introduces a lot of complexity, which has prevented most of those kind of solutions from taking off,&#8221; Reece said. &#8220;I hope that Micro.blog is a step in the right direction, encouraging people to write more on their own site even for short microblog posts, instead of just Twitter and Facebook, with more open formats and APIs. It&#8217;s more achievable if we can build off of tools like WordPress instead of starting over.&#8221;</p>\n<p>Reece said he thinks WordPress.com (Automattic) is one of only a couple web publishing companies he believes could last 100 years. &#8220;Only 2 companies keep coming to mind: WordPress.com and GitHub,&#8221; he said in a <a href=\"http://mirror.manton.org/2015/09/complete-mirror-of-this-blog.html\" target=\"_blank\">post about mirroring his blog to GitHub</a>. &#8220;I believe both will last for decades, maybe even 100 years, and both embrace the open web in a way that most other centralized web sites do not.&#8221;</p>\n<p>During his 14 years of blogging and 10 years of using Twitter, Reece became an advocate for the open web. He said he used to be excited about Twitter and built apps for the platform but grew disillusioned at their approach to locking down the API.</p>\n<p>&#8220;We&#8217;ve been so focused on writing on Twitter and Facebook that we&#8217;ve gotten away from more independent publishing that makes blogs and the open web great,&#8221; Reece said. &#8220;I think microblogging has a place on the open web, and that posting to a blog and reading posts from friends can have just as great a user experience as using a traditional social network. I&#8217;ve already heard from many people who have been inspired recently to blog again, which is really the main goal of Micro.blog.&#8221;</p>\n<p>The <a href=\"https://www.kickstarter.com/projects/manton/indie-microblogging-owning-your-short-form-writing/community\" target=\"_blank\">Micro.blog Kickstarter campaign</a> will end in 27 days. Reece said he was surprised the project was funded so quickly. He plans to work hard over the next month to roll out Micro.blog to everyone.</p>\n<p>&#8220;I can&#8217;t wait to see how users use the service, how the book can help WordPress users expand their existing blogs, and what developers want to build on the APIs going forward,&#8221; Reece said.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Jan 2017 23:14:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"HeroPress: We Are The Same\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1556\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://heropress.com/essays/we-are-the-same/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9064:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/01/010417-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: To every woman... we are the same. I am you and you are me.\" /><p><em>Topher asked me to write an article for HeroPress as we sat together in an alcove in the Philly Convention Center. I was in a vulnerable space. My lightning talk at WordCamp US had concluded, and I was settling into the experience of being at another WordCamp. I thought about the life experiences that brought me to my second presentation a year later, and I started to cry. Below is why.</em></p>\n<p>One of my earliest memories is attending my mother&#8217;s graduate school graduation ceremony. It was a huge achievement. I wore a pink frilly dress with afro puffs to her graduation ceremony. I am sure I was gripping someone&#8217;s leg and hiding behind them. Behind my mother, my aunt or maybe my father. I was painfully awkward and shy. Which didn&#8217;t make any sense because my family was constantly telling me, &#8216;Be quiet&#8217;. That could have been their anthem for me. Children were meant to be seen, not heard.</p>\n<blockquote><p>I think of that young Sierra Leonean American girl I was, I think back to that day, and wonder what became of her.</p></blockquote>\n<p>She grew taller, much taller, transitioned from pink dresses to a pink bedroom, and, some say, is poised. But she is still painfully awkward. You wouldn&#8217;t know it, but you can catch her at times sitting quietly at an event achingly wishing she were alone and didn’t have to perform.</p>\n<p>I project confidence because I was drafted into an oratory competition in middle school. Something about my voice caught the attention of my middle school teacher Mrs. McNeil. She entered me into one. I don&#8217;t recall what I read or the outcome. I only remember my mom driving me to my competition and her, my sister and I pulling up to a very crowded parking lot. Everything gets fuzzy after we arrived.</p>\n<p>In high school, I didn&#8217;t need to be drafted into public speaking. I had strong ideals and opinions, and when it came to debate competitions I didn&#8217;t need to fit in and be cool. All I had to do was win. I debated as a Junior Statesmen, entered the Essex County Mock Trial competition, and the High School Moot Court Tournament at Princeton University. During 10th or 11th grade I got commendations for my role as a mother whose son died due to someone&#8217;s negligence at school. I argued with the other team’s attorneys. I was distraught. I channeled my inner mother. The judge gave our Mock Trial team extra points because I made the case believable. In 11th grade my partner and I came second place in the Moot Court competition at Princeton.</p>\n<p>I live in Maplewood, New Jersey. It is a town that actively engages its children. Our administration and teachers educate us to be competitive academically and in our extracurricular activities, and to actively seek out opportunities for service.</p>\n<blockquote><p>Teachers tell us we can be great &#8211; and expectations are that we will be great.</p></blockquote>\n<p>It is ingrained in us that to whom much is given much is expected. I do the best I can to embody what is expected of me.</p>\n<p>Truthfully, as an African girl, it was wonderful to be educated like this. At home my parents, aunts and uncles expect nothing less. Outside of home and my classes and clubs, I received mixed messages about who I was and what I could achieve. I was one of a handful of Africans in a diverse community. I didn&#8217;t look African or sound African I was told growing up. And I was surprised as a child of how differently I was treated by many of the same color other than my best friend and her family in elementary school. It was fascinating. On one occasion at school I achingly experienced different treatment. A college counselor lost interest in helping me with financial aid when it came up in conversation that I was African. After that conversation she was too busy to meet with me. I went to the head of guidance instead who was fabulous.</p>\n<blockquote><p>Occasions like this make me acutely proud of where my family comes from and the sacrifices my parents made 30 plus years ago when they immigrated here.</p></blockquote>\n<p>I see in them that resilience is a must and that success is accessible through motivation, hard work, focus, education and self-improvement.</p>\n<p>As a child, I hurt at the barriers some put up when I told them I am African. And I still do. At times, we are misunderstood and misrepresented. And it doesn&#8217;t make me any less proud of my Sierra Leonean heritage.</p>\n<p>Three weeks ago, I had dinner with someone I met years ago. I mentioned something related to my heritage. She stopped for a second. She said she was surprised to hear I am African. Her enthusiasm towards me immediately drained. I wasn&#8217;t shocked. I pushed away the feeling of disappointment I feel in these occasions. I acknowledged the difference internally and it didn&#8217;t stop me from enjoying her company. It&#8217;s a situation I&#8217;ve found myself in many, many times.</p>\n<p>I was told I could be great as a child growing up in Maplewood. I let this propel me forward through each obstacle in my way, and I let this make me stand tall as I take on each daunting task before me. I took this with me to every college class and graduate class I have taken even when overpowered by feelings of inadequacy. I have been to events at places where very few people will ever have the chance to go. There are organizations I have worked for that have a competitive selection process. There are certificates I have earned that make me wonder how I gathered the strength to make it through. And there are presentations like the ones I gave at WordCamp US in 2015 and 2016 where I fought through feelings of inadequacy to stand on stage and speak before hundreds of people in the tech industry.</p>\n<blockquote><p>At these times, I think of the little Sierra Leonean American girl in the pink frilly dress with afro puffs, and wonder how she could achieve each one of these accomplishments.</p></blockquote>\n<p>I wonder how she became so warmly embraced by the WordPress community, invited to plan WordCamp NYC at the United Nations in 2016, and invited to be a co-organizer of Meetups in NYC. It reflects how inclusive our community is.</p>\n<p>I think of my gender, my color, and my heritage.</p>\n<p>To every woman &#8211; we are the same. And, even if we glance at each other and look away, I am you and you are me. We can’t let anyone convince us otherwise.</p>\n<blockquote><p>I think of the African girl on the continent who doesn’t have the choices and resources I have. I cry for her, and I cry for me.</p></blockquote>\n<p>I cry because I may never meet her, never look deeply into her eyes, never tell her that she will be great, give her the resources she needs to fully realize her dreams and give her the space to be embraced by the WordPress community. Make no mistake in this digital age that this little girl is aware of what she doesn’t have, and that she needs us to propel her forward.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: We Are The Same\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=We%20Are%20The%20Same&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fwe-are-the-same%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: We Are The Same\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fwe-are-the-same%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fwe-are-the-same%2F&title=We+Are+The+Same\" rel=\"nofollow\" target=\"_blank\" title=\"Share: We Are The Same\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/we-are-the-same/&media=https://heropress.com/wp-content/uploads/2017/01/010417-150x150.jpg&description=We Are The Same\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: We Are The Same\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/we-are-the-same/\" title=\"We Are The Same\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/we-are-the-same/\">We Are The Same</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Jan 2017 12:00:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Winstina Hughes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: W3Techs Ranks WordPress as the Fastest Growing CMS of 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64826\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/w3techs-ranks-wordpress-as-the-fastest-growing-cms-of-2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3019:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/blogging.jpg?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/blogging.jpg?resize=960%2C521&ssl=1\" alt=\"\" class=\"size-full wp-image-54799\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/3ZHG0XOIT6\">Luis Llerena</a>\n<p>W3Techs published its <a href=\"https://w3techs.com/blog/entry/web_technologies_of_the_year_2016\" target=\"_blank\">Web Technologies of 2016</a> report today, compiling technologies that saw the largest increase in usage last year. The survey pulls data from the top 10 million sites (according to Alexa rankings) and compares the number of sites for each technology by measuring the difference from January 1, 2016 to January 1, 2017.</p>\n<p>W3Techs ranks WordPress as the fastest growing content management system with 58.5% market share. Shopify and Squarespace demonstrated the second and third largest increases in usage. Squarespace is a newcomer to the top three. In <a href=\"https://w3techs.com/blog/entry/web_technologies_of_the_year_2015\" target=\"_blank\">2015</a> the second and third place winners were Drupal and Shopify. WordPress has dominated the top spot every year since 2010.</p>\n<p>CMS usage on the whole saw a 3.3% increase. Of the top 15 CMS&#8217;s only six demonstrated growth, including the aforementioned top three, as well as Joomla, Drupal, and Bitrix, which showed nominal 0.1% increases in market share by the end of 2016. Blogger is on the decline, and the remaining CMS&#8217;s showed no increase or decrease.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/cms-usage-2016.png?ssl=1\"><img src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/cms-usage-2016.png?resize=1025%2C444&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64832\" /></a></p>\n<p>PHP regained its top ranking among server-side programming languages as the fastest growing in 2016, a title which it temporarily lost to Java in 2015. W3Techs estimates PHP to be used by 82.4% of all websites for which it can detect a server-side programming language.</p>\n<p>Another interesting result of the survey is that &#8220;WordPress Jetpack,&#8221; the stats module in Jetpack, ranks third among the fastest growing traffic analysis tools, trailing Google Analytics and Yandex.Metrika. Jetpack Stats has been on a slow upward trend, rising from 1.6% in 2011 to 4.5% in 2017. The top fastest growing players in this category have repeated several years in a row.</p>\n<p>It&#8217;s important to note that many Jetpack stats users also use Google Analytics, but these numbers also give a rough idea of Jetpack usage increase, since it is one of the most popular modules in the plugin. According to W3Techs, <a href=\"https://w3techs.com/technologies/details/ta-wordpressstats/all/all\" target=\"_blank\">Jetpack Stats</a> is used by 6.9% of sites for which it can detect a traffic analysis tool, which it estimates as 4.5% of all websites.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Jan 2017 23:03:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WPTavern: WP-CLI Gets Official WordPress.org Support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64789\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wptavern.com/wp-cli-gets-official-wordpress-org-support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5086:\"<p>The WP-CLI open source project will be coming under the WordPress.org umbrella in 2017. After recent talks with Daniel Bachhuber, WP-CLI&#8217;s official maintainer, Matt Mullenweg <a href=\"https://make.wordpress.org/core/2016/12/28/supporting-the-future-of-wp-cli/\" target=\"_blank\">announced WordPress&#8217; support for the project</a>, calling it &#8220;one of the highest impact developments for WP in many years.&#8221; The wp-cli.org website will soon be migrated to WordPress.org and a <a href=\"https://make.wordpress.org/cli/\" target=\"_blank\">CLI Make site</a> with its own P2 is now available to contributors.</p>\n<p>&#8220;As we head into 2017, I wanted to make sure that its future is certain for everyone who builds on it, and that the major contributors to the project, chiefly Daniel Bachhuber, are able to work on it even more in the coming year,&#8221; Mullenweg said. Now that the project is part of WordPress.org, Mullenweg said he will be leading a coalition of companies to &#8220;solidify their financial support&#8221; of <a href=\"http://wp-cli.org/blog/the-big-question.html\" target=\"_blank\">the existing fundraising effort</a> that Bachhuber launched in mid-December 2016.</p>\n<p>The logistics of the new funding model haven&#8217;t yet been completely ironed out, but Bachhuber says <a href=\"https://runcommand.io/\" target=\"_blank\">runcommand</a> will not be shutting down.</p>\n<p>&#8220;Runcommand&#8217;s sole focus will be to hire people to work on WP-CLI,&#8221; he said. &#8220;This hybrid approach better ensures WP-CLI&#8217;s long-term future (e.g. the project is under the wing of the WordPress project), while also being a creative way for paying for dedicated resources to it.&#8221;</p>\n<p>Bachhuber explored different funding models for WP CLI throughout 2016 without much success. When discussions about making it an official WordPress core project first began, he was leaning towards keeping WP-CLI operating as an independent project. The new hybrid approach gives companies the opportunity to financially support an official WordPress project via runcommand, where Bachhuber hopes to hire additional maintainers on a part-time basis.</p>\n<p>&#8220;I&#8217;ve thought a lot about funding open source over the last year,&#8221; Bachhuber said. &#8220;In the context of WP-CLI, I came to the conclusion that I didn&#8217;t have confidence in WP-CLI being a completely independent project + financially sustainable business.&#8221;</p>\n<p>Bachhuber said he feels &#8220;reasonably confident&#8221; about the future of the project after recent developments and hopes to have funding for a few part-time maintainers.</p>\n<p>&#8220;I think part-time is key because each of us needs to be working / solving problems in the real-world, and then taking those solutions back to the project,&#8221; Bachhuber said. Although many open source projects operate without paying people for contributions, he believes there is an important distinction between maintainers and contributors.</p>\n<p>&#8220;Contributors act in a voluntary manner (e.g. contributing code when they have a couple hours free),&#8221; Bachhuber said. &#8220;Maintainers take responsibility for the project, showing up every day, and doing most of the unglamorous work. I think maintainership is an important aspect of a healthy open source project. Everyone has an example of an open source project they use that&#8217;s no longer maintained and how painful it is to be dependent on it.&#8221;</p>\n<p>Responses to the news of WP-CLI gaining official WordPress.org support were overwhelmingly positive, as the tool is critical to the WordPress developer community. The decision to have WP-CLI operate under WordPress.org&#8217;s umbrella makes it better positioned to drive the financial support needed to sustain the ongoing burden of maintainership.</p>\n<p>Bachhuber said the current fundraising effort, which is <a href=\"https://wptavern.com/wp-cli-project-launches-patron-support-model-to-fund-ongoing-development\" target=\"_blank\">based on a patron support model</a>, is approximately 1/5 of the way to his funding goal. He is still waiting to hear from a number of large players but the funding drive will remain open indefinitely for now. Bachhuber said they will re-evaluate once they reach the goal.</p>\n<p>&#8220;I consider this the best possible outcome of my efforts trying to identify sustainability for the project over the last year,&#8221; Bachhuber said in the <a href=\"https://make.wordpress.org/cli/2017/01/03/lets-do-this/\" target=\"_blank\">first post</a> on the Make WordPress CLI site. &#8220;The decision to make WP-CLI an official WordPress project also means there’s a clear path forward for me to invest more of my own time into the <a href=\"http://wp-cli.org/docs/roadmap/\" target=\"_blank\">WP-CLI roadmap</a>. Concurrent with the transition process over the next couple of months, I want to move forward the conversation of how we realize a future where WP-CLI is the fastest way to do anything with WordPress.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Jan 2017 06:50:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"HeroPress: Help a HeroPress friend\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://heropress.com/?p=1553\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"https://heropress.com/help-heropress-friend/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2334:\"<p>Hey folks, HeroPress contributor Michael Beil is fighting for his life right now. Michael&#8217;s a personal friend, and a tremendous person. There&#8217;s an <a href=\"https://www.plumfund.com/financial-hardship/michael-john-beil\">online donation form</a> to help with medical bills and life in general. If you can, please help out.</p>\n<p><a href=\"https://heropress.com/essays/life-without-limits/\">You can read Michael&#8217;s HeroPress essay here</a>.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Help a HeroPress friend\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Help%20a%20HeroPress%20friend&via=heropress&url=https%3A%2F%2Fheropress.com%2Fhelp-heropress-friend%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Help a HeroPress friend\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fhelp-heropress-friend%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fhelp-heropress-friend%2F&title=Help+a+HeroPress+friend\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Help a HeroPress friend\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/help-heropress-friend/&media=http://heropress.com/wp-content/plugins/rtsocial/images/default-pinterest.png&description=Help a HeroPress friend\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Help a HeroPress friend\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/help-heropress-friend/\" title=\"Help a HeroPress friend\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/help-heropress-friend/\">Help a HeroPress friend</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 31 Dec 2016 01:20:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WPTavern: WPWeekly Episode 258 – 2016 Year in Review Part 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=64794&preview=true&preview_id=64794\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wptavern.com/wpweekly-episode-258-2016-year-in-review-part-1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1078:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I recap the news and headlines of the first half of 2016. Part two will be recorded on January 4th, 2017, where we&#8217;ll look back at the headlines during the second half of 2016, give our predictions for 2017, and share what we&#8217;re looking forward to in the new year.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, January 4th 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #258:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Dec 2016 21:45:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Post Status: What we want from WordPress in 2017, live from Post Status Publish\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=31717\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://poststatus.com/post-status-draft-live-at-publish/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1751:\"<p>After Post Status Publish&#8217;s main talks concluded, Joe Hoyle and I recorded the podcast during the reception. It was a laid back format where we discuss the future of WordPress, including our own wishlist features, and then we spent the majority of the hour taking questions from the audience.</p>\n<p>We recorded this prior to the announcement of the <a href=\"https://poststatus.com/matt-mullenweg-state-word-2016/\">new development schedule</a> and changes to major releases, but most of our conversation remains relevant, as many of our wishlist items are within the three release focus areas that have been chosen.</p>\n<p>You can listen to just the audio, also on our podcast, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher.</p>\n<!--[if lt IE 9]><script>document.createElement(\'audio\');</script><![endif]-->\n<a href=\"https://audio.simplecast.com/56018.mp3\">https://audio.simplecast.com/56018.mp3</a>\n<p><a href=\"https://audio.simplecast.com/56018.mp3\">Direct Download</a></p>\n<p>Or just watch the <a href=\"https://youtu.be/Xoteb83jmD8\">video on YouTube</a>, or below for the full experience. And don&#8217;t forget to subscribe to <a href=\"https://www.youtube.com/c/PostStatus\">my new channel on YouTube</a>.</p>\n<p></p>\n<p>The rest of the videos from <a href=\"https://poststatus.com/publish\">Publish</a> are available to Post Status members.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Dec 2016 15:21:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"HeroPress: Over The Atlantic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1545\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://heropress.com/essays/over-the-atlantic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6054:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/12/122816-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: I\'ve come to realise the WordPress community doesn\'t tolerate bad actors.\" /><p>I’m on a plane. They’ve just served lunch and I realise I’m stuck. There isn’t enough room to slip out for a bathroom break without tipping my meal and the trolley blocks the aisle.</p>\n<p>I cough and notice I’m tense, what’s going on? I enjoy flying, why should today be any different? Is it that I might be sick? Maybe it’s shovelling clothes off of the dining table into an open suitcase and rushing for a taxi at 6am? Or responding to a client at 11pm then playing Rimworld till 2am knowing I’d be up at 5? Maybe it’s Mr Robot? Anyone who’s seen that show knows it isn’t exactly happy.</p>\n<p>I open my watch up and try the new breathe app. I’ve installed watch apps before but never found much use from them, but this came with the update from Apple this morning so I’ll give it a go. It holds me steady but I’m still tense.</p>\n<p>I put on some music and try to eat some food. Maybe that’s the problem? I get anxious sometimes about food, it can get me in trouble. During speaker submissions for WordCamp Europe Sophia I wrote a mini rant about sandwiches and labeling. Siobhan thought it was funny, but I should know better. It was that year I saw a talk on depression.</p>\n<p>I’ve seen several people speak about it, but right now I’m anxious, and I’m typing. After WCEU 2016 I promised Topher I’d write an article for him, and I’ve been occupied. The last month or so, I’ve been working and not taking care of myself. I’m not sure if I&#8217;m actually sick or if this is burn out. I’ve noticed aches in my hands, it worries me.</p>\n<p>I think about what writing this will do. My WP Tavern article ranks higher than me on Facebook search.</p>\n<blockquote><p>There’s nothing like an article on anxiety popping up when a date searches your name. I don’t want to be known as the mental health guy.</p></blockquote>\n<p>But a promise is a promise. When I last did this people were supportive. They said nice things, they talked about their own feelings and gave talks. Nobody sent their pity.</p>\n<p>The food tray’s gone now, I’m not sure how I feel but I know there’s 2 Automatticians in front of me and 2 to the side. We land in Vancouver in 6 hours for the grand meet up, and I know I’ll get a big hug from several people. They’re genuine nice people, and I’ve come to realise the WordPress community doesn’t tolerate bad actors. We share what we think is important, what people need to hear.</p>\n<p>I’ve got one more episode of Mr Robot, I’ll think about those I see at WordCamps and close this app. It isn’t long before I can talk in person.</p>\n<hr />\n<p>I’m home! Despite a total lack of scrambled eggs on toast in not one, not two, but three major international airports, I’ve finally returned home. My friends dragged me jet lagged to a play entitled “The pacifists answer to the war on cancer” where a jolly sequinned cancer cell sings a song moments after a woman screams in agony. I got to sing happy birthday to my family with a room of Automatticians, climb a mountain, it was fun!</p>\n<p>I think about what I’ve written, and wish I’d been more positive.</p>\n<blockquote><p>Life can be scary but I’m surrounded by people who want to help.</p></blockquote>\n<p>Sometimes that’s family, or friends, but user groups and events help too. These people have the same problems and worries I do, and deal with them in many ways.</p>\n<p>Importantly, they’re willing to talk about their problems in front of hundreds of people, and share their solutions. I feel it’s something that isn’t mentioned often enough. Burnout and stress is rampant in our industry, and I’m glad people are stepping up to the challenge.</p>\n<p>I’m a lead organiser for a WordCamp Manchester now. That means I can’t speak at my own conference, but I’m hoping to get a good talk or two. Maybe things aren’t so terrible? Maybe next time I’ll get a window seat.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Over The Atlantic\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Over%20The%20Atlantic&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fover-the-atlantic%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Over The Atlantic\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fover-the-atlantic%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fover-the-atlantic%2F&title=Over+The+Atlantic\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Over The Atlantic\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/over-the-atlantic/&media=https://heropress.com/wp-content/uploads/2016/12/122816-150x150.jpg&description=Over The Atlantic\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Over The Atlantic\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/over-the-atlantic/\" title=\"Over The Atlantic\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/over-the-atlantic/\">Over The Atlantic</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Dec 2016 12:00:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Tom Nowell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Matt: Christmas Music: Leslie Odom Jr.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47002\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://ma.tt/2016/12/christmas-music-leslie-odom-jr/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:629:\"<p>I love Christmas music, and <a href=\"https://ma.tt/2013/12/christmas-jazz-music/\">most years</a> I like to recommend a Christmas music album that is a bit more jazz or has something interesting about it. This year I want to point you to Leslie Odom Jr., aka Aaron Burr in the hit musical Hamilton, who is a gifted vocalist. <cite>Hat tip: Rose Kuo.</cite> Check out &#8220;My Favorite Things.&#8221; Embedded on Spotify below, also on <a href=\"https://itunes.apple.com/us/album/simply-christmas/id1170245823\">iTunes</a> and <a href=\"https://www.amazon.com/Simply-Christmas-Leslie-Odom-Jr/dp/B01L22Y87K\">Amazon</a>.</p>\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 24 Dec 2016 18:18:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"WPTavern: BuddyPress 2.7.4 Patches Security Vulnerability That Could Allow Arbitrary File Deletion\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=64736&preview=true&preview_id=64736\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://wptavern.com/buddypress-2-7-4-patches-security-vulnerability-that-could-allow-arbitrary-file-deletion\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1223:\"<p>The BuddyPress development team has <a href=\"https://buddypress.org/2016/12/buddypress-2-7-4-security-release/\">released BuddyPress 2.7.4</a> to address a security vulnerability that affects all versions back to 2.0.</p>\n<p>According to John James Jacoby, lead developer of BuddyPress, &#8220;This version patches a vulnerability to the BuddyPress core attachments API that could allow arbitrary file deletion on certain installation configurations.&#8221;</p>\n<p>The vulnerability was responsibly disclosed by Sam Pizzey through the <a href=\"https://hackerone.com/automattic\">HackerOne bounty program</a>. Although Automattic primarily uses the service for its own products, they accept reports for open source projects such as WordPress and BuddyPress.</p>\n<p>Boone Gorges and Paul Gibbs collaborated on a fix for all affected versions of BuddyPress while Stephen Edgar and Dion helped package the release. Those who use BuddyPress are highly encouraged to update as soon as possible to protect against this vulnerability. If you encounter any issues or need help, please create a post on the project&#8217;s<a href=\"https://buddypress.org/support/\"> support forums.</a></p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Dec 2016 19:59:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"BuddyPress: BuddyPress 2.7.4 – Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=262326\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://buddypress.org/2016/12/buddypress-2-7-4-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1235:\"<p>BuddyPress 2.7.4 is now available, and is a security release &amp; recommended upgrade for all BuddyPress installations. We&#8217;ve also ported the code changes in 2.7.4 to all branches back 2.0, and are pushing updates out for all installations where we are able to do so.</p>\n<p>These releases include a fix to the BuddyPress core attachments API that could allow arbitrary file deletion on certain installation configurations.</p>\n<p>This bug was responsibly disclosed to the WordPress security team (and the BuddyPress team) through the WordPress HackerOne Bounty Program by Sam Pizzey (mopman).</p>\n<p>Both Boone &amp; Paul worked together to fix this for all versions of BuddyPress that are currently in active use, and Stephen &amp; Dion helped package and push these releases out.</p>\n<p>Please update to these latest versions of BuddyPress today in your WordPress Dashboard, or by <a href=\"https://wordpress.org/plugins/buddypress/\">downloading from the wordpress.org plugin repository</a>.</p>\n<p>Questions or comments? Check out the <a href=\"https://codex.buddypress.org/releases/version-2-7-4/\">2.7.4 changelog</a>, or stop by our <a href=\"https://buddypress.org/support/\">support forums</a> or  Trac.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Dec 2016 02:25:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"John James Jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WPTavern: WordPress.org Launches Homepage Redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64708\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wptavern.com/wordpress-org-launches-homepage-redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2790:\"<p><a href=\"https://wordpress.org/\" target=\"_blank\">WordPress.org</a> made its new <a href=\"https://wptavern.com/the-wordpress-org-homepage-is-getting-a-redesign\" target=\"_blank\">homepage redesign</a> live today. The meta team worked quickly to put the new design in place in time for the holidays.</p>\n<p>&#8220;While this is only the first iteration, the plan is to continue design and development to create something truly amazing,&#8221; Mark Uraine said in the <a href=\"https://make.wordpress.org/meta/2016/12/22/new-homepage-is-launched/\" target=\"_blank\">announcement</a>. &#8220;This is the first step toward that goal.&#8221;</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/wordpress-homepage-new-design-e1482443742169.png?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/wordpress-homepage-new-design-e1482443742169.png?resize=1025%2C854&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64722\" /></a></p>\n<p>The header and footer have been kept from the previous design. According to meta team member Samuel Wood, matching them to the new design is beyond the scope of this first iteration.</p>\n<p>&#8220;The header and footer are global pieces,&#8221; Wood said. &#8220;Redesigning them, in any way, will have to be part of a much larger effort in redesigning, well, everything. The entire site would need adjustments to adjust them.&#8221;</p>\n<p>Uraine <a href=\"https://make.wordpress.org/meta/2016/12/12/new-homepage-redesign/#comment-8739\" target=\"_blank\">said</a> in a previous post that there are iterations underway for a new, more minimal header that better aligns with the new homepage style.</p>\n<p>Feedback on the <a href=\"https://make.wordpress.org/meta/2016/12/12/new-homepage-redesign/\" target=\"_blank\">initial draft</a> included notes on the copy, particularly the &#8220;Meet WordPress&#8221; headline. One person commented on it not being inclusive of people who have already met WordPress and are returning. Also, a few found the tagline to be too narrow: <em>WordPress is open source software you can use to create a beautiful website, blog, or app.</em> Some suggested the inclusion of other use cases, such as store, forum, and membership site. These ideas have not been incorporated but they were recognized by the design team in the comments on the initial draft.</p>\n<p>The homepage redesign went from sketches to prototype to live on WordPress.org in a matter of a couple weeks. Feedback has been overwhelmingly positive so far, and most see it as a huge improvement. The new design should receive a great deal more exposure now that it&#8217;s live, which will hopefully bring in more varied perspectives towards making it extraordinary in future iterations.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Dec 2016 23:13:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: New .org Homepage\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46996\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"https://ma.tt/2016/12/new-org-homepage/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:410:\"<p>For the first time in&#8230; many years, <a href=\"https://wordpress.org/\">WordPress.org has a new home page</a>. What&#8217;s on the page today actually isn&#8217;t that important, even though it&#8217;s better in many ways, the key is that it&#8217;s changing again, the stone has <a href=\"https://make.wordpress.org/meta/2016/12/22/new-homepage-is-launched/\">been unstuck</a> and can now keep rolling.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Dec 2016 22:10:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: WPWeekly Episode 257 – My Side Project, WordPress 4.7, and the News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=64711&preview=true&preview_id=64711\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wptavern.com/wpweekly-episode-257-my-side-project-wordpress-4-7-and-the-news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3589:\"<p>In this episode of WordPress Weekly, <a href=\"http://www.marcuscouch.com/\">Marcus Couch</a> and I discuss the news of the week including, WooCommerce&#8217;s 42% market share, the redesign concept of WordPress.org, and two plugin acquisitions. I also share details of a side project I&#8217;m working on that involves BuddyPress. Last but not least, we briefly discuss <a href=\"https://twitter.com/kingjeff2\">Jeff King&#8217;s</a> impact on GoDaddy as he&#8217;s leaving the company at the end of this year.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/wordpress-4-7-introduces-twenty-seventeen-default-theme-and-wp-rest-api-content-endpoints\">WordPress 4.7 Introduces Twenty Seventeen Default Theme and WP REST API Content Endpoints</a><br />\n<a href=\"https://wptavern.com/the-wordpress-org-homepage-is-getting-a-redesign\">The WordPress.org Homepage is Getting a Redesign</a><br />\n<a href=\"https://wptavern.com/woocommerce-powers-42-of-all-online-stores\">WooCommerce Powers 42% of All Online Stores</a><br />\n<a href=\"https://wptavern.com/podcast-motor-acquires-seriously-simple-podcasting-plugin\">Podcast Motor Acquires Seriously Simple Podcasting Plugin</a><br />\n<a href=\"https://wptavern.com/updraftplus-acquires-wp-optimize-will-be-integrated-into-updraftcentral\">UpdraftPlus Acquires WP-Optimize, Will Be Integrated Into UpdraftCentral</a><br />\n<a href=\"https://wptavern.com/wordpress-com-launches-vr-content-coming-soon-to-jetpack\">WordPress.com Launches VR Content, Coming Soon to Jetpack</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/wp-youtube-live/\">WP YouTube Live</a> displays a YouTube live video from a specified channel via shortcode. There are several shortcode options available that allow you to autoplay and change the video&#8217;s dimensions. There&#8217;s also an option to not display a video if there isn&#8217;t a live video taking place.</p>\n<p><a href=\"https://wordpress.org/plugins/woo-floating-cart-lite/\">Woo Floating Cart Lite</a> is an interactive floating cart for WooCommerce that slides into view when a user decides to buy an item. Products, quantities, and prices are updated instantly via AJAX. It&#8217;s similar to many of the professional carts you may have seen at the big retail stores where the cart is in view at all times.</p>\n<p><a href=\"https://wordpress.org/plugins/import-facebook-events/\">Import Facebook Events</a> allows you to import events from Facebook into <a href=\"https://wordpress.org/plugins/the-events-calendar/\">The Events Calendar</a> and <a href=\"https://wordpress.org/plugins/events-manager/\">Events Manager</a> plugins. If you are like me and use The Events Manager as your events plugin of choice, this plugin is a no-brainer as an extra add-on. As an add-on plugin this plugin needs The Events Calendar or Events Manager Installed and activated.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, December 28th 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #257:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Dec 2016 21:20:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: Nadia Eghbal Publishes Guide to Financial Support for Open Source\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64676\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wptavern.com/nadia-eghbal-publishes-guide-to-financial-support-for-open-source\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4614:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/lemonade-stand.jpg?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/lemonade-stand.jpg?resize=1024%2C577&ssl=1\" alt=\"\" class=\"size-full wp-image-64693\" /></a>photo credit: rachaelvoorhees <a href=\"http://www.flickr.com/photos/17237319@N00/2521106411\">A Young Entrepreneur on a Hot Day at Portland State</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-sa/2.0/\">(license)</a>\n<p>If you want to make a living in the world of open source software, <a href=\"http://nadiaeghbal.com/\" target=\"_blank\">Nadia Eghbal</a> has created a <a href=\"https://github.com/nayafia/lemonade-stand#consulting--services\" target=\"_blank\">guide</a> that explores various models for funding your work. Eghbal, who has written extensively on <a href=\"http://nadiaeghbal.com/oss\" target=\"_blank\">sustainability and open source</a>, recently authored <a href=\"https://wptavern.com/ford-foundation-publishes-non-technical-white-paper-on-open-source-software-and-the-challenges-of-sustaining-digital-infrastructure\" target=\"_blank\">a white paper published by the Ford Foundation</a> called “Roads and Bridges: The Unseen Labor Behind Our Digital Infrastructure.” The whitepaper was written to help consumers and companies understand the challenges of sustaining open source software.</p>\n<p>Eghbal published &#8220;A handy guide to financial support for open source&#8221; on GitHub so that others with experience can contribute to the reference. The repository is called &#8220;<a href=\"https://github.com/nayafia/lemonade-stand\" target=\"_blank\">lemonade stand</a>,&#8221; a term that references a common summertime business venture where children cut their teeth in entrepreneurship. The lemonade stand is often used as a symbol of capitalism, a new arena that many developers will need to embrace if they want to provide a sustainable future for their open source work.</p>\n<p>Eghbal&#8217;s guide currently includes 16 different categories of funding, starting with the smallest (donations, bounties, crowdfunding) to the largest (foundations, consortiums, and venture capital). The funding categories explore pros, cons, and relevent case studies where the particular model has been explored.</p>\n<p>&#8220;The purpose of this guide is to provide an exhaustive list of all the ways you can get paid, so that you can figure out what works best for you,&#8221; Eghbal said. It has already received additions from 12 contributors, including Daniel Bachhuber, who is currently <a href=\"https://wptavern.com/wp-cli-project-launches-patron-support-model-to-fund-ongoing-development\" target=\"_blank\">exploring a patron support model to fund his work on WP-CLI</a>.</p>\n<p>With a few notable exceptions like Red Hat and Linux, open source projects suffer from a severe lack of funding, a problem which Eghbal calls &#8220;<a href=\"https://medium.com/@nayafia/how-i-stumbled-upon-the-internet-s-biggest-blind-spot-b9aa23618c58#.6efp8nk2c\" target=\"_blank\">the internet&#8217;s biggest blind spot</a>.&#8221; She notes that the problem of funding digital infrastructure is relatively new but is accelerating as more people are using open source software but ignoring the developer tools everyone relies on.</p>\n<p>WP-CLI is a prime example in the WordPress community. Developers who use it are more inclined to send sporadic donations than become personally invested in maintaining the code base, which has led Bachhuber to test different funding models throughout 2016. There have been <a href=\"https://twitter.com/dd32/status/807435845724577792\" target=\"_blank\">discussions</a> about making it an official WordPress core project with the goal of widening the contributor base and ensuring its longterm future. However, Bachhuber <a href=\"https://twitter.com/danielbachhuber/status/806563582968115201\" target=\"_blank\">said</a> he &#8220;strongly believes WP-CLI should be an independent project.&#8221;</p>\n<p>Eghbal&#8217;s funding <a href=\"https://github.com/nayafia/lemonade-stand\" target=\"_blank\">guide</a> is an important document for open source software maintainers who are struggling to fund their efforts and looking for more options beyond sticking a simple download button on the project&#8217;s website. If you&#8217;re looking for more discussion on this topic, Eghbal co-produces a podcast called <a href=\"https://changelog.com/rfc/archive\" target=\"_blank\">Request for Commits</a> that explores open source&#8217;s complicated relationship with money and various sustainability models.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Dec 2016 20:00:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: Wallace: A Free WordPress Theme Built on the WP REST API and Angular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64652\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wptavern.com/wallace-a-free-wordpress-theme-built-on-the-wp-rest-api-and-angular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4819:\"<p><a href=\"https://twitter.com/Bradley_Kirby\" target=\"_blank\">Bradley Kirby</a> released version 1.0 of his <a href=\"https://wallacetheme.com/\" target=\"_blank\">Wallace WordPress theme</a> today. The theme is built using the WP REST API and <a href=\"https://angular.io/\" target=\"_blank\">Angular 2</a>. Kirby has been working on Wallace for the past two years and has rewritten it several times in order to keep pace with changes in the REST API and Angular.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/wallace-theme.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/wallace-theme.png?resize=1025%2C925&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64661\" /></a></p>\n<p>If you view the <a href=\"https://demo.wallacetheme.com/\" target=\"_blank\">Wallace demo</a>, you&#8217;ll notice that the theme is super fast because the interface is rendered on the client side with JavaScript.</p>\n<p>&#8220;It really opens a whole new world of possibility for WordPress themes,&#8221; Kirby said. &#8220;For this release I&#8217;ve primarily focused on smooth page transitions. That&#8217;s just not possible with the traditional server-rendered themes. But I think there&#8217;s a lot of really cool customization techniques that the API allows for, too. That&#8217;s what I&#8217;m hoping to explore next.&#8221;</p>\n<p>Although React has emerged as <a href=\"https://wptavern.com/state-of-javascript-survey-results-published-react-emerges-as-clear-winner-in-front-end-frameworks\" target=\"_blank\">the most popular JavaScript framework for front-end development</a> in 2016, Kirby said he chose Angular mostly because he learned it first.</p>\n<p>&#8220;I really like the prescriptive nature of Angular,&#8221; Kirby said. &#8220;There&#8217;s a &#8216;right&#8217; way to do things that you&#8217;ll find in example projects and all the functionality comes with the framework itself. With React you have to use a collection of third-party libraries with various maintainers. With Angular, it&#8217;s all Google, and all one repository. I think React is a perfectly fine framework, and they actually share a lot of concepts.&#8221;</p>\n<p>Wallace currently only supports posts, but Kirby plans to implement more core WordPress features, including pages, comments, searching, and category filtering. He said those features shouldn&#8217;t be too difficult to implement now that the frame is there.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/12/wallace-posts.png?ssl=1\"><img src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/12/wallace-posts.png?resize=500%2C494&ssl=1\" alt=\"\" class=\"aligncenter size-large wp-image-64669\" /></a></p>\n<p>&#8220;From a programming perspective, this was way more difficult to create than a PHP-rendered theme, because you get so much &#8216;for free&#8217; with the PHP theming API that you don&#8217;t get when you&#8217;re just making raw requests to the REST API,&#8221; Kirby said. The primary advantage of theming with the API is more instantaneous interactions with the content, but creating API-driven themes is not yet as easy as the old way of theming.</p>\n<p>Kirby said he is actively exploring the idea of submitting Wallace to WordPress.org, but the Theme Review Team does not permit the use of Twig templates.</p>\n<p>&#8220;I&#8217;ve brought it up with the team that approves themes, and they didn&#8217;t like that I was using the Twig templating library on the PHP side,&#8221; Kirby said. &#8220;So I&#8217;d have to maintain two versions of the theme if I were to submit it to the directory.&#8221; Kirby hasn&#8217;t ruled it out yet and said he will probably revisit the idea next year.</p>\n<p>&#8220;Twig templates mirror Angular templates really nicely,&#8221; Kirby said. &#8220;It cuts down on the maintenance burden quite a bit, because I have to exactly mirror the templates on the server side and the client side. That would be more difficult if I had to construct PHP echo strings, the typical WordPress template way.&#8221;</p>\n<p>Wallace is integrated with the Customizer and will disable its JavaScript when it detects the Customizer is open, reverting back to a &#8220;normal&#8221; theme. Currently the only option users can customize is the site icon and site title. Wallace does not yet offer support for setting a static front page.</p>\n<p>The next items on Wallace&#8217;s roadmap are adding more core features into the theme. Kirby said he is also exploring the idea of creating a commercial magazine theme in the future.</p>\n<p>&#8220;I think the real killer use case for this way of developing themes is e-commerce, but I want to get a good solid magazine style premium theme done before I tackle that,&#8221; Kirby said.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Dec 2016 22:43:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: How to Make BuddyPress User Registration Invite-Only\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64644\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wptavern.com/how-to-make-buddypress-user-registration-invite-only\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3486:\"<p>One of the first things I recommend users do after installing WordPress is to either close user registration or install a plugin that protects the site against spam registrations. A friend of mine recently started a new WordPress site that has BuddyPress installed.</p>\n<p>After two weeks, I chipped in to help him out and discovered more than 300 registered spam accounts. To make matters worse, these accounts were able to create new groups in BuddyPress and each one contained spam content. The first thing I did was close user registration then I began the boring process of removing the accounts.</p>\n<p>We ran into an issue where legitimate users needed to create accounts while user registration was closed. After asking <a href=\"https://twitter.com/jeffr0/status/810664097868107777\">for suggestions</a> on Twitter and performing a few Google searches, I discovered the <a href=\"https://wordpress.org/plugins/invite-anyone/\">Invite Anyone</a> plugin by <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>. Invite Anyone allows registered members to invite people to register to the site via email while registration is closed.</p>\n<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/InviteAnyoneSettings.png?ssl=1\"><img class=\"size-full wp-image-64646\" src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/InviteAnyoneSettings.png?resize=859%2C836&ssl=1\" alt=\"Invite Anyone Settings\" /></a>Invite Anyone Settings\n<p>Using variables provided by the plugin, you can customize the email invitation subject line, the invitation message, and the text at the end of the email. I used the default values which happened to suit my needs. You can also give registered users the ability to customize the invitation subject line or message body and limit the number of emails members can send at one time. In my case, the most important setting to enable was allowing email invitations to be accepted even when site registration is disabled.</p>\n<p>There are other configuration settings as well such as controlling who can send emails and limiting group invitations. Invite Only also has <a href=\"https://www.cloudsponge.com/signup/invite-anyone/\">built-in support for CloudSponge</a>, a service where users can invite anyone from their address books without leaving your site. Stats are built-in as well but during testing I couldn&#8217;t get the Stats tab to load. The Stats tab loads the General Settings page instead.</p>\n<p>Here&#8217;s what Invite Anyone looks like from a user&#8217;s BuddyPress profile page. In addition to inviting someone to the site, users can also invite them to a BuddyPress group as well.</p>\n<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/InviteAnyoneFrontEnd.png?ssl=1\"><img class=\"size-full wp-image-64647\" src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/InviteAnyoneFrontEnd.png?resize=885%2C658&ssl=1\" alt=\"What Invite Anyone Looks Like on the Frontend\" /></a>What Invite Anyone Looks Like on the Frontend\n<p>I&#8217;m using this plugin on a site running WordPress 4.7 and it&#8217;s functioning as expected. So far, we&#8217;ve invited three people and all of them were able to successfully register an account despite user registration being disabled. If you use BuddyPress and need a free solution that implements a user invitation system, I recommend <a href=\"https://wordpress.org/plugins/invite-anyone/\">Invite Anyone</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Dec 2016 19:33:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"HeroPress: The WordPress Mantra Is Mine Too\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1537\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://heropress.com/essays/wordpress-mantra-mine/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8731:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/12/122116-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: The simple fact that I improve someone\'s life through my work means the world to me.\" /><h3>Transparency makes the world go round</h3>\n<p>I like being honest, so please allow me to provide a context for this story. First of all, I&#8217;m a pretty introvert kind of guy, and I often need to be thrown in the cold water to start learning how to swim. This was exactly what happened with my teammate, Oana, when she asked me if I&#8217;d be tempted to give HeroPress a go. Of course I would, and so it started the beginning of this story. The next lines are the result of a friendly dialogue between us. Enjoy the ride, dear fellows.</p>\n<p>Here&#8217;s Andrei, a passionate web dev who truly admires the WordPress world. I&#8217;m a full-time backend at Pixelgrade, a design studio where we create WordPress themes that solve real and painful digital problems. Yes, we don&#8217;t just play around with eye-candy pixels, we strive to show up with trustworthy solutions that make people&#8217;s lives easier and more pleasant.</p>\n<p>I&#8217;ve experienced an intense professional rollercoaster till I got here. I still remember the first time I met with the WordPress fascinating world. It was during my first job interview. The employer (today a good friend of mine) told me that I would need to play around with Joomla, something I loved at that time. You can laugh, it&#8217;s okay. I do the same.</p>\n<p>However, the interview was full of tricks since I needed to do something totally different: create a homepage into WordPress. This way, the team could have seen how fast I&#8217;m able to learn new stuff. Pretty good trap since everyone working in the digital playground needs to be open-minded and capable of improving their skills and knowledge.</p>\n<p>That was the very first contact with WordPress, and I was surprised to see its potential. Not only it was easy-to-learn and get along with thanks to an in-depth documentation, but it also had an active community eager to help. Fast forward and the story had a happy ending: I got the job.</p>\n<blockquote><p>Becoming better is kind of a mantra for the true WordPress people</p></blockquote>\n<p>Starting from there and since today I still appreciate WordPress from top to toe. I have a bunch of reasons why I feel this world fits my values and principles. First of all, I enjoy all the PHP talking around WordPress. I find it interesting and challenging at the same time, and every time I have the chance to get involved, I accept it without hesitations. Another great aspect is directly related to my day-to-day job at Pixelgrade. The backend universe where I can improve an amount of cool things keeps my motivation up and kicking. On top of that, I resonate with JavaScript in various ways, backend and frontend too, and from time-to-time I write down my thoughts on my personal blog. I&#8217;m always happy to share ideas and provide feedback that helps. In the end, this is all about when you think of WordPress as an ecosystem, right?</p>\n<p>Talking about this core mission, I must confess that WordPress can be felt like a lifestyle into a room with glass walls. Everyone sees what you do, how you do it, and why you keep doing it. Nobody can take your work for granted, but can easily be inspired by it and even improving it. Becoming better is kind of a mantra for the true WordPress people, and that&#8217;s why they jump in and start spreading solutions about how things can achieve a superior level. With other words, it&#8217;s like sailing with a bunch of amazing people eager to enjoy the same outstanding experience.</p>\n<p>On the other hand, there are some coders that still think that WordPress is not that sexy and challenging in the end. They&#8217;re definitely not in the same boat, but I think it&#8217;s fair from our side to help them change their mind. And not because we chose to work in this playground, mostly because this platform changed a lot in the last years.</p>\n<blockquote><p>The simple fact that I improve someone&#8217;s life through my work means the world to me.</p></blockquote>\n<p>Here are my thoughts for all those programming lovers that would like to try WordPress, but need an extra boost.</p>\n<h3>A wide range of features</h3>\n<p>Articles, menus, widgets, users, live previews, e-commerce, e-learning, listings and so on. You can administrate them, make them better, simply play around as you wish. It might sound naive, but in reality these different areas are constantly bringing all kind of challenges on the table.</p>\n<h3>Legacy code</h3>\n<p>WordPress still strives to support the PHP 5.2.4 version, which was dropped five years ago but 7.5% from today&#8217;s websites still use it. But hey, WordPress is all about keeping users on board, happy and loyal, not skipping the battle. In the end, it does say something about the whole philosophy of the people behind the scenes.</p>\n<h3>Colleges got it wrong</h3>\n<p>There was a time where people studying Object Oriented Programming didn&#8217;t take WordPress seriously since it&#8217;s based on functional programming and that handy and approachable isn&#8217;t something that helps you progress. Well, things changed, people changed, now functional programming is turning back as the coolest thing to do nowadays, and WordPress is trying to get the best from both paradigms.</p>\n<h3>WordPress makes me proud</h3>\n<p>I mean it. It&#8217;s not just shiny words thrown into the digital garden. I&#8217;m a proud WordPress backend dev who deeply feels that impact matters, and building things for an open-source community matters even more. I&#8217;m also happy with the diverse work I do at Pixelgrade: one day can be Customify or the WP Body Class plugin, the next one can be improving Listable, a WordPress theme used by thousands of users spread all over the world. In between could be the passionate discussions regarding the core of WordPress, some advice tailored on other authors or the amazing WordCamp Europe. Whatever it is, I am grateful that I found my place where creativity, freedom, and braveness are in the first place.</p>\n<p>Call it as you wish, but the simple fact that I improve someone&#8217;s life through my work means the world to me. It gives me a sense of fulfillment, the necessary energy to keep improving, and the never-ending joy that I did something useful. And hey, there&#8217;s just another beginning since Pixelgrade has reshaped its digital presence through an outstanding website and more consistent brand story. So bring it on, fellows!</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: The WordPress Mantra Is Mine Too\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=The%20WordPress%20Mantra%20Is%20Mine%20Too&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fwordpress-mantra-mine%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: The WordPress Mantra Is Mine Too\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fwordpress-mantra-mine%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fwordpress-mantra-mine%2F&title=The+WordPress+Mantra+Is+Mine+Too\" rel=\"nofollow\" target=\"_blank\" title=\"Share: The WordPress Mantra Is Mine Too\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/wordpress-mantra-mine/&media=https://heropress.com/wp-content/uploads/2016/12/122116-150x150.jpg&description=The WordPress Mantra Is Mine Too\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: The WordPress Mantra Is Mine Too\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/wordpress-mantra-mine/\" title=\"The WordPress Mantra Is Mine Too\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/wordpress-mantra-mine/\">The WordPress Mantra Is Mine Too</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Dec 2016 12:00:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Andrei Lupu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WPTavern: The WordPress.org Homepage is Getting a Redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64587\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wptavern.com/the-wordpress-org-homepage-is-getting-a-redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3549:\"<p>A WordPress.org homepage redesign is now in the works with a strong focus on marketing to new users. As the face of the open source project, the site is long overdue for some design attention. Mark Uraine, a designer at Automattic, <a href=\"https://make.wordpress.org/meta/2016/12/12/new-homepage-redesign/\" target=\"_blank\">posted</a> on the Make/Meta blog about how quickly the project is coming together:</p>\n<p>&#8220;During the Contributor Day at WordCamp US, the Marketing Team sat down with a project in mind — the homepage of wordpress.org,&#8221; Uraine said. &#8220;Since the new design style is making an appearance in various places across the site, there was a desire to reboot the homepage as well.&#8221;</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/wordpress-homepage.png?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/wordpress-homepage.png?resize=203%2C500&ssl=1\" alt=\"\" class=\"alignleft size-large wp-image-64631\" /></a>Uraine posted the group&#8217;s original sketches as well as a screenshot of the initial draft on desktop and mobile. The screenshot doesn&#8217;t include the site&#8217;s header and footer, which will be added when the design is implemented. The team has also created a <a href=\"http://codepen.io/mapk/full/MbGpvR/\" target=\"_blank\">Codepen Prototype</a>, which demonstrates the fixed background featuring high profile WordPress sites that visitors see as they scroll.</p>\n<p>&#8220;Keep in mind that this is only version 1.0 and we’re planning on launching and iterating quickly,&#8221; Uraine said when asking for feedback from the community. &#8220;Otto has offered his help to get this implemented. After a few technical revisions, I’ll be passing it over to him for implementation and providing support where I can.&#8221;</p>\n<p>The redesign focuses on social proof (market share and showcase examples) as well as WordPress&#8217; features and extensibility:</p>\n<p><em>&#8220;Extend WordPress with over 45,000 plugins to help your website meet your needs. Add an online store, galleries, mailing lists, forums, analytics, and much more.&#8221;</em></p>\n<p>Since Uraine posted the design draft, commenters have been weighing in with revisions to the site copy, which hasn&#8217;t yet been finalized. A few contributors have also suggested including A/B testing, although no specific metrics have been determined. The redesign is moving fast, so make sure to jump in on the <a href=\"https://make.wordpress.org/meta/2016/12/12/new-homepage-redesign/\" target=\"_blank\">Make/Meta post</a> if you have feedback on the draft.</p>\n<p>WordPress is getting more strategic about its marketing in 2017. Matt Mullenweg announced during the <a href=\"https://wptavern.com/state-of-the-word-2016-mullenweg-pushes-calypso-as-future-of-wordpress-interface-proposes-major-changes-to-release-cycle\" target=\"_blank\">2016 State of the Word</a> that he is bringing a new product-based leadership to core development and is assembling a <a href=\"https://wptavern.com/matt-mullenweg-proposes-wordpress-growth-council\" target=\"_blank\">Growth Council</a> to coordinate strategy with organizations invested in WordPress&#8217; growth.</p>\n<p>&#8220;I think in the past WordPress got by on a lot of marketing happenstance,&#8221; Mullenweg said. &#8220;We can become a lot more sophisticated with our messaging and presentation on WordPress.org to bring people in and tell the story about what makes WordPress different.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Dec 2016 20:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 24 Jan 2017 12:27:00 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Tue, 24 Jan 2017 12:15:15 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";s:14:\"20130911040210\";}','no');
INSERT INTO `wp_options` VALUES (206,'_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109','1485304023','no'),(207,'_transient_feed_mod_b9388c83948825c1edaef0d856b7b109','1485260823','no'),(204,'_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109','1485304023','no'),(205,'_transient_feed_b9388c83948825c1edaef0d856b7b109','a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Jan 2017 12:20:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Duplicate Post\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/duplicate-post/#post-2646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2007 17:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2646@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Clone posts and pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Lopo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"25254@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"UpdraftPlus WordPress Backup Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"38058@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"51888@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"132@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Regenerate Thumbnails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/regenerate-thumbnails/#post-6743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Aug 2008 14:38:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"6743@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Allows you to regenerate your thumbnails after changing the thumbnail sizes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Alex Mills (Viper007Bond)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"23862@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"Increase your traffic, view your stats, speed up your site, and protect yourself from hackers with Jetpack.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"753@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"The original SEO plugin for WordPress, downloaded over 30,000,000 times since 2007.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2082@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Extends and enhances TinyMCE, the WordPress Visual Editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"15@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Really Simple CAPTCHA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/really-simple-captcha/#post-9542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Mar 2009 02:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"9542@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Really Simple CAPTCHA is a CAPTCHA module intended to be called from other plugins. It is originally created for my Contact Form 7 plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2141@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"NextGEN Gallery - WordPress Gallery Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"1169@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 16 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Google Analytics by MonsterInsights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2316@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"Connect Google Analytics with WordPress by adding your Google Analytics tracking code. Get the stats that matter.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Syed Balkhi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"29860@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"18101@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"29832@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"Secure your website with the most comprehensive WordPress security plugin. Firewall, malware scan, blocking, live traffic, login security &#38; more.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Clef Two-Factor Authentication\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wpclef/#post-47509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Dec 2012 01:25:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"47509@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"Modern two-factor that people love to use: strong authentication without passwords or tokens; single sign on/off; magical login experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Dave Ross\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"W3 Total Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/w3-total-cache/#post-12073\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2009 18:46:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"12073@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"Search Engine (SEO) &#38; Performance Optimization (WPO) via caching. Integrated caching: CDN, Minify, Page, Object, Fragment, Database support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Frederick Townes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"8321@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using the Yoast SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2572@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Hello Dolly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/hello-dolly/#post-5790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2008 22:11:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"5790@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP-PageNavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-pagenavi/#post-363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 23:17:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"363@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Adds a more advanced paging navigation interface.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Lester Chan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"50539@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Displays Google Analytics reports in your WordPress Dashboard. Inserts the latest Google Analytics tracking code in your pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"26907@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly. Provides tool t\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Samir Shah\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"26607@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"28395@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Black Studio TinyMCE Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Nov 2011 15:06:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"31973@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The visual editor widget for Wordpress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marco Chiesi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"21738@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:146:\"Take the guesswork out of WordPress security. iThemes Security offers 30+ ways to lock down WordPress in an easy-to-use WordPress security plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"iThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"SiteOrigin Widgets Bundle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/so-widgets-bundle/#post-67824\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 24 May 2014 14:27:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"67824@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"A collection of all widgets, neatly bundled into a single plugin. It&#039;s also a framework to code your own widgets on top of.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 24 Jan 2017 12:27:03 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:13:\"last-modified\";s:29:\"Wed, 05 Dec 2007 17:40:03 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";s:14:\"20130911040210\";}','no'),(151,'_transient_timeout_plugin_slugs','1490453954','no'),(152,'_transient_plugin_slugs','a:18:{i:0;s:31:\"acf-accordion/acf-accordion.php\";i:1;s:55:\"advanced-custom-fields-contact-form-7-field/acf-cf7.php\";i:2;s:34:\"advanced-custom-fields-pro/acf.php\";i:3;s:19:\"akismet/akismet.php\";i:4;s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";i:5;s:36:\"contact-form-7/wp-contact-form-7.php\";i:6;s:28:\"favicon-xt-manager/index.php\";i:7;s:43:\"google-analytics-dashboard-for-wp/gadwp.php\";i:8;s:36:\"google-sitemap-generator/sitemap.php\";i:9;s:9:\"hello.php\";i:10;s:38:\"integracao-rd-station/rdstation-wp.php\";i:11;s:45:\"limit-login-attempts/limit-login-attempts.php\";i:12;s:33:\"addthis/addthis_social_widget.php\";i:13;s:23:\"wordfence/wordfence.php\";i:14;s:41:\"wordpress-importer/wordpress-importer.php\";i:15;s:43:\"comments-from-facebook/facebook-comment.php\";i:16;s:24:\"wordpress-seo/wp-seo.php\";i:17;s:25:\"zopim-live-chat/zopim.php\";}','no'),(203,'_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9','1485260821','no'),(1723,'_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a','1490378291','no'),(1724,'_site_transient_poptags_40cd750bba9870f18aada2478b24840a','a:100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"6251\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3843\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3823\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"3348\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2913\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"2655\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:4:\"2365\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"2270\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"2183\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"2163\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"2122\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"2091\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"2020\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1985\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1818\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1711\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1698\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1509\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1426\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:4:\"1338\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1318\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:4:\"1191\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:4:\"1159\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:4:\"1132\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:4:\"1052\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:4:\"1042\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:4:\"1010\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:4:\"1008\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:4:\"1004\";}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";s:3:\"985\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"962\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"923\";}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";s:3:\"923\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"890\";}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";s:3:\"889\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"848\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"809\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"809\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"799\";}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";s:3:\"793\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"790\";}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";s:3:\"790\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"781\";}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";s:3:\"775\";}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"CSS\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";s:3:\"769\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"763\";}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";s:3:\"755\";}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";s:3:\"747\";}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";s:3:\"741\";}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";s:3:\"733\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"721\";}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";s:3:\"671\";}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";s:3:\"668\";}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";s:3:\"664\";}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";s:3:\"663\";}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";s:3:\"655\";}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";s:3:\"644\";}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";s:3:\"643\";}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";s:3:\"630\";}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";s:3:\"625\";}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";s:3:\"612\";}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";s:3:\"609\";}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";s:3:\"607\";}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";s:3:\"604\";}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";s:3:\"603\";}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";s:3:\"595\";}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";s:3:\"581\";}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";s:3:\"578\";}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";s:3:\"572\";}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";s:3:\"568\";}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";s:3:\"565\";}s:4:\"shop\";a:3:{s:4:\"name\";s:4:\"shop\";s:4:\"slug\";s:4:\"shop\";s:5:\"count\";s:3:\"558\";}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";s:3:\"555\";}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";s:3:\"548\";}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";s:3:\"546\";}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";s:3:\"533\";}s:7:\"picture\";a:3:{s:4:\"name\";s:7:\"picture\";s:4:\"slug\";s:7:\"picture\";s:5:\"count\";s:3:\"529\";}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";s:3:\"523\";}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";s:3:\"501\";}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";s:3:\"497\";}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";s:3:\"481\";}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";s:3:\"477\";}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";s:3:\"474\";}s:8:\"pictures\";a:3:{s:4:\"name\";s:8:\"pictures\";s:4:\"slug\";s:8:\"pictures\";s:5:\"count\";s:3:\"468\";}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";s:3:\"463\";}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";s:3:\"459\";}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";s:3:\"455\";}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";s:3:\"452\";}s:8:\"lightbox\";a:3:{s:4:\"name\";s:8:\"lightbox\";s:4:\"slug\";s:8:\"lightbox\";s:5:\"count\";s:3:\"450\";}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";s:3:\"450\";}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";s:3:\"440\";}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";s:3:\"440\";}s:9:\"thumbnail\";a:3:{s:4:\"name\";s:9:\"thumbnail\";s:4:\"slug\";s:9:\"thumbnail\";s:5:\"count\";s:3:\"438\";}s:6:\"paypal\";a:3:{s:4:\"name\";s:6:\"paypal\";s:4:\"slug\";s:6:\"paypal\";s:5:\"count\";s:3:\"438\";}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";s:3:\"436\";}s:6:\"upload\";a:3:{s:4:\"name\";s:6:\"upload\";s:4:\"slug\";s:6:\"upload\";s:5:\"count\";s:3:\"435\";}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"News\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";s:3:\"433\";}s:16:\"custom-post-type\";a:3:{s:4:\"name\";s:16:\"custom post type\";s:4:\"slug\";s:16:\"custom-post-type\";s:5:\"count\";s:3:\"431\";}s:8:\"linkedin\";a:3:{s:4:\"name\";s:8:\"linkedin\";s:4:\"slug\";s:8:\"linkedin\";s:5:\"count\";s:3:\"430\";}s:7:\"profile\";a:3:{s:4:\"name\";s:7:\"profile\";s:4:\"slug\";s:7:\"profile\";s:5:\"count\";s:3:\"429\";}}','no'),(155,'recently_activated','a:0:{}','yes'),(156,'current_theme','WOW FRAMEWORK 1.0','yes'),(157,'theme_mods_lfacil','a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:9:\"principal\";i:9;}}','yes'),(158,'theme_switched','','yes'),(1721,'_transient_timeout_acf_get_remote_plugin_info','1490453703','no'),(1722,'_transient_acf_get_remote_plugin_info','a:12:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:8:\"homepage\";s:37:\"https://www.advancedcustomfields.com/\";s:7:\"version\";s:6:\"5.5.10\";s:6:\"author\";s:13:\"Elliot Condon\";s:10:\"author_url\";s:28:\"http://www.elliotcondon.com/\";s:12:\"contributors\";s:12:\"elliotcondon\";s:8:\"requires\";s:5:\"3.6.0\";s:6:\"tested\";s:5:\"4.8.0\";s:6:\"tagged\";s:123:\"acf, advanced, custom, field, fields, custom field, custom fields, simple fields, magic fields, more fields, repeater, edit\";s:9:\"changelog\";s:1015:\"<h4>5.5.10</h4><ul><li>API: Added new functionality to the `acf_form()` function:</li><li>- added new <code>html_updated_message</code> setting</li><li>- added new <code>html_submit_button</code> setting</li><li>- added new <code>html_submit_spinner</code> setting</li><li>- added new <code>acf/pre_submit_form</code> filter run when form is successfully submit (before saving $_POST)</li><li>- added new <code>acf/submit_form</code> action run when form is successfully submit (after saving $_POST)</li><li>- added new <code>%post_id%</code> replace string to the <code>return</code> setting</li><li>- added new encryption logic to prevent $_POST exploits</li><li>- added new `acf_register_form()` function</li><li>Core: Fixed bug preventing values being loaded on a new post/page preview</li><li>Core: Fixed missing <code>Bulk Actions</code> dropdown on sync screen when no field groups exist</li><li>Core: Fixed bug ignoring PHP field groups if exists in JSON</li><li>Core: Minor fixes and improvements</li></ul>\";s:14:\"upgrade_notice\";s:0:\"\";}','no'),(159,'acf_version','5.5.2','yes'),(160,'_site_transient_timeout_popular_importers_a095d8b6199e257f2d5546ee48783d5f','1485387608','no'),(161,'_site_transient_popular_importers_a095d8b6199e257f2d5546ee48783d5f','a:2:{s:9:\"importers\";a:8:{s:7:\"blogger\";a:4:{s:4:\"name\";s:7:\"Blogger\";s:11:\"description\";s:54:\"Import posts, comments, and users from a Blogger blog.\";s:11:\"plugin-slug\";s:16:\"blogger-importer\";s:11:\"importer-id\";s:7:\"blogger\";}s:9:\"wpcat2tag\";a:4:{s:4:\"name\";s:29:\"Categories and Tags Converter\";s:11:\"description\";s:71:\"Convert existing categories to tags or tags to categories, selectively.\";s:11:\"plugin-slug\";s:18:\"wpcat2tag-importer\";s:11:\"importer-id\";s:10:\"wp-cat2tag\";}s:11:\"livejournal\";a:4:{s:4:\"name\";s:11:\"LiveJournal\";s:11:\"description\";s:46:\"Import posts from LiveJournal using their API.\";s:11:\"plugin-slug\";s:20:\"livejournal-importer\";s:11:\"importer-id\";s:11:\"livejournal\";}s:11:\"movabletype\";a:4:{s:4:\"name\";s:24:\"Movable Type and TypePad\";s:11:\"description\";s:62:\"Import posts and comments from a Movable Type or TypePad blog.\";s:11:\"plugin-slug\";s:20:\"movabletype-importer\";s:11:\"importer-id\";s:2:\"mt\";}s:4:\"opml\";a:4:{s:4:\"name\";s:8:\"Blogroll\";s:11:\"description\";s:28:\"Import links in OPML format.\";s:11:\"plugin-slug\";s:13:\"opml-importer\";s:11:\"importer-id\";s:4:\"opml\";}s:3:\"rss\";a:4:{s:4:\"name\";s:3:\"RSS\";s:11:\"description\";s:30:\"Import posts from an RSS feed.\";s:11:\"plugin-slug\";s:12:\"rss-importer\";s:11:\"importer-id\";s:3:\"rss\";}s:6:\"tumblr\";a:4:{s:4:\"name\";s:6:\"Tumblr\";s:11:\"description\";s:53:\"Import posts &amp; media from Tumblr using their API.\";s:11:\"plugin-slug\";s:15:\"tumblr-importer\";s:11:\"importer-id\";s:6:\"tumblr\";}s:9:\"wordpress\";a:4:{s:4:\"name\";s:9:\"WordPress\";s:11:\"description\";s:96:\"Import posts, pages, comments, custom fields, categories, and tags from a WordPress export file.\";s:11:\"plugin-slug\";s:18:\"wordpress-importer\";s:11:\"importer-id\";s:9:\"wordpress\";}}s:10:\"translated\";b:0;}','no'),(186,'wpcf7','a:2:{s:7:\"version\";s:3:\"4.7\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1485216159;s:7:\"version\";s:5:\"4.6.1\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}','yes'),(238,'wpseo','a:21:{s:14:\"blocking_files\";a:0:{}s:15:\"ms_defaults_set\";b:0;s:7:\"version\";s:3:\"4.1\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:0:\"\";s:20:\"disableadvanced_meta\";b:1;s:19:\"onpage_indexability\";b:1;s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:12:\"website_name\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";b:0;s:16:\"environment_type\";s:0:\"\";s:20:\"enable_setting_pages\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";b:0;}','yes');
INSERT INTO `wp_options` VALUES (239,'wpseo_permalinks','a:9:{s:15:\"cleanpermalinks\";b:0;s:24:\"cleanpermalink-extravars\";s:0:\"\";s:29:\"cleanpermalink-googlecampaign\";b:0;s:31:\"cleanpermalink-googlesitesearch\";b:0;s:15:\"cleanreplytocom\";b:0;s:10:\"cleanslugs\";b:1;s:18:\"redirectattachment\";b:0;s:17:\"stripcategorybase\";b:0;s:13:\"trailingslash\";b:0;}','yes'),(240,'wpseo_titles','a:88:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:23:\"content-analysis-active\";b:1;s:23:\"keyword-analysis-active\";b:1;s:9:\"separator\";s:7:\"sc-dash\";s:5:\"noodp\";b:0;s:15:\"usemetakeywords\";b:0;s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:40:\"%%name%%, Autor em %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:66:\"Você pesquisou por %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:44:\"Página não encontrada %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:18:\"metakey-home-wpseo\";s:0:\"\";s:20:\"metakey-author-wpseo\";s:0:\"\";s:22:\"noindex-subpages-wpseo\";b:0;s:20:\"noindex-author-wpseo\";b:0;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"metakey-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:16:\"hideeditbox-post\";b:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"metakey-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:16:\"hideeditbox-page\";b:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"metakey-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:22:\"hideeditbox-attachment\";b:0;s:12:\"title-banner\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:15:\"metadesc-banner\";s:0:\"\";s:14:\"metakey-banner\";s:0:\"\";s:14:\"noindex-banner\";b:0;s:15:\"showdate-banner\";b:0;s:18:\"hideeditbox-banner\";b:0;s:14:\"title-vantagem\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:17:\"metadesc-vantagem\";s:0:\"\";s:16:\"metakey-vantagem\";s:0:\"\";s:16:\"noindex-vantagem\";b:0;s:17:\"showdate-vantagem\";b:0;s:20:\"hideeditbox-vantagem\";b:0;s:22:\"title-ptarchive-banner\";s:51:\"Arquivo %%pt_plural%% %%page%% %%sep%% %%sitename%%\";s:25:\"metadesc-ptarchive-banner\";s:0:\"\";s:24:\"metakey-ptarchive-banner\";s:0:\"\";s:24:\"bctitle-ptarchive-banner\";s:0:\"\";s:24:\"noindex-ptarchive-banner\";b:0;s:24:\"title-ptarchive-vantagem\";s:51:\"Arquivo %%pt_plural%% %%page%% %%sep%% %%sitename%%\";s:27:\"metadesc-ptarchive-vantagem\";s:0:\"\";s:26:\"metakey-ptarchive-vantagem\";s:0:\"\";s:26:\"bctitle-ptarchive-vantagem\";s:0:\"\";s:26:\"noindex-ptarchive-vantagem\";b:0;s:18:\"title-tax-category\";s:53:\"Arquivos %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:20:\"metakey-tax-category\";s:0:\"\";s:24:\"hideeditbox-tax-category\";b:0;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"Arquivos %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:20:\"metakey-tax-post_tag\";s:0:\"\";s:24:\"hideeditbox-tax-post_tag\";b:0;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"Arquivos %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:23:\"metakey-tax-post_format\";s:0:\"\";s:27:\"hideeditbox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:25:\"title-tax-banner_category\";s:53:\"Arquivos %%term_title%% %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-tax-banner_category\";s:0:\"\";s:27:\"metakey-tax-banner_category\";s:0:\"\";s:31:\"hideeditbox-tax-banner_category\";b:0;s:27:\"noindex-tax-banner_category\";b:0;s:27:\"title-tax-vantagem_category\";s:53:\"Arquivos %%term_title%% %%page%% %%sep%% %%sitename%%\";s:30:\"metadesc-tax-vantagem_category\";s:0:\"\";s:29:\"metakey-tax-vantagem_category\";s:0:\"\";s:33:\"hideeditbox-tax-vantagem_category\";b:0;s:29:\"noindex-tax-vantagem_category\";b:0;}','yes'),(341,'phpxtFaviconXtManagerOptions','a:6:{s:14:\"phpxtFavStatus\";s:1:\"1\";s:18:\"phpxtActiveFavicon\";s:4:\"img1\";s:14:\"phpxtFMVersion\";s:3:\"1.0\";s:18:\"phpxtFMVersionType\";s:4:\"free\";s:7:\"FavURL1\";s:79:\"http://www.linhafacil.com.br/v2/wp-content/uploads/2017/01/linhafacilicones.png\";s:7:\"FavURL2\";s:81:\"http://www.linhafacil.com.br/v2/wp-content/uploads/2017/01/linhafacilicones-1.png\";}','yes'),(533,'_site_transient_timeout_browser_4aa90aa42c739d4f97395a124db7a00f','1485948909','no'),(534,'_site_transient_browser_4aa90aa42c739d4f97395a124db7a00f','a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"55.0.2883.87\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}','no'),(344,'wpdevart_comment_facebook_app_id','204883546582871','yes'),(345,'wpdevart_comments_box_order_type','social','yes'),(346,'wpdevart_comment_title_text','','yes'),(347,'wpdevart_comment_title_text_color','#000000','yes'),(348,'wpdevart_comment_title_text_font_size','20','yes'),(349,'wpdevart_comment_title_text_font_famely','Calibri,Helvetica Neue,Helvetica,Arial,Verdana,sans-serif','yes'),(350,'wpdevart_comment_title_text_position','left','yes'),(351,'wpdevart_comments_box_show_in','{\\\"home\\\":false,\\\"post\\\":false,\\\"page\\\":false}','yes'),(352,'wpdevart_comments_box_width','100%','yes'),(353,'wpdevart_comments_box_count_of_comments','8','yes'),(354,'wpdevart_comments_box_locale','pt_BR','yes'),(241,'wpseo_social','a:20:{s:9:\"fb_admins\";a:0:{}s:12:\"fbconnectkey\";s:32:\"e6de3861a954f6de3af799add33b1863\";s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:14:\"plus-publisher\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:7:\"summary\";s:11:\"youtube_url\";s:0:\"\";s:15:\"google_plus_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}','yes'),(242,'wpseo_rss','a:2:{s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:54:\"O post %%POSTLINK%% apareceu primeiro em %%BLOGLINK%%.\";}','yes'),(243,'wpseo_internallinks','a:14:{s:20:\"breadcrumbs-404crumb\";s:33:\"Erro 404: Página não encontrada\";s:23:\"breadcrumbs-blog-remove\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:13:\"Arquivos para\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:7:\"Início\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:19:\"Você pesquisou por\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:23:\"post_types-post-maintax\";i:0;s:25:\"post_types-banner-maintax\";i:0;s:27:\"post_types-vantagem-maintax\";i:0;s:33:\"taxonomy-banner_category-ptparent\";i:0;s:35:\"taxonomy-vantagem_category-ptparent\";i:0;}','yes'),(244,'wpseo_xml','a:20:{s:22:\"disable_author_sitemap\";b:1;s:22:\"disable_author_noposts\";b:1;s:16:\"enablexmlsitemap\";b:1;s:16:\"entries-per-page\";i:1000;s:14:\"excluded-posts\";s:0:\"\";s:38:\"user_role-administrator-not_in_sitemap\";b:0;s:31:\"user_role-editor-not_in_sitemap\";b:0;s:31:\"user_role-author-not_in_sitemap\";b:0;s:36:\"user_role-contributor-not_in_sitemap\";b:0;s:35:\"user_role-subscriber-not_in_sitemap\";b:0;s:30:\"post_types-post-not_in_sitemap\";b:0;s:30:\"post_types-page-not_in_sitemap\";b:0;s:36:\"post_types-attachment-not_in_sitemap\";b:1;s:32:\"post_types-banner-not_in_sitemap\";b:0;s:34:\"post_types-vantagem-not_in_sitemap\";b:0;s:34:\"taxonomies-category-not_in_sitemap\";b:0;s:34:\"taxonomies-post_tag-not_in_sitemap\";b:0;s:37:\"taxonomies-post_format-not_in_sitemap\";b:0;s:41:\"taxonomies-banner_category-not_in_sitemap\";b:0;s:43:\"taxonomies-vantagem_category-not_in_sitemap\";b:0;}','yes'),(245,'wpseo_flush_rewrite','1','yes'),(246,'_transient_timeout_yoast_i18n_wordpress-seo_pt_BR','1485349074','no'),(247,'_transient_yoast_i18n_wordpress-seo_pt_BR','','no'),(248,'_transient_yoast_i18n_wordpress-seo_promo_hide','1','yes'),(252,'wpseo_sitemap_1_cache_validator','mGbX','no'),(253,'wpseo_sitemap_acf-field-group_cache_validator','lNLH','no'),(270,'wpseo_sitemap_attachment_cache_validator','4wMqD','no'),(251,'wpseo_sitemap_cache_validator_global','4nIfa','no'),(273,'wpseo_sitemap_nav_menu_cache_validator','4wXwA','no'),(254,'wpseo_sitemap_acf-field_cache_validator','4p4q5','no'),(255,'wpseo_sitemap_page_cache_validator','4ssCf','no'),(256,'wpseo_sitemap_revision_cache_validator','4xlfv','no'),(261,'wpseo_sitemap_post_cache_validator','mGc7','no'),(262,'wpseo_sitemap_category_cache_validator','4xlfs','no'),(272,'wpseo_sitemap_nav_menu_item_cache_validator','4wXwD','no'),(276,'wpseo_sitemap_author_cache_validator','4xLkt','no'),(282,'gadash_options','{\"ga_dash_clientid\":\"\",\"ga_dash_clientsecret\":\"\",\"ga_dash_access_front\":[\"administrator\"],\"ga_dash_access_back\":[\"administrator\"],\"ga_dash_tableid_jail\":\"109602080\",\"ga_dash_style\":\"#1e73be\",\"switch_profile\":0,\"ga_dash_cachetime\":3600,\"ga_dash_tracking\":\"1\",\"ga_dash_tracking_type\":\"universal\",\"ga_dash_default_ua\":\"\",\"ga_dash_anonim\":0,\"ga_dash_userapi\":0,\"ga_event_tracking\":0,\"ga_event_downloads\":\"zip|mp3*|mpe*g|pdf|docx*|pptx*|xlsx*|rar*\",\"ga_track_exclude\":[],\"ga_target_geomap\":\"\",\"ga_realtime_pages\":10,\"ga_dash_token\":\"{\\\"access_token\\\":\\\"ya29.GlvdA9s1dGH4XvjsuBfTuvLRFq66n0FfCZf0Px0ayfpK7mpJoxuCphtQlQxeUPoKIemXuVYg9fTmwHsvBMzMZw6MrJ9MoOsyIdxTnRq3ws3BRRBMWbXyyek2h4o3\\\",\\\"expires_in\\\":3600,\\\"refresh_token\\\":\\\"1\\\\\\/995K36Do1Og5DLw63vHHoVFTtgH7sALCGqugmuvm8phAi3sMC1yqrppkAGDm9p3l\\\",\\\"token_type\\\":\\\"Bearer\\\",\\\"created\\\":1485267404}\",\"ga_dash_profile_list\":[[\"Todos os dados do website\",\"109602080\",\"UA-68516905-1\",\"http:\\/\\/www.linhafacil.com.br\\/\",-18000,\"America\\/Rio_Branco\",null],[\"Default AdWords Express Profile\",\"135771797\",\"UA-88804737-1\",\"oferta.linhafacil.com.br\",-28800,\"America\\/Los_Angeles\",null]],\"ga_enhanced_links\":0,\"ga_dash_remarketing\":0,\"ga_dash_network\":0,\"ga_dash_adsense\":0,\"ga_speed_samplerate\":\"1\",\"ga_event_bouncerate\":0,\"ga_crossdomain_tracking\":0,\"ga_crossdomain_list\":\"\",\"ga_author_dimindex\":0,\"ga_category_dimindex\":0,\"ga_tag_dimindex\":0,\"ga_user_dimindex\":0,\"ga_pubyear_dimindex\":0,\"ga_pubyearmonth_dimindex\":0,\"ga_aff_tracking\":0,\"ga_event_affiliates\":\"\\/out\\/\",\"automatic_updates_minorversion\":\"1\",\"backend_item_reports\":1,\"frontend_item_reports\":0,\"dashboard_widget\":1,\"api_backoff\":0,\"ga_cookiedomain\":\"\",\"ga_cookiename\":\"\",\"ga_cookieexpires\":\"\",\"ga_dash_excludesa\":0,\"ga_hash_tracking\":0,\"pagetitle_404\":\"Page Not Found\",\"maps_api_key\":\"\",\"ga_dash_hidden\":\"Y\"}','yes'),(283,'gadwp_version','4.9.6.2','yes'),(284,'gadwp_got_updated','1','yes'),(285,'widget_gadwp-frontwidget-report','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(286,'sm_rewrite_done','$Id: sitemap-loader.php 937300 2014-06-23 18:04:11Z arnee $','yes'),(772,'limit_login_lockouts','a:0:{}','yes'),(289,'aioseop_options','a:94:{s:16:\"aiosp_home_title\";s:37:\"Linha Facil Auto Proteção Veicular.\";s:22:\"aiosp_home_description\";s:139:\"Nunca foi tão fácil proteger seu veiculo, veja como é fácil e barato proteger seu veiculo. Estamos preparados para cuidar do seu carro.\";s:20:\"aiosp_togglekeywords\";s:1:\"0\";s:19:\"aiosp_home_keywords\";s:134:\"Proteção veicular, Proteção pro Carro, Seguro Auto, Assistência 24 horas, Rastreador, Seguro de Motos, Moto segura, Carro seguro.\";s:26:\"aiosp_use_static_home_info\";s:1:\"0\";s:9:\"aiosp_can\";s:2:\"on\";s:30:\"aiosp_no_paged_canonical_links\";s:0:\"\";s:31:\"aiosp_customize_canonical_links\";s:0:\"\";s:20:\"aiosp_rewrite_titles\";s:1:\"1\";s:20:\"aiosp_force_rewrites\";s:1:\"1\";s:24:\"aiosp_use_original_title\";s:1:\"0\";s:16:\"aiosp_cap_titles\";s:2:\"on\";s:28:\"aiosp_home_page_title_format\";s:12:\"%page_title%\";s:23:\"aiosp_page_title_format\";s:27:\"%page_title% | %blog_title%\";s:23:\"aiosp_post_title_format\";s:27:\"%post_title% | %blog_title%\";s:27:\"aiosp_category_title_format\";s:31:\"%category_title% | %blog_title%\";s:26:\"aiosp_archive_title_format\";s:30:\"%archive_title% | %blog_title%\";s:23:\"aiosp_date_title_format\";s:21:\"%date% | %blog_title%\";s:25:\"aiosp_author_title_format\";s:23:\"%author% | %blog_title%\";s:22:\"aiosp_tag_title_format\";s:20:\"%tag% | %blog_title%\";s:25:\"aiosp_search_title_format\";s:23:\"%search% | %blog_title%\";s:24:\"aiosp_description_format\";s:13:\"%description%\";s:22:\"aiosp_404_title_format\";s:33:\"Nothing found for %request_words%\";s:18:\"aiosp_paged_format\";s:14:\" - Part %page%\";s:17:\"aiosp_enablecpost\";s:2:\"on\";s:17:\"aiosp_cpostactive\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:19:\"aiosp_cpostadvanced\";s:1:\"0\";s:18:\"aiosp_cpostnoindex\";s:0:\"\";s:19:\"aiosp_cpostnofollow\";s:0:\"\";s:16:\"aiosp_cpostnoodp\";s:0:\"\";s:17:\"aiosp_cpostnoydir\";s:0:\"\";s:17:\"aiosp_cposttitles\";s:0:\"\";s:21:\"aiosp_posttypecolumns\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:19:\"aiosp_google_verify\";s:0:\"\";s:17:\"aiosp_bing_verify\";s:0:\"\";s:22:\"aiosp_pinterest_verify\";s:0:\"\";s:22:\"aiosp_google_publisher\";s:0:\"\";s:28:\"aiosp_google_disable_profile\";s:0:\"\";s:29:\"aiosp_google_sitelinks_search\";s:0:\"\";s:26:\"aiosp_google_set_site_name\";s:0:\"\";s:30:\"aiosp_google_specify_site_name\";s:0:\"\";s:28:\"aiosp_google_author_advanced\";s:1:\"0\";s:28:\"aiosp_google_author_location\";a:1:{i:0;s:3:\"all\";}s:29:\"aiosp_google_enable_publisher\";s:2:\"on\";s:30:\"aiosp_google_specify_publisher\";s:0:\"\";s:25:\"aiosp_google_analytics_id\";s:0:\"\";s:25:\"aiosp_ga_advanced_options\";s:2:\"on\";s:15:\"aiosp_ga_domain\";s:0:\"\";s:21:\"aiosp_ga_multi_domain\";s:0:\"\";s:21:\"aiosp_ga_addl_domains\";s:0:\"\";s:21:\"aiosp_ga_anonymize_ip\";s:0:\"\";s:28:\"aiosp_ga_display_advertising\";s:0:\"\";s:22:\"aiosp_ga_exclude_users\";s:0:\"\";s:29:\"aiosp_ga_track_outbound_links\";s:0:\"\";s:25:\"aiosp_ga_link_attribution\";s:0:\"\";s:27:\"aiosp_ga_enhanced_ecommerce\";s:0:\"\";s:20:\"aiosp_use_categories\";s:2:\"on\";s:26:\"aiosp_use_tags_as_keywords\";s:2:\"on\";s:32:\"aiosp_dynamic_postspage_keywords\";s:2:\"on\";s:22:\"aiosp_category_noindex\";s:2:\"on\";s:26:\"aiosp_archive_date_noindex\";s:2:\"on\";s:28:\"aiosp_archive_author_noindex\";s:2:\"on\";s:18:\"aiosp_tags_noindex\";s:0:\"\";s:20:\"aiosp_search_noindex\";s:0:\"\";s:17:\"aiosp_404_noindex\";s:0:\"\";s:17:\"aiosp_tax_noindex\";s:0:\"\";s:23:\"aiosp_paginated_noindex\";s:0:\"\";s:24:\"aiosp_paginated_nofollow\";s:0:\"\";s:11:\"aiosp_noodp\";s:0:\"\";s:12:\"aiosp_noydir\";s:0:\"\";s:18:\"aiosp_skip_excerpt\";s:0:\"\";s:27:\"aiosp_generate_descriptions\";s:0:\"\";s:20:\"aiosp_run_shortcodes\";s:0:\"\";s:33:\"aiosp_hide_paginated_descriptions\";s:0:\"\";s:32:\"aiosp_dont_truncate_descriptions\";s:0:\"\";s:19:\"aiosp_schema_markup\";s:2:\"on\";s:20:\"aiosp_unprotect_meta\";s:0:\"\";s:33:\"aiosp_redirect_attachement_parent\";s:0:\"\";s:14:\"aiosp_ex_pages\";s:0:\"\";s:20:\"aiosp_post_meta_tags\";s:0:\"\";s:20:\"aiosp_page_meta_tags\";s:0:\"\";s:21:\"aiosp_front_meta_tags\";s:0:\"\";s:20:\"aiosp_home_meta_tags\";s:0:\"\";s:12:\"aiosp_do_log\";s:0:\"\";s:19:\"last_active_version\";s:8:\"2.3.12.1\";s:29:\"aiosp_attachment_title_format\";s:27:\"%post_title% | %blog_title%\";s:29:\"aiosp_custom_css_title_format\";s:27:\"%post_title% | %blog_title%\";s:38:\"aiosp_customize_changeset_title_format\";s:27:\"%post_title% | %blog_title%\";s:34:\"aiosp_acf-field-group_title_format\";s:27:\"%post_title% | %blog_title%\";s:28:\"aiosp_acf-field_title_format\";s:27:\"%post_title% | %blog_title%\";s:37:\"aiosp_wpcf7_contact_form_title_format\";s:27:\"%post_title% | %blog_title%\";s:25:\"aiosp_banner_title_format\";s:27:\"%post_title% | %blog_title%\";s:27:\"aiosp_vantagem_title_format\";s:27:\"%post_title% | %blog_title%\";s:7:\"modules\";a:3:{s:29:\"aiosp_feature_manager_options\";a:7:{s:36:\"aiosp_feature_manager_enable_sitemap\";s:2:\"on\";s:38:\"aiosp_feature_manager_enable_opengraph\";s:2:\"on\";s:35:\"aiosp_feature_manager_enable_robots\";s:2:\"on\";s:40:\"aiosp_feature_manager_enable_file_editor\";s:2:\"on\";s:46:\"aiosp_feature_manager_enable_importer_exporter\";s:2:\"on\";s:39:\"aiosp_feature_manager_enable_bad_robots\";s:2:\"on\";s:40:\"aiosp_feature_manager_enable_performance\";s:2:\"on\";}s:20:\"aiosp_robots_options\";a:0:{}s:21:\"aiosp_sitemap_options\";a:45:{s:22:\"aiosp_sitemap_filename\";s:7:\"sitemap\";s:24:\"aiosp_sitemap_daily_cron\";s:1:\"0\";s:21:\"aiosp_sitemap_indexes\";s:0:\"\";s:22:\"aiosp_sitemap_paginate\";s:0:\"\";s:23:\"aiosp_sitemap_max_posts\";s:5:\"50000\";s:23:\"aiosp_sitemap_posttypes\";a:6:{i:0;s:3:\"all\";i:1;s:4:\"post\";i:2;s:4:\"page\";i:3;s:10:\"attachment\";i:4;s:6:\"banner\";i:5;s:8:\"vantagem\";}s:24:\"aiosp_sitemap_taxonomies\";a:6:{i:0;s:3:\"all\";i:1;s:8:\"category\";i:2;s:8:\"post_tag\";i:3;s:11:\"post_format\";i:4;s:15:\"banner_category\";i:5;s:17:\"vantagem_category\";}s:21:\"aiosp_sitemap_archive\";s:0:\"\";s:20:\"aiosp_sitemap_author\";s:0:\"\";s:21:\"aiosp_sitemap_gzipped\";s:2:\"on\";s:20:\"aiosp_sitemap_robots\";s:2:\"on\";s:21:\"aiosp_sitemap_rewrite\";s:2:\"on\";s:24:\"aiosp_sitemap_addl_pages\";a:0:{}s:29:\"aiosp_sitemap_excl_categories\";s:0:\"\";s:24:\"aiosp_sitemap_excl_pages\";s:0:\"\";s:27:\"aiosp_sitemap_prio_homepage\";s:2:\"no\";s:23:\"aiosp_sitemap_prio_post\";s:2:\"no\";s:32:\"aiosp_sitemap_prio_post_vantagem\";s:2:\"no\";s:30:\"aiosp_sitemap_prio_post_banner\";s:2:\"no\";s:34:\"aiosp_sitemap_prio_post_attachment\";s:2:\"no\";s:28:\"aiosp_sitemap_prio_post_page\";s:2:\"no\";s:28:\"aiosp_sitemap_prio_post_post\";s:2:\"no\";s:29:\"aiosp_sitemap_prio_taxonomies\";s:2:\"no\";s:47:\"aiosp_sitemap_prio_taxonomies_vantagem_category\";s:2:\"no\";s:45:\"aiosp_sitemap_prio_taxonomies_banner_category\";s:2:\"no\";s:41:\"aiosp_sitemap_prio_taxonomies_post_format\";s:2:\"no\";s:38:\"aiosp_sitemap_prio_taxonomies_post_tag\";s:2:\"no\";s:38:\"aiosp_sitemap_prio_taxonomies_category\";s:2:\"no\";s:26:\"aiosp_sitemap_prio_archive\";s:2:\"no\";s:25:\"aiosp_sitemap_prio_author\";s:2:\"no\";s:27:\"aiosp_sitemap_freq_homepage\";s:2:\"no\";s:23:\"aiosp_sitemap_freq_post\";s:2:\"no\";s:32:\"aiosp_sitemap_freq_post_vantagem\";s:2:\"no\";s:30:\"aiosp_sitemap_freq_post_banner\";s:2:\"no\";s:34:\"aiosp_sitemap_freq_post_attachment\";s:2:\"no\";s:28:\"aiosp_sitemap_freq_post_page\";s:2:\"no\";s:28:\"aiosp_sitemap_freq_post_post\";s:2:\"no\";s:29:\"aiosp_sitemap_freq_taxonomies\";s:2:\"no\";s:47:\"aiosp_sitemap_freq_taxonomies_vantagem_category\";s:2:\"no\";s:45:\"aiosp_sitemap_freq_taxonomies_banner_category\";s:2:\"no\";s:41:\"aiosp_sitemap_freq_taxonomies_post_format\";s:2:\"no\";s:38:\"aiosp_sitemap_freq_taxonomies_post_tag\";s:2:\"no\";s:38:\"aiosp_sitemap_freq_taxonomies_category\";s:2:\"no\";s:26:\"aiosp_sitemap_freq_archive\";s:2:\"no\";s:25:\"aiosp_sitemap_freq_author\";s:2:\"no\";}}}','yes'),(1719,'_site_transient_timeout_aioseop_update_check_time','1490388894','no'),(1720,'_site_transient_aioseop_update_check_time','1490367294','no'),(1741,'_transient_timeout_feed_54af7cb0f50a8f4f8cdb30f2d9b4f50c','1490411229','no'),(1742,'_transient_feed_54af7cb0f50a8f4f8cdb30f2d9b4f50c','a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Semper Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"https://semperplugins.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Premium WordPress Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Mar 2017 16:28:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wordpress.org/?v=4.7.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://semperplugins.com/wp-content/uploads/2016/06/cropped-AIOSEOP-Gear-Blue-32x32.png\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Semper Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"https://semperplugins.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:51:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"A Glance at the Past &amp; Future of Keyword Research\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://semperplugins.com/past-and-future-of-keyword-research/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://semperplugins.com/past-and-future-of-keyword-research/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Mar 2017 11:27:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:16:\"keyword research\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:15:\"semantic search\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"user intent\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://semperplugins.com/?p=3155/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:424:\"While getting started on a brand new SEO campaign, often the first thing you would be doing is keyword research. It is supposed to provide the much-needed skeletal framework for your campaign and has proven to be a vital technique for a<span class=\"ellipsis\">&#8230;</span><div class=\"read-more\"><a href=\"https://semperplugins.com/past-and-future-of-keyword-research/\">Read more &#8250;</a></div><!-- end of .read-more -->\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Walter Moore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5164:\"<p><img class=\"size-full wp-image-3159 aligncenter\" src=\"https://semperplugins.com/wp-content/uploads/2017/03/850x250-Predicting-the-Future-of-Keyword-Research-its-Relevance-for-SEO.jpg\" alt=\"\" width=\"850\" height=\"250\" srcset=\"https://semperplugins.com/wp-content/uploads/2017/03/850x250-Predicting-the-Future-of-Keyword-Research-its-Relevance-for-SEO.jpg 850w, https://semperplugins.com/wp-content/uploads/2017/03/850x250-Predicting-the-Future-of-Keyword-Research-its-Relevance-for-SEO-300x88.jpg 300w, https://semperplugins.com/wp-content/uploads/2017/03/850x250-Predicting-the-Future-of-Keyword-Research-its-Relevance-for-SEO-768x226.jpg 768w, https://semperplugins.com/wp-content/uploads/2017/03/850x250-Predicting-the-Future-of-Keyword-Research-its-Relevance-for-SEO-100x29.jpg 100w, https://semperplugins.com/wp-content/uploads/2017/03/850x250-Predicting-the-Future-of-Keyword-Research-its-Relevance-for-SEO-150x44.jpg 150w, https://semperplugins.com/wp-content/uploads/2017/03/850x250-Predicting-the-Future-of-Keyword-Research-its-Relevance-for-SEO-200x59.jpg 200w, https://semperplugins.com/wp-content/uploads/2017/03/850x250-Predicting-the-Future-of-Keyword-Research-its-Relevance-for-SEO-450x132.jpg 450w, https://semperplugins.com/wp-content/uploads/2017/03/850x250-Predicting-the-Future-of-Keyword-Research-its-Relevance-for-SEO-600x176.jpg 600w\" sizes=\"(max-width: 850px) 100vw, 850px\" /></p>\n<p>While getting started on a brand new SEO campaign, often the first thing you would be doing is keyword research. It is supposed to provide the much-needed skeletal framework for your campaign and has proven to be a vital technique for a long time now. However, during the last few years, keyword research has changed dramatically, it has experienced fascinating evolutions and has somewhat become less relevant in more ways than one.</p>\n<h2><strong>Why Is Keyword Research Important?</strong></h2>\n<p>Keyword research is essential to ensure that your content satisfies inbound visitors and that all incoming queries are directly related to your business.</p>\n<p>You can find out which queries offer low competition, allowing you to selectively target vital keywords and phrases to include in your site’s content. Identifying keywords and keeping track of them serves as an important metric that you can utilize to gauge your campaign’s effectiveness, by keeping track of rankings over a period of time.</p>\n<h2><strong>Back In Time</strong></h2>\n<p>In the past, SEO seemed to be really simple. You stuffed your keywords all over your page&#8217;s content, into each and every meta tag, and prayed for the best.</p>\n<p>With the help of Google Analytics, Google offered lots of data about how individuals were searching, and exactly how they came across your site through keywords. Moreover, once you had access to a list of keywords which ensured low competition but high traffic, you could at once start optimizing your content to target those queries.</p>\n<p>Most Google searches would feature one-to-one relationships. During those days, Google would take your words and find near exact matches on the web.</p>\n<h2><strong>What&#8217;s that, Hummingbird?</strong></h2>\n<p>In 2013, Google launched its Hummingbird algorithm update.</p>\n<p>This update presented a whole new concept called &#8216;semantic search&#8217; that revolutionized the way Google handles queries. Instead of taking the user’s words and looking for appropriate matches online, Google evaluates the intention that is behind a user’s query and then determines which content is relevant.</p>\n<p>Even though it looks like an insignificant difference, in reality, it has a great impact on the way we should perceive keywords. The faster that semantic search evolved, the more power that individual keywords lost, giving way to long-tail keywords and topical themes.</p>\n<h2><strong>Forecasting the Future</strong></h2>\n<p><a href=\"https://semperplugins.com/keyword-research-trends-that-matter-in-2017/\">In our recent post on keyword research trends</a>, we discussed how new technologies drastically impact the manner in which searches are conducted. Digital assistants such as Cortana and Siri are motivating users to perform searches through speech and are fundamentally changing the way queries are entered.</p>\n<p>Other innovations such as augmented reality, wearables, and virtual reality could be having the same and complementary effect, by compelling users to alter the manner in which they search. New kinds of interfaces and (even) smaller screens will soon be changing the way we interact with search engines.</p>\n<h2><strong>Conclusion</strong></h2>\n<p>Keyword research is bound to change and will not remain in its present form forever. We will be witnessing an iterative and gradual transition to a whole new search research system that is based specifically on the latest technologies and current search trends. You better prepare yourself mentally for a few drastic changes during the next decade.</p>\n<p>This article has been written by Walter Moore from <a href=\"https://www.gingerdomain.com/\">gingerdomain.com</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://semperplugins.com/past-and-future-of-keyword-research/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:51:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Keyword Research Trends That Matter In 2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://semperplugins.com/keyword-research-trends-that-matter-in-2017/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://semperplugins.com/keyword-research-trends-that-matter-in-2017/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 03 Mar 2017 19:53:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:16:\"keyword research\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"SEO tips\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"user intent\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://semperplugins.com/?p=3006/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:448:\"Despite what you’ve been hearing, keyword research isn’t dead. Without keywords, there is no SEO… right? Let’s look at the facts. 93% of online experiences in 2016 started with a search, and search starts with words. Keywords will remain relevant<span class=\"ellipsis\">&#8230;</span><div class=\"read-more\"><a href=\"https://semperplugins.com/keyword-research-trends-that-matter-in-2017/\">Read more &#8250;</a></div><!-- end of .read-more -->\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Arnaud Broes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2127:\"<p><img class=\"size-full wp-image-3105 aligncenter\" src=\"https://semperplugins.com/wp-content/uploads/2016/12/keyword-analysis-in-2017.jpg\" alt=\"\" width=\"851\" height=\"251\" srcset=\"https://semperplugins.com/wp-content/uploads/2016/12/keyword-analysis-in-2017.jpg 851w, https://semperplugins.com/wp-content/uploads/2016/12/keyword-analysis-in-2017-300x88.jpg 300w, https://semperplugins.com/wp-content/uploads/2016/12/keyword-analysis-in-2017-768x227.jpg 768w, https://semperplugins.com/wp-content/uploads/2016/12/keyword-analysis-in-2017-848x250.jpg 848w, https://semperplugins.com/wp-content/uploads/2016/12/keyword-analysis-in-2017-100x29.jpg 100w, https://semperplugins.com/wp-content/uploads/2016/12/keyword-analysis-in-2017-150x44.jpg 150w, https://semperplugins.com/wp-content/uploads/2016/12/keyword-analysis-in-2017-200x59.jpg 200w, https://semperplugins.com/wp-content/uploads/2016/12/keyword-analysis-in-2017-450x133.jpg 450w, https://semperplugins.com/wp-content/uploads/2016/12/keyword-analysis-in-2017-600x177.jpg 600w\" sizes=\"(max-width: 851px) 100vw, 851px\" /></p>\n<p>Despite what you’ve been hearing, keyword research isn’t dead. Without keywords, there is no SEO… right? Let’s look at the facts.</p>\n<p>93% of online experiences in 2016 started with a search, and search starts with words. Keywords will remain relevant as long as people use words to interact with search engines. The only thing that has changed are the additional factors that have influenced how we use keywords for SEO.</p>\n<p>The truth is that search engines are no longer looking only at keywords, but also value many other factors. Keywords are now just a miniscule part of the pie. That is not to say that keyword discovery isn’t important. In fact, it is important in the way you go about it: <strong>we need to go levels deeper – to the precise level that users are searching for</strong>;<strong> </strong>and search engines are indexing for.</p>\n<p>This post will focus on the three main focuses of valuable keyword research in 2017:</p>\n<p>(1) user intent<br />\n(2) long-tail keywords<br />\n(3) Google voice search</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://semperplugins.com/keyword-research-trends-that-matter-in-2017/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"17\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Happy 9th Thank a Plugin Developer Day!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://semperplugins.com/happy-9th-thank-a-plugin-developer-day/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://semperplugins.com/happy-9th-thank-a-plugin-developer-day/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 28 Jan 2017 05:55:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://semperplugins.com/?p=3074/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:424:\"Happy 9th Plugin developer Day! Looking back, it&#8217;s been a wild ride. 9 years ago yesterday All in One SEO Pack hit 1 million downloads. Since then we&#8217;ve blown that away with over 30 million downloads, and the launch of All<span class=\"ellipsis\">&#8230;</span><div class=\"read-more\"><a href=\"https://semperplugins.com/happy-9th-thank-a-plugin-developer-day/\">Read more &#8250;</a></div><!-- end of .read-more -->\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Michael Torbert\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2487:\"<p>Happy 9th Plugin developer Day! Looking back, it&#8217;s been a wild ride. 9 years ago yesterday All in One SEO Pack hit <a href=\"https://semperfiwebdesign.com/blog/all-in-one-seo-pack-hits-one-million-downloads/\">1 million downloads</a>.</p>\n<p>Since then we&#8217;ve blown that away with over 30 million downloads, and the launch of <a href=\"https://semperplugins.com/all-in-one-seo-pack-pro-version/\">All in One SEO Pack Pro</a> here at semperplugins.com, and so much more.</p>\n<p>It&#8217;s amazing to think that when Matt Mullenweg <a href=\"https://wordpress.org/news/2009/01/thank-a-plugin-developer-day/\">first made the declaration</a> in 2009, we only had 4000 plugins in the directory, and an average of five per install.</p>\n<p>In order to celebrate Thank a Plugin Developer Day, please send a donation to or leave a 5 star rating for your favorite plugin. (You can <a href=\"https://wordpress.org/support/view/plugin-reviews/all-in-one-seo-pack?filter=5#postform\" target=\"_blank\">click here</a> to rate All in One SEO Pack 5 stars. [wink])</p>\n<p><a href=\"https://semperplugins.com/wp-content/uploads/2017/01/Screen-Shot-2017-01-28-at-1.49.38-PM.png\"><img class=\"alignnone wp-image-3078 size-medium\" src=\"https://semperplugins.com/wp-content/uploads/2017/01/Screen-Shot-2017-01-28-at-1.49.38-PM-300x100.png\" width=\"300\" height=\"100\" srcset=\"https://semperplugins.com/wp-content/uploads/2017/01/Screen-Shot-2017-01-28-at-1.49.38-PM-300x100.png 300w, https://semperplugins.com/wp-content/uploads/2017/01/Screen-Shot-2017-01-28-at-1.49.38-PM-768x256.png 768w, https://semperplugins.com/wp-content/uploads/2017/01/Screen-Shot-2017-01-28-at-1.49.38-PM-1024x341.png 1024w, https://semperplugins.com/wp-content/uploads/2017/01/Screen-Shot-2017-01-28-at-1.49.38-PM-750x250.png 750w, https://semperplugins.com/wp-content/uploads/2017/01/Screen-Shot-2017-01-28-at-1.49.38-PM-100x33.png 100w, https://semperplugins.com/wp-content/uploads/2017/01/Screen-Shot-2017-01-28-at-1.49.38-PM-150x50.png 150w, https://semperplugins.com/wp-content/uploads/2017/01/Screen-Shot-2017-01-28-at-1.49.38-PM-200x67.png 200w, https://semperplugins.com/wp-content/uploads/2017/01/Screen-Shot-2017-01-28-at-1.49.38-PM-450x150.png 450w, https://semperplugins.com/wp-content/uploads/2017/01/Screen-Shot-2017-01-28-at-1.49.38-PM-600x200.png 600w, https://semperplugins.com/wp-content/uploads/2017/01/Screen-Shot-2017-01-28-at-1.49.38-PM-900x300.png 900w\" sizes=\"(max-width: 300px) 100vw, 300px\" /></a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://semperplugins.com/happy-9th-thank-a-plugin-developer-day/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Could WordPress Multisite Be a Game Changer for You?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://semperplugins.com/wordpress-multisite/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://semperplugins.com/wordpress-multisite/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 Jan 2017 14:27:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:19:\"WordPress Multisite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://semperplugins.com/?p=2359\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:419:\"Are you managing multiple WordPress sites? Yes? Did you know you could manage them all from a single dashboard? No? Well you can with WordPress Multisite. Multisite was introduced in 2010 but a surprising number of site administrators and users are<span class=\"ellipsis\">&#8230;</span><div class=\"read-more\"><a href=\"https://semperplugins.com/wordpress-multisite/\">Read more &#8250;</a></div><!-- end of .read-more -->\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Arnaud Broes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4175:\"<p><img class=\"size-full wp-image-2975 aligncenter\" src=\"https://semperplugins.com/wp-content/uploads/2016/07/wordpress-multisite-1.jpg\" alt=\"wordpress-multisite\" width=\"851\" height=\"251\" srcset=\"https://semperplugins.com/wp-content/uploads/2016/07/wordpress-multisite-1.jpg 851w, https://semperplugins.com/wp-content/uploads/2016/07/wordpress-multisite-1-300x88.jpg 300w, https://semperplugins.com/wp-content/uploads/2016/07/wordpress-multisite-1-768x227.jpg 768w, https://semperplugins.com/wp-content/uploads/2016/07/wordpress-multisite-1-848x250.jpg 848w, https://semperplugins.com/wp-content/uploads/2016/07/wordpress-multisite-1-100x29.jpg 100w, https://semperplugins.com/wp-content/uploads/2016/07/wordpress-multisite-1-150x44.jpg 150w, https://semperplugins.com/wp-content/uploads/2016/07/wordpress-multisite-1-200x59.jpg 200w, https://semperplugins.com/wp-content/uploads/2016/07/wordpress-multisite-1-450x133.jpg 450w, https://semperplugins.com/wp-content/uploads/2016/07/wordpress-multisite-1-600x177.jpg 600w\" sizes=\"(max-width: 851px) 100vw, 851px\" /></p>\n<p>Are you managing multiple WordPress sites? Yes? Did you know you could manage them all from a single dashboard? No? Well you can with WordPress Multisite.</p>\n<p><a href=\"https://codex.wordpress.org/Create_A_Network\" target=\"_blank\">Multisite was introduced in 2010</a> but a surprising number of site administrators and users are still unfamiliar with it. This post will demystify WordPress Multisite to help you evaluate whether it is a good solution for your business; and show you how to install it.</p>\n<p>Let’s begin with the basics.</p>\n<h2>What is WordPress Multisite?</h2>\n<p>Multisite is a feature that enables you to create and manage multiple websites &amp; blogs from a single WordPress installation. That means that you can manage as many sites as you want from one Dashboard. Just one.</p>\n<h3>Important Features</h3>\n<ul>\n<li>It allows for a network of subdomains and directories</li>\n<li>You can enable other users to create accounts and WordPress blogs on your Multisite Network</li>\n<li>Super Admins can install themes and plugins for sites within their Multisite Network. However, site administrators on the network do not have that capability</li>\n<li>Super Admins can also make changes to themes for all websites on their Multisite Network while site administrators cannot</li>\n</ul>\n<p>Installing, managing and updating a Multisite Network is not as difficult as it sounds; in fact, the installation is almost similar to a standard WordPress installation. It also has the same core files, folder structure and code base as a standard WordPress site.</p>\n<p>Another great thing about WordPress Multisite is that all the themes and plugins on your network are stored once, regardless of how many sites are using them. That means that your server space would be smaller than if each site had its own WordPress installation.</p>\n<p>There are, however, a few differences between a Multisite and a standard installation: the admin screens and how they are used, the files, folders and the database tables. Let’s go over them.</p>\n<h3>Files and Folders</h3>\n<p>The wp-config.php file and the wp-uploads folder in a Multisite Network are a bit different from the ones in a standard WordPress installation.</p>\n<p>The <strong>wp-config.php</strong> file contains additional lines that activate Multisite and notify WordPress on how it functions or operates.</p>\n<p>The <strong>wp-uploads</strong> folder has a subfolder for each site on the network and the files of each site are stored in the site’s folder, as you normally would expect to see them in the wp-uploads folder of a standard WordPress installation.</p>\n<p>At the end of the day, these are differences you don’t need to concern yourself with – WordPress takes care of it for you!</p>\n<h3>Database</h3>\n<p>A standard WordPress installation has 11 database tables to store your site’s content and settings. Nine of those 11 tables are duplicated for each site on a Multisite Network. So the more sites you have, the more tables you’ll have.</p>\n<p>This is another difference you do not need to worry about.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://semperplugins.com/wordpress-multisite/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:51:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"10 Ways to Speed up Your WordPress Site\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://semperplugins.com/10-quick-easy-ways-to-speed-up-your-wordpress-site/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://semperplugins.com/10-quick-easy-ways-to-speed-up-your-wordpress-site/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Dec 2016 15:20:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"SEO Tips\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:17:\"WordPress hosting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:20:\"WordPress site speed\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://semperplugins.com/?p=2361\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:430:\"Nobody likes a slow site. Just think about the sheer number of times you revisited a website that took too long to load…we’re guessing it’s zero. Let’s look at some statistics to back this up. As shown in this Kissmetrics<span class=\"ellipsis\">&#8230;</span><div class=\"read-more\"><a href=\"https://semperplugins.com/10-quick-easy-ways-to-speed-up-your-wordpress-site/\">Read more &#8250;</a></div><!-- end of .read-more -->\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Arnaud Broes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3153:\"<p><img class=\"aligncenter wp-image-2964 size-full\" src=\"https://semperplugins.com/wp-content/uploads/2016/07/spped-up-wordpress-site.jpg\" alt=\"The loading speed of your WordPress site matters to search engines, as it has a significant impact on the ranking of your site.\" width=\"851\" height=\"250\" srcset=\"https://semperplugins.com/wp-content/uploads/2016/07/spped-up-wordpress-site.jpg 851w, https://semperplugins.com/wp-content/uploads/2016/07/spped-up-wordpress-site-300x88.jpg 300w, https://semperplugins.com/wp-content/uploads/2016/07/spped-up-wordpress-site-768x226.jpg 768w, https://semperplugins.com/wp-content/uploads/2016/07/spped-up-wordpress-site-850x250.jpg 850w, https://semperplugins.com/wp-content/uploads/2016/07/spped-up-wordpress-site-100x29.jpg 100w, https://semperplugins.com/wp-content/uploads/2016/07/spped-up-wordpress-site-150x44.jpg 150w, https://semperplugins.com/wp-content/uploads/2016/07/spped-up-wordpress-site-200x59.jpg 200w, https://semperplugins.com/wp-content/uploads/2016/07/spped-up-wordpress-site-450x132.jpg 450w, https://semperplugins.com/wp-content/uploads/2016/07/spped-up-wordpress-site-600x176.jpg 600w\" sizes=\"(max-width: 851px) 100vw, 851px\" /></p>\n<p>Nobody likes a slow site. Just think about the sheer number of times you revisited a website that took too long to load…we’re guessing it’s zero. Let’s look at some statistics to back this up.</p>\n<p>As shown in <a href=\"https://blog.kissmetrics.com/loading-time/?wide=1\" target=\"_blank\">this Kissmetrics infographic</a>, 40 percent of site users exit a site that takes more than three seconds to load. The statistics are even scarier for e-commerce sites: 80 percent of shoppers who are not satisfied with a site’s speed or performance are less likely to shop on the same site again. Plus, a one second delay cuts customer satisfaction by 16 percent and results in a 8 percent loss in conversions. Yikes!</p>\n<p>Speed is also a <a href=\"http://semperplugins.com/google-penguin-update/\" target=\"_blank\">critical component of Google’s ranking algorithm</a>. If you have a slow site, your Google rankings will fall and you will experience considerably less traffic to your site. As we saw with Google’s<a href=\"http://semperplugins.com/google-amp-mobile-seo/\" target=\"_blank\"> introduction of Accelerated Mobile Pages (AMP)</a>, mobile page speed is also going to be an important ranking factor.</p>\n<p>So you now understand the effects of site speed user experience, engagement and SEO. What can you do to make your site load faster? This post will take you through 10 quick and effective ways to speed up your WordPress site.</p>\n<p>Before we begin, you need to measure your current site performance and speed so that you can quantify any improvements in performance after you implement the methods in this post. <a href=\"https://tools.pingdom.com/\" target=\"_blank\">Pingdom offers a free performance analysis</a> for your site. You can also look at your site’s page speed and <a href=\"https://analytics.google.com/\" target=\"_blank\">other performance data in Google Analytics</a> under the Behavior section.</p>\n<p>Let’s get to it.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://semperplugins.com/10-quick-easy-ways-to-speed-up-your-wordpress-site/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"58\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"The ABCs of WordPress Site Maintenance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://semperplugins.com/wordpress-site-maintenance/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://semperplugins.com/wordpress-site-maintenance/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Dec 2016 14:25:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:21:\"WordPress maintenance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://semperplugins.com/?p=2365\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:428:\"Think of your WordPress site as a machine, which just like every other machine, needs regular maintenance to ensure that it runs optimally. Without adequate maintenance your site may be vulnerable to security issues such as malware attacks; spam; slow<span class=\"ellipsis\">&#8230;</span><div class=\"read-more\"><a href=\"https://semperplugins.com/wordpress-site-maintenance/\">Read more &#8250;</a></div><!-- end of .read-more -->\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Arnaud Broes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2355:\"<p><img class=\"size-full wp-image-2947 aligncenter\" src=\"https://semperplugins.com/wp-content/uploads/2016/07/wordpress-site-maintenance.jpg\" alt=\"Maintenance and updates are key to a high-performing, secure WordPress site.\" width=\"851\" height=\"250\" srcset=\"https://semperplugins.com/wp-content/uploads/2016/07/wordpress-site-maintenance.jpg 851w, https://semperplugins.com/wp-content/uploads/2016/07/wordpress-site-maintenance-300x88.jpg 300w, https://semperplugins.com/wp-content/uploads/2016/07/wordpress-site-maintenance-768x226.jpg 768w, https://semperplugins.com/wp-content/uploads/2016/07/wordpress-site-maintenance-850x250.jpg 850w, https://semperplugins.com/wp-content/uploads/2016/07/wordpress-site-maintenance-100x29.jpg 100w, https://semperplugins.com/wp-content/uploads/2016/07/wordpress-site-maintenance-150x44.jpg 150w, https://semperplugins.com/wp-content/uploads/2016/07/wordpress-site-maintenance-200x59.jpg 200w, https://semperplugins.com/wp-content/uploads/2016/07/wordpress-site-maintenance-450x132.jpg 450w, https://semperplugins.com/wp-content/uploads/2016/07/wordpress-site-maintenance-600x176.jpg 600w\" sizes=\"(max-width: 851px) 100vw, 851px\" /></p>\n<p>Think of your WordPress site as a machine, which just like every other machine, needs regular maintenance to ensure that it runs optimally. Without adequate maintenance your site may be vulnerable to security issues such as malware attacks; spam; slow page loading speeds; and the risk of long term unreliability. Regular maintenance also enables you to spot problems early before they develop into something more complex and unfixable; and to avoid common system mishaps and failures.</p>\n<p>This article will highlight different ways to ensure that your site is well maintained so it keeps performing optimally.</p>\n<p>Note: You must, at the very least, have admin access to your dashboard in order to install the necessary plugins and make the required changes to properly maintain your site.</p>\n<p><span style=\"font-weight: bold;\">Items that we will cover include:</span></p>\n<ul>\n<li>Backing up your site</li>\n<li>Putting your site in maintenance mode</li>\n<li>WordPress core, theme and plugin updates</li>\n<li>Database maintenance</li>\n<li>Monitoring site performance</li>\n<li>Eliminating comment spam</li>\n<li>Staying updated</li>\n</ul>\n<p>Let&#8217;s get going.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://semperplugins.com/wordpress-site-maintenance/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"How to Declutter Your WordPress Administrator Interface\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://semperplugins.com/how-to-declutter-your-wordpress-administrator-interface/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://semperplugins.com/how-to-declutter-your-wordpress-administrator-interface/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Nov 2016 16:19:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:25:\"wordpress admin interface\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://semperplugins.com/?p=2450\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:471:\"The WordPress admin interface is complex and jam-packed with exciting options, which is great for experienced users. However, most users usually find the admin interface intimidating and often confusing. In such a case, innocent exploration, or a stray click, could<span class=\"ellipsis\">&#8230;</span><div class=\"read-more\"><a href=\"https://semperplugins.com/how-to-declutter-your-wordpress-administrator-interface/\">Read more &#8250;</a></div><!-- end of .read-more -->\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Arnaud Broes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5724:\"<p><img class=\"size-full wp-image-2648 aligncenter\" src=\"http://semperplugins.com/wp-content/uploads/2016/08/wordpress-admin-panel.jpg\" alt=\"Customizing your WordPress admin panel will not only make make things easier, it\'s also quite important to your site\'s security.\" width=\"1771\" height=\"521\" srcset=\"https://semperplugins.com/wp-content/uploads/2016/08/wordpress-admin-panel.jpg 1771w, https://semperplugins.com/wp-content/uploads/2016/08/wordpress-admin-panel-300x88.jpg 300w, https://semperplugins.com/wp-content/uploads/2016/08/wordpress-admin-panel-768x226.jpg 768w, https://semperplugins.com/wp-content/uploads/2016/08/wordpress-admin-panel-1024x301.jpg 1024w, https://semperplugins.com/wp-content/uploads/2016/08/wordpress-admin-panel-850x250.jpg 850w, https://semperplugins.com/wp-content/uploads/2016/08/wordpress-admin-panel-100x29.jpg 100w, https://semperplugins.com/wp-content/uploads/2016/08/wordpress-admin-panel-150x44.jpg 150w, https://semperplugins.com/wp-content/uploads/2016/08/wordpress-admin-panel-200x59.jpg 200w, https://semperplugins.com/wp-content/uploads/2016/08/wordpress-admin-panel-450x132.jpg 450w, https://semperplugins.com/wp-content/uploads/2016/08/wordpress-admin-panel-600x177.jpg 600w, https://semperplugins.com/wp-content/uploads/2016/08/wordpress-admin-panel-900x265.jpg 900w\" sizes=\"(max-width: 1771px) 100vw, 1771px\" /></p>\n<p>The WordPress admin interface is complex and jam-packed with exciting options, which is great for experienced users. However, most users usually find the admin interface intimidating and often confusing. In such a case, innocent exploration, or a stray click, could quite easily (and quickly) result in a defunct site.</p>\n<p>Whether you’re a developer handing over a beautiful site to a client or an admin of a multi-user site, you need to customize and streamline the admin panel to protect the site and enhance the user experience.</p>\n<p>This article is a guide to help you simplify and declutter the WordPress admin interface for your clients or site users, while retaining the powerful functionality it is known for.</p>\n<p>Let’s get started!</p>\n<h2>Security Considerations</h2>\n<p>Pump the breaks. Let’s first address an important issue: security. We know, “boo hoo!” But it’s vital to start with customizations that reinforce the security of your site. Here are a few customizations to make and things to check:</p>\n<ul>\n<li>Change the default “admin” username to something less identifiable</li>\n<li>Change the login page URL from the default wp-login-php</li>\n<li>Create complex passwords</li>\n<li>Limit the number of login attempts in a given time period</li>\n</ul>\n<p>A good security plugin such as <a href=\"https://ithemes.com/security/\" target=\"_blank\">iThemes Security</a> can help you with each of the above.  These are just a few vital security considerations to keep in mind.</p>\n<p>Back on topic, now let’s get started!</p>\n<h2>Assign Editor Roles</h2>\n<div id=\"attachment_2869\" style=\"width: 414px\" class=\"wp-caption alignright\"><img class=\"wp-image-2869 size-full\" src=\"http://semperplugins.com/wp-content/uploads/2016/08/wordpress-roles.jpg\" alt=\"Editors should be able to edit anything concerning the content but shouldn\'t have acces to the settings of the site.\" width=\"404\" height=\"286\" srcset=\"https://semperplugins.com/wp-content/uploads/2016/08/wordpress-roles.jpg 404w, https://semperplugins.com/wp-content/uploads/2016/08/wordpress-roles-300x212.jpg 300w, https://semperplugins.com/wp-content/uploads/2016/08/wordpress-roles-353x250.jpg 353w, https://semperplugins.com/wp-content/uploads/2016/08/wordpress-roles-100x71.jpg 100w, https://semperplugins.com/wp-content/uploads/2016/08/wordpress-roles-150x106.jpg 150w, https://semperplugins.com/wp-content/uploads/2016/08/wordpress-roles-200x142.jpg 200w\" sizes=\"(max-width: 404px) 100vw, 404px\" /><p class=\"wp-caption-text\">Editors should be able to edit anything concerning the content but shouldn&#8217;t have acces to the settings of the site.</p></div>\n<p>The admin menu panel (on the left hand side of the screen) is usually quite cluttered – filled with plugin menus, tools and settings that are rarely used. So why not remove unnecessary menu items and reduce the chaos by assigning editor roles to anyone that doesn’t need full administrator access?</p>\n<p>There are however some important tools and settings that would be hidden by assigning editor roles. For example, users may need to access certain settings, perhaps to a slider plugin, that affects content on the site. In those cases, you need to implement some code or use a role editor plugin to exclusively grant them access to that plugin.</p>\n<h2>Customize the Dashboard</h2>\n<p>The Dashboard is another messy area of the WordPress admin interface that could overwhelm even the most advanced users. Even the editor account can still have a cluttered dashboard view. So how can you reduce the noise?</p>\n<p>Head to the Screen Options tab at the top of the admin page. There, you can enable and disable various content tools on every screen.</p>\n<h2>Add Guides or Manuals</h2>\n<p>Right next to the Screen Options tab is the Help section. The good news is that you can easily modify the Help section to provide custom guidelines that may help users perform necessary tasks and functions.</p>\n<p>For example, you can add help text for custom post types and pages. You can do this by adding code or using a plugin (there are several that can help with this, but more on that later).</p>\n<p>You should organize the guide in a way that would be most beneficial to all users. Perhaps review the frequently asked questions from users or clients and address those questions in the guide.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://semperplugins.com/how-to-declutter-your-wordpress-administrator-interface/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:54:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"How Categories &amp; Tags Work\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://semperplugins.com/categories-and-tags/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://semperplugins.com/categories-and-tags/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Oct 2016 13:00:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"SEO Tips\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"categories\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:4:\"tags\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:13:\"WordPress SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://semperplugins.com/?p=2240\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:389:\"Are you creating categories on the go while you&#8217;re publishing posts? Do you have more than 15 categories on your blog? Are you using tags to bring some order back to your site? If you answered yes to any of those<span class=\"ellipsis\">&#8230;</span><div class=\"read-more\"><a href=\"https://semperplugins.com/categories-and-tags/\">Read more &#8250;</a></div><!-- end of .read-more -->\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Arnaud Broes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2936:\"<p><img class=\"size-full wp-image-2644 alignnone\" src=\"http://semperplugins.com/wp-content/uploads/2016/08/categories-and-tags.jpg\" alt=\"Learn how you can effectively use WordPress categories and tags to improve your on-page SEO.\" width=\"1771\" height=\"521\" srcset=\"https://semperplugins.com/wp-content/uploads/2016/08/categories-and-tags.jpg 1771w, https://semperplugins.com/wp-content/uploads/2016/08/categories-and-tags-300x88.jpg 300w, https://semperplugins.com/wp-content/uploads/2016/08/categories-and-tags-768x226.jpg 768w, https://semperplugins.com/wp-content/uploads/2016/08/categories-and-tags-1024x301.jpg 1024w, https://semperplugins.com/wp-content/uploads/2016/08/categories-and-tags-850x250.jpg 850w, https://semperplugins.com/wp-content/uploads/2016/08/categories-and-tags-100x29.jpg 100w, https://semperplugins.com/wp-content/uploads/2016/08/categories-and-tags-150x44.jpg 150w, https://semperplugins.com/wp-content/uploads/2016/08/categories-and-tags-200x59.jpg 200w, https://semperplugins.com/wp-content/uploads/2016/08/categories-and-tags-450x132.jpg 450w, https://semperplugins.com/wp-content/uploads/2016/08/categories-and-tags-600x177.jpg 600w, https://semperplugins.com/wp-content/uploads/2016/08/categories-and-tags-900x265.jpg 900w\" sizes=\"(max-width: 1771px) 100vw, 1771px\" /></p>\n<p>Are you creating categories on the go while you&#8217;re publishing posts? Do you have more than 15 categories on your blog? Are you using tags to bring some order back to your site? If you answered yes to any of those questions, you may be among many WordPress users that are confused about how to use categories and tags effectively, particularly to benefit SEO.</p>\n<p>Categories and tags are the two main methods to organize posts in WordPress, but they also serve different purposes. Using them in the correct way will not only help you improve your SEO, but ultimately provide a much better user experience for your readers.</p>\n<p>This article will explain the difference between the two and show you how to get the most out of each of them in the hopes of bringing some order back to your site.</p>\n<h2>What about SEO?</h2>\n<p>Categories and tags, when used correctly, could improve your SEO in three ways:</p>\n<ol>\n<li>The internal links will help search engine crawlers find all your site’s content by following those links. In short, it allows search engines such as Google and Bing to access and index all of your posts and include them in search results.</li>\n<li>Your category and tag names, which are the anchor text of the internal links, will give search engines a clue as to what your site is about. This helps you rank your content for those valuable keywords.</li>\n<li>Popular posts that generate inbound links will use categories and tags to link to other related posts on your site, effectively boosting your website’s ranking on search engines and getting you that extra link juice.</li>\n</ol>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://semperplugins.com/categories-and-tags/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"New Release for All in One SEO Pack version 2.3.10\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://semperplugins.com/new-release-for-all-in-one-seo-pack-version-2-3-10/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://semperplugins.com/new-release-for-all-in-one-seo-pack-version-2-3-10/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Oct 2016 23:26:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://semperplugins.com/?p=2721\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:456:\"We are pleased to announce the release of All in One SEO Pack version 2.3.10. This version includes new features, bug fixes, increased security, and tons of under the hood performance improvements, including: Fixes for hosts with overly aggressive backend<span class=\"ellipsis\">&#8230;</span><div class=\"read-more\"><a href=\"https://semperplugins.com/new-release-for-all-in-one-seo-pack-version-2-3-10/\">Read more &#8250;</a></div><!-- end of .read-more -->\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Steve Mortiboy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2006:\"<p>We are pleased to announce the release of All in One SEO Pack version 2.3.10. This version includes new features, bug fixes, increased security, and tons of under the hood performance improvements, including:</p>\n<ul>\n<li>Fixes for hosts with overly aggressive backend caching</li>\n<li>Various performance improvements/Optimizations</li>\n<li>Streamlined various options pages… fewer options, more functionality!</li>\n<li>Getting started with <a href=\"http://semperplugins.com/documentation/understanding-xml-sitemaps-video/\">XML Sitemaps module</a> is easier and quicker than ever</li>\n<li>Enhancements to code that automatically pings Google/Bing with XML Sitemap updates</li>\n<li>Fix for when old static externally produced XML Sitemap files aren’t detected for deletion in certain cases</li>\n<li>Fix for the final PHP 7 warnings</li>\n<li>Improvements to make Preview Snippet more accurate</li>\n<li>CSS and other UX fixes</li>\n<li>Improvements for sites using HTTPS/SSL</li>\n<li>Improvements for non-English sites</li>\n<li>Improved inline documentation</li>\n<li>Additional documentation in the <a href=\"http://semperplugins.com/documentation/\" target=\"_blank\">Help Center</a></li>\n<li>Enhancements for logging</li>\n<li>New API filter hook to <a href=\"http://semperplugins.com/documentation/all-in-one-seo-send-xml-sitemap-search-engines/\">modify search engine XML sitemap ping URLs</a></li>\n<li>Many more <a href=\"http://semperplugins.com/sections/api/\">API hooks</a></li>\n<li>Much, much more! (60+ total changes)</li>\n</ul>\n<p>Update your sites today to take advantage of these features, improvements and bug fixes. Go to Plugins in your WordPress admin area to update.</p>\n<p>Do you want access to exclusive video content, premium support, and even more features? Upgrade to <a href=\"http://semperplugins.com/all-in-one-seo-pack-pro-version/?loc=post2310\">All in One SEO Pack Pro</a> version. Use coupon code <span style=\"font-weight: bold;\">FALL2016</span> for $20 off the regular price.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://semperplugins.com/new-release-for-all-in-one-seo-pack-version-2-3-10/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WordPress Hack Redirects Visitors to Malicious Sites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://semperplugins.com/wordpress-redirect-hack/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://semperplugins.com/wordpress-redirect-hack/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 12 Sep 2016 14:22:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:18:\"WordPress security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://semperplugins.com/?p=2102\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:437:\"Security is a major concern for WordPress site owners and rightly so: there are over 7.5 million cyber-attacks on WordPress sites every hour. Unsurprisingly, WordPress’ open-source nature and flexibility makes it vulnerable to a host of diverse attacks. But its<span class=\"ellipsis\">&#8230;</span><div class=\"read-more\"><a href=\"https://semperplugins.com/wordpress-redirect-hack/\">Read more &#8250;</a></div><!-- end of .read-more -->\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Arnaud Broes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4897:\"<p>Security is a major concern for WordPress site owners and rightly so: there are over 7.5 million cyber-attacks on WordPress sites every hour. Unsurprisingly, WordPress’ open-source nature and flexibility makes it vulnerable to a host of diverse attacks. But its core is quite secure as the WordPress team is dedicated to conserving the structural integrity of the application. The same, however, cannot be said for all WordPress themes and plugins.</p>\n<p>A malware attack was recently discovered by <a href=\"https://blog.sucuri.net/\" target=\"_blank\">John Castro of Sucuri</a>. The malware places 10-12 lines of code at the top of vulnerable WordPress theme header.php files in order to redirect visitors to malicious sites.</p>\n<p>This article will provide details of the attack; as well as tips to secure your site from such attacks in the future.</p>\n<h2>How the Malware Attack Works</h2>\n<p>As mentioned earlier, the malware places 10-12 lines of code at the top of the header.php file of an active WordPress theme. The code appears as follows:</p>\n<p><img class=\"aligncenter wp-image-2219\" src=\"http://semperplugins.com/wp-content/uploads/2016/05/malicious-injection-in-header-php-1024x875.png\" alt=\"Malware injection in header.php file\" width=\"632\" height=\"540\" srcset=\"https://semperplugins.com/wp-content/uploads/2016/05/malicious-injection-in-header-php-1024x875.png 1024w, https://semperplugins.com/wp-content/uploads/2016/05/malicious-injection-in-header-php-300x256.png 300w, https://semperplugins.com/wp-content/uploads/2016/05/malicious-injection-in-header-php-768x656.png 768w, https://semperplugins.com/wp-content/uploads/2016/05/malicious-injection-in-header-php-293x250.png 293w, https://semperplugins.com/wp-content/uploads/2016/05/malicious-injection-in-header-php-100x85.png 100w, https://semperplugins.com/wp-content/uploads/2016/05/malicious-injection-in-header-php-150x128.png 150w, https://semperplugins.com/wp-content/uploads/2016/05/malicious-injection-in-header-php-200x171.png 200w, https://semperplugins.com/wp-content/uploads/2016/05/malicious-injection-in-header-php-450x385.png 450w, https://semperplugins.com/wp-content/uploads/2016/05/malicious-injection-in-header-php-600x513.png 600w, https://semperplugins.com/wp-content/uploads/2016/05/malicious-injection-in-header-php-900x769.png 900w, https://semperplugins.com/wp-content/uploads/2016/05/malicious-injection-in-header-php.png 1486w\" sizes=\"(max-width: 632px) 100vw, 632px\" /></p>\n<p>The malware redirects visitors to default7 .com (not the final redirect destination) upon their first visit. It then sets the &#8220;896diC9OFnqeAcKGN7fW&#8221;cookie to track returning visitors for a year, and tests for search engine crawlers. If there are no crawlers, it proceeds to check the user agent header.</p>\n<p>The redirects are random for everyone. Furthermore, default7 .com is only just the first redirect destination. Visitors are further redirected to the following domains (depending on the IP address and browser):</p>\n<ul>\n<li>test246 .com</li>\n<li>test0 .com</li>\n<li>distinctfestive .com</li>\n<li>ableoccassion .com</li>\n</ul>\n<p>What is particularly interesting is the malware’s behavior on Internet Explorer. When the visitor uses Internet Explorer, they are redirected to a site that provides a malicious Flash or Java update.</p>\n<p><img class=\"alignright wp-image-2572 size-full\" src=\"http://semperplugins.com/wp-content/uploads/2016/08/Fake-Adobe-Flash-update.jpg\" alt=\"Fake Adobe Flash update\" width=\"453\" height=\"319\" srcset=\"https://semperplugins.com/wp-content/uploads/2016/08/Fake-Adobe-Flash-update.jpg 453w, https://semperplugins.com/wp-content/uploads/2016/08/Fake-Adobe-Flash-update-300x211.jpg 300w, https://semperplugins.com/wp-content/uploads/2016/08/Fake-Adobe-Flash-update-355x250.jpg 355w, https://semperplugins.com/wp-content/uploads/2016/08/Fake-Adobe-Flash-update-100x70.jpg 100w, https://semperplugins.com/wp-content/uploads/2016/08/Fake-Adobe-Flash-update-150x106.jpg 150w, https://semperplugins.com/wp-content/uploads/2016/08/Fake-Adobe-Flash-update-200x141.jpg 200w, https://semperplugins.com/wp-content/uploads/2016/08/Fake-Adobe-Flash-update-450x317.jpg 450w\" sizes=\"(max-width: 453px) 100vw, 453px\" /></p>\n<p>Another interesting behavior occurs on Facebook. When you share an infected site link on Facebook, you may see the post snippet from another site – one of the five redirect sites. Facebook will still redirect people to the malicious site, even after you remove the malware from your site. This is because the cache is shared. <a href=\"https://developers.facebook.com/tools/debug\" target=\"_blank\">You can reset the cache here</a>.</p>\n<p>You may be surprised to hear that this kind of infection is quite common when hackers get access to a WordPress admin interface. With the right credentials, they are able to (quite easily) edit a theme file.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://semperplugins.com/wordpress-redirect-hack/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"21\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:31:\"https://semperplugins.com/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:15:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 24 Mar 2017 15:07:09 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:14:\"content-length\";s:5:\"12143\";s:7:\"expires\";s:29:\"Thu, 19 Nov 1981 08:52:00 GMT\";s:13:\"cache-control\";s:35:\"no-store, no-cache, must-revalidate\";s:6:\"pragma\";s:8:\"no-cache\";s:3:\"p3p\";s:69:\"CP=\"IDC DSP COR ADM DEVi TAIi PSA PSD IVAi IVDi CONi HIS OUR IND CNT\"\";s:12:\"x-robots-tag\";s:15:\"noindex, follow\";s:4:\"link\";s:62:\"<https://semperplugins.com/wp-json/>; rel=\"https://api.w.org/\"\";s:10:\"set-cookie\";a:5:{i:0;s:44:\"PHPSESSID=h8v11nlro9edtoa84uccsvpjp6; path=/\";i:1;s:120:\"wpml_referer_url=https%3A%2F%2Fsemperplugins.com%2Ffeed%2F; expires=Sat, 25-Mar-2017 15:07:09 GMT; Max-Age=86400; path=/\";i:2;s:86:\"_icl_current_language=en; expires=Sat, 25-Mar-2017 15:07:09 GMT; Max-Age=86400; path=/\";i:3;s:70:\"Cart66DBSID=26HHK1OVQGURBGRKQ07TEDEQ3VO8YHSEGMO5RAC5; path=/; HttpOnly\";i:4;s:86:\"_icl_current_language=en; expires=Sat, 25-Mar-2017 15:07:09 GMT; Max-Age=86400; path=/\";}s:13:\"last-modified\";s:29:\"Mon, 20 Mar 2017 16:28:50 GMT\";s:4:\"etag\";s:39:\"\"8be10366eda6a3b695328021221b165b-gzip\"\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";s:14:\"20130911070210\";}','no');
INSERT INTO `wp_options` VALUES (774,'limit_login_lockouts_total','1','no'),(759,'_site_transient_browser_1b51c4cc46f14dca9b8b1030e8359468','a:9:{s:8:\"platform\";s:5:\"Linux\";s:4:\"name\";s:13:\"Mobile Safari\";s:7:\"version\";s:6:\"537.36\";s:10:\"update_url\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:11:\"img_src_ssl\";s:0:\"\";s:15:\"current_version\";s:0:\"\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}','no'),(758,'_site_transient_timeout_browser_1b51c4cc46f14dca9b8b1030e8359468','1486414215','no'),(756,'_site_transient_timeout_browser_7e76bd391529bcfbe516d98533665a31','1486413807','no'),(757,'_site_transient_browser_7e76bd391529bcfbe516d98533665a31','a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"55.0.2883.87\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}','no'),(304,'sm_options','a:51:{s:18:\"sm_b_prio_provider\";s:41:\"GoogleSitemapGeneratorPrioByCountProvider\";s:9:\"sm_b_ping\";b:1;s:10:\"sm_b_stats\";b:0;s:12:\"sm_b_pingmsn\";b:1;s:12:\"sm_b_autozip\";b:1;s:11:\"sm_b_memory\";s:0:\"\";s:9:\"sm_b_time\";i:-1;s:18:\"sm_b_style_default\";b:1;s:10:\"sm_b_style\";s:0:\"\";s:12:\"sm_b_baseurl\";s:0:\"\";s:11:\"sm_b_robots\";b:1;s:9:\"sm_b_html\";b:1;s:12:\"sm_b_exclude\";a:0:{}s:17:\"sm_b_exclude_cats\";a:0:{}s:10:\"sm_in_home\";b:1;s:11:\"sm_in_posts\";b:1;s:15:\"sm_in_posts_sub\";b:0;s:11:\"sm_in_pages\";b:1;s:10:\"sm_in_cats\";b:0;s:10:\"sm_in_arch\";b:0;s:10:\"sm_in_auth\";b:0;s:10:\"sm_in_tags\";b:0;s:9:\"sm_in_tax\";a:0:{}s:17:\"sm_in_customtypes\";a:0:{}s:13:\"sm_in_lastmod\";b:1;s:10:\"sm_cf_home\";s:5:\"daily\";s:11:\"sm_cf_posts\";s:7:\"monthly\";s:11:\"sm_cf_pages\";s:6:\"weekly\";s:10:\"sm_cf_cats\";s:6:\"weekly\";s:10:\"sm_cf_auth\";s:6:\"weekly\";s:15:\"sm_cf_arch_curr\";s:5:\"daily\";s:14:\"sm_cf_arch_old\";s:6:\"yearly\";s:10:\"sm_cf_tags\";s:6:\"weekly\";s:10:\"sm_pr_home\";d:1;s:11:\"sm_pr_posts\";d:0.59999999999999997779553950749686919152736663818359375;s:15:\"sm_pr_posts_min\";d:0.200000000000000011102230246251565404236316680908203125;s:11:\"sm_pr_pages\";d:0.59999999999999997779553950749686919152736663818359375;s:10:\"sm_pr_cats\";d:0.299999999999999988897769753748434595763683319091796875;s:10:\"sm_pr_arch\";d:0.299999999999999988897769753748434595763683319091796875;s:10:\"sm_pr_auth\";d:0.299999999999999988897769753748434595763683319091796875;s:10:\"sm_pr_tags\";d:0.299999999999999988897769753748434595763683319091796875;s:12:\"sm_i_donated\";b:0;s:17:\"sm_i_hide_donated\";b:0;s:17:\"sm_i_install_date\";i:1485265759;s:14:\"sm_i_hide_note\";b:0;s:15:\"sm_i_hide_works\";b:0;s:16:\"sm_i_hide_donors\";b:0;s:9:\"sm_i_hash\";s:20:\"d71ce029fbeab6d9e020\";s:13:\"sm_i_lastping\";i:1488387369;s:16:\"sm_i_supportfeed\";b:1;s:22:\"sm_i_supportfeed_cache\";i:1489849077;}','yes'),(305,'sm_status','O:28:\"GoogleSitemapGeneratorStatus\":4:{s:39:\"\0GoogleSitemapGeneratorStatus\0startTime\";d:1488387367.124546051025390625;s:37:\"\0GoogleSitemapGeneratorStatus\0endTime\";d:1488387368.2511179447174072265625;s:41:\"\0GoogleSitemapGeneratorStatus\0pingResults\";a:2:{s:6:\"google\";a:5:{s:9:\"startTime\";d:1488387367.1264860630035400390625;s:7:\"endTime\";d:1488387367.9478209018707275390625;s:7:\"success\";b:1;s:3:\"url\";s:108:\"http://www.google.com/webmasters/sitemaps/ping?sitemap=http%3A%2F%2Fwww.linhafacil.com.br%2Fv2%2Fsitemap.xml\";s:4:\"name\";s:6:\"Google\";}s:4:\"bing\";a:5:{s:9:\"startTime\";d:1488387367.949428081512451171875;s:7:\"endTime\";d:1488387368.248547077178955078125;s:7:\"success\";b:1;s:3:\"url\";s:101:\"http://www.bing.com/webmaster/ping.aspx?siteMap=http%3A%2F%2Fwww.linhafacil.com.br%2Fv2%2Fsitemap.xml\";s:4:\"name\";s:4:\"Bing\";}}s:38:\"\0GoogleSitemapGeneratorStatus\0autoSave\";b:1;}','no'),(1650,'_transient_timeout_feed_mod_08a9370cca8e4bda25c11f8557e93830','1490453877','no'),(1651,'_transient_feed_mod_08a9370cca8e4bda25c11f8557e93830','1489849077','no'),(1648,'_transient_timeout_feed_08a9370cca8e4bda25c11f8557e93830','1490453877','no'),(1649,'_transient_feed_08a9370cca8e4bda25c11f8557e93830','a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:23:\"\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Google Sitemap Generator Support Topics\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Google Sitemap Generator Support Topics\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Wed, 02 Jul 2014 7:54:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:3:{i:0;a:6:{s:4:\"data\";s:19:\"\n			\n			\n			\n			\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Common error messages in Google Webmaster Tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://www.arnebrachhold.de/redir/sitemap-feed-gwterrs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"C2VZYxeTESzcCF2IhS13\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Apr 2014 00:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:19:\"\n			\n			\n			\n			\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"How to move your sitemap to the root of your domain\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"http://www.arnebrachhold.de/redir/sitemap-feed-movesm/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"C2VZYxeTESzcCF2IhS12\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 27 Apr 2014 00:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:19:\"\n			\n			\n			\n			\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"Introducing a new format for your sitemap\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"http://www.arnebrachhold.de/redir/sitemap-feed-newformat/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"C2VZYxeTESzcCF2IhS1l\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 26 Apr 2014 00:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:12:{s:4:\"date\";s:29:\"Sat, 18 Mar 2017 14:57:57 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=utf-8\";s:10:\"set-cookie\";s:133:\"__cfduid=de0db98215bc04e841f8833434c01ce6a1489849077; expires=Sun, 18-Mar-18 14:57:57 GMT; path=/; domain=.arnebrachhold.de; HttpOnly\";s:13:\"cache-control\";s:23:\"public, max-age=2678400\";s:13:\"last-modified\";s:29:\"Wed, 02 Jul 2014 19:54:35 GMT\";s:4:\"etag\";s:32:\"d1272b2e516d060d6085f9129217af7c\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:16:\"content-encoding\";s:4:\"gzip\";s:15:\"cf-cache-status\";s:3:\"HIT\";s:7:\"expires\";s:29:\"Tue, 18 Apr 2017 14:57:57 GMT\";s:6:\"server\";s:16:\"cloudflare-nginx\";s:6:\"cf-ray\";s:20:\"34190c1f06eb06af-EWR\";}}s:5:\"build\";s:14:\"20130911040210\";}','no'),(1751,'_site_transient_timeout_available_translations','1490388712','no'),(1752,'_site_transient_available_translations','a:108:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:38:06\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.3/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:49:08\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-22 18:59:07\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-23 04:36:52\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.3/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-06 09:18:57\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-04 16:58:43\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-05 09:44:12\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"མུ་མཐུད།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-04 20:20:28\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-05 11:34:47\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 08:46:26\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:12:\"Čeština‎\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:49:29\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-02-28 00:33:54\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:40:03\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-18 13:57:42\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-18 13:57:53\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.7.3/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:39:59\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/4.7.3/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-02-21 10:37:42\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-27 00:40:28\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:49:34\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:54:30\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:53:43\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-28 03:10:25\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:47:07\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:41:31\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/es_AR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:54:37\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/es_CO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:53:56\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/es_VE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-15 12:53:17\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/es_ES.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"es\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:54:37\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/es_GT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-28 20:09:49\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_CL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-09 09:36:22\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_PE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:42:28\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/es_MX.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 16:37:11\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:54:33\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-02-02 15:21:03\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:42:25\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-02-03 21:08:25\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:40:32\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-18 16:05:09\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:40:27\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-02-07 18:47:03\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"ચાલુ રાખવું\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-29 21:21:10\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-03 12:18:25\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"जारी\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-29 13:53:21\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:39\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-06 16:02:41\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-02-16 13:36:46\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-17 11:59:56\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-13 05:03:32\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:40:24\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:39:13\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-07 02:07:59\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:39:53\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:25\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:54:34\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-17 20:40:40\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:54:41\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:43:32\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 07:29:35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"Үргэлжлүүлэх\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-24 06:52:11\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-05 09:45:10\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.1.16\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.1.16/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:42:31\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:31\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-03 13:02:03\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-02-16 13:24:21\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.7.3/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-21 11:39:51\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:40:57\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-02 13:47:38\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-17 10:14:23\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.1.16\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.16/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-24 10:09:34\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-16 03:50:08\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-06 22:32:58\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-13 19:43:03\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-24 12:22:25\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-02-08 17:57:45\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-29 18:17:50\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:41:03\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-18 12:21:25\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:43\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-30 02:38:08\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-02-17 11:46:52\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-05 09:23:39\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:9:\"Uyƣurqə\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-15 23:25:27\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-30 07:08:17\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-22 15:46:29\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-24 09:19:48\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.3/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-01-26 15:54:45\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-20 03:14:21\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"4.7.3\";s:7:\"updated\";s:19:\"2017-03-09 05:40:16\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.3/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}','no'),(1729,'wordfence_version','6.3.5','yes'),(1730,'wordfenceActivated','1','yes'),(1731,'wf_plugin_act_error','','yes'),(1736,'_site_transient_update_plugins','O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1490377956;s:7:\"checked\";a:18:{s:31:\"acf-accordion/acf-accordion.php\";s:5:\"1.1.1\";s:55:\"advanced-custom-fields-contact-form-7-field/acf-cf7.php\";s:5:\"1.1.0\";s:34:\"advanced-custom-fields-pro/acf.php\";s:5:\"5.5.2\";s:19:\"akismet/akismet.php\";s:3:\"3.3\";s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";s:8:\"2.3.12.1\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:3:\"4.7\";s:28:\"favicon-xt-manager/index.php\";s:3:\"1.0\";s:43:\"google-analytics-dashboard-for-wp/gadwp.php\";s:7:\"4.9.6.2\";s:36:\"google-sitemap-generator/sitemap.php\";s:5:\"4.0.8\";s:9:\"hello.php\";s:3:\"1.6\";s:38:\"integracao-rd-station/rdstation-wp.php\";s:5:\"3.1.1\";s:45:\"limit-login-attempts/limit-login-attempts.php\";s:5:\"1.7.1\";s:33:\"addthis/addthis_social_widget.php\";s:5:\"5.3.5\";s:23:\"wordfence/wordfence.php\";s:5:\"6.3.5\";s:41:\"wordpress-importer/wordpress-importer.php\";s:5:\"0.6.3\";s:43:\"comments-from-facebook/facebook-comment.php\";s:5:\"1.7.0\";s:24:\"wordpress-seo/wp-seo.php\";s:3:\"4.5\";s:25:\"zopim-live-chat/zopim.php\";s:5:\"1.4.7\";}s:8:\"response\";a:1:{s:34:\"advanced-custom-fields-pro/acf.php\";O:8:\"stdClass\":5:{s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:6:\"plugin\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"new_version\";s:6:\"5.5.10\";s:3:\"url\";s:37:\"https://www.advancedcustomfields.com/\";s:7:\"package\";s:0:\"\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:17:{s:31:\"acf-accordion/acf-accordion.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"59230\";s:4:\"slug\";s:13:\"acf-accordion\";s:6:\"plugin\";s:31:\"acf-accordion/acf-accordion.php\";s:11:\"new_version\";s:5:\"1.1.1\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/acf-accordion/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/acf-accordion.zip\";}s:55:\"advanced-custom-fields-contact-form-7-field/acf-cf7.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"40941\";s:4:\"slug\";s:43:\"advanced-custom-fields-contact-form-7-field\";s:6:\"plugin\";s:55:\"advanced-custom-fields-contact-form-7-field/acf-cf7.php\";s:11:\"new_version\";s:5:\"1.1.0\";s:3:\"url\";s:74:\"https://wordpress.org/plugins/advanced-custom-fields-contact-form-7-field/\";s:7:\"package\";s:92:\"https://downloads.wordpress.org/plugin/advanced-custom-fields-contact-form-7-field.1.1.2.zip\";}s:19:\"akismet/akismet.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"3.3\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/akismet.3.3.zip\";}s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"520\";s:4:\"slug\";s:19:\"all-in-one-seo-pack\";s:6:\"plugin\";s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";s:11:\"new_version\";s:8:\"2.3.12.1\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/all-in-one-seo-pack/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/all-in-one-seo-pack.2.3.12.1.zip\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"790\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:3:\"4.7\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.7.zip\";}s:28:\"favicon-xt-manager/index.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"60537\";s:4:\"slug\";s:18:\"favicon-xt-manager\";s:6:\"plugin\";s:28:\"favicon-xt-manager/index.php\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/favicon-xt-manager/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/favicon-xt-manager.zip\";}s:43:\"google-analytics-dashboard-for-wp/gadwp.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"39196\";s:4:\"slug\";s:33:\"google-analytics-dashboard-for-wp\";s:6:\"plugin\";s:43:\"google-analytics-dashboard-for-wp/gadwp.php\";s:11:\"new_version\";s:7:\"4.9.6.2\";s:3:\"url\";s:64:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/plugin/google-analytics-dashboard-for-wp.4.9.6.2.zip\";}s:36:\"google-sitemap-generator/sitemap.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"132\";s:4:\"slug\";s:24:\"google-sitemap-generator\";s:6:\"plugin\";s:36:\"google-sitemap-generator/sitemap.php\";s:11:\"new_version\";s:5:\"4.0.8\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/google-sitemap-generator/\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/plugin/google-sitemap-generator.4.0.8.zip\";}s:9:\"hello.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"3564\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";}s:38:\"integracao-rd-station/rdstation-wp.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"64247\";s:4:\"slug\";s:21:\"integracao-rd-station\";s:6:\"plugin\";s:38:\"integracao-rd-station/rdstation-wp.php\";s:11:\"new_version\";s:5:\"3.1.1\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/integracao-rd-station/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/integracao-rd-station.zip\";}s:45:\"limit-login-attempts/limit-login-attempts.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:4:\"6158\";s:4:\"slug\";s:20:\"limit-login-attempts\";s:6:\"plugin\";s:45:\"limit-login-attempts/limit-login-attempts.php\";s:11:\"new_version\";s:5:\"1.7.1\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/limit-login-attempts/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/limit-login-attempts.1.7.1.zip\";s:14:\"upgrade_notice\";s:249:\"Users of version 1.6.2 and 1.7.0 should upgrade immediately. There was a problem with &quot;auth cookie&quot; lockout enforcement. Lockout of normal password login attempts still worked as it should. Please see plugin Changelog for more information.\";}s:33:\"addthis/addthis_social_widget.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:4:\"5710\";s:4:\"slug\";s:7:\"addthis\";s:6:\"plugin\";s:33:\"addthis/addthis_social_widget.php\";s:11:\"new_version\";s:5:\"5.3.5\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/addthis/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/addthis.5.3.5.zip\";s:14:\"upgrade_notice\";s:284:\"Removing data-title and addthis:title attributes from inline tool HTML so that Open Graph tags can be used. Replacing some deprecated functions. Compatibility improvements for Follow Buttons by AddThis, Related Posts by AddThis, Website Tools by AddThis &amp; Smart Layers by AddThis.\";}s:23:\"wordfence/wordfence.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"25305\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:5:\"6.3.5\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/wordfence.6.3.5.zip\";}s:41:\"wordpress-importer/wordpress-importer.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"14975\";s:4:\"slug\";s:18:\"wordpress-importer\";s:6:\"plugin\";s:41:\"wordpress-importer/wordpress-importer.php\";s:11:\"new_version\";s:5:\"0.6.3\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/wordpress-importer/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/wordpress-importer.0.6.3.zip\";}s:43:\"comments-from-facebook/facebook-comment.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"63766\";s:4:\"slug\";s:22:\"comments-from-facebook\";s:6:\"plugin\";s:43:\"comments-from-facebook/facebook-comment.php\";s:11:\"new_version\";s:5:\"1.7.0\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/comments-from-facebook/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/comments-from-facebook.1.7.0.zip\";}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"5899\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:3:\"4.5\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.4.5.zip\";}s:25:\"zopim-live-chat/zopim.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"12426\";s:4:\"slug\";s:15:\"zopim-live-chat\";s:6:\"plugin\";s:25:\"zopim-live-chat/zopim.php\";s:11:\"new_version\";s:5:\"1.4.7\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/zopim-live-chat/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/zopim-live-chat.1.4.7.zip\";}}}','no'),(1246,'gadwp_cache_qr2_190218121','a:2:{s:5:\"value\";O:31:\"Google_Service_Analytics_GaData\":24:{s:17:\"\0*\0collection_key\";s:4:\"rows\";s:25:\"\0*\0internal_gapi_mappings\";a:0:{}s:20:\"\0*\0columnHeadersType\";s:44:\"Google_Service_Analytics_GaDataColumnHeaders\";s:24:\"\0*\0columnHeadersDataType\";s:5:\"array\";s:19:\"containsSampledData\";b:0;s:16:\"\0*\0dataTableType\";s:40:\"Google_Service_Analytics_GaDataDataTable\";s:20:\"\0*\0dataTableDataType\";s:0:\"\";s:2:\"id\";s:213:\"https://www.googleapis.com/analytics/v3/data/ga?ids=ga:109602080&dimensions=ga:date,ga:dayOfWeekName&metrics=ga:uniquePageviews&filters=ga:pagePath%3D%3D/v2/2-via-do-boleto/&start-date=30daysAgo&end-date=yesterday\";s:12:\"itemsPerPage\";i:1000;s:4:\"kind\";s:16:\"analytics#gaData\";s:8:\"nextLink\";N;s:12:\"previousLink\";N;s:18:\"\0*\0profileInfoType\";s:42:\"Google_Service_Analytics_GaDataProfileInfo\";s:22:\"\0*\0profileInfoDataType\";s:0:\"\";s:12:\"\0*\0queryType\";s:36:\"Google_Service_Analytics_GaDataQuery\";s:16:\"\0*\0queryDataType\";s:0:\"\";s:4:\"rows\";a:30:{i:0;a:3:{i:0;s:8:\"20170122\";i:1;s:6:\"Sunday\";i:2;s:1:\"0\";}i:1;a:3:{i:0;s:8:\"20170123\";i:1;s:6:\"Monday\";i:2;s:1:\"0\";}i:2;a:3:{i:0;s:8:\"20170124\";i:1;s:7:\"Tuesday\";i:2;s:1:\"0\";}i:3;a:3:{i:0;s:8:\"20170125\";i:1;s:9:\"Wednesday\";i:2;s:1:\"0\";}i:4;a:3:{i:0;s:8:\"20170126\";i:1;s:8:\"Thursday\";i:2;s:1:\"0\";}i:5;a:3:{i:0;s:8:\"20170127\";i:1;s:6:\"Friday\";i:2;s:1:\"0\";}i:6;a:3:{i:0;s:8:\"20170128\";i:1;s:8:\"Saturday\";i:2;s:1:\"0\";}i:7;a:3:{i:0;s:8:\"20170129\";i:1;s:6:\"Sunday\";i:2;s:1:\"0\";}i:8;a:3:{i:0;s:8:\"20170130\";i:1;s:6:\"Monday\";i:2;s:1:\"0\";}i:9;a:3:{i:0;s:8:\"20170131\";i:1;s:7:\"Tuesday\";i:2;s:1:\"0\";}i:10;a:3:{i:0;s:8:\"20170201\";i:1;s:9:\"Wednesday\";i:2;s:1:\"0\";}i:11;a:3:{i:0;s:8:\"20170202\";i:1;s:8:\"Thursday\";i:2;s:1:\"0\";}i:12;a:3:{i:0;s:8:\"20170203\";i:1;s:6:\"Friday\";i:2;s:1:\"0\";}i:13;a:3:{i:0;s:8:\"20170204\";i:1;s:8:\"Saturday\";i:2;s:1:\"0\";}i:14;a:3:{i:0;s:8:\"20170205\";i:1;s:6:\"Sunday\";i:2;s:1:\"0\";}i:15;a:3:{i:0;s:8:\"20170206\";i:1;s:6:\"Monday\";i:2;s:1:\"0\";}i:16;a:3:{i:0;s:8:\"20170207\";i:1;s:7:\"Tuesday\";i:2;s:1:\"0\";}i:17;a:3:{i:0;s:8:\"20170208\";i:1;s:9:\"Wednesday\";i:2;s:1:\"0\";}i:18;a:3:{i:0;s:8:\"20170209\";i:1;s:8:\"Thursday\";i:2;s:1:\"0\";}i:19;a:3:{i:0;s:8:\"20170210\";i:1;s:6:\"Friday\";i:2;s:1:\"0\";}i:20;a:3:{i:0;s:8:\"20170211\";i:1;s:8:\"Saturday\";i:2;s:1:\"0\";}i:21;a:3:{i:0;s:8:\"20170212\";i:1;s:6:\"Sunday\";i:2;s:1:\"0\";}i:22;a:3:{i:0;s:8:\"20170213\";i:1;s:6:\"Monday\";i:2;s:1:\"0\";}i:23;a:3:{i:0;s:8:\"20170214\";i:1;s:7:\"Tuesday\";i:2;s:1:\"0\";}i:24;a:3:{i:0;s:8:\"20170215\";i:1;s:9:\"Wednesday\";i:2;s:1:\"0\";}i:25;a:3:{i:0;s:8:\"20170216\";i:1;s:8:\"Thursday\";i:2;s:1:\"0\";}i:26;a:3:{i:0;s:8:\"20170217\";i:1;s:6:\"Friday\";i:2;s:1:\"0\";}i:27;a:3:{i:0;s:8:\"20170218\";i:1;s:8:\"Saturday\";i:2;s:1:\"0\";}i:28;a:3:{i:0;s:8:\"20170219\";i:1;s:6:\"Sunday\";i:2;s:1:\"0\";}i:29;a:3:{i:0;s:8:\"20170220\";i:1;s:6:\"Monday\";i:2;s:1:\"0\";}}s:10:\"sampleSize\";N;s:11:\"sampleSpace\";N;s:8:\"selfLink\";s:213:\"https://www.googleapis.com/analytics/v3/data/ga?ids=ga:109602080&dimensions=ga:date,ga:dayOfWeekName&metrics=ga:uniquePageviews&filters=ga:pagePath%3D%3D/v2/2-via-do-boleto/&start-date=30daysAgo&end-date=yesterday\";s:12:\"totalResults\";i:30;s:19:\"totalsForAllResults\";a:1:{s:18:\"ga:uniquePageviews\";s:1:\"0\";}s:12:\"\0*\0modelData\";a:3:{s:5:\"query\";a:9:{s:10:\"start-date\";s:9:\"30daysAgo\";s:8:\"end-date\";s:9:\"yesterday\";s:3:\"ids\";s:12:\"ga:109602080\";s:10:\"dimensions\";s:24:\"ga:date,ga:dayOfWeekName\";s:7:\"metrics\";a:1:{i:0;s:18:\"ga:uniquePageviews\";}s:7:\"filters\";s:33:\"ga:pagePath==/v2/2-via-do-boleto/\";s:11:\"start-index\";i:1;s:11:\"max-results\";i:1000;s:13:\"samplingLevel\";s:16:\"HIGHER_PRECISION\";}s:11:\"profileInfo\";a:6:{s:9:\"profileId\";s:9:\"109602080\";s:9:\"accountId\";s:8:\"68516905\";s:13:\"webPropertyId\";s:13:\"UA-68516905-1\";s:21:\"internalWebPropertyId\";s:9:\"105322658\";s:11:\"profileName\";s:25:\"Todos os dados do website\";s:7:\"tableId\";s:12:\"ga:109602080\";}s:13:\"columnHeaders\";a:3:{i:0;a:3:{s:4:\"name\";s:7:\"ga:date\";s:10:\"columnType\";s:9:\"DIMENSION\";s:8:\"dataType\";s:6:\"STRING\";}i:1;a:3:{s:4:\"name\";s:16:\"ga:dayOfWeekName\";s:10:\"columnType\";s:9:\"DIMENSION\";s:8:\"dataType\";s:6:\"STRING\";}i:2;a:3:{s:4:\"name\";s:18:\"ga:uniquePageviews\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"INTEGER\";}}}s:12:\"\0*\0processed\";a:0:{}}s:7:\"expires\";i:1487739600;}','no');
INSERT INTO `wp_options` VALUES (1746,'_transient_aioseop_feed','a:4:{i:0;a:4:{s:3:\"url\";s:62:\"https://semperplugins.com/past-and-future-of-keyword-research/\";s:5:\"title\";s:53:\"A Glance at the Past &amp; Future of Keyword Research\";s:4:\"date\";s:12:\"Mar 7th 2017\";s:7:\"content\";s:131:\"\nWhile getting started on a brand new SEO campaign, often the first thing you would be doing is keyword research. It is suppose...\";}i:1;a:4:{s:3:\"url\";s:70:\"https://semperplugins.com/keyword-research-trends-that-matter-in-2017/\";s:5:\"title\";s:43:\"Keyword Research Trends That Matter In 2017\";s:4:\"date\";s:12:\"Mar 3rd 2017\";s:7:\"content\";s:131:\"\nDespite what you’ve been hearing, keyword research isn’t dead. Without keywords, there is no SEO… right? Let’s look at ...\";}i:2;a:4:{s:3:\"url\";s:65:\"https://semperplugins.com/happy-9th-thank-a-plugin-developer-day/\";s:5:\"title\";s:39:\"Happy 9th Thank a Plugin Developer Day!\";s:4:\"date\";s:13:\"Jan 28th 2017\";s:7:\"content\";s:131:\"Happy 9th Plugin developer Day! Looking back, it&#8217;s been a wild ride. 9 years ago yesterday All in One SEO Pack hit 1 milli...\";}i:3;a:4:{s:3:\"url\";s:46:\"https://semperplugins.com/wordpress-multisite/\";s:5:\"title\";s:52:\"Could WordPress Multisite Be a Game Changer for You?\";s:4:\"date\";s:13:\"Jan 13th 2017\";s:7:\"content\";s:131:\"\nAre you managing multiple WordPress sites? Yes? Did you know you could manage them all from a single dashboard? No? Well you ca...\";}}','no'),(1743,'_transient_timeout_feed_mod_54af7cb0f50a8f4f8cdb30f2d9b4f50c','1490411229','no'),(1744,'_transient_feed_mod_54af7cb0f50a8f4f8cdb30f2d9b4f50c','1490368029','no'),(1745,'_transient_timeout_aioseop_feed','1490411229','no'),(1247,'gadwp_cache_qr3_2784002523','a:2:{s:5:\"value\";O:31:\"Google_Service_Analytics_GaData\":24:{s:17:\"\0*\0collection_key\";s:4:\"rows\";s:25:\"\0*\0internal_gapi_mappings\";a:0:{}s:20:\"\0*\0columnHeadersType\";s:44:\"Google_Service_Analytics_GaDataColumnHeaders\";s:24:\"\0*\0columnHeadersDataType\";s:5:\"array\";s:19:\"containsSampledData\";b:0;s:16:\"\0*\0dataTableType\";s:40:\"Google_Service_Analytics_GaDataDataTable\";s:20:\"\0*\0dataTableDataType\";s:0:\"\";s:2:\"id\";s:303:\"https://www.googleapis.com/analytics/v3/data/ga?ids=ga:109602080&metrics=ga:uniquePageviews,ga:users,ga:pageviews,ga:BounceRate,ga:organicSearches,ga:pageviewsPerSession,ga:avgTimeOnPage,ga:avgPageLoadTime,ga:exitRate&filters=ga:pagePath%3D%3D/v2/2-via-do-boleto/&start-date=30daysAgo&end-date=yesterday\";s:12:\"itemsPerPage\";i:1000;s:4:\"kind\";s:16:\"analytics#gaData\";s:8:\"nextLink\";N;s:12:\"previousLink\";N;s:18:\"\0*\0profileInfoType\";s:42:\"Google_Service_Analytics_GaDataProfileInfo\";s:22:\"\0*\0profileInfoDataType\";s:0:\"\";s:12:\"\0*\0queryType\";s:36:\"Google_Service_Analytics_GaDataQuery\";s:16:\"\0*\0queryDataType\";s:0:\"\";s:4:\"rows\";a:1:{i:0;a:9:{i:0;s:1:\"0\";i:1;s:1:\"0\";i:2;s:1:\"0\";i:3;s:3:\"0.0\";i:4;s:1:\"0\";i:5;s:3:\"0.0\";i:6;s:3:\"0.0\";i:7;s:3:\"0.0\";i:8;s:3:\"0.0\";}}s:10:\"sampleSize\";N;s:11:\"sampleSpace\";N;s:8:\"selfLink\";s:303:\"https://www.googleapis.com/analytics/v3/data/ga?ids=ga:109602080&metrics=ga:uniquePageviews,ga:users,ga:pageviews,ga:BounceRate,ga:organicSearches,ga:pageviewsPerSession,ga:avgTimeOnPage,ga:avgPageLoadTime,ga:exitRate&filters=ga:pagePath%3D%3D/v2/2-via-do-boleto/&start-date=30daysAgo&end-date=yesterday\";s:12:\"totalResults\";i:1;s:19:\"totalsForAllResults\";a:9:{s:18:\"ga:uniquePageviews\";s:1:\"0\";s:8:\"ga:users\";s:1:\"0\";s:12:\"ga:pageviews\";s:1:\"0\";s:13:\"ga:BounceRate\";s:3:\"0.0\";s:18:\"ga:organicSearches\";s:1:\"0\";s:22:\"ga:pageviewsPerSession\";s:3:\"0.0\";s:16:\"ga:avgTimeOnPage\";s:3:\"0.0\";s:18:\"ga:avgPageLoadTime\";s:3:\"0.0\";s:11:\"ga:exitRate\";s:3:\"0.0\";}s:12:\"\0*\0modelData\";a:3:{s:5:\"query\";a:8:{s:10:\"start-date\";s:9:\"30daysAgo\";s:8:\"end-date\";s:9:\"yesterday\";s:3:\"ids\";s:12:\"ga:109602080\";s:7:\"metrics\";a:9:{i:0;s:18:\"ga:uniquePageviews\";i:1;s:8:\"ga:users\";i:2;s:12:\"ga:pageviews\";i:3;s:13:\"ga:BounceRate\";i:4;s:18:\"ga:organicSearches\";i:5;s:22:\"ga:pageviewsPerSession\";i:6;s:16:\"ga:avgTimeOnPage\";i:7;s:18:\"ga:avgPageLoadTime\";i:8;s:11:\"ga:exitRate\";}s:7:\"filters\";s:33:\"ga:pagePath==/v2/2-via-do-boleto/\";s:11:\"start-index\";i:1;s:11:\"max-results\";i:1000;s:13:\"samplingLevel\";s:16:\"HIGHER_PRECISION\";}s:11:\"profileInfo\";a:6:{s:9:\"profileId\";s:9:\"109602080\";s:9:\"accountId\";s:8:\"68516905\";s:13:\"webPropertyId\";s:13:\"UA-68516905-1\";s:21:\"internalWebPropertyId\";s:9:\"105322658\";s:11:\"profileName\";s:25:\"Todos os dados do website\";s:7:\"tableId\";s:12:\"ga:109602080\";}s:13:\"columnHeaders\";a:9:{i:0;a:3:{s:4:\"name\";s:18:\"ga:uniquePageviews\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"INTEGER\";}i:1;a:3:{s:4:\"name\";s:8:\"ga:users\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"INTEGER\";}i:2;a:3:{s:4:\"name\";s:12:\"ga:pageviews\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"INTEGER\";}i:3;a:3:{s:4:\"name\";s:13:\"ga:BounceRate\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"PERCENT\";}i:4;a:3:{s:4:\"name\";s:18:\"ga:organicSearches\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"INTEGER\";}i:5;a:3:{s:4:\"name\";s:22:\"ga:pageviewsPerSession\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:5:\"FLOAT\";}i:6;a:3:{s:4:\"name\";s:16:\"ga:avgTimeOnPage\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:4:\"TIME\";}i:7;a:3:{s:4:\"name\";s:18:\"ga:avgPageLoadTime\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:5:\"FLOAT\";}i:8;a:3:{s:4:\"name\";s:11:\"ga:exitRate\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"PERCENT\";}}}s:12:\"\0*\0processed\";a:0:{}}s:7:\"expires\";i:1487739600;}','no'),(410,'addthis_shared_settings','a:21:{s:25:\"addthis_anonymous_profile\";s:35:\"wp-8b731be721de999ca8a45271f5172957\";s:28:\"addthis_asynchronous_loading\";b:1;s:24:\"addthis_per_post_enabled\";b:1;s:15:\"addthis_profile\";s:0:\"\";s:15:\"addthis_rate_us\";s:0:\"\";s:28:\"credential_validation_status\";s:1:\"0\";s:8:\"wpfooter\";b:1;s:31:\"sharing_buttons_feature_enabled\";s:1:\"1\";s:23:\"addthis_plugin_controls\";s:9:\"WordPress\";s:19:\"addthis_environment\";s:0:\"\";s:24:\"addthis_twitter_template\";s:0:\"\";s:13:\"addthis_bitly\";b:0;s:18:\"addthis_share_json\";s:0:\"\";s:19:\"addthis_layers_json\";s:0:\"\";s:16:\"data_ga_property\";s:0:\"\";s:16:\"addthis_language\";s:0:\"\";s:9:\"atversion\";i:300;s:19:\"addthis_append_data\";b:1;s:18:\"addthis_addressbar\";b:0;s:11:\"addthis_508\";b:0;s:19:\"addthis_config_json\";s:0:\"\";}','yes'),(411,'addthis_sharing_buttons_settings','a:55:{s:5:\"above\";s:13:\"large_toolbox\";s:17:\"above_chosen_list\";s:0:\"\";s:19:\"above_auto_services\";b:1;s:17:\"above_custom_more\";s:0:\"\";s:22:\"above_custom_preferred\";s:0:\"\";s:21:\"above_custom_services\";s:0:\"\";s:17:\"above_custom_size\";s:0:\"\";s:19:\"above_custom_string\";s:0:\"\";s:21:\"addthis_above_enabled\";b:1;s:18:\"addthis_aftertitle\";b:0;s:22:\"addthis_beforecomments\";b:0;s:21:\"addthis_below_enabled\";b:1;s:21:\"addthis_sidebar_count\";s:1:\"5\";s:23:\"addthis_sidebar_enabled\";b:1;s:24:\"addthis_sidebar_position\";s:5:\"right\";s:30:\"addthis_mobile_toolbar_enabled\";b:0;s:43:\"addthis_mobile_toolbar_numPreferredServices\";s:1:\"4\";s:31:\"addthis_mobile_toolbar_position\";s:6:\"bottom\";s:29:\"addthis_mobile_toolbar_counts\";b:1;s:23:\"atversion_update_status\";s:1:\"0\";s:5:\"below\";s:13:\"large_toolbox\";s:17:\"below_chosen_list\";s:0:\"\";s:19:\"below_auto_services\";b:1;s:17:\"below_custom_more\";s:0:\"\";s:22:\"below_custom_preferred\";s:0:\"\";s:21:\"below_custom_services\";s:0:\"\";s:17:\"below_custom_size\";s:0:\"\";s:19:\"below_custom_string\";s:0:\"\";s:8:\"location\";s:5:\"below\";s:5:\"style\";s:11:\"fb_tw_p1_sc\";s:7:\"toolbox\";s:0:\"\";s:25:\"addthis_above_showon_home\";b:1;s:26:\"addthis_above_showon_posts\";b:1;s:26:\"addthis_above_showon_pages\";b:1;s:29:\"addthis_above_showon_archives\";b:1;s:31:\"addthis_above_showon_categories\";b:1;s:29:\"addthis_above_showon_excerpts\";b:1;s:25:\"addthis_below_showon_home\";b:1;s:26:\"addthis_below_showon_posts\";b:1;s:26:\"addthis_below_showon_pages\";b:1;s:29:\"addthis_below_showon_archives\";b:1;s:31:\"addthis_below_showon_categories\";b:1;s:29:\"addthis_below_showon_excerpts\";b:1;s:27:\"addthis_sidebar_showon_home\";b:1;s:28:\"addthis_sidebar_showon_posts\";b:0;s:28:\"addthis_sidebar_showon_pages\";b:0;s:31:\"addthis_sidebar_showon_archives\";b:0;s:33:\"addthis_sidebar_showon_categories\";b:0;s:34:\"addthis_mobile_toolbar_showon_home\";b:1;s:35:\"addthis_mobile_toolbar_showon_posts\";b:1;s:35:\"addthis_mobile_toolbar_showon_pages\";b:1;s:38:\"addthis_mobile_toolbar_showon_archives\";b:1;s:40:\"addthis_mobile_toolbar_showon_categories\";b:1;s:22:\"addthis_plugin_version\";s:5:\"5.3.5\";s:21:\"addthis_sidebar_theme\";s:4:\"Gray\";}','yes'),(412,'widget_addthis-widget','a:1:{s:12:\"_multiwidget\";i:1;}','yes'),(413,'addthis_run_once','1','yes'),(414,'addthis_settings','','yes'),(598,'zopimGreetings','{\"away\":{\"window\":\"If you leave a question or comment, our agents will be notified and will try to attend to you shortly =)\",\"bar\":\"Click here to chat\"},\"offline\":{\"window\":\"We are offline, but if you leave your message and contact details, we will try to get back to you =)\",\"bar\":\"Leave a message\"},\"online\":{\"window\":\"Leave a question or comment and our agents will try to attend to you shortly =)\",\"bar\":\"Click here to chat\"}}','yes'),(1740,'_site_transient_browser_88337cd9fed317d029aaa03191c0be0b','a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"56.0.2924.87\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}','no'),(595,'zopimUsername','contato@linhafacil.com.br','yes'),(596,'zopimSalt','contato@linhafacil.com.br_$0$2cd7ee300bd35b7315477cebf96a6f817293f42f$e5+ObOtNpoXIpem0NtR14HOfMC8CC0XtV3dlKSRdl1HV+ID6uj26PMKydp5ZoudJyyIhFByFcSoOQD4bKMXA1g==','yes'),(597,'zopimCode','3HB1lbQbzzxYrxsX6QfveCUoYcBHJZZu','yes'),(599,'zopimWidgetOptions','$zopim( function() {\n})','yes'),(773,'limit_login_logged','a:1:{s:15:\"186.222.185.254\";a:1:{s:5:\"admin\";i:1;}}','no'),(783,'_site_transient_timeout_browser_a29bc552607ca9ec4113e0a587f1cb01','1486419106','no'),(784,'_site_transient_browser_a29bc552607ca9ec4113e0a587f1cb01','a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"56.0.2924.76\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}','no'),(818,'_site_transient_browser_2cc72a451a02be39ef75d8c5628e1800','a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"56.0.2924.76\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}','no'),(1747,'gadwp_cache_qr2_760231456','a:2:{s:5:\"value\";O:31:\"Google_Service_Analytics_GaData\":24:{s:17:\"\0*\0collection_key\";s:4:\"rows\";s:25:\"\0*\0internal_gapi_mappings\";a:0:{}s:20:\"\0*\0columnHeadersType\";s:44:\"Google_Service_Analytics_GaDataColumnHeaders\";s:24:\"\0*\0columnHeadersDataType\";s:5:\"array\";s:19:\"containsSampledData\";b:0;s:16:\"\0*\0dataTableType\";s:40:\"Google_Service_Analytics_GaDataDataTable\";s:20:\"\0*\0dataTableDataType\";s:0:\"\";s:2:\"id\";s:160:\"https://www.googleapis.com/analytics/v3/data/ga?ids=ga:109602080&dimensions=ga:date,ga:dayOfWeekName&metrics=ga:sessions&start-date=30daysAgo&end-date=yesterday\";s:12:\"itemsPerPage\";i:1000;s:4:\"kind\";s:16:\"analytics#gaData\";s:8:\"nextLink\";N;s:12:\"previousLink\";N;s:18:\"\0*\0profileInfoType\";s:42:\"Google_Service_Analytics_GaDataProfileInfo\";s:22:\"\0*\0profileInfoDataType\";s:0:\"\";s:12:\"\0*\0queryType\";s:36:\"Google_Service_Analytics_GaDataQuery\";s:16:\"\0*\0queryDataType\";s:0:\"\";s:4:\"rows\";a:30:{i:0;a:3:{i:0;s:8:\"20170222\";i:1;s:9:\"Wednesday\";i:2;s:1:\"1\";}i:1;a:3:{i:0;s:8:\"20170223\";i:1;s:8:\"Thursday\";i:2;s:1:\"0\";}i:2;a:3:{i:0;s:8:\"20170224\";i:1;s:6:\"Friday\";i:2;s:1:\"2\";}i:3;a:3:{i:0;s:8:\"20170225\";i:1;s:8:\"Saturday\";i:2;s:1:\"0\";}i:4;a:3:{i:0;s:8:\"20170226\";i:1;s:6:\"Sunday\";i:2;s:1:\"0\";}i:5;a:3:{i:0;s:8:\"20170227\";i:1;s:6:\"Monday\";i:2;s:1:\"0\";}i:6;a:3:{i:0;s:8:\"20170228\";i:1;s:7:\"Tuesday\";i:2;s:1:\"0\";}i:7;a:3:{i:0;s:8:\"20170301\";i:1;s:9:\"Wednesday\";i:2;s:1:\"0\";}i:8;a:3:{i:0;s:8:\"20170302\";i:1;s:8:\"Thursday\";i:2;s:1:\"0\";}i:9;a:3:{i:0;s:8:\"20170303\";i:1;s:6:\"Friday\";i:2;s:1:\"0\";}i:10;a:3:{i:0;s:8:\"20170304\";i:1;s:8:\"Saturday\";i:2;s:1:\"0\";}i:11;a:3:{i:0;s:8:\"20170305\";i:1;s:6:\"Sunday\";i:2;s:1:\"0\";}i:12;a:3:{i:0;s:8:\"20170306\";i:1;s:6:\"Monday\";i:2;s:1:\"0\";}i:13;a:3:{i:0;s:8:\"20170307\";i:1;s:7:\"Tuesday\";i:2;s:1:\"0\";}i:14;a:3:{i:0;s:8:\"20170308\";i:1;s:9:\"Wednesday\";i:2;s:1:\"0\";}i:15;a:3:{i:0;s:8:\"20170309\";i:1;s:8:\"Thursday\";i:2;s:1:\"0\";}i:16;a:3:{i:0;s:8:\"20170310\";i:1;s:6:\"Friday\";i:2;s:1:\"0\";}i:17;a:3:{i:0;s:8:\"20170311\";i:1;s:8:\"Saturday\";i:2;s:1:\"0\";}i:18;a:3:{i:0;s:8:\"20170312\";i:1;s:6:\"Sunday\";i:2;s:1:\"0\";}i:19;a:3:{i:0;s:8:\"20170313\";i:1;s:6:\"Monday\";i:2;s:1:\"0\";}i:20;a:3:{i:0;s:8:\"20170314\";i:1;s:7:\"Tuesday\";i:2;s:1:\"0\";}i:21;a:3:{i:0;s:8:\"20170315\";i:1;s:9:\"Wednesday\";i:2;s:1:\"0\";}i:22;a:3:{i:0;s:8:\"20170316\";i:1;s:8:\"Thursday\";i:2;s:1:\"0\";}i:23;a:3:{i:0;s:8:\"20170317\";i:1;s:6:\"Friday\";i:2;s:1:\"0\";}i:24;a:3:{i:0;s:8:\"20170318\";i:1;s:8:\"Saturday\";i:2;s:1:\"0\";}i:25;a:3:{i:0;s:8:\"20170319\";i:1;s:6:\"Sunday\";i:2;s:1:\"0\";}i:26;a:3:{i:0;s:8:\"20170320\";i:1;s:6:\"Monday\";i:2;s:1:\"4\";}i:27;a:3:{i:0;s:8:\"20170321\";i:1;s:7:\"Tuesday\";i:2;s:1:\"1\";}i:28;a:3:{i:0;s:8:\"20170322\";i:1;s:9:\"Wednesday\";i:2;s:1:\"1\";}i:29;a:3:{i:0;s:8:\"20170323\";i:1;s:8:\"Thursday\";i:2;s:1:\"0\";}}s:10:\"sampleSize\";N;s:11:\"sampleSpace\";N;s:8:\"selfLink\";s:160:\"https://www.googleapis.com/analytics/v3/data/ga?ids=ga:109602080&dimensions=ga:date,ga:dayOfWeekName&metrics=ga:sessions&start-date=30daysAgo&end-date=yesterday\";s:12:\"totalResults\";i:30;s:19:\"totalsForAllResults\";a:1:{s:11:\"ga:sessions\";s:1:\"9\";}s:12:\"\0*\0modelData\";a:3:{s:5:\"query\";a:8:{s:10:\"start-date\";s:9:\"30daysAgo\";s:8:\"end-date\";s:9:\"yesterday\";s:3:\"ids\";s:12:\"ga:109602080\";s:10:\"dimensions\";s:24:\"ga:date,ga:dayOfWeekName\";s:7:\"metrics\";a:1:{i:0;s:11:\"ga:sessions\";}s:11:\"start-index\";i:1;s:11:\"max-results\";i:1000;s:13:\"samplingLevel\";s:16:\"HIGHER_PRECISION\";}s:11:\"profileInfo\";a:6:{s:9:\"profileId\";s:9:\"109602080\";s:9:\"accountId\";s:8:\"68516905\";s:13:\"webPropertyId\";s:13:\"UA-68516905-1\";s:21:\"internalWebPropertyId\";s:9:\"105322658\";s:11:\"profileName\";s:25:\"Todos os dados do website\";s:7:\"tableId\";s:12:\"ga:109602080\";}s:13:\"columnHeaders\";a:3:{i:0;a:3:{s:4:\"name\";s:7:\"ga:date\";s:10:\"columnType\";s:9:\"DIMENSION\";s:8:\"dataType\";s:6:\"STRING\";}i:1;a:3:{s:4:\"name\";s:16:\"ga:dayOfWeekName\";s:10:\"columnType\";s:9:\"DIMENSION\";s:8:\"dataType\";s:6:\"STRING\";}i:2;a:3:{s:4:\"name\";s:11:\"ga:sessions\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"INTEGER\";}}}s:12:\"\0*\0processed\";a:0:{}}s:7:\"expires\";i:1490418000;}','no'),(817,'_site_transient_timeout_browser_2cc72a451a02be39ef75d8c5628e1800','1486471044','no'),(973,'_site_transient_timeout_browser_f2132d5511994ece1a0efc6b3d1d42e9','1487007360','no'),(974,'_site_transient_browser_f2132d5511994ece1a0efc6b3d1d42e9','a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"57.0.2987.21\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}','no'),(1717,'_site_transient_timeout_browser_c9e0548f699565df26d7416ac381ae2b','1490971951','no'),(1409,'_site_transient_timeout_browser_0dd3a423e2d4366a9fb4fd8a57650874','1488992110','no'),(1410,'_site_transient_browser_0dd3a423e2d4366a9fb4fd8a57650874','a:9:{s:8:\"platform\";s:5:\"Linux\";s:4:\"name\";s:13:\"Mobile Safari\";s:7:\"version\";s:6:\"537.36\";s:10:\"update_url\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:11:\"img_src_ssl\";s:0:\"\";s:15:\"current_version\";s:0:\"\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}','no'),(1333,'_site_transient_timeout_browser_7d01992d2940bcb269d744faad09c8ef','1488549609','no'),(1334,'_site_transient_browser_7d01992d2940bcb269d744faad09c8ef','a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"57.0.2987.74\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}','no'),(1748,'gadwp_cache_qr3_123861593','a:2:{s:5:\"value\";O:31:\"Google_Service_Analytics_GaData\":24:{s:17:\"\0*\0collection_key\";s:4:\"rows\";s:25:\"\0*\0internal_gapi_mappings\";a:0:{}s:20:\"\0*\0columnHeadersType\";s:44:\"Google_Service_Analytics_GaDataColumnHeaders\";s:24:\"\0*\0columnHeadersDataType\";s:5:\"array\";s:19:\"containsSampledData\";b:0;s:16:\"\0*\0dataTableType\";s:40:\"Google_Service_Analytics_GaDataDataTable\";s:20:\"\0*\0dataTableDataType\";s:0:\"\";s:2:\"id\";s:260:\"https://www.googleapis.com/analytics/v3/data/ga?ids=ga:109602080&metrics=ga:sessions,ga:users,ga:pageviews,ga:BounceRate,ga:organicSearches,ga:pageviewsPerSession,ga:avgTimeOnPage,ga:avgPageLoadTime,ga:avgSessionDuration&start-date=30daysAgo&end-date=yesterday\";s:12:\"itemsPerPage\";i:1000;s:4:\"kind\";s:16:\"analytics#gaData\";s:8:\"nextLink\";N;s:12:\"previousLink\";N;s:18:\"\0*\0profileInfoType\";s:42:\"Google_Service_Analytics_GaDataProfileInfo\";s:22:\"\0*\0profileInfoDataType\";s:0:\"\";s:12:\"\0*\0queryType\";s:36:\"Google_Service_Analytics_GaDataQuery\";s:16:\"\0*\0queryDataType\";s:0:\"\";s:4:\"rows\";a:1:{i:0;a:9:{i:0;s:1:\"9\";i:1;s:1:\"7\";i:2;s:2:\"11\";i:3;s:17:\"77.77777777777779\";i:4;s:1:\"0\";i:5;s:18:\"1.2222222222222223\";i:6;s:5:\"472.5\";i:7;s:3:\"0.0\";i:8;s:5:\"105.0\";}}s:10:\"sampleSize\";N;s:11:\"sampleSpace\";N;s:8:\"selfLink\";s:260:\"https://www.googleapis.com/analytics/v3/data/ga?ids=ga:109602080&metrics=ga:sessions,ga:users,ga:pageviews,ga:BounceRate,ga:organicSearches,ga:pageviewsPerSession,ga:avgTimeOnPage,ga:avgPageLoadTime,ga:avgSessionDuration&start-date=30daysAgo&end-date=yesterday\";s:12:\"totalResults\";i:1;s:19:\"totalsForAllResults\";a:9:{s:11:\"ga:sessions\";s:1:\"9\";s:8:\"ga:users\";s:1:\"7\";s:12:\"ga:pageviews\";s:2:\"11\";s:13:\"ga:BounceRate\";s:17:\"77.77777777777779\";s:18:\"ga:organicSearches\";s:1:\"0\";s:22:\"ga:pageviewsPerSession\";s:18:\"1.2222222222222223\";s:16:\"ga:avgTimeOnPage\";s:5:\"472.5\";s:18:\"ga:avgPageLoadTime\";s:3:\"0.0\";s:21:\"ga:avgSessionDuration\";s:5:\"105.0\";}s:12:\"\0*\0modelData\";a:3:{s:5:\"query\";a:7:{s:10:\"start-date\";s:9:\"30daysAgo\";s:8:\"end-date\";s:9:\"yesterday\";s:3:\"ids\";s:12:\"ga:109602080\";s:7:\"metrics\";a:9:{i:0;s:11:\"ga:sessions\";i:1;s:8:\"ga:users\";i:2;s:12:\"ga:pageviews\";i:3;s:13:\"ga:BounceRate\";i:4;s:18:\"ga:organicSearches\";i:5;s:22:\"ga:pageviewsPerSession\";i:6;s:16:\"ga:avgTimeOnPage\";i:7;s:18:\"ga:avgPageLoadTime\";i:8;s:21:\"ga:avgSessionDuration\";}s:11:\"start-index\";i:1;s:11:\"max-results\";i:1000;s:13:\"samplingLevel\";s:16:\"HIGHER_PRECISION\";}s:11:\"profileInfo\";a:6:{s:9:\"profileId\";s:9:\"109602080\";s:9:\"accountId\";s:8:\"68516905\";s:13:\"webPropertyId\";s:13:\"UA-68516905-1\";s:21:\"internalWebPropertyId\";s:9:\"105322658\";s:11:\"profileName\";s:25:\"Todos os dados do website\";s:7:\"tableId\";s:12:\"ga:109602080\";}s:13:\"columnHeaders\";a:9:{i:0;a:3:{s:4:\"name\";s:11:\"ga:sessions\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"INTEGER\";}i:1;a:3:{s:4:\"name\";s:8:\"ga:users\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"INTEGER\";}i:2;a:3:{s:4:\"name\";s:12:\"ga:pageviews\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"INTEGER\";}i:3;a:3:{s:4:\"name\";s:13:\"ga:BounceRate\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"PERCENT\";}i:4;a:3:{s:4:\"name\";s:18:\"ga:organicSearches\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:7:\"INTEGER\";}i:5;a:3:{s:4:\"name\";s:22:\"ga:pageviewsPerSession\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:5:\"FLOAT\";}i:6;a:3:{s:4:\"name\";s:16:\"ga:avgTimeOnPage\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:4:\"TIME\";}i:7;a:3:{s:4:\"name\";s:18:\"ga:avgPageLoadTime\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:5:\"FLOAT\";}i:8;a:3:{s:4:\"name\";s:21:\"ga:avgSessionDuration\";s:10:\"columnType\";s:6:\"METRIC\";s:8:\"dataType\";s:4:\"TIME\";}}}s:12:\"\0*\0processed\";a:0:{}}s:7:\"expires\";i:1490418000;}','no'),(1735,'_site_transient_update_core','O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/pt_BR/wordpress-4.7.3.zip\";s:6:\"locale\";s:5:\"pt_BR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/pt_BR/wordpress-4.7.3.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.7.3\";s:7:\"version\";s:5:\"4.7.3\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1490377718;s:15:\"version_checked\";s:5:\"4.7.3\";s:12:\"translations\";a:0:{}}','no'),(1718,'_site_transient_browser_c9e0548f699565df26d7416ac381ae2b','a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"58.0.3029.19\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}','no'),(1737,'_site_transient_update_themes','O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1490367978;s:7:\"checked\";a:4:{s:6:\"lfacil\";s:8:\"1.0-beta\";s:13:\"twentyfifteen\";s:3:\"1.7\";s:15:\"twentyseventeen\";s:3:\"1.1\";s:13:\"twentysixteen\";s:3:\"1.3\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}','no');
DROP TABLE IF EXISTS `wp_postmeta`;
CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2183 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `wp_postmeta` VALUES (2177,227,'link',''),(74,41,'_wp_attached_file','2017/01/caminhoes-150x150-1.png'),(73,40,'_edit_lock','1485269747:2'),(2182,227,'_accordion','field_588f7627cb9cd'),(642,110,'_rdscriptcontentinfooter',''),(640,110,'_rdscriptcontentbottom',''),(641,110,'_rdscriptcontentinhead',''),(13,8,'_menu_item_type','custom'),(14,8,'_menu_item_menu_item_parent','0'),(15,8,'_menu_item_object_id','8'),(16,8,'_menu_item_object','custom'),(17,8,'_menu_item_target',''),(18,8,'_menu_item_classes','a:1:{i:0;s:8:\"btn-home\";}'),(19,8,'_menu_item_xfn',''),(20,8,'_menu_item_url','http://www.linhafacil.com.br/v2/'),(639,110,'_rdscriptcontenttop',''),(636,170,'acordions',''),(637,170,'_acordions','field_5887501a480ec'),(635,169,'_acordions','field_5887501a480ec'),(634,169,'acordions',''),(2022,210,'imagem_principal',''),(390,14,'_aioseop_opengraph_settings','a:13:{s:32:\"aioseop_opengraph_settings_title\";s:0:\"\";s:31:\"aioseop_opengraph_settings_desc\";s:0:\"\";s:36:\"aioseop_opengraph_settings_customimg\";s:0:\"\";s:37:\"aioseop_opengraph_settings_imagewidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_imageheight\";s:0:\"\";s:32:\"aioseop_opengraph_settings_video\";s:0:\"\";s:37:\"aioseop_opengraph_settings_videowidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_videoheight\";s:0:\"\";s:35:\"aioseop_opengraph_settings_category\";s:8:\"activity\";s:34:\"aioseop_opengraph_settings_section\";s:0:\"\";s:30:\"aioseop_opengraph_settings_tag\";s:0:\"\";s:34:\"aioseop_opengraph_settings_setcard\";s:7:\"summary\";s:44:\"aioseop_opengraph_settings_customimg_twitter\";s:0:\"\";}'),(407,14,'_at_widget','1'),(37,11,'_edit_last','1'),(38,11,'imagem_principal','60'),(39,11,'_imagem_principal','field_58860ca42f9e3'),(40,12,'_edit_last','1'),(41,14,'_edit_last','1'),(42,14,'imagem_principal','100'),(43,14,'_imagem_principal','field_58860ca42f9e3'),(44,14,'link',''),(45,14,'_link','field_5886118f0934c'),(46,19,'_edit_last','1'),(47,19,'texto_diferenciado','até R$ 150.000,00'),(48,19,'_texto_diferenciado','field_58862a7dd9d12'),(49,19,'_thumbnail_id','52'),(50,20,'_edit_last','1'),(51,25,'texto_diferenciado','até R$ 75.000,00'),(52,25,'_texto_diferenciado','field_58862a7dd9d12'),(53,25,'_thumbnail_id','49'),(54,25,'_dp_original','19'),(55,25,'_edit_last','1'),(56,28,'texto_diferenciado','até R$ 250.000,00'),(57,28,'_texto_diferenciado','field_58862a7dd9d12'),(58,28,'_thumbnail_id','46'),(59,28,'_dp_original','19'),(60,28,'_edit_last','1'),(61,32,'texto_diferenciado','até R$ 350.000,00'),(62,32,'_texto_diferenciado','field_58862a7dd9d12'),(63,32,'_thumbnail_id','43'),(64,32,'_dp_original','28'),(65,32,'_edit_last','1'),(66,35,'_edit_last','2'),(67,35,'texto_diferenciado','Enquanto resolvemos seu sinistro, oferecemos um veículo extra para você usar, durante o conserto do seu veículo.'),(68,35,'_texto_diferenciado','field_58862a7dd9d12'),(69,40,'texto_diferenciado','Orientações e auxílio nas atividades extrajudiciais relacionadas a sua proteção veicular, sem custos adicionais.'),(70,40,'_texto_diferenciado','field_58862a7dd9d12'),(71,40,'_dp_original','35'),(72,40,'_edit_last','2'),(75,41,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:31:\"2017/01/caminhoes-150x150-1.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(76,42,'_wp_attached_file','2017/01/caminhoes-300x300-1.png'),(77,42,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:300;s:6:\"height\";i:300;s:4:\"file\";s:31:\"2017/01/caminhoes-300x300-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"caminhoes-300x300-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(78,43,'_wp_attached_file','2017/01/caminhoes-1.png'),(79,43,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:400;s:6:\"height\";i:400;s:4:\"file\";s:23:\"2017/01/caminhoes-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"caminhoes-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"caminhoes-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(80,44,'_wp_attached_file','2017/01/Vans-150x150-1.png'),(81,44,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:26:\"2017/01/Vans-150x150-1.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(82,45,'_wp_attached_file','2017/01/Vans-300x300-1.png'),(83,45,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:300;s:6:\"height\";i:300;s:4:\"file\";s:26:\"2017/01/Vans-300x300-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"Vans-300x300-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(84,46,'_wp_attached_file','2017/01/Vans-1.png'),(85,46,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:400;s:6:\"height\";i:400;s:4:\"file\";s:18:\"2017/01/Vans-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"Vans-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"Vans-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(86,47,'_wp_attached_file','2017/01/Motos-150x150-1.png'),(87,47,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:27:\"2017/01/Motos-150x150-1.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(88,48,'_wp_attached_file','2017/01/Motos-300x300-1.png'),(89,48,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:300;s:6:\"height\";i:300;s:4:\"file\";s:27:\"2017/01/Motos-300x300-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"Motos-300x300-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(90,49,'_wp_attached_file','2017/01/Motos-1.png'),(91,49,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:400;s:6:\"height\";i:400;s:4:\"file\";s:19:\"2017/01/Motos-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"Motos-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"Motos-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(92,50,'_wp_attached_file','2017/01/carros-150x150-1.png'),(93,50,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:28:\"2017/01/carros-150x150-1.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(94,51,'_wp_attached_file','2017/01/carros-300x300-1.png'),(95,51,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:300;s:6:\"height\";i:300;s:4:\"file\";s:28:\"2017/01/carros-300x300-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"carros-300x300-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(96,52,'_wp_attached_file','2017/01/carros-1.png'),(97,52,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:400;s:6:\"height\";i:400;s:4:\"file\";s:20:\"2017/01/carros-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"carros-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"carros-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(98,53,'_wp_attached_file','2017/01/guy-top-150x150-1.png'),(99,53,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:29:\"2017/01/guy-top-150x150-1.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(100,54,'_wp_attached_file','2017/01/guy-top-171x300-1.png'),(101,54,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:171;s:6:\"height\";i:300;s:4:\"file\";s:29:\"2017/01/guy-top-171x300-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"guy-top-171x300-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"guy-top-171x300-1-171x300.png\";s:5:\"width\";i:171;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(102,55,'_wp_attached_file','2017/01/guy-top-1.png'),(103,55,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:359;s:6:\"height\";i:629;s:4:\"file\";s:21:\"2017/01/guy-top-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"guy-top-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"guy-top-1-171x300.png\";s:5:\"width\";i:171;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(104,56,'_wp_attached_file','2017/01/bg-slider-150x150-1.jpg'),(105,56,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:31:\"2017/01/bg-slider-150x150-1.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(106,57,'_wp_attached_file','2017/01/bg-slider-300x65-1.jpg'),(107,57,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:300;s:6:\"height\";i:65;s:4:\"file\";s:30:\"2017/01/bg-slider-300x65-1.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"bg-slider-300x65-1-150x65.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:65;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"bg-slider-300x65-1-300x65.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:65;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(108,58,'_wp_attached_file','2017/01/bg-slider-768x166-1.jpg'),(109,58,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:768;s:6:\"height\";i:166;s:4:\"file\";s:31:\"2017/01/bg-slider-768x166-1.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"bg-slider-768x166-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"bg-slider-768x166-1-300x65.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:65;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"bg-slider-768x166-1-768x166.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:166;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(110,59,'_wp_attached_file','2017/01/bg-slider-1024x221-1.jpg'),(111,59,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:221;s:4:\"file\";s:32:\"2017/01/bg-slider-1024x221-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"bg-slider-1024x221-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"bg-slider-1024x221-1-300x65.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:65;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"bg-slider-1024x221-1-768x166.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:166;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"bg-slider-1024x221-1-1024x221.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:221;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(112,60,'_wp_attached_file','2017/01/bg-slider-1.jpg'),(113,60,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:2280;s:6:\"height\";i:492;s:4:\"file\";s:23:\"2017/01/bg-slider-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"bg-slider-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"bg-slider-1-300x65.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:65;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"bg-slider-1-768x166.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:166;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"bg-slider-1-1024x221.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:221;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(114,32,'_edit_lock','1485262277:1'),(115,12,'_edit_lock','1485214848:1'),(119,28,'_edit_lock','1485262283:1'),(117,61,'texto_diferenciado','até R$ 350.000,00'),(118,61,'_texto_diferenciado','field_58862a7dd9d12'),(123,25,'_edit_lock','1485263475:1'),(121,62,'texto_diferenciado','até R$ 250.000,00'),(122,62,'_texto_diferenciado','field_58862a7dd9d12'),(127,19,'_edit_lock','1485262376:1'),(125,63,'texto_diferenciado','até R$ 75.000,00'),(126,63,'_texto_diferenciado','field_58862a7dd9d12'),(131,11,'_edit_lock','1485221379:1'),(129,64,'texto_diferenciado','até R$ 150.000,00'),(130,64,'_texto_diferenciado','field_58862a7dd9d12'),(132,11,'link',''),(133,11,'_link','field_5886118f0934c'),(134,14,'_edit_lock','1485303077:1'),(144,66,'_edit_last','1'),(136,14,'texto_diferenciado',''),(137,14,'_texto_diferenciado','field_58862a7dd9d12'),(138,65,'imagem_principal','55'),(139,65,'_imagem_principal','field_58860ca42f9e3'),(140,65,'link',''),(141,65,'_link','field_5886118f0934c'),(142,65,'texto_diferenciado',''),(143,65,'_texto_diferenciado','field_58862a7dd9d12'),(145,66,'_edit_lock','1485361306:1'),(146,20,'_edit_lock','1485809305:1'),(147,67,'_form','<label> Seu nome (obrigatório)\n    [text* your-name] </label>\n\n<label> Seu e-mail (obrigatório)\n    [email* your-email] </label>\n\n<label> Assunto\n    [text your-subject] </label>\n\n<label> Sua mensagem\n    [textarea your-message] </label>\n\n[submit \"Enviar\"]'),(148,67,'_mail','a:8:{s:7:\"subject\";s:59:\"Facil Auto Prote&ccedil;&atilde;o Veicular \"[your-subject]\"\";s:6:\"sender\";s:41:\"[your-name] <wordpress@linhafacil.com.br>\";s:4:\"body\";s:226:\"De: [your-name] <[your-email]>\nAssunto: [your-subject]\n\nCorpo da mensagem:\n[your-message]\n\n--\nEste e-mail foi enviado de um formulário de contato em Facil Auto Prote&ccedil;&atilde;o Veicular (http://www.linhafacil.com.br/v2)\";s:9:\"recipient\";s:29:\"marketinglinhafacil@gmail.com\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}'),(149,67,'_mail_2','a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:59:\"Facil Auto Prote&ccedil;&atilde;o Veicular \"[your-subject]\"\";s:6:\"sender\";s:72:\"Facil Auto Prote&ccedil;&atilde;o Veicular <wordpress@linhafacil.com.br>\";s:4:\"body\";s:170:\"Corpo da mensagem:\n[your-message]\n\n--\nEste e-mail foi enviado de um formulário de contato em Facil Auto Prote&ccedil;&atilde;o Veicular (http://www.linhafacil.com.br/v2)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:39:\"Reply-To: marketinglinhafacil@gmail.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}'),(150,67,'_messages','a:8:{s:12:\"mail_sent_ok\";s:27:\"Agradecemos a sua mensagem.\";s:12:\"mail_sent_ng\";s:85:\"Ocorreu um erro ao tentar enviar sua mensagem. Por favor, tente novamente mais tarde.\";s:16:\"validation_error\";s:73:\"Um ou mais campos possuem um erro. Por favor verifique e tente novamente.\";s:4:\"spam\";s:85:\"Ocorreu um erro ao tentar enviar sua mensagem. Por favor, tente novamente mais tarde.\";s:12:\"accept_terms\";s:72:\"Você deve aceitar os termos e condições antes de enviar sua mensagem.\";s:16:\"invalid_required\";s:24:\"O campo é obrigatório.\";s:16:\"invalid_too_long\";s:23:\"O campo é muito longo.\";s:17:\"invalid_too_short\";s:23:\"O campo é muito curto.\";}'),(151,67,'_additional_settings',NULL),(152,67,'_locale','pt_BR'),(153,69,'_form','[text* your-name class:col-md-12 placeholder \"Nome Completo\"]\n[text* your-email class:col-md-12 placeholder \"Email\"]\n[text* tel-352 class:col-md-12 placeholder \"Telefone\"]\n[text* cep class:col-md-12 placeholder \"CEP\"]\n[text* MarcaModelo class:col-md-12 placeholder \"Marca/Modelo\"]\n[text* Ano class:col-md-12 placeholder \"Ano do veículo\"]\n\n[submit \"Fazer Cotação\"]'),(154,69,'_mail','a:8:{s:7:\"subject\";s:47:\"[your-name] Facil Auto Proteção [MarcaModelo]\";s:6:\"sender\";s:41:\"[your-name] <wordpress@linhafacil.com.br>\";s:4:\"body\";s:271:\"De: [your-name] <[your-email]>\nAssunto: [your-subject]\n\nCorpo da mensagem:\n[your-name]\n[your-email]\n[tel-352]\n[cep]\n[MarcaModelo]\n[Ano]\n--\nEste e-mail foi enviado de um formulário de contato em Facil Auto Prote&ccedil;&atilde;o Veicular (http://www.linhafacil.com.br/v2)\";s:9:\"recipient\";s:29:\"marketinglinhafacil@gmail.com\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}'),(155,69,'_mail_2','a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:47:\"Facil Auto Proteção Veicular \"[your-subject]\"\";s:6:\"sender\";s:60:\"Facil Auto Proteção Veicular <wordpress@linhafacil.com.br>\";s:4:\"body\";s:170:\"Corpo da mensagem:\n[your-message]\n\n--\nEste e-mail foi enviado de um formulário de contato em Facil Auto Prote&ccedil;&atilde;o Veicular (http://www.linhafacil.com.br/v2)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:39:\"Reply-To: marketinglinhafacil@gmail.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}'),(156,69,'_messages','a:23:{s:12:\"mail_sent_ok\";s:24:\"Recebemos sua cotação.\";s:12:\"mail_sent_ng\";s:85:\"Ocorreu um erro ao tentar enviar sua mensagem. Por favor, tente novamente mais tarde.\";s:16:\"validation_error\";s:73:\"Um ou mais campos possuem um erro. Por favor verifique e tente novamente.\";s:4:\"spam\";s:85:\"Ocorreu um erro ao tentar enviar sua mensagem. Por favor, tente novamente mais tarde.\";s:12:\"accept_terms\";s:72:\"Você deve aceitar os termos e condições antes de enviar sua mensagem.\";s:16:\"invalid_required\";s:24:\"O campo é obrigatório.\";s:16:\"invalid_too_long\";s:23:\"O campo é muito longo.\";s:17:\"invalid_too_short\";s:23:\"O campo é muito curto.\";s:12:\"invalid_date\";s:34:\"O formato de data está incorreto.\";s:14:\"date_too_early\";s:44:\"A data é anterior à mais antiga permitida.\";s:13:\"date_too_late\";s:44:\"A data é posterior à maior data permitida.\";s:13:\"upload_failed\";s:49:\"Ocorreu um erro desconhecido ao enviar o arquivo.\";s:24:\"upload_file_type_invalid\";s:59:\"Você não tem permissão para enviar esse tipo de arquivo.\";s:21:\"upload_file_too_large\";s:26:\"O arquivo é muito grande.\";s:23:\"upload_failed_php_error\";s:36:\"Ocorreu um erro ao enviar o arquivo.\";s:14:\"invalid_number\";s:34:\"O formato de número é inválido.\";s:16:\"number_too_small\";s:46:\"O número é menor do que o mínimo permitido.\";s:16:\"number_too_large\";s:46:\"O número é maior do que o máximo permitido.\";s:23:\"quiz_answer_not_correct\";s:39:\"A resposta para o quiz está incorreta.\";s:17:\"captcha_not_match\";s:35:\"O código digitado está incorreto.\";s:13:\"invalid_email\";s:44:\"O endereço de email informado é inválido.\";s:11:\"invalid_url\";s:19:\"A URL é inválida.\";s:11:\"invalid_tel\";s:35:\"O número de telefone é inválido.\";}'),(157,69,'_additional_settings',''),(158,69,'_locale','pt_BR'),(2055,69,'_config_errors','a:1:{s:23:\"mail.additional_headers\";a:1:{i:0;a:2:{s:4:\"code\";i:102;s:4:\"args\";a:3:{s:7:\"message\";s:37:\"O valor do campo %name% é inválido.\";s:6:\"params\";a:1:{s:4:\"name\";s:8:\"Reply-To\";}s:4:\"link\";s:90:\"http://contactform7.com/configuration-errors/#mail.additional_headers:error_invalid_syntax\";}}}}'),(160,66,'texto_diferenciado','Veja como é fácil se associar.'),(161,66,'_texto_diferenciado','field_58862a7dd9d12'),(162,70,'texto_diferenciado',''),(163,70,'_texto_diferenciado','field_58862a7dd9d12'),(173,73,'_wp_attached_file','2017/01/banner-mid.jpg'),(171,72,'texto_diferenciado','Veja como é fácil se associar'),(167,71,'texto_diferenciado','Tenha nossa Proteção veicular preencha este pequeno formulário e entraremos em contato'),(168,71,'_texto_diferenciado','field_58862a7dd9d12'),(172,72,'_texto_diferenciado','field_58862a7dd9d12'),(174,73,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:2280;s:6:\"height\";i:1000;s:4:\"file\";s:22:\"2017/01/banner-mid.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"banner-mid-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"banner-mid-300x132.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:132;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"banner-mid-768x337.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"banner-mid-1024x449.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:449;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(2181,227,'accordion',''),(2176,227,'_imagem_principal','field_58860ca42f9e3'),(213,78,'_edit_lock','1485809098:1'),(194,35,'_edit_lock','1485268589:2'),(2168,225,'link',''),(2169,225,'_link','field_5886118f0934c'),(2170,225,'texto_diferenciado',''),(2171,225,'_texto_diferenciado','field_58862a7dd9d12'),(2172,225,'accordion',''),(2173,225,'_accordion','field_588f7627cb9cd'),(2167,225,'_imagem_principal','field_58860ca42f9e3'),(2166,225,'imagem_principal',''),(212,78,'_edit_last','1'),(214,81,'_edit_last','1'),(215,81,'_edit_lock','1486072915:1'),(216,81,'_yoast_wpseo_content_score','30'),(217,81,'acordions',''),(218,81,'_acordions','field_5887501a480ec'),(219,82,'acordions',''),(220,82,'_acordions','field_5887501a480ec'),(1253,193,'_accordion','field_588f7627cb9cd'),(1252,193,'accordion','1'),(1251,193,'_texto_diferenciado','field_58862a7dd9d12'),(1250,193,'texto_diferenciado','Regulamento de Motos'),(1423,195,'accordion_0_itm_txt_0_texto_heading','REGULAMENTO DO PROGRAMA DE PROTEÇÃO DE MOTOCICLETAS – GASP'),(1422,195,'_texto_diferenciado','field_58862a7dd9d12'),(1421,195,'texto_diferenciado','Regulamento de Motos'),(1420,195,'_acordions','field_5887501a480ec'),(1419,195,'acordions',''),(235,84,'acordions','3'),(236,84,'_acordions','field_5887501a480ec'),(237,84,'acordions_0_conteudo','TEste TESTeSTes\r\n\r\nTESt\r\n\r\nTESte'),(238,84,'_acordions_0_conteudo','field_58875065480ef'),(239,84,'acordions_1_conteudo','TEste\r\n\r\nTEste\r\n\r\nTESte'),(240,84,'_acordions_1_conteudo','field_58875065480ef'),(241,84,'acordions_2_conteudo',''),(242,84,'_acordions_2_conteudo','field_58875065480ef'),(243,85,'_edit_last','1'),(244,85,'_edit_lock','1485823608:1'),(245,85,'_yoast_wpseo_content_score','30'),(246,85,'acordions',''),(247,85,'_acordions','field_5887501a480ec'),(248,86,'acordions',''),(249,86,'_acordions','field_5887501a480ec'),(250,87,'_edit_last','2'),(251,87,'_edit_lock','1485270126:2'),(268,92,'_edit_last','1'),(253,87,'_yoast_wpseo_content_score','30'),(254,87,'texto_diferenciado','Se perder a chave do seu veículo ou deixá-la dentro dele trancado, conte com serviço de chaveiro 24 horas para socorrê-lo.'),(255,87,'_texto_diferenciado','field_58862a7dd9d12'),(256,88,'texto_diferenciado',''),(257,88,'_texto_diferenciado','field_58862a7dd9d12'),(258,87,'_yoast_wpseo_primary_category','6'),(260,89,'texto_diferenciado',''),(261,89,'_texto_diferenciado','field_58862a7dd9d12'),(263,90,'texto_diferenciado','Logens longes longes lorenss'),(264,90,'_texto_diferenciado','field_58862a7dd9d12'),(266,91,'texto_diferenciado','@:Lorem ipsum dolor sit amet, consectetur adipisicing elit.'),(267,91,'_texto_diferenciado','field_58862a7dd9d12'),(269,92,'_edit_lock','1487696876:1'),(270,93,'_wp_attached_file','2017/01/3d.png'),(271,93,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:1151;s:6:\"height\";i:202;s:4:\"file\";s:14:\"2017/01/3d.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"3d-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"3d-300x53.png\";s:5:\"width\";i:300;s:6:\"height\";i:53;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:14:\"3d-768x135.png\";s:5:\"width\";i:768;s:6:\"height\";i:135;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:15:\"3d-1024x180.png\";s:5:\"width\";i:1024;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(272,92,'_thumbnail_id','222'),(280,95,'_menu_item_type','taxonomy'),(274,92,'_yoast_wpseo_content_score','60'),(275,92,'texto_diferenciado',''),(276,92,'_texto_diferenciado','field_58862a7dd9d12'),(277,94,'texto_diferenciado',''),(278,94,'_texto_diferenciado','field_58862a7dd9d12'),(279,92,'_yoast_wpseo_primary_category','12'),(281,95,'_menu_item_menu_item_parent','0'),(282,95,'_menu_item_object_id','12'),(283,95,'_menu_item_object','category'),(284,95,'_menu_item_target',''),(285,95,'_menu_item_classes','a:1:{i:0;s:0:\"\";}'),(286,95,'_menu_item_xfn',''),(287,95,'_menu_item_url',''),(295,100,'_wp_attached_file','2017/01/guy-top-2.png'),(290,96,'texto_diferenciado',''),(291,96,'_texto_diferenciado','field_58862a7dd9d12'),(293,97,'texto_diferenciado',''),(294,97,'_texto_diferenciado','field_58862a7dd9d12'),(296,100,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:359;s:6:\"height\";i:629;s:4:\"file\";s:21:\"2017/01/guy-top-2.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"guy-top-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"guy-top-2-171x300.png\";s:5:\"width\";i:171;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(311,104,'texto_diferenciado','Se você perder a chave do seu veículo ou eventualmente, deixá-la dentro dele trancado, disponibilizamos o serviço de chaveiro 24 horas para socorrê-lo.'),(298,101,'imagem_principal','100'),(299,101,'_imagem_principal','field_58860ca42f9e3'),(300,101,'link',''),(301,101,'_link','field_5886118f0934c'),(302,101,'texto_diferenciado',''),(303,101,'_texto_diferenciado','field_58862a7dd9d12'),(333,109,'texto_diferenciado','Se perder a chave do seu veículo ou deixá-la dentro dele trancado, conte com serviço de chaveiro 24 horas para socorrê-lo.'),(305,102,'texto_diferenciado','Se você perder a chave do seu veículo ou eventualmente, distrair-se e deixá-la dentro do veículo trancado, disponibilizamos o serviço de chaveiro 24 horas para socorrê-lo.'),(306,102,'_texto_diferenciado','field_58862a7dd9d12'),(308,103,'texto_diferenciado','Se você perder a chave do seu veículo ou eventualmente, distrair-se e deixá-la dentro dele trancado, disponibilizamos o serviço de chaveiro 24 horas para socorrê-lo.'),(309,103,'_texto_diferenciado','field_58862a7dd9d12'),(312,104,'_texto_diferenciado','field_58862a7dd9d12'),(314,35,'_aioseop_opengraph_settings','a:13:{s:32:\"aioseop_opengraph_settings_title\";s:0:\"\";s:31:\"aioseop_opengraph_settings_desc\";s:0:\"\";s:36:\"aioseop_opengraph_settings_customimg\";s:0:\"\";s:37:\"aioseop_opengraph_settings_imagewidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_imageheight\";s:0:\"\";s:32:\"aioseop_opengraph_settings_video\";s:0:\"\";s:37:\"aioseop_opengraph_settings_videowidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_videoheight\";s:0:\"\";s:35:\"aioseop_opengraph_settings_category\";s:8:\"activity\";s:34:\"aioseop_opengraph_settings_section\";s:0:\"\";s:30:\"aioseop_opengraph_settings_tag\";s:0:\"\";s:34:\"aioseop_opengraph_settings_setcard\";s:7:\"summary\";s:44:\"aioseop_opengraph_settings_customimg_twitter\";s:0:\"\";}'),(315,35,'_disabel_wpdevart_facebook_comment','enable'),(316,105,'texto_diferenciado','Enquanto resolvemos seu sinistro, oferecemos um veículo extra para você usar, durante o conserto do seu veículo.'),(317,105,'_texto_diferenciado','field_58862a7dd9d12'),(320,40,'_aioseop_opengraph_settings','a:13:{s:32:\"aioseop_opengraph_settings_title\";s:0:\"\";s:31:\"aioseop_opengraph_settings_desc\";s:0:\"\";s:36:\"aioseop_opengraph_settings_customimg\";s:0:\"\";s:37:\"aioseop_opengraph_settings_imagewidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_imageheight\";s:0:\"\";s:32:\"aioseop_opengraph_settings_video\";s:0:\"\";s:37:\"aioseop_opengraph_settings_videowidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_videoheight\";s:0:\"\";s:35:\"aioseop_opengraph_settings_category\";s:8:\"activity\";s:34:\"aioseop_opengraph_settings_section\";s:0:\"\";s:30:\"aioseop_opengraph_settings_tag\";s:0:\"\";s:34:\"aioseop_opengraph_settings_setcard\";s:7:\"summary\";s:44:\"aioseop_opengraph_settings_customimg_twitter\";s:0:\"\";}'),(321,40,'_disabel_wpdevart_facebook_comment','enable'),(328,108,'texto_diferenciado','Orientações e auxílio nas atividades extrajudiciais relacionadas a sua proteção veicular, sem custos adicionais.'),(322,106,'texto_diferenciado','Nosso associado conta com assistência jurídica que orienta e auxilia nas atividades extrajudiciais relacionadas a sua proteção veicular, sem custos adicionais.'),(323,106,'_texto_diferenciado','field_58862a7dd9d12'),(325,107,'texto_diferenciado','Nosso associado conta com assistência jurídica que orienta e auxilia nas atividades extrajudiciais relacionadas a sua proteção veicular, sem custos adicionais.'),(326,107,'_texto_diferenciado','field_58862a7dd9d12'),(329,108,'_texto_diferenciado','field_58862a7dd9d12'),(331,87,'_aioseop_opengraph_settings','a:13:{s:32:\"aioseop_opengraph_settings_title\";s:0:\"\";s:31:\"aioseop_opengraph_settings_desc\";s:0:\"\";s:36:\"aioseop_opengraph_settings_customimg\";s:0:\"\";s:37:\"aioseop_opengraph_settings_imagewidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_imageheight\";s:0:\"\";s:32:\"aioseop_opengraph_settings_video\";s:0:\"\";s:37:\"aioseop_opengraph_settings_videowidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_videoheight\";s:0:\"\";s:35:\"aioseop_opengraph_settings_category\";s:8:\"activity\";s:34:\"aioseop_opengraph_settings_section\";s:0:\"\";s:30:\"aioseop_opengraph_settings_tag\";s:0:\"\";s:34:\"aioseop_opengraph_settings_setcard\";s:7:\"summary\";s:44:\"aioseop_opengraph_settings_customimg_twitter\";s:0:\"\";}'),(332,87,'_disabel_wpdevart_facebook_comment','enable'),(334,109,'_texto_diferenciado','field_58862a7dd9d12'),(335,110,'_edit_lock','1485362711:1'),(336,110,'_edit_last','1'),(340,110,'texto_diferenciado','Garanta proteção total para seu veículo, inclusive para o seu estepe. Ganhe um novo, em caso de furto ou roubo.'),(338,110,'_aioseop_opengraph_settings','a:13:{s:32:\"aioseop_opengraph_settings_title\";s:0:\"\";s:31:\"aioseop_opengraph_settings_desc\";s:0:\"\";s:36:\"aioseop_opengraph_settings_customimg\";s:0:\"\";s:37:\"aioseop_opengraph_settings_imagewidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_imageheight\";s:0:\"\";s:32:\"aioseop_opengraph_settings_video\";s:0:\"\";s:37:\"aioseop_opengraph_settings_videowidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_videoheight\";s:0:\"\";s:35:\"aioseop_opengraph_settings_category\";s:8:\"activity\";s:34:\"aioseop_opengraph_settings_section\";s:0:\"\";s:30:\"aioseop_opengraph_settings_tag\";s:0:\"\";s:34:\"aioseop_opengraph_settings_setcard\";s:7:\"summary\";s:44:\"aioseop_opengraph_settings_customimg_twitter\";s:0:\"\";}'),(339,110,'_disabel_wpdevart_facebook_comment','disable'),(341,110,'_texto_diferenciado','field_58862a7dd9d12'),(342,111,'texto_diferenciado','Garanta proteção total para seu veículo, inclusive para o seu estepe. Ganhe um novo, em caso de furto ou roubo.'),(343,111,'_texto_diferenciado','field_58862a7dd9d12'),(649,172,'_aioseop_opengraph_settings','a:13:{s:32:\"aioseop_opengraph_settings_title\";s:0:\"\";s:31:\"aioseop_opengraph_settings_desc\";s:0:\"\";s:36:\"aioseop_opengraph_settings_customimg\";s:0:\"\";s:37:\"aioseop_opengraph_settings_imagewidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_imageheight\";s:0:\"\";s:32:\"aioseop_opengraph_settings_video\";s:0:\"\";s:37:\"aioseop_opengraph_settings_videowidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_videoheight\";s:0:\"\";s:35:\"aioseop_opengraph_settings_category\";s:8:\"activity\";s:34:\"aioseop_opengraph_settings_section\";s:0:\"\";s:30:\"aioseop_opengraph_settings_tag\";s:0:\"\";s:34:\"aioseop_opengraph_settings_setcard\";s:7:\"summary\";s:44:\"aioseop_opengraph_settings_customimg_twitter\";s:0:\"\";}'),(2144,172,'_aioseop_title','Vantagens e desvantagens '),(658,172,'texto_diferenciado',''),(645,172,'_edit_lock','1487682356:1'),(646,172,'_edit_last','1'),(643,110,'_at_widget','1'),(373,115,'_menu_item_object_id','115'),(353,113,'_menu_item_type','post_type'),(354,113,'_menu_item_menu_item_parent','166'),(355,113,'_menu_item_object_id','85'),(356,113,'_menu_item_object','page'),(357,113,'_menu_item_target',''),(358,113,'_menu_item_classes','a:1:{i:0;s:0:\"\";}'),(359,113,'_menu_item_xfn',''),(360,113,'_menu_item_url',''),(372,115,'_menu_item_menu_item_parent','0'),(362,114,'_menu_item_type','post_type'),(363,114,'_menu_item_menu_item_parent','166'),(364,114,'_menu_item_object_id','81'),(365,114,'_menu_item_object','page'),(366,114,'_menu_item_target',''),(367,114,'_menu_item_classes','a:1:{i:0;s:0:\"\";}'),(368,114,'_menu_item_xfn',''),(369,114,'_menu_item_url',''),(371,115,'_menu_item_type','custom'),(374,115,'_menu_item_object','custom'),(375,115,'_menu_item_target',''),(376,115,'_menu_item_classes','a:1:{i:0;s:0:\"\";}'),(377,115,'_menu_item_xfn',''),(378,115,'_menu_item_url','http://www.linhafacil.com.br'),(380,116,'_menu_item_type','custom'),(381,116,'_menu_item_menu_item_parent','0'),(382,116,'_menu_item_object_id','116'),(383,116,'_menu_item_object','custom'),(384,116,'_menu_item_target',''),(385,116,'_menu_item_classes','a:1:{i:0;s:0:\"\";}'),(386,116,'_menu_item_xfn',''),(387,116,'_menu_item_url','#'),(391,14,'_disabel_wpdevart_facebook_comment','enable'),(400,118,'imagem_principal','100'),(401,118,'_imagem_principal','field_58860ca42f9e3'),(402,118,'link',''),(403,118,'_link','field_5886118f0934c'),(404,118,'texto_diferenciado',''),(405,118,'_texto_diferenciado','field_58862a7dd9d12'),(522,138,'imagem_principal','100'),(392,117,'imagem_principal','100'),(393,117,'_imagem_principal','field_58860ca42f9e3'),(394,117,'link',''),(395,117,'_link','field_5886118f0934c'),(396,117,'texto_diferenciado','Somos uma associação de benefícios, que conta com profissionais com larga experiência de mercado! Nossa Matriz está localizada em Belo Horizonte e temos diversas Unidades por todo o território brasileiro! Mais do que experiência, temos compromisso com todos aqueles que confiam em nossa gestão e na força do mutualismo para o alcance de nossos objetivos. Temos como compromisso a busca por melhorias contínuas dos serviços aos nossos associados, tudo para tornar sua vida mais Fácil!'),(397,117,'_texto_diferenciado','field_58862a7dd9d12'),(515,137,'imagem_principal','100'),(516,137,'_imagem_principal','field_58860ca42f9e3'),(517,137,'link',''),(518,137,'_link','field_5886118f0934c'),(519,137,'texto_diferenciado',''),(520,137,'_texto_diferenciado','field_58862a7dd9d12'),(508,136,'imagem_principal','100'),(509,136,'_imagem_principal','field_58860ca42f9e3'),(408,119,'imagem_principal','100'),(409,119,'_imagem_principal','field_58860ca42f9e3'),(410,119,'link',''),(411,119,'_link','field_5886118f0934c'),(412,119,'texto_diferenciado','Somos uma associação de benefícios, que conta com profissionais com larga experiência de mercado! Nossa Matriz está localizada em Belo Horizonte e temos diversas Unidades por todo o território brasileiro! Mais do que experiência, temos compromisso com todos aqueles que confiam em nossa gestão e na força do mutualismo para o alcance de nossos objetivos. Temos como compromisso a busca por melhorias contínuas dos serviços aos nossos associados, tudo para tornar sua vida mais Fácil!'),(413,119,'_texto_diferenciado','field_58862a7dd9d12'),(415,120,'imagem_principal','100'),(416,120,'_imagem_principal','field_58860ca42f9e3'),(417,120,'link',''),(418,120,'_link','field_5886118f0934c'),(419,120,'texto_diferenciado','Somos uma associação de benefícios, que conta com profissionais com larga experiência de mercado! Nossa Matriz está localizada em Belo Horizonte e temos diversas Unidades por todo o território brasileiro! Mais do que experiência, temos compromisso com todos aqueles que confiam em nossa gestão e na força do mutualismo para o alcance de nossos objetivos. Temos como compromisso a busca por melhorias contínuas dos serviços aos nossos associados, tudo para tornar sua vida mais Fácil!'),(420,120,'_texto_diferenciado','field_58862a7dd9d12'),(422,121,'imagem_principal','100'),(423,121,'_imagem_principal','field_58860ca42f9e3'),(424,121,'link',''),(425,121,'_link','field_5886118f0934c'),(426,121,'texto_diferenciado','Somos uma associação de benefícios, que conta com profissionais com larga experiência de mercado! Nossa Matriz está localizada em Belo Horizonte e temos diversas Unidades por todo o território brasileiro! Mais do que experiência, temos compromisso com todos aqueles que confiam em nossa gestão e na força do mutualismo para o alcance de nossos objetivos. Temos como compromisso a busca por melhorias contínuas dos serviços aos nossos associados, tudo para tornar sua vida mais Fácil!'),(427,121,'_texto_diferenciado','field_58862a7dd9d12'),(428,122,'_edit_lock','1485296915:1'),(429,122,'_edit_last','1'),(430,122,'_at_widget','1'),(431,122,'form_identifier','contato_site_principal'),(432,122,'token_rdstation','9557f108cf96bab204f9465da579838c'),(433,122,'form_id','69'),(435,14,'_rdscriptcontenttop',''),(436,14,'_rdscriptcontentbottom',''),(437,14,'_rdscriptcontentinhead',''),(438,14,'_rdscriptcontentinfooter',''),(441,123,'imagem_principal','100'),(442,123,'_imagem_principal','field_58860ca42f9e3'),(443,123,'link',''),(444,123,'_link','field_5886118f0934c'),(445,123,'texto_diferenciado','Somos uma associação de benefícios, que conta com profissionais com larga experiência de mercado! Nossa Matriz está localizada em Belo Horizonte e temos diversas Unidades por todo o território brasileiro! Mais do que experiência, temos compromisso com todos aqueles que confiam em nossa gestão e na força do mutualismo para o alcance de nossos objetivos. Temos como compromisso a busca por melhorias contínuas dos serviços aos nossos associados, tudo para tornar sua vida mais Fácil!'),(446,123,'_texto_diferenciado','field_58862a7dd9d12'),(448,124,'imagem_principal','100'),(449,124,'_imagem_principal','field_58860ca42f9e3'),(450,124,'link',''),(451,124,'_link','field_5886118f0934c'),(452,124,'texto_diferenciado','Somos uma associação de benefícios, que conta com profissionais com larga experiência de mercado, cuja matriz está localizada em Belo Horizonte/MG, dispondo de diversas unidades por todo o território nacional.  Mais do que experiência, temos compromisso com todos aqueles que confiam em nossa gestão e na força do mutualismo para o alcance de nossos objetivos, sempre na busca por melhorias contínuas dos serviços aos nossos associados, tudo para tornar sua vida mais Fácil!'),(453,124,'_texto_diferenciado','field_58862a7dd9d12'),(455,125,'imagem_principal','100'),(456,125,'_imagem_principal','field_58860ca42f9e3'),(457,125,'link',''),(458,125,'_link','field_5886118f0934c'),(459,125,'texto_diferenciado','Somos uma associação de benefícios, que conta com profissionais com larga experiência de mercado, cuja matriz está localizada em Belo Horizonte/MG, dispondo de diversas unidades por todo o território nacional.  Mais do que experiência, temos compromisso com todos aqueles que confiam em nossa gestão e na força do mutualismo para o alcance de nossos objetivos, sempre na busca por melhorias contínuas dos serviços aos nossos associados, tudo para tornar sua vida mais Fácil!'),(460,125,'_texto_diferenciado','field_58862a7dd9d12'),(2180,227,'_texto_diferenciado','field_58862a7dd9d12'),(2179,227,'texto_diferenciado',''),(2178,227,'_link','field_5886118f0934c'),(2175,227,'imagem_principal',''),(475,128,'texto_diferenciado','Veja como é fácil se associar'),(468,66,'_aioseop_opengraph_settings','a:13:{s:32:\"aioseop_opengraph_settings_title\";s:0:\"\";s:31:\"aioseop_opengraph_settings_desc\";s:0:\"\";s:36:\"aioseop_opengraph_settings_customimg\";s:0:\"\";s:37:\"aioseop_opengraph_settings_imagewidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_imageheight\";s:0:\"\";s:32:\"aioseop_opengraph_settings_video\";s:0:\"\";s:37:\"aioseop_opengraph_settings_videowidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_videoheight\";s:0:\"\";s:35:\"aioseop_opengraph_settings_category\";s:8:\"activity\";s:34:\"aioseop_opengraph_settings_section\";s:0:\"\";s:30:\"aioseop_opengraph_settings_tag\";s:0:\"\";s:34:\"aioseop_opengraph_settings_setcard\";s:7:\"summary\";s:44:\"aioseop_opengraph_settings_customimg_twitter\";s:0:\"\";}'),(469,66,'_disabel_wpdevart_facebook_comment','disable'),(470,66,'_rdscriptcontenttop',''),(471,66,'_rdscriptcontentbottom',''),(472,66,'_rdscriptcontentinhead',''),(473,66,'_rdscriptcontentinfooter',''),(474,66,'_at_widget','1'),(476,128,'_texto_diferenciado','field_58862a7dd9d12'),(478,129,'texto_diferenciado','Veja como é fácil se associar'),(479,129,'_texto_diferenciado','field_58862a7dd9d12'),(481,130,'_edit_lock','1487679817:1'),(482,130,'_edit_last','1'),(483,130,'_aioseop_opengraph_settings','a:13:{s:32:\"aioseop_opengraph_settings_title\";s:0:\"\";s:31:\"aioseop_opengraph_settings_desc\";s:0:\"\";s:36:\"aioseop_opengraph_settings_customimg\";s:0:\"\";s:37:\"aioseop_opengraph_settings_imagewidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_imageheight\";s:0:\"\";s:32:\"aioseop_opengraph_settings_video\";s:0:\"\";s:37:\"aioseop_opengraph_settings_videowidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_videoheight\";s:0:\"\";s:35:\"aioseop_opengraph_settings_category\";s:8:\"activity\";s:34:\"aioseop_opengraph_settings_section\";s:0:\"\";s:30:\"aioseop_opengraph_settings_tag\";s:0:\"\";s:34:\"aioseop_opengraph_settings_setcard\";s:7:\"summary\";s:44:\"aioseop_opengraph_settings_customimg_twitter\";s:0:\"\";}'),(484,131,'acordions',''),(485,131,'_acordions','field_5887501a480ec'),(486,130,'_disabel_wpdevart_facebook_comment','disable'),(487,130,'_rdscriptcontenttop',''),(488,130,'_rdscriptcontentbottom',''),(489,130,'_rdscriptcontentinhead',''),(490,130,'_rdscriptcontentinfooter',''),(491,130,'_at_widget','1'),(492,130,'acordions',''),(493,130,'_acordions','field_5887501a480ec'),(494,132,'acordions',''),(495,132,'_acordions','field_5887501a480ec'),(496,133,'acordions',''),(497,133,'_acordions','field_5887501a480ec'),(498,134,'acordions',''),(499,134,'_acordions','field_5887501a480ec'),(501,135,'imagem_principal','100'),(502,135,'_imagem_principal','field_58860ca42f9e3'),(503,135,'link',''),(504,135,'_link','field_5886118f0934c'),(505,135,'texto_diferenciado','Somos uma associação de benefícios, que conta com profissionais com larga experiência de mercado, cuja matriz está localizada em Belo Horizonte/MG, dispondo de diversas unidades por todo o território nacional.  Mais do que experiência, temos compromisso com todos aqueles que confiam em nossa gestão e na força do mutualismo para o alcance de nossos objetivos, sempre na busca por melhorias contínuas dos serviços aos nossos associados, tudo para tornar sua vida mais Fácil!'),(506,135,'_texto_diferenciado','field_58862a7dd9d12'),(510,136,'link',''),(511,136,'_link','field_5886118f0934c'),(512,136,'texto_diferenciado','É um plano de proteção veicular oferecido pela Linha Fácil que oferece proteção e segurança aos veículos de seus associados aderentes ao programa, através do rateio dos danos materiais eventualmente sofridos e acobertados pelo programa, bem como através da prevenção ativa de acidentes, pela veiculação de material educativo pertinente às normas de segurança no trânsito.'),(513,136,'_texto_diferenciado','field_58862a7dd9d12'),(523,138,'_imagem_principal','field_58860ca42f9e3'),(524,138,'link',''),(525,138,'_link','field_5886118f0934c'),(526,138,'texto_diferenciado',''),(527,138,'_texto_diferenciado','field_58862a7dd9d12'),(529,139,'imagem_principal','100'),(530,139,'_imagem_principal','field_58860ca42f9e3'),(531,139,'link',''),(532,139,'_link','field_5886118f0934c'),(533,139,'texto_diferenciado',''),(534,139,'_texto_diferenciado','field_58862a7dd9d12'),(536,140,'texto_diferenciado','Veja como é fácil se associar.'),(537,140,'_texto_diferenciado','field_58862a7dd9d12'),(538,141,'_edit_last','1'),(539,141,'_aioseop_opengraph_settings','a:13:{s:32:\"aioseop_opengraph_settings_title\";s:0:\"\";s:31:\"aioseop_opengraph_settings_desc\";s:0:\"\";s:36:\"aioseop_opengraph_settings_customimg\";s:0:\"\";s:37:\"aioseop_opengraph_settings_imagewidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_imageheight\";s:0:\"\";s:32:\"aioseop_opengraph_settings_video\";s:0:\"\";s:37:\"aioseop_opengraph_settings_videowidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_videoheight\";s:0:\"\";s:35:\"aioseop_opengraph_settings_category\";s:8:\"activity\";s:34:\"aioseop_opengraph_settings_section\";s:0:\"\";s:30:\"aioseop_opengraph_settings_tag\";s:0:\"\";s:34:\"aioseop_opengraph_settings_setcard\";s:7:\"summary\";s:44:\"aioseop_opengraph_settings_customimg_twitter\";s:0:\"\";}'),(540,142,'acordions',''),(541,142,'_acordions','field_5887501a480ec'),(542,141,'_disabel_wpdevart_facebook_comment','disable'),(543,141,'_rdscriptcontenttop',''),(544,141,'_rdscriptcontentbottom',''),(545,141,'_rdscriptcontentinhead',''),(546,141,'_rdscriptcontentinfooter',''),(547,141,'_at_widget','1'),(548,141,'_edit_lock','1485361248:1'),(549,143,'acordions',''),(550,143,'_acordions','field_5887501a480ec'),(551,144,'acordions',''),(552,144,'_acordions','field_5887501a480ec'),(553,145,'acordions',''),(554,145,'_acordions','field_5887501a480ec'),(555,146,'acordions',''),(556,146,'_acordions','field_5887501a480ec'),(557,147,'acordions',''),(558,147,'_acordions','field_5887501a480ec'),(559,148,'acordions',''),(560,148,'_acordions','field_5887501a480ec'),(561,149,'acordions',''),(562,149,'_acordions','field_5887501a480ec'),(563,150,'acordions',''),(564,150,'_acordions','field_5887501a480ec'),(565,141,'acordions',''),(566,141,'_acordions','field_5887501a480ec'),(567,151,'acordions',''),(568,151,'_acordions','field_5887501a480ec'),(569,152,'acordions',''),(570,152,'_acordions','field_5887501a480ec'),(571,153,'acordions',''),(572,153,'_acordions','field_5887501a480ec'),(573,154,'acordions',''),(574,154,'_acordions','field_5887501a480ec'),(575,155,'acordions',''),(576,155,'_acordions','field_5887501a480ec'),(577,156,'acordions',''),(578,156,'_acordions','field_5887501a480ec'),(579,157,'_edit_lock','1485815366:1'),(580,157,'_edit_last','1'),(581,157,'_aioseop_opengraph_settings','a:13:{s:32:\"aioseop_opengraph_settings_title\";s:0:\"\";s:31:\"aioseop_opengraph_settings_desc\";s:0:\"\";s:36:\"aioseop_opengraph_settings_customimg\";s:0:\"\";s:37:\"aioseop_opengraph_settings_imagewidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_imageheight\";s:0:\"\";s:32:\"aioseop_opengraph_settings_video\";s:0:\"\";s:37:\"aioseop_opengraph_settings_videowidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_videoheight\";s:0:\"\";s:35:\"aioseop_opengraph_settings_category\";s:8:\"activity\";s:34:\"aioseop_opengraph_settings_section\";s:0:\"\";s:30:\"aioseop_opengraph_settings_tag\";s:0:\"\";s:34:\"aioseop_opengraph_settings_setcard\";s:7:\"summary\";s:44:\"aioseop_opengraph_settings_customimg_twitter\";s:0:\"\";}'),(582,157,'_disabel_wpdevart_facebook_comment','disable'),(583,157,'_rdscriptcontenttop',''),(584,157,'_rdscriptcontentbottom',''),(585,157,'_rdscriptcontentinhead',''),(586,157,'_rdscriptcontentinfooter',''),(587,157,'_at_widget','1'),(588,157,'acordions',''),(589,157,'_acordions','field_5887501a480ec'),(590,158,'acordions',''),(591,158,'_acordions','field_5887501a480ec'),(2023,210,'_imagem_principal','field_58860ca42f9e3'),(594,161,'_edit_lock','1485355471:1'),(595,161,'_edit_last','1'),(2024,210,'link',''),(597,164,'_menu_item_type','post_type'),(598,164,'_menu_item_menu_item_parent','0'),(599,164,'_menu_item_object_id','157'),(600,164,'_menu_item_object','page'),(601,164,'_menu_item_target',''),(602,164,'_menu_item_classes','a:1:{i:0;s:0:\"\";}'),(603,164,'_menu_item_xfn',''),(604,164,'_menu_item_url',''),(606,165,'_menu_item_type','post_type'),(607,165,'_menu_item_menu_item_parent','0'),(608,165,'_menu_item_object_id','141'),(609,165,'_menu_item_object','page'),(610,165,'_menu_item_target',''),(611,165,'_menu_item_classes','a:1:{i:0;s:0:\"\";}'),(612,165,'_menu_item_xfn',''),(613,165,'_menu_item_url',''),(615,166,'_menu_item_type','custom'),(616,166,'_menu_item_menu_item_parent','0'),(617,166,'_menu_item_object_id','166'),(618,166,'_menu_item_object','custom'),(619,166,'_menu_item_target',''),(620,166,'_menu_item_classes','a:1:{i:0;s:0:\"\";}'),(621,166,'_menu_item_xfn',''),(622,166,'_menu_item_url','#'),(651,172,'_disabel_wpdevart_facebook_comment','enable'),(652,172,'_rdscriptcontenttop',''),(653,172,'_rdscriptcontentbottom',''),(654,172,'_rdscriptcontentinhead',''),(655,172,'_rdscriptcontentinfooter',''),(656,172,'_at_widget','1'),(659,172,'_texto_diferenciado','field_58862a7dd9d12'),(660,173,'texto_diferenciado',''),(661,173,'_texto_diferenciado','field_58862a7dd9d12'),(667,174,'texto_diferenciado',''),(668,174,'_texto_diferenciado','field_58862a7dd9d12'),(670,175,'_edit_lock','1487681918:1'),(671,175,'_edit_last','1'),(683,175,'texto_diferenciado',''),(2110,175,'_aioseop_title','Proteção e não o seguro.'),(674,175,'_aioseop_opengraph_settings','a:13:{s:32:\"aioseop_opengraph_settings_title\";s:0:\"\";s:31:\"aioseop_opengraph_settings_desc\";s:0:\"\";s:36:\"aioseop_opengraph_settings_customimg\";s:0:\"\";s:37:\"aioseop_opengraph_settings_imagewidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_imageheight\";s:0:\"\";s:32:\"aioseop_opengraph_settings_video\";s:0:\"\";s:37:\"aioseop_opengraph_settings_videowidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_videoheight\";s:0:\"\";s:35:\"aioseop_opengraph_settings_category\";s:8:\"activity\";s:34:\"aioseop_opengraph_settings_section\";s:0:\"\";s:30:\"aioseop_opengraph_settings_tag\";s:0:\"\";s:34:\"aioseop_opengraph_settings_setcard\";s:7:\"summary\";s:44:\"aioseop_opengraph_settings_customimg_twitter\";s:0:\"\";}'),(676,175,'_disabel_wpdevart_facebook_comment','enable'),(677,175,'_rdscriptcontenttop',''),(678,175,'_rdscriptcontentbottom',''),(679,175,'_rdscriptcontentinhead',''),(680,175,'_rdscriptcontentinfooter',''),(681,175,'_at_widget','1'),(684,175,'_texto_diferenciado','field_58862a7dd9d12'),(685,176,'texto_diferenciado',''),(686,176,'_texto_diferenciado','field_58862a7dd9d12'),(692,20,'_at_widget','1'),(693,181,'_edit_lock','1486063896:1'),(694,181,'_edit_last','1'),(695,181,'_aioseop_opengraph_settings','a:13:{s:32:\"aioseop_opengraph_settings_title\";s:0:\"\";s:31:\"aioseop_opengraph_settings_desc\";s:0:\"\";s:36:\"aioseop_opengraph_settings_customimg\";s:0:\"\";s:37:\"aioseop_opengraph_settings_imagewidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_imageheight\";s:0:\"\";s:32:\"aioseop_opengraph_settings_video\";s:0:\"\";s:37:\"aioseop_opengraph_settings_videowidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_videoheight\";s:0:\"\";s:35:\"aioseop_opengraph_settings_category\";s:8:\"activity\";s:34:\"aioseop_opengraph_settings_section\";s:0:\"\";s:30:\"aioseop_opengraph_settings_tag\";s:0:\"\";s:34:\"aioseop_opengraph_settings_setcard\";s:7:\"summary\";s:44:\"aioseop_opengraph_settings_customimg_twitter\";s:0:\"\";}'),(696,181,'_disabel_wpdevart_facebook_comment','enable'),(697,181,'_rdscriptcontenttop',''),(698,181,'_rdscriptcontentbottom',''),(699,181,'_rdscriptcontentinhead',''),(700,181,'_rdscriptcontentinfooter',''),(701,181,'_at_widget','1'),(702,181,'texto_diferenciado',''),(703,181,'_texto_diferenciado','field_58862a7dd9d12'),(704,181,'accordion_0_itm_txt_0_texto_heading','Teste Heading'),(705,181,'_accordion_0_itm_txt_0_texto_heading','field_588f76e9cb9cf'),(706,181,'accordion_0_itm_txt_0_txt_flex','<span style=\"color: #ff6600;\">@:Lorem ipsum dolor sit amet, consectetur adipisicing elit. Commodi, vitae, doloribus, quam voluptatibus sequi culpa laborum eveniet omnis quis distinctio sit officia repudiandae iure labore ipsam laboriosam exercitationem! Culpa, ut, debitis eligendi magnam laboriosam sed sit reprehenderit molestias nisi voluptatum reiciendis neque amet necessitatibus pariatur est incidunt soluta atque tempore nostrum doloribus vitae officiis quod autem adipisci suscipit dignissimos quo. Facere, ad, facilis, nihil debitis ullam voluptatem deserunt eum quia aut perspiciatis repudiandae consequuntur explicabo. Id, veritatis, iusto minus assumenda sunt vel perspiciatis esse nobis corporis voluptate est nesciunt delectus explicabo sequi enim dolores hic? Laudantium, fuga, ullam, ipsum, ad accusamus molestiae autem nobis sit sed minus cumque error? Est, corporis, in totam quo asperiores odit autem iusto ipsum veniam harum obcaecati eos explicabo voluptatum fugiat debitis ipsa adipisci magnam! A, molestiae, perferendis vero veritatis voluptatum ducimus animi explicabo ratio.</span>\r\n\r\n<a href=\"http://www.linhafacil.com.br/v2/wp-content/uploads/2017/01/Motos-1.png\"><img class=\"alignnone size-full wp-image-49\" src=\"http://www.linhafacil.com.br/v2/wp-content/uploads/2017/01/Motos-1.png\" alt=\"\" width=\"400\" height=\"400\" /></a>'),(707,181,'_accordion_0_itm_txt_0_txt_flex','field_588f82b779e0d'),(708,181,'accordion_0_itm_txt','a:1:{i:0;s:5:\"txt_2\";}'),(709,181,'_accordion_0_itm_txt','field_588f7649cb9ce'),(710,181,'accordion','1'),(711,181,'_accordion','field_588f7627cb9cd'),(712,181,'acordions',''),(713,181,'_acordions','field_5887501a480ec'),(714,182,'texto_diferenciado',''),(715,182,'_texto_diferenciado','field_58862a7dd9d12'),(716,182,'accordion_0_itm_txt_0_texto_heading',''),(717,182,'_accordion_0_itm_txt_0_texto_heading','field_588f76e9cb9cf'),(718,182,'accordion_0_itm_txt_0_txt_flex',''),(719,182,'_accordion_0_itm_txt_0_txt_flex','field_588f82b779e0d'),(720,182,'accordion_0_itm_txt','a:1:{i:0;s:5:\"txt_2\";}'),(721,182,'_accordion_0_itm_txt','field_588f7649cb9ce'),(722,182,'accordion','1'),(723,182,'_accordion','field_588f7627cb9cd'),(724,182,'acordions',''),(725,182,'_acordions','field_5887501a480ec'),(726,183,'texto_diferenciado',''),(727,183,'_texto_diferenciado','field_58862a7dd9d12'),(728,183,'accordion_0_itm_txt_0_texto_heading','Teste Heading'),(729,183,'_accordion_0_itm_txt_0_texto_heading','field_588f76e9cb9cf'),(730,183,'accordion_0_itm_txt_0_txt_flex','@:Lorem ipsum dolor sit amet, consectetur adipisicing elit. Commodi, vitae, doloribus, quam voluptatibus sequi culpa laborum eveniet omnis quis distinctio sit officia repudiandae iure labore ipsam laboriosam exercitationem! Culpa, ut, debitis eligendi magnam laboriosam sed sit reprehenderit molestias nisi voluptatum reiciendis neque amet necessitatibus pariatur est incidunt soluta atque tempore nostrum doloribus vitae officiis quod autem adipisci suscipit dignissimos quo. Facere, ad, facilis, nihil debitis ullam voluptatem deserunt eum quia aut perspiciatis repudiandae consequuntur explicabo. Id, veritatis, iusto minus assumenda sunt vel perspiciatis esse nobis corporis voluptate est nesciunt delectus explicabo sequi enim dolores hic? Laudantium, fuga, ullam, ipsum, ad accusamus molestiae autem nobis sit sed minus cumque error? Est, corporis, in totam quo asperiores odit autem iusto ipsum veniam harum obcaecati eos explicabo voluptatum fugiat debitis ipsa adipisci magnam! A, molestiae, perferendis vero veritatis voluptatum ducimus animi explicabo ratio.\r\n\r\n<a href=\"http://www.linhafacil.com.br/v2/wp-content/uploads/2017/01/Motos-1.png\"><img class=\"alignnone size-full wp-image-49\" src=\"http://www.linhafacil.com.br/v2/wp-content/uploads/2017/01/Motos-1.png\" alt=\"\" width=\"400\" height=\"400\" /></a>'),(731,183,'_accordion_0_itm_txt_0_txt_flex','field_588f82b779e0d'),(732,183,'accordion_0_itm_txt','a:1:{i:0;s:5:\"txt_2\";}'),(733,183,'_accordion_0_itm_txt','field_588f7649cb9ce'),(734,183,'accordion','1'),(735,183,'_accordion','field_588f7627cb9cd'),(736,183,'acordions',''),(737,183,'_acordions','field_5887501a480ec'),(738,184,'texto_diferenciado',''),(739,184,'_texto_diferenciado','field_58862a7dd9d12'),(740,184,'accordion_0_itm_txt_0_texto_heading','Teste Heading'),(741,184,'_accordion_0_itm_txt_0_texto_heading','field_588f76e9cb9cf'),(742,184,'accordion_0_itm_txt_0_txt_flex','<span style=\"color: #ff6600;\">@:Lorem ipsum dolor sit amet, consectetur adipisicing elit. Commodi, vitae, doloribus, quam voluptatibus sequi culpa laborum eveniet omnis quis distinctio sit officia repudiandae iure labore ipsam laboriosam exercitationem! Culpa, ut, debitis eligendi magnam laboriosam sed sit reprehenderit molestias nisi voluptatum reiciendis neque amet necessitatibus pariatur est incidunt soluta atque tempore nostrum doloribus vitae officiis quod autem adipisci suscipit dignissimos quo. Facere, ad, facilis, nihil debitis ullam voluptatem deserunt eum quia aut perspiciatis repudiandae consequuntur explicabo. Id, veritatis, iusto minus assumenda sunt vel perspiciatis esse nobis corporis voluptate est nesciunt delectus explicabo sequi enim dolores hic? Laudantium, fuga, ullam, ipsum, ad accusamus molestiae autem nobis sit sed minus cumque error? Est, corporis, in totam quo asperiores odit autem iusto ipsum veniam harum obcaecati eos explicabo voluptatum fugiat debitis ipsa adipisci magnam! A, molestiae, perferendis vero veritatis voluptatum ducimus animi explicabo ratio.</span>\r\n\r\n<a href=\"http://www.linhafacil.com.br/v2/wp-content/uploads/2017/01/Motos-1.png\"><img class=\"alignnone size-full wp-image-49\" src=\"http://www.linhafacil.com.br/v2/wp-content/uploads/2017/01/Motos-1.png\" alt=\"\" width=\"400\" height=\"400\" /></a>');
INSERT INTO `wp_postmeta` VALUES (743,184,'_accordion_0_itm_txt_0_txt_flex','field_588f82b779e0d'),(744,184,'accordion_0_itm_txt','a:1:{i:0;s:5:\"txt_2\";}'),(745,184,'_accordion_0_itm_txt','field_588f7649cb9ce'),(746,184,'accordion','1'),(747,184,'_accordion','field_588f7627cb9cd'),(748,184,'acordions',''),(749,184,'_acordions','field_5887501a480ec'),(750,181,'accordion_0_itm_txt_0_cor_de_fundo','#5b5b5b'),(751,181,'_accordion_0_itm_txt_0_cor_de_fundo','field_588f91138c9fa'),(752,181,'accordion_0_itm_txt_0_cor_do_texto','#dd9933'),(753,181,'_accordion_0_itm_txt_0_cor_do_texto','field_588f91eaa6afb'),(754,181,'accordion_0_itm_txt_0_cor_do_icone','#eaeaea'),(755,181,'_accordion_0_itm_txt_0_cor_do_icone','field_588f923ef5376'),(756,188,'texto_diferenciado',''),(757,188,'_texto_diferenciado','field_58862a7dd9d12'),(758,188,'accordion_0_itm_txt_0_texto_heading','Teste Heading'),(759,188,'_accordion_0_itm_txt_0_texto_heading','field_588f76e9cb9cf'),(760,188,'accordion_0_itm_txt_0_txt_flex','<span style=\"color: #ff6600;\">@:Lorem ipsum dolor sit amet, consectetur adipisicing elit. Commodi, vitae, doloribus, quam voluptatibus sequi culpa laborum eveniet omnis quis distinctio sit officia repudiandae iure labore ipsam laboriosam exercitationem! Culpa, ut, debitis eligendi magnam laboriosam sed sit reprehenderit molestias nisi voluptatum reiciendis neque amet necessitatibus pariatur est incidunt soluta atque tempore nostrum doloribus vitae officiis quod autem adipisci suscipit dignissimos quo. Facere, ad, facilis, nihil debitis ullam voluptatem deserunt eum quia aut perspiciatis repudiandae consequuntur explicabo. Id, veritatis, iusto minus assumenda sunt vel perspiciatis esse nobis corporis voluptate est nesciunt delectus explicabo sequi enim dolores hic? Laudantium, fuga, ullam, ipsum, ad accusamus molestiae autem nobis sit sed minus cumque error? Est, corporis, in totam quo asperiores odit autem iusto ipsum veniam harum obcaecati eos explicabo voluptatum fugiat debitis ipsa adipisci magnam! A, molestiae, perferendis vero veritatis voluptatum ducimus animi explicabo ratio.</span>\r\n\r\n<a href=\"http://www.linhafacil.com.br/v2/wp-content/uploads/2017/01/Motos-1.png\"><img class=\"alignnone size-full wp-image-49\" src=\"http://www.linhafacil.com.br/v2/wp-content/uploads/2017/01/Motos-1.png\" alt=\"\" width=\"400\" height=\"400\" /></a>'),(761,188,'_accordion_0_itm_txt_0_txt_flex','field_588f82b779e0d'),(762,188,'accordion_0_itm_txt','a:1:{i:0;s:5:\"txt_2\";}'),(763,188,'_accordion_0_itm_txt','field_588f7649cb9ce'),(764,188,'accordion','1'),(765,188,'_accordion','field_588f7627cb9cd'),(766,188,'acordions',''),(767,188,'_acordions','field_5887501a480ec'),(768,188,'accordion_0_itm_txt_0_cor_de_fundo','#5b5b5b'),(769,188,'_accordion_0_itm_txt_0_cor_de_fundo','field_588f91138c9fa'),(770,188,'accordion_0_itm_txt_0_cor_do_texto','#dd9933'),(771,188,'_accordion_0_itm_txt_0_cor_do_texto','field_588f91eaa6afb'),(772,188,'accordion_0_itm_txt_0_cor_do_icone','#eaeaea'),(773,188,'_accordion_0_itm_txt_0_cor_do_icone','field_588f923ef5376'),(774,190,'texto_diferenciado',''),(775,190,'_texto_diferenciado','field_58862a7dd9d12'),(776,190,'accordion_0_itm_txt_0_texto_heading','O que é rateio em uma associação de proteção veicular?'),(777,190,'_accordion_0_itm_txt_0_texto_heading','field_588f76e9cb9cf'),(778,190,'accordion_0_itm_txt_0_cor_de_fundo',''),(779,190,'_accordion_0_itm_txt_0_cor_de_fundo','field_588f91138c9fa'),(780,190,'accordion_0_itm_txt_0_cor_do_texto','#dd9933'),(781,190,'_accordion_0_itm_txt_0_cor_do_texto','field_588f91eaa6afb'),(782,190,'accordion_0_itm_txt_0_cor_do_icone','#ffffff'),(783,190,'_accordion_0_itm_txt_0_cor_do_icone','field_588f923ef5376'),(784,190,'accordion_0_itm_txt_0_txt_flex','Rateio é a divisão proporcional dos prejuízos causados pelos veículos dos associados.'),(785,190,'_accordion_0_itm_txt_0_txt_flex','field_588f82b779e0d'),(786,190,'accordion_0_itm_txt_1_texto_heading','Quem paga pelo prejuízo?'),(787,190,'_accordion_0_itm_txt_1_texto_heading','field_588f76e9cb9cf'),(788,190,'accordion_0_itm_txt_1_cor_de_fundo',''),(789,190,'_accordion_0_itm_txt_1_cor_de_fundo','field_588f91138c9fa'),(790,190,'accordion_0_itm_txt_1_cor_do_texto','#dd9933'),(791,190,'_accordion_0_itm_txt_1_cor_do_texto','field_588f91eaa6afb'),(792,190,'accordion_0_itm_txt_1_cor_do_icone','#ffffff'),(793,190,'_accordion_0_itm_txt_1_cor_do_icone','field_588f923ef5376'),(794,190,'accordion_0_itm_txt_1_txt_flex','Todos os associados, proporcionalmente aos número de cotas.'),(795,190,'_accordion_0_itm_txt_1_txt_flex','field_588f82b779e0d'),(796,190,'accordion_0_itm_txt','a:11:{i:0;s:5:\"txt_2\";i:1;s:5:\"txt_2\";i:2;s:5:\"txt_2\";i:3;s:5:\"txt_2\";i:4;s:5:\"txt_2\";i:5;s:5:\"txt_2\";i:6;s:5:\"txt_2\";i:7;s:5:\"txt_2\";i:8;s:5:\"txt_2\";i:9;s:5:\"txt_2\";i:10;s:5:\"txt_2\";}'),(797,190,'_accordion_0_itm_txt','field_588f7649cb9ce'),(798,190,'accordion_1_itm_txt',''),(799,190,'_accordion_1_itm_txt','field_588f7649cb9ce'),(800,190,'accordion','2'),(801,190,'_accordion','field_588f7627cb9cd'),(802,190,'acordions',''),(803,190,'_acordions','field_5887501a480ec'),(804,190,'accordion_0_itm_txt_2_texto_heading','O que são quotas?'),(805,190,'_accordion_0_itm_txt_2_texto_heading','field_588f76e9cb9cf'),(806,190,'accordion_0_itm_txt_2_cor_de_fundo','#dd9933'),(807,190,'_accordion_0_itm_txt_2_cor_de_fundo','field_588f91138c9fa'),(808,190,'accordion_0_itm_txt_2_cor_do_texto',''),(809,190,'_accordion_0_itm_txt_2_cor_do_texto','field_588f91eaa6afb'),(810,190,'accordion_0_itm_txt_2_cor_do_icone',''),(811,190,'_accordion_0_itm_txt_2_cor_do_icone','field_588f923ef5376'),(812,190,'accordion_0_itm_txt_2_txt_flex','Quantia com que cada pessoa contribui para o pagamento de uma despesa comum. No caso, o valor de cada veículo é convertido em cotas, exemplo: De R$0,00 à R$10.000,00 = 0,5 cota De R$10.001,00 à R$20.000,00 = 1 cota e assim sucessivamente.'),(813,190,'_accordion_0_itm_txt_2_txt_flex','field_588f82b779e0d'),(814,190,'accordion_0_itm_txt_3_texto_heading','Existe reserva financeira?'),(815,190,'_accordion_0_itm_txt_3_texto_heading','field_588f76e9cb9cf'),(816,190,'accordion_0_itm_txt_3_cor_de_fundo','#dd9933'),(817,190,'_accordion_0_itm_txt_3_cor_de_fundo','field_588f91138c9fa'),(818,190,'accordion_0_itm_txt_3_cor_do_texto',''),(819,190,'_accordion_0_itm_txt_3_cor_do_texto','field_588f91eaa6afb'),(820,190,'accordion_0_itm_txt_3_cor_do_icone',''),(821,190,'_accordion_0_itm_txt_3_cor_do_icone','field_588f923ef5376'),(822,190,'accordion_0_itm_txt_3_txt_flex','<div class=\"panel panel-default\">\r\n<div id=\"collapse4\" class=\"panel-collapse collapse in\">\r\n<div class=\"panel-body\">\r\n\r\nNão é necessário, uma vez que os prejuízos são rateados entre os associados, mas, nada impede que uma associação constitua reservas ou até mesmo patrimônio.\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"panel panel-default\"></div>'),(823,190,'_accordion_0_itm_txt_3_txt_flex','field_588f82b779e0d'),(824,190,'accordion_0_itm_txt_4_texto_heading','Quem controla uma associação?'),(825,190,'_accordion_0_itm_txt_4_texto_heading','field_588f76e9cb9cf'),(826,190,'accordion_0_itm_txt_4_cor_de_fundo','#dd9933'),(827,190,'_accordion_0_itm_txt_4_cor_de_fundo','field_588f91138c9fa'),(828,190,'accordion_0_itm_txt_4_cor_do_texto',''),(829,190,'_accordion_0_itm_txt_4_cor_do_texto','field_588f91eaa6afb'),(830,190,'accordion_0_itm_txt_4_cor_do_icone',''),(831,190,'_accordion_0_itm_txt_4_cor_do_icone','field_588f923ef5376'),(832,190,'accordion_0_itm_txt_4_txt_flex','<div class=\"panel panel-default\">\r\n<div id=\"collapse5\" class=\"panel-collapse collapse in\">\r\n<div class=\"panel-body\">\r\n\r\nUma associação é controlada pelo seu Presidente e demais diretores, que devem se empenhar para seguir o Estatuto e o Regulamento da associação.\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"panel panel-default\"></div>'),(833,190,'_accordion_0_itm_txt_4_txt_flex','field_588f82b779e0d'),(834,190,'accordion_0_itm_txt_5_texto_heading','O que é Estatuto?'),(835,190,'_accordion_0_itm_txt_5_texto_heading','field_588f76e9cb9cf'),(836,190,'accordion_0_itm_txt_5_cor_de_fundo','#dd9933'),(837,190,'_accordion_0_itm_txt_5_cor_de_fundo','field_588f91138c9fa'),(838,190,'accordion_0_itm_txt_5_cor_do_texto',''),(839,190,'_accordion_0_itm_txt_5_cor_do_texto','field_588f91eaa6afb'),(840,190,'accordion_0_itm_txt_5_cor_do_icone',''),(841,190,'_accordion_0_itm_txt_5_cor_do_icone','field_588f923ef5376'),(842,190,'accordion_0_itm_txt_5_txt_flex','Estatuto, é um conjunto de normas jurídicas, acordada pelos seus sócios ou fundadores, que regulamenta o funcionamento de uma pessoa jurídica, quer seja uma sociedade, uma associação ou fundação.'),(843,190,'_accordion_0_itm_txt_5_txt_flex','field_588f82b779e0d'),(844,190,'accordion_0_itm_txt_6_texto_heading','O que é regulamento?'),(845,190,'_accordion_0_itm_txt_6_texto_heading','field_588f76e9cb9cf'),(846,190,'accordion_0_itm_txt_6_cor_de_fundo','#dd9933'),(847,190,'_accordion_0_itm_txt_6_cor_de_fundo','field_588f91138c9fa'),(848,190,'accordion_0_itm_txt_6_cor_do_texto',''),(849,190,'_accordion_0_itm_txt_6_cor_do_texto','field_588f91eaa6afb'),(850,190,'accordion_0_itm_txt_6_cor_do_icone',''),(851,190,'_accordion_0_itm_txt_6_cor_do_icone','field_588f923ef5376'),(852,190,'accordion_0_itm_txt_6_txt_flex','<div class=\"panel panel-default\">\r\n<div id=\"collapse7\" class=\"panel-collapse collapse in\">\r\n<div class=\"panel-body\">\r\n\r\nÉ um conjunto organizado e coerente de preceitos ou normas, que regerão o trabalho em uma organização.\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"panel panel-default\"></div>'),(853,190,'_accordion_0_itm_txt_6_txt_flex','field_588f82b779e0d'),(854,190,'accordion_0_itm_txt_7_texto_heading','A atividade é ilegal?'),(855,190,'_accordion_0_itm_txt_7_texto_heading','field_588f76e9cb9cf'),(856,190,'accordion_0_itm_txt_7_cor_de_fundo','#dd9933'),(857,190,'_accordion_0_itm_txt_7_cor_de_fundo','field_588f91138c9fa'),(858,190,'accordion_0_itm_txt_7_cor_do_texto',''),(859,190,'_accordion_0_itm_txt_7_cor_do_texto','field_588f91eaa6afb'),(860,190,'accordion_0_itm_txt_7_cor_do_icone',''),(861,190,'_accordion_0_itm_txt_7_cor_do_icone','field_588f923ef5376'),(862,190,'accordion_0_itm_txt_7_txt_flex','Não, a atividade associativista está amparada pela lei federal em seu artigo 5° e, no artigo 53 do novo código civil brasileiro, que diz que: “Todos são iguais perante a lei, sem distinção de qualquer natureza”.'),(863,190,'_accordion_0_itm_txt_7_txt_flex','field_588f82b779e0d'),(864,190,'accordion_0_itm_txt_8_texto_heading','A Proteção Veicular é o mesmo que seguro?'),(865,190,'_accordion_0_itm_txt_8_texto_heading','field_588f76e9cb9cf'),(866,190,'accordion_0_itm_txt_8_cor_de_fundo',''),(867,190,'_accordion_0_itm_txt_8_cor_de_fundo','field_588f91138c9fa'),(868,190,'accordion_0_itm_txt_8_cor_do_texto',''),(869,190,'_accordion_0_itm_txt_8_cor_do_texto','field_588f91eaa6afb'),(870,190,'accordion_0_itm_txt_8_cor_do_icone',''),(871,190,'_accordion_0_itm_txt_8_cor_do_icone','field_588f923ef5376'),(872,190,'accordion_0_itm_txt_8_txt_flex','<div class=\"panel panel-default\">\r\n<div id=\"collapse9\" class=\"panel-collapse collapse in\">\r\n<div class=\"panel-body\">\r\n\r\nNão, as associações em sua maioria são entidades sem fins lucrativos, onde na sua essência, buscam gerar algum tipo de benefício aos seus associados. No caso da Proteção Veicular, os benefícios são alcançados pelos custos reduzidos dos valores da proteção, e na agilidade dos processos.\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"panel panel-default\"></div>'),(873,190,'_accordion_0_itm_txt_8_txt_flex','field_588f82b779e0d'),(874,190,'accordion_0_itm_txt_9_texto_heading','A Susep, tem algum poder sobre uma associação?'),(875,190,'_accordion_0_itm_txt_9_texto_heading','field_588f76e9cb9cf'),(876,190,'accordion_0_itm_txt_9_cor_de_fundo',''),(877,190,'_accordion_0_itm_txt_9_cor_de_fundo','field_588f91138c9fa'),(878,190,'accordion_0_itm_txt_9_cor_do_texto',''),(879,190,'_accordion_0_itm_txt_9_cor_do_texto','field_588f91eaa6afb'),(880,190,'accordion_0_itm_txt_9_cor_do_icone',''),(881,190,'_accordion_0_itm_txt_9_cor_do_icone','field_588f923ef5376'),(882,190,'accordion_0_itm_txt_9_txt_flex','Não, a Susep é o órgão que regulamenta os seguros privados no Brasil. Como a atividade praticada pela associação não pode ser confundida com seguro, a Susep não tem nenhum poder regulatório sobre as associações.'),(883,190,'_accordion_0_itm_txt_9_txt_flex','field_588f82b779e0d'),(884,190,'accordion_0_itm_txt_10_texto_heading','Você sabe a diferença de auxilio Funeral e Assistência Funeral ?'),(885,190,'_accordion_0_itm_txt_10_texto_heading','field_588f76e9cb9cf'),(886,190,'accordion_0_itm_txt_10_cor_de_fundo',''),(887,190,'_accordion_0_itm_txt_10_cor_de_fundo','field_588f91138c9fa'),(888,190,'accordion_0_itm_txt_10_cor_do_texto',''),(889,190,'_accordion_0_itm_txt_10_cor_do_texto','field_588f91eaa6afb'),(890,190,'accordion_0_itm_txt_10_cor_do_icone',''),(891,190,'_accordion_0_itm_txt_10_cor_do_icone','field_588f923ef5376'),(892,190,'accordion_0_itm_txt_10_txt_flex','O seguro auxílio-funeral, geralmente, tem capital segurado (valor da\r\nindenização) de valor baixo, com cobrança do prêmio respectivo. Seu objetivo\r\né reembolsar as despesas com o funeral do segurado. A escolha de prestadores\r\ndos serviços é livre. O seguro garante o reembolso das despesas com o\r\nsepultamento do segurado, permitindo que a família escolha livremente os\r\nserviços que quer contratar. Sua contratação pode ser feita junto com a do\r\nseguro de acidentes pessoais.\r\n\r\nA assistência funeral, por sua vez, é um serviço sem direito à livre\r\nescolha. Os familiares do segurado ficam limitados a prestadores de serviços\r\nindicados pela seguradora.'),(893,190,'_accordion_0_itm_txt_10_txt_flex','field_588f82b779e0d'),(894,157,'texto_diferenciado',''),(895,157,'_texto_diferenciado','field_58862a7dd9d12'),(896,157,'accordion_0_itm_txt_0_texto_heading','O que é rateio em uma associação de proteção veicular?'),(897,157,'_accordion_0_itm_txt_0_texto_heading','field_588f76e9cb9cf'),(898,157,'accordion_0_itm_txt_0_cor_de_fundo',''),(899,157,'_accordion_0_itm_txt_0_cor_de_fundo','field_588f91138c9fa'),(900,157,'accordion_0_itm_txt_0_cor_do_texto','#dd9933'),(901,157,'_accordion_0_itm_txt_0_cor_do_texto','field_588f91eaa6afb'),(902,157,'accordion_0_itm_txt_0_cor_do_icone','#ffffff'),(903,157,'_accordion_0_itm_txt_0_cor_do_icone','field_588f923ef5376'),(904,157,'accordion_0_itm_txt_0_txt_flex','Rateio é a divisão proporcional dos prejuízos causados pelos veículos dos associados.'),(905,157,'_accordion_0_itm_txt_0_txt_flex','field_588f82b779e0d'),(906,157,'accordion_0_itm_txt_1_texto_heading','Quem paga pelo prejuízo?'),(907,157,'_accordion_0_itm_txt_1_texto_heading','field_588f76e9cb9cf'),(908,157,'accordion_0_itm_txt_1_cor_de_fundo',''),(909,157,'_accordion_0_itm_txt_1_cor_de_fundo','field_588f91138c9fa'),(910,157,'accordion_0_itm_txt_1_cor_do_texto','#dd9933'),(911,157,'_accordion_0_itm_txt_1_cor_do_texto','field_588f91eaa6afb'),(912,157,'accordion_0_itm_txt_1_cor_do_icone','#ffffff'),(913,157,'_accordion_0_itm_txt_1_cor_do_icone','field_588f923ef5376'),(914,157,'accordion_0_itm_txt_1_txt_flex','Todos os associados, proporcionalmente aos número de cotas.'),(915,157,'_accordion_0_itm_txt_1_txt_flex','field_588f82b779e0d'),(916,157,'accordion_0_itm_txt_2_texto_heading','O que são quotas?'),(917,157,'_accordion_0_itm_txt_2_texto_heading','field_588f76e9cb9cf'),(918,157,'accordion_0_itm_txt_2_cor_de_fundo','#dd9933'),(919,157,'_accordion_0_itm_txt_2_cor_de_fundo','field_588f91138c9fa'),(920,157,'accordion_0_itm_txt_2_cor_do_texto',''),(921,157,'_accordion_0_itm_txt_2_cor_do_texto','field_588f91eaa6afb'),(922,157,'accordion_0_itm_txt_2_cor_do_icone',''),(923,157,'_accordion_0_itm_txt_2_cor_do_icone','field_588f923ef5376'),(924,157,'accordion_0_itm_txt_2_txt_flex','Quantia com que cada pessoa contribui para o pagamento de uma despesa comum. No caso, o valor de cada veículo é convertido em cotas, exemplo: De R$0,00 à R$10.000,00 = 0,5 cota De R$10.001,00 à R$20.000,00 = 1 cota e assim sucessivamente.'),(925,157,'_accordion_0_itm_txt_2_txt_flex','field_588f82b779e0d'),(926,157,'accordion_0_itm_txt_3_texto_heading','Existe reserva financeira?'),(927,157,'_accordion_0_itm_txt_3_texto_heading','field_588f76e9cb9cf'),(928,157,'accordion_0_itm_txt_3_cor_de_fundo','#dd9933'),(929,157,'_accordion_0_itm_txt_3_cor_de_fundo','field_588f91138c9fa'),(930,157,'accordion_0_itm_txt_3_cor_do_texto',''),(931,157,'_accordion_0_itm_txt_3_cor_do_texto','field_588f91eaa6afb'),(932,157,'accordion_0_itm_txt_3_cor_do_icone',''),(933,157,'_accordion_0_itm_txt_3_cor_do_icone','field_588f923ef5376'),(934,157,'accordion_0_itm_txt_3_txt_flex','<div class=\"panel panel-default\">\r\n<div id=\"collapse4\" class=\"panel-collapse collapse in\">\r\n<div class=\"panel-body\">\r\n\r\nNão é necessário, uma vez que os prejuízos são rateados entre os associados, mas, nada impede que uma associação constitua reservas ou até mesmo patrimônio.\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"panel panel-default\"></div>'),(935,157,'_accordion_0_itm_txt_3_txt_flex','field_588f82b779e0d'),(936,157,'accordion_0_itm_txt_4_texto_heading','Quem controla uma associação?'),(937,157,'_accordion_0_itm_txt_4_texto_heading','field_588f76e9cb9cf'),(938,157,'accordion_0_itm_txt_4_cor_de_fundo','#dd9933'),(939,157,'_accordion_0_itm_txt_4_cor_de_fundo','field_588f91138c9fa'),(940,157,'accordion_0_itm_txt_4_cor_do_texto',''),(941,157,'_accordion_0_itm_txt_4_cor_do_texto','field_588f91eaa6afb'),(942,157,'accordion_0_itm_txt_4_cor_do_icone',''),(943,157,'_accordion_0_itm_txt_4_cor_do_icone','field_588f923ef5376'),(944,157,'accordion_0_itm_txt_4_txt_flex','<div class=\"panel panel-default\">\r\n<div id=\"collapse5\" class=\"panel-collapse collapse in\">\r\n<div class=\"panel-body\">\r\n\r\nUma associação é controlada pelo seu Presidente e demais diretores, que devem se empenhar para seguir o Estatuto e o Regulamento da associação.\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"panel panel-default\"></div>'),(945,157,'_accordion_0_itm_txt_4_txt_flex','field_588f82b779e0d'),(946,157,'accordion_0_itm_txt_5_texto_heading','O que é Estatuto?'),(947,157,'_accordion_0_itm_txt_5_texto_heading','field_588f76e9cb9cf'),(948,157,'accordion_0_itm_txt_5_cor_de_fundo','#dd9933'),(949,157,'_accordion_0_itm_txt_5_cor_de_fundo','field_588f91138c9fa'),(950,157,'accordion_0_itm_txt_5_cor_do_texto',''),(951,157,'_accordion_0_itm_txt_5_cor_do_texto','field_588f91eaa6afb'),(952,157,'accordion_0_itm_txt_5_cor_do_icone',''),(953,157,'_accordion_0_itm_txt_5_cor_do_icone','field_588f923ef5376'),(954,157,'accordion_0_itm_txt_5_txt_flex','&nbsp;\r\n\r\nEstatuto, é um conjunto de normas jurídicas, acordada pelos seus sócios ou fundadores, que regulamenta o funcionamento de uma pessoa jurídica, quer seja uma sociedade, uma associação ou fundação.'),(955,157,'_accordion_0_itm_txt_5_txt_flex','field_588f82b779e0d'),(956,157,'accordion_0_itm_txt_6_texto_heading','O que é regulamento?'),(957,157,'_accordion_0_itm_txt_6_texto_heading','field_588f76e9cb9cf'),(958,157,'accordion_0_itm_txt_6_cor_de_fundo','#dd9933'),(959,157,'_accordion_0_itm_txt_6_cor_de_fundo','field_588f91138c9fa'),(960,157,'accordion_0_itm_txt_6_cor_do_texto',''),(961,157,'_accordion_0_itm_txt_6_cor_do_texto','field_588f91eaa6afb'),(962,157,'accordion_0_itm_txt_6_cor_do_icone',''),(963,157,'_accordion_0_itm_txt_6_cor_do_icone','field_588f923ef5376'),(964,157,'accordion_0_itm_txt_6_txt_flex','<div class=\"panel panel-default\">\r\n<div id=\"collapse7\" class=\"panel-collapse collapse in\">\r\n<div class=\"panel-body\">\r\n\r\nÉ um conjunto organizado e coerente de preceitos ou normas, que regerão o trabalho em uma organização.\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"panel panel-default\"></div>'),(965,157,'_accordion_0_itm_txt_6_txt_flex','field_588f82b779e0d'),(966,157,'accordion_0_itm_txt_7_texto_heading','A atividade é ilegal?'),(967,157,'_accordion_0_itm_txt_7_texto_heading','field_588f76e9cb9cf'),(968,157,'accordion_0_itm_txt_7_cor_de_fundo','#dd9933'),(969,157,'_accordion_0_itm_txt_7_cor_de_fundo','field_588f91138c9fa'),(970,157,'accordion_0_itm_txt_7_cor_do_texto',''),(971,157,'_accordion_0_itm_txt_7_cor_do_texto','field_588f91eaa6afb'),(972,157,'accordion_0_itm_txt_7_cor_do_icone',''),(973,157,'_accordion_0_itm_txt_7_cor_do_icone','field_588f923ef5376'),(974,157,'accordion_0_itm_txt_7_txt_flex','Não, a atividade associativista está amparada pela lei federal em seu artigo 5° e, no artigo 53 do novo código civil brasileiro, que diz que: “Todos são iguais perante a lei, sem distinção de qualquer natureza”.'),(975,157,'_accordion_0_itm_txt_7_txt_flex','field_588f82b779e0d'),(976,157,'accordion_0_itm_txt_8_texto_heading','A Proteção Veicular é o mesmo que seguro?'),(977,157,'_accordion_0_itm_txt_8_texto_heading','field_588f76e9cb9cf'),(978,157,'accordion_0_itm_txt_8_cor_de_fundo',''),(979,157,'_accordion_0_itm_txt_8_cor_de_fundo','field_588f91138c9fa'),(980,157,'accordion_0_itm_txt_8_cor_do_texto',''),(981,157,'_accordion_0_itm_txt_8_cor_do_texto','field_588f91eaa6afb'),(982,157,'accordion_0_itm_txt_8_cor_do_icone',''),(983,157,'_accordion_0_itm_txt_8_cor_do_icone','field_588f923ef5376'),(984,157,'accordion_0_itm_txt_8_txt_flex','<div class=\"panel panel-default\">\r\n<div id=\"collapse9\" class=\"panel-collapse collapse in\">\r\n<div class=\"panel-body\">\r\n\r\nNão, as associações em sua maioria são entidades sem fins lucrativos, onde na sua essência, buscam gerar algum tipo de benefício aos seus associados. No caso da Proteção Veicular, os benefícios são alcançados pelos custos reduzidos dos valores da proteção, e na agilidade dos processos.\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"panel panel-default\"></div>'),(985,157,'_accordion_0_itm_txt_8_txt_flex','field_588f82b779e0d'),(986,157,'accordion_0_itm_txt_9_texto_heading','A Susep, tem algum poder sobre uma associação?'),(987,157,'_accordion_0_itm_txt_9_texto_heading','field_588f76e9cb9cf'),(988,157,'accordion_0_itm_txt_9_cor_de_fundo',''),(989,157,'_accordion_0_itm_txt_9_cor_de_fundo','field_588f91138c9fa'),(990,157,'accordion_0_itm_txt_9_cor_do_texto',''),(991,157,'_accordion_0_itm_txt_9_cor_do_texto','field_588f91eaa6afb'),(992,157,'accordion_0_itm_txt_9_cor_do_icone',''),(993,157,'_accordion_0_itm_txt_9_cor_do_icone','field_588f923ef5376'),(994,157,'accordion_0_itm_txt_9_txt_flex','Não, a Susep é o órgão que regulamenta os seguros privados no Brasil. Como a atividade praticada pela associação não pode ser confundida com seguro, a Susep não tem nenhum poder regulatório sobre as associações.'),(995,157,'_accordion_0_itm_txt_9_txt_flex','field_588f82b779e0d'),(996,157,'accordion_0_itm_txt_10_texto_heading','Você sabe a diferença de auxilio Funeral e Assistência Funeral ?'),(997,157,'_accordion_0_itm_txt_10_texto_heading','field_588f76e9cb9cf'),(998,157,'accordion_0_itm_txt_10_cor_de_fundo',''),(999,157,'_accordion_0_itm_txt_10_cor_de_fundo','field_588f91138c9fa'),(1000,157,'accordion_0_itm_txt_10_cor_do_texto',''),(1001,157,'_accordion_0_itm_txt_10_cor_do_texto','field_588f91eaa6afb'),(1002,157,'accordion_0_itm_txt_10_cor_do_icone',''),(1003,157,'_accordion_0_itm_txt_10_cor_do_icone','field_588f923ef5376'),(1004,157,'accordion_0_itm_txt_10_txt_flex','O seguro auxílio-funeral, geralmente, tem capital segurado (valor da\r\nindenização) de valor baixo, com cobrança do prêmio respectivo. Seu objetivo\r\né reembolsar as despesas com o funeral do segurado. A escolha de prestadores\r\ndos serviços é livre. O seguro garante o reembolso das despesas com o\r\nsepultamento do segurado, permitindo que a família escolha livremente os\r\nserviços que quer contratar. Sua contratação pode ser feita junto com a do\r\nseguro de acidentes pessoais.\r\n\r\nA assistência funeral, por sua vez, é um serviço sem direito à livre\r\nescolha. Os familiares do segurado ficam limitados a prestadores de serviços\r\nindicados pela seguradora.\r\n\r\n&nbsp;\r\n\r\n&nbsp;'),(1005,157,'_accordion_0_itm_txt_10_txt_flex','field_588f82b779e0d'),(1006,157,'accordion_0_itm_txt','a:11:{i:0;s:5:\"txt_2\";i:1;s:5:\"txt_2\";i:2;s:5:\"txt_2\";i:3;s:5:\"txt_2\";i:4;s:5:\"txt_2\";i:5;s:5:\"txt_2\";i:6;s:5:\"txt_2\";i:7;s:5:\"txt_2\";i:8;s:5:\"txt_2\";i:9;s:5:\"txt_2\";i:10;s:5:\"txt_2\";}'),(1007,157,'_accordion_0_itm_txt','field_588f7649cb9ce'),(1133,192,'_acordions','field_5887501a480ec'),(1132,192,'acordions',''),(1010,157,'accordion','1'),(1011,157,'_accordion','field_588f7627cb9cd'),(1012,191,'acordions',''),(1013,191,'_acordions','field_5887501a480ec'),(1014,191,'texto_diferenciado',''),(1015,191,'_texto_diferenciado','field_58862a7dd9d12'),(1016,191,'accordion_0_itm_txt_0_texto_heading','O que é rateio em uma associação de proteção veicular?'),(1017,191,'_accordion_0_itm_txt_0_texto_heading','field_588f76e9cb9cf'),(1018,191,'accordion_0_itm_txt_0_cor_de_fundo',''),(1019,191,'_accordion_0_itm_txt_0_cor_de_fundo','field_588f91138c9fa'),(1020,191,'accordion_0_itm_txt_0_cor_do_texto','#dd9933'),(1021,191,'_accordion_0_itm_txt_0_cor_do_texto','field_588f91eaa6afb'),(1022,191,'accordion_0_itm_txt_0_cor_do_icone','#ffffff'),(1023,191,'_accordion_0_itm_txt_0_cor_do_icone','field_588f923ef5376'),(1024,191,'accordion_0_itm_txt_0_txt_flex','Rateio é a divisão proporcional dos prejuízos causados pelos veículos dos associados.'),(1025,191,'_accordion_0_itm_txt_0_txt_flex','field_588f82b779e0d'),(1026,191,'accordion_0_itm_txt_1_texto_heading','Quem paga pelo prejuízo?'),(1027,191,'_accordion_0_itm_txt_1_texto_heading','field_588f76e9cb9cf'),(1028,191,'accordion_0_itm_txt_1_cor_de_fundo',''),(1029,191,'_accordion_0_itm_txt_1_cor_de_fundo','field_588f91138c9fa'),(1030,191,'accordion_0_itm_txt_1_cor_do_texto','#dd9933'),(1031,191,'_accordion_0_itm_txt_1_cor_do_texto','field_588f91eaa6afb'),(1032,191,'accordion_0_itm_txt_1_cor_do_icone','#ffffff'),(1033,191,'_accordion_0_itm_txt_1_cor_do_icone','field_588f923ef5376'),(1034,191,'accordion_0_itm_txt_1_txt_flex','Todos os associados, proporcionalmente aos número de cotas.'),(1035,191,'_accordion_0_itm_txt_1_txt_flex','field_588f82b779e0d'),(1036,191,'accordion_0_itm_txt_2_texto_heading','O que são quotas?'),(1037,191,'_accordion_0_itm_txt_2_texto_heading','field_588f76e9cb9cf'),(1038,191,'accordion_0_itm_txt_2_cor_de_fundo','#dd9933'),(1039,191,'_accordion_0_itm_txt_2_cor_de_fundo','field_588f91138c9fa'),(1040,191,'accordion_0_itm_txt_2_cor_do_texto',''),(1041,191,'_accordion_0_itm_txt_2_cor_do_texto','field_588f91eaa6afb'),(1042,191,'accordion_0_itm_txt_2_cor_do_icone',''),(1043,191,'_accordion_0_itm_txt_2_cor_do_icone','field_588f923ef5376'),(1044,191,'accordion_0_itm_txt_2_txt_flex','Quantia com que cada pessoa contribui para o pagamento de uma despesa comum. No caso, o valor de cada veículo é convertido em cotas, exemplo: De R$0,00 à R$10.000,00 = 0,5 cota De R$10.001,00 à R$20.000,00 = 1 cota e assim sucessivamente.'),(1045,191,'_accordion_0_itm_txt_2_txt_flex','field_588f82b779e0d'),(1046,191,'accordion_0_itm_txt_3_texto_heading','Existe reserva financeira?'),(1047,191,'_accordion_0_itm_txt_3_texto_heading','field_588f76e9cb9cf'),(1048,191,'accordion_0_itm_txt_3_cor_de_fundo','#dd9933'),(1049,191,'_accordion_0_itm_txt_3_cor_de_fundo','field_588f91138c9fa'),(1050,191,'accordion_0_itm_txt_3_cor_do_texto',''),(1051,191,'_accordion_0_itm_txt_3_cor_do_texto','field_588f91eaa6afb'),(1052,191,'accordion_0_itm_txt_3_cor_do_icone',''),(1053,191,'_accordion_0_itm_txt_3_cor_do_icone','field_588f923ef5376'),(1054,191,'accordion_0_itm_txt_3_txt_flex','<div class=\"panel panel-default\">\r\n<div id=\"collapse4\" class=\"panel-collapse collapse in\">\r\n<div class=\"panel-body\">\r\n\r\nNão é necessário, uma vez que os prejuízos são rateados entre os associados, mas, nada impede que uma associação constitua reservas ou até mesmo patrimônio.\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"panel panel-default\"></div>'),(1055,191,'_accordion_0_itm_txt_3_txt_flex','field_588f82b779e0d'),(1056,191,'accordion_0_itm_txt_4_texto_heading','Quem controla uma associação?'),(1057,191,'_accordion_0_itm_txt_4_texto_heading','field_588f76e9cb9cf'),(1058,191,'accordion_0_itm_txt_4_cor_de_fundo','#dd9933'),(1059,191,'_accordion_0_itm_txt_4_cor_de_fundo','field_588f91138c9fa'),(1060,191,'accordion_0_itm_txt_4_cor_do_texto',''),(1061,191,'_accordion_0_itm_txt_4_cor_do_texto','field_588f91eaa6afb'),(1062,191,'accordion_0_itm_txt_4_cor_do_icone',''),(1063,191,'_accordion_0_itm_txt_4_cor_do_icone','field_588f923ef5376'),(1064,191,'accordion_0_itm_txt_4_txt_flex','<div class=\"panel panel-default\">\r\n<div id=\"collapse5\" class=\"panel-collapse collapse in\">\r\n<div class=\"panel-body\">\r\n\r\nUma associação é controlada pelo seu Presidente e demais diretores, que devem se empenhar para seguir o Estatuto e o Regulamento da associação.\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"panel panel-default\"></div>'),(1065,191,'_accordion_0_itm_txt_4_txt_flex','field_588f82b779e0d'),(1066,191,'accordion_0_itm_txt_5_texto_heading','O que é Estatuto?'),(1067,191,'_accordion_0_itm_txt_5_texto_heading','field_588f76e9cb9cf'),(1068,191,'accordion_0_itm_txt_5_cor_de_fundo','#dd9933'),(1069,191,'_accordion_0_itm_txt_5_cor_de_fundo','field_588f91138c9fa'),(1070,191,'accordion_0_itm_txt_5_cor_do_texto',''),(1071,191,'_accordion_0_itm_txt_5_cor_do_texto','field_588f91eaa6afb'),(1072,191,'accordion_0_itm_txt_5_cor_do_icone',''),(1073,191,'_accordion_0_itm_txt_5_cor_do_icone','field_588f923ef5376'),(1074,191,'accordion_0_itm_txt_5_txt_flex','&nbsp;\r\n\r\nEstatuto, é um conjunto de normas jurídicas, acordada pelos seus sócios ou fundadores, que regulamenta o funcionamento de uma pessoa jurídica, quer seja uma sociedade, uma associação ou fundação.'),(1075,191,'_accordion_0_itm_txt_5_txt_flex','field_588f82b779e0d'),(1076,191,'accordion_0_itm_txt_6_texto_heading','O que é regulamento?'),(1077,191,'_accordion_0_itm_txt_6_texto_heading','field_588f76e9cb9cf'),(1078,191,'accordion_0_itm_txt_6_cor_de_fundo','#dd9933'),(1079,191,'_accordion_0_itm_txt_6_cor_de_fundo','field_588f91138c9fa'),(1080,191,'accordion_0_itm_txt_6_cor_do_texto',''),(1081,191,'_accordion_0_itm_txt_6_cor_do_texto','field_588f91eaa6afb'),(1082,191,'accordion_0_itm_txt_6_cor_do_icone',''),(1083,191,'_accordion_0_itm_txt_6_cor_do_icone','field_588f923ef5376'),(1084,191,'accordion_0_itm_txt_6_txt_flex','<div class=\"panel panel-default\">\r\n<div id=\"collapse7\" class=\"panel-collapse collapse in\">\r\n<div class=\"panel-body\">\r\n\r\nÉ um conjunto organizado e coerente de preceitos ou normas, que regerão o trabalho em uma organização.\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"panel panel-default\"></div>'),(1085,191,'_accordion_0_itm_txt_6_txt_flex','field_588f82b779e0d'),(1086,191,'accordion_0_itm_txt_7_texto_heading','A atividade é ilegal?'),(1087,191,'_accordion_0_itm_txt_7_texto_heading','field_588f76e9cb9cf'),(1088,191,'accordion_0_itm_txt_7_cor_de_fundo','#dd9933'),(1089,191,'_accordion_0_itm_txt_7_cor_de_fundo','field_588f91138c9fa'),(1090,191,'accordion_0_itm_txt_7_cor_do_texto',''),(1091,191,'_accordion_0_itm_txt_7_cor_do_texto','field_588f91eaa6afb'),(1092,191,'accordion_0_itm_txt_7_cor_do_icone',''),(1093,191,'_accordion_0_itm_txt_7_cor_do_icone','field_588f923ef5376'),(1094,191,'accordion_0_itm_txt_7_txt_flex','Não, a atividade associativista está amparada pela lei federal em seu artigo 5° e, no artigo 53 do novo código civil brasileiro, que diz que: “Todos são iguais perante a lei, sem distinção de qualquer natureza”.'),(1095,191,'_accordion_0_itm_txt_7_txt_flex','field_588f82b779e0d'),(1096,191,'accordion_0_itm_txt_8_texto_heading','A Proteção Veicular é o mesmo que seguro?'),(1097,191,'_accordion_0_itm_txt_8_texto_heading','field_588f76e9cb9cf'),(1098,191,'accordion_0_itm_txt_8_cor_de_fundo',''),(1099,191,'_accordion_0_itm_txt_8_cor_de_fundo','field_588f91138c9fa'),(1100,191,'accordion_0_itm_txt_8_cor_do_texto',''),(1101,191,'_accordion_0_itm_txt_8_cor_do_texto','field_588f91eaa6afb'),(1102,191,'accordion_0_itm_txt_8_cor_do_icone',''),(1103,191,'_accordion_0_itm_txt_8_cor_do_icone','field_588f923ef5376'),(1104,191,'accordion_0_itm_txt_8_txt_flex','<div class=\"panel panel-default\">\r\n<div id=\"collapse9\" class=\"panel-collapse collapse in\">\r\n<div class=\"panel-body\">\r\n\r\nNão, as associações em sua maioria são entidades sem fins lucrativos, onde na sua essência, buscam gerar algum tipo de benefício aos seus associados. No caso da Proteção Veicular, os benefícios são alcançados pelos custos reduzidos dos valores da proteção, e na agilidade dos processos.\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"panel panel-default\"></div>'),(1105,191,'_accordion_0_itm_txt_8_txt_flex','field_588f82b779e0d'),(1106,191,'accordion_0_itm_txt_9_texto_heading','A Susep, tem algum poder sobre uma associação?'),(1107,191,'_accordion_0_itm_txt_9_texto_heading','field_588f76e9cb9cf'),(1108,191,'accordion_0_itm_txt_9_cor_de_fundo',''),(1109,191,'_accordion_0_itm_txt_9_cor_de_fundo','field_588f91138c9fa'),(1110,191,'accordion_0_itm_txt_9_cor_do_texto',''),(1111,191,'_accordion_0_itm_txt_9_cor_do_texto','field_588f91eaa6afb'),(1112,191,'accordion_0_itm_txt_9_cor_do_icone',''),(1113,191,'_accordion_0_itm_txt_9_cor_do_icone','field_588f923ef5376'),(1114,191,'accordion_0_itm_txt_9_txt_flex','Não, a Susep é o órgão que regulamenta os seguros privados no Brasil. Como a atividade praticada pela associação não pode ser confundida com seguro, a Susep não tem nenhum poder regulatório sobre as associações.'),(1115,191,'_accordion_0_itm_txt_9_txt_flex','field_588f82b779e0d'),(1116,191,'accordion_0_itm_txt_10_texto_heading','Você sabe a diferença de auxilio Funeral e Assistência Funeral ?'),(1117,191,'_accordion_0_itm_txt_10_texto_heading','field_588f76e9cb9cf'),(1118,191,'accordion_0_itm_txt_10_cor_de_fundo',''),(1119,191,'_accordion_0_itm_txt_10_cor_de_fundo','field_588f91138c9fa'),(1120,191,'accordion_0_itm_txt_10_cor_do_texto',''),(1121,191,'_accordion_0_itm_txt_10_cor_do_texto','field_588f91eaa6afb'),(1122,191,'accordion_0_itm_txt_10_cor_do_icone',''),(1123,191,'_accordion_0_itm_txt_10_cor_do_icone','field_588f923ef5376'),(1124,191,'accordion_0_itm_txt_10_txt_flex','O seguro auxílio-funeral, geralmente, tem capital segurado (valor da\r\nindenização) de valor baixo, com cobrança do prêmio respectivo. Seu objetivo\r\né reembolsar as despesas com o funeral do segurado. A escolha de prestadores\r\ndos serviços é livre. O seguro garante o reembolso das despesas com o\r\nsepultamento do segurado, permitindo que a família escolha livremente os\r\nserviços que quer contratar. Sua contratação pode ser feita junto com a do\r\nseguro de acidentes pessoais.\r\n\r\nA assistência funeral, por sua vez, é um serviço sem direito à livre\r\nescolha. Os familiares do segurado ficam limitados a prestadores de serviços\r\nindicados pela seguradora.'),(1125,191,'_accordion_0_itm_txt_10_txt_flex','field_588f82b779e0d'),(1126,191,'accordion_0_itm_txt','a:11:{i:0;s:5:\"txt_2\";i:1;s:5:\"txt_2\";i:2;s:5:\"txt_2\";i:3;s:5:\"txt_2\";i:4;s:5:\"txt_2\";i:5;s:5:\"txt_2\";i:6;s:5:\"txt_2\";i:7;s:5:\"txt_2\";i:8;s:5:\"txt_2\";i:9;s:5:\"txt_2\";i:10;s:5:\"txt_2\";}'),(1127,191,'_accordion_0_itm_txt','field_588f7649cb9ce'),(1128,191,'accordion_1_itm_txt',''),(1129,191,'_accordion_1_itm_txt','field_588f7649cb9ce'),(1130,191,'accordion','2'),(1131,191,'_accordion','field_588f7627cb9cd'),(1134,192,'texto_diferenciado',''),(1135,192,'_texto_diferenciado','field_58862a7dd9d12'),(1136,192,'accordion_0_itm_txt_0_texto_heading','O que é rateio em uma associação de proteção veicular?'),(1137,192,'_accordion_0_itm_txt_0_texto_heading','field_588f76e9cb9cf'),(1138,192,'accordion_0_itm_txt_0_cor_de_fundo',''),(1139,192,'_accordion_0_itm_txt_0_cor_de_fundo','field_588f91138c9fa'),(1140,192,'accordion_0_itm_txt_0_cor_do_texto','#dd9933'),(1141,192,'_accordion_0_itm_txt_0_cor_do_texto','field_588f91eaa6afb'),(1142,192,'accordion_0_itm_txt_0_cor_do_icone','#ffffff'),(1143,192,'_accordion_0_itm_txt_0_cor_do_icone','field_588f923ef5376'),(1144,192,'accordion_0_itm_txt_0_txt_flex','Rateio é a divisão proporcional dos prejuízos causados pelos veículos dos associados.'),(1145,192,'_accordion_0_itm_txt_0_txt_flex','field_588f82b779e0d'),(1146,192,'accordion_0_itm_txt_1_texto_heading','Quem paga pelo prejuízo?'),(1147,192,'_accordion_0_itm_txt_1_texto_heading','field_588f76e9cb9cf'),(1148,192,'accordion_0_itm_txt_1_cor_de_fundo',''),(1149,192,'_accordion_0_itm_txt_1_cor_de_fundo','field_588f91138c9fa'),(1150,192,'accordion_0_itm_txt_1_cor_do_texto','#dd9933'),(1151,192,'_accordion_0_itm_txt_1_cor_do_texto','field_588f91eaa6afb'),(1152,192,'accordion_0_itm_txt_1_cor_do_icone','#ffffff'),(1153,192,'_accordion_0_itm_txt_1_cor_do_icone','field_588f923ef5376'),(1154,192,'accordion_0_itm_txt_1_txt_flex','Todos os associados, proporcionalmente aos número de cotas.'),(1155,192,'_accordion_0_itm_txt_1_txt_flex','field_588f82b779e0d'),(1156,192,'accordion_0_itm_txt_2_texto_heading','O que são quotas?'),(1157,192,'_accordion_0_itm_txt_2_texto_heading','field_588f76e9cb9cf'),(1158,192,'accordion_0_itm_txt_2_cor_de_fundo','#dd9933'),(1159,192,'_accordion_0_itm_txt_2_cor_de_fundo','field_588f91138c9fa'),(1160,192,'accordion_0_itm_txt_2_cor_do_texto',''),(1161,192,'_accordion_0_itm_txt_2_cor_do_texto','field_588f91eaa6afb'),(1162,192,'accordion_0_itm_txt_2_cor_do_icone',''),(1163,192,'_accordion_0_itm_txt_2_cor_do_icone','field_588f923ef5376'),(1164,192,'accordion_0_itm_txt_2_txt_flex','Quantia com que cada pessoa contribui para o pagamento de uma despesa comum. No caso, o valor de cada veículo é convertido em cotas, exemplo: De R$0,00 à R$10.000,00 = 0,5 cota De R$10.001,00 à R$20.000,00 = 1 cota e assim sucessivamente.'),(1165,192,'_accordion_0_itm_txt_2_txt_flex','field_588f82b779e0d'),(1166,192,'accordion_0_itm_txt_3_texto_heading','Existe reserva financeira?'),(1167,192,'_accordion_0_itm_txt_3_texto_heading','field_588f76e9cb9cf'),(1168,192,'accordion_0_itm_txt_3_cor_de_fundo','#dd9933'),(1169,192,'_accordion_0_itm_txt_3_cor_de_fundo','field_588f91138c9fa'),(1170,192,'accordion_0_itm_txt_3_cor_do_texto',''),(1171,192,'_accordion_0_itm_txt_3_cor_do_texto','field_588f91eaa6afb'),(1172,192,'accordion_0_itm_txt_3_cor_do_icone',''),(1173,192,'_accordion_0_itm_txt_3_cor_do_icone','field_588f923ef5376'),(1174,192,'accordion_0_itm_txt_3_txt_flex','<div class=\"panel panel-default\">\r\n<div id=\"collapse4\" class=\"panel-collapse collapse in\">\r\n<div class=\"panel-body\">\r\n\r\nNão é necessário, uma vez que os prejuízos são rateados entre os associados, mas, nada impede que uma associação constitua reservas ou até mesmo patrimônio.\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"panel panel-default\"></div>'),(1175,192,'_accordion_0_itm_txt_3_txt_flex','field_588f82b779e0d'),(1176,192,'accordion_0_itm_txt_4_texto_heading','Quem controla uma associação?'),(1177,192,'_accordion_0_itm_txt_4_texto_heading','field_588f76e9cb9cf'),(1178,192,'accordion_0_itm_txt_4_cor_de_fundo','#dd9933'),(1179,192,'_accordion_0_itm_txt_4_cor_de_fundo','field_588f91138c9fa'),(1180,192,'accordion_0_itm_txt_4_cor_do_texto',''),(1181,192,'_accordion_0_itm_txt_4_cor_do_texto','field_588f91eaa6afb'),(1182,192,'accordion_0_itm_txt_4_cor_do_icone',''),(1183,192,'_accordion_0_itm_txt_4_cor_do_icone','field_588f923ef5376'),(1184,192,'accordion_0_itm_txt_4_txt_flex','<div class=\"panel panel-default\">\r\n<div id=\"collapse5\" class=\"panel-collapse collapse in\">\r\n<div class=\"panel-body\">\r\n\r\nUma associação é controlada pelo seu Presidente e demais diretores, que devem se empenhar para seguir o Estatuto e o Regulamento da associação.\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"panel panel-default\"></div>'),(1185,192,'_accordion_0_itm_txt_4_txt_flex','field_588f82b779e0d'),(1186,192,'accordion_0_itm_txt_5_texto_heading','O que é Estatuto?'),(1187,192,'_accordion_0_itm_txt_5_texto_heading','field_588f76e9cb9cf'),(1188,192,'accordion_0_itm_txt_5_cor_de_fundo','#dd9933'),(1189,192,'_accordion_0_itm_txt_5_cor_de_fundo','field_588f91138c9fa'),(1190,192,'accordion_0_itm_txt_5_cor_do_texto',''),(1191,192,'_accordion_0_itm_txt_5_cor_do_texto','field_588f91eaa6afb'),(1192,192,'accordion_0_itm_txt_5_cor_do_icone',''),(1193,192,'_accordion_0_itm_txt_5_cor_do_icone','field_588f923ef5376'),(1194,192,'accordion_0_itm_txt_5_txt_flex','&nbsp;\r\n\r\nEstatuto, é um conjunto de normas jurídicas, acordada pelos seus sócios ou fundadores, que regulamenta o funcionamento de uma pessoa jurídica, quer seja uma sociedade, uma associação ou fundação.'),(1195,192,'_accordion_0_itm_txt_5_txt_flex','field_588f82b779e0d'),(1196,192,'accordion_0_itm_txt_6_texto_heading','O que é regulamento?'),(1197,192,'_accordion_0_itm_txt_6_texto_heading','field_588f76e9cb9cf'),(1198,192,'accordion_0_itm_txt_6_cor_de_fundo','#dd9933'),(1199,192,'_accordion_0_itm_txt_6_cor_de_fundo','field_588f91138c9fa'),(1200,192,'accordion_0_itm_txt_6_cor_do_texto',''),(1201,192,'_accordion_0_itm_txt_6_cor_do_texto','field_588f91eaa6afb'),(1202,192,'accordion_0_itm_txt_6_cor_do_icone',''),(1203,192,'_accordion_0_itm_txt_6_cor_do_icone','field_588f923ef5376'),(1204,192,'accordion_0_itm_txt_6_txt_flex','<div class=\"panel panel-default\">\r\n<div id=\"collapse7\" class=\"panel-collapse collapse in\">\r\n<div class=\"panel-body\">\r\n\r\nÉ um conjunto organizado e coerente de preceitos ou normas, que regerão o trabalho em uma organização.\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"panel panel-default\"></div>'),(1205,192,'_accordion_0_itm_txt_6_txt_flex','field_588f82b779e0d'),(1206,192,'accordion_0_itm_txt_7_texto_heading','A atividade é ilegal?'),(1207,192,'_accordion_0_itm_txt_7_texto_heading','field_588f76e9cb9cf'),(1208,192,'accordion_0_itm_txt_7_cor_de_fundo','#dd9933'),(1209,192,'_accordion_0_itm_txt_7_cor_de_fundo','field_588f91138c9fa'),(1210,192,'accordion_0_itm_txt_7_cor_do_texto',''),(1211,192,'_accordion_0_itm_txt_7_cor_do_texto','field_588f91eaa6afb'),(1212,192,'accordion_0_itm_txt_7_cor_do_icone',''),(1213,192,'_accordion_0_itm_txt_7_cor_do_icone','field_588f923ef5376'),(1214,192,'accordion_0_itm_txt_7_txt_flex','Não, a atividade associativista está amparada pela lei federal em seu artigo 5° e, no artigo 53 do novo código civil brasileiro, que diz que: “Todos são iguais perante a lei, sem distinção de qualquer natureza”.'),(1215,192,'_accordion_0_itm_txt_7_txt_flex','field_588f82b779e0d'),(1216,192,'accordion_0_itm_txt_8_texto_heading','A Proteção Veicular é o mesmo que seguro?'),(1217,192,'_accordion_0_itm_txt_8_texto_heading','field_588f76e9cb9cf'),(1218,192,'accordion_0_itm_txt_8_cor_de_fundo',''),(1219,192,'_accordion_0_itm_txt_8_cor_de_fundo','field_588f91138c9fa'),(1220,192,'accordion_0_itm_txt_8_cor_do_texto',''),(1221,192,'_accordion_0_itm_txt_8_cor_do_texto','field_588f91eaa6afb'),(1222,192,'accordion_0_itm_txt_8_cor_do_icone',''),(1223,192,'_accordion_0_itm_txt_8_cor_do_icone','field_588f923ef5376'),(1224,192,'accordion_0_itm_txt_8_txt_flex','<div class=\"panel panel-default\">\r\n<div id=\"collapse9\" class=\"panel-collapse collapse in\">\r\n<div class=\"panel-body\">\r\n\r\nNão, as associações em sua maioria são entidades sem fins lucrativos, onde na sua essência, buscam gerar algum tipo de benefício aos seus associados. No caso da Proteção Veicular, os benefícios são alcançados pelos custos reduzidos dos valores da proteção, e na agilidade dos processos.\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"panel panel-default\"></div>'),(1225,192,'_accordion_0_itm_txt_8_txt_flex','field_588f82b779e0d'),(1226,192,'accordion_0_itm_txt_9_texto_heading','A Susep, tem algum poder sobre uma associação?'),(1227,192,'_accordion_0_itm_txt_9_texto_heading','field_588f76e9cb9cf'),(1228,192,'accordion_0_itm_txt_9_cor_de_fundo',''),(1229,192,'_accordion_0_itm_txt_9_cor_de_fundo','field_588f91138c9fa'),(1230,192,'accordion_0_itm_txt_9_cor_do_texto',''),(1231,192,'_accordion_0_itm_txt_9_cor_do_texto','field_588f91eaa6afb'),(1232,192,'accordion_0_itm_txt_9_cor_do_icone',''),(1233,192,'_accordion_0_itm_txt_9_cor_do_icone','field_588f923ef5376'),(1234,192,'accordion_0_itm_txt_9_txt_flex','Não, a Susep é o órgão que regulamenta os seguros privados no Brasil. Como a atividade praticada pela associação não pode ser confundida com seguro, a Susep não tem nenhum poder regulatório sobre as associações.'),(1235,192,'_accordion_0_itm_txt_9_txt_flex','field_588f82b779e0d'),(1236,192,'accordion_0_itm_txt_10_texto_heading','Você sabe a diferença de auxilio Funeral e Assistência Funeral ?'),(1237,192,'_accordion_0_itm_txt_10_texto_heading','field_588f76e9cb9cf'),(1238,192,'accordion_0_itm_txt_10_cor_de_fundo',''),(1239,192,'_accordion_0_itm_txt_10_cor_de_fundo','field_588f91138c9fa'),(1240,192,'accordion_0_itm_txt_10_cor_do_texto',''),(1241,192,'_accordion_0_itm_txt_10_cor_do_texto','field_588f91eaa6afb'),(1242,192,'accordion_0_itm_txt_10_cor_do_icone',''),(1243,192,'_accordion_0_itm_txt_10_cor_do_icone','field_588f923ef5376'),(1244,192,'accordion_0_itm_txt_10_txt_flex','O seguro auxílio-funeral, geralmente, tem capital segurado (valor da\r\nindenização) de valor baixo, com cobrança do prêmio respectivo. Seu objetivo\r\né reembolsar as despesas com o funeral do segurado. A escolha de prestadores\r\ndos serviços é livre. O seguro garante o reembolso das despesas com o\r\nsepultamento do segurado, permitindo que a família escolha livremente os\r\nserviços que quer contratar. Sua contratação pode ser feita junto com a do\r\nseguro de acidentes pessoais.\r\n\r\nA assistência funeral, por sua vez, é um serviço sem direito à livre\r\nescolha. Os familiares do segurado ficam limitados a prestadores de serviços\r\nindicados pela seguradora.\r\n\r\n&nbsp;\r\n\r\n&nbsp;'),(1245,192,'_accordion_0_itm_txt_10_txt_flex','field_588f82b779e0d'),(1246,192,'accordion_0_itm_txt','a:11:{i:0;s:5:\"txt_2\";i:1;s:5:\"txt_2\";i:2;s:5:\"txt_2\";i:3;s:5:\"txt_2\";i:4;s:5:\"txt_2\";i:5;s:5:\"txt_2\";i:6;s:5:\"txt_2\";i:7;s:5:\"txt_2\";i:8;s:5:\"txt_2\";i:9;s:5:\"txt_2\";i:10;s:5:\"txt_2\";}'),(1247,192,'_accordion_0_itm_txt','field_588f7649cb9ce'),(1248,192,'accordion','1'),(1249,192,'_accordion','field_588f7627cb9cd'),(1302,194,'_wp_attachment_metadata','a:5:{s:5:\"width\";i:512;s:6:\"height\";i:415;s:4:\"file\";s:30:\"2017/01/referenciaderatio1.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"referenciaderatio1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"referenciaderatio1-300x243.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:243;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),(1301,194,'_wp_attached_file','2017/01/referenciaderatio1.jpg'),(1260,193,'acordions',''),(1261,193,'_acordions','field_5887501a480ec'),(1262,81,'_disabel_wpdevart_facebook_comment','enable'),(1263,81,'_rdscriptcontenttop',''),(1264,81,'_rdscriptcontentbottom',''),(1265,81,'_rdscriptcontentinhead',''),(1266,81,'_rdscriptcontentinfooter',''),(1267,81,'_at_widget','1'),(1268,81,'_aioseop_opengraph_settings','a:13:{s:32:\"aioseop_opengraph_settings_title\";s:0:\"\";s:31:\"aioseop_opengraph_settings_desc\";s:0:\"\";s:36:\"aioseop_opengraph_settings_customimg\";s:0:\"\";s:37:\"aioseop_opengraph_settings_imagewidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_imageheight\";s:0:\"\";s:32:\"aioseop_opengraph_settings_video\";s:0:\"\";s:37:\"aioseop_opengraph_settings_videowidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_videoheight\";s:0:\"\";s:35:\"aioseop_opengraph_settings_category\";s:8:\"activity\";s:34:\"aioseop_opengraph_settings_section\";s:0:\"\";s:30:\"aioseop_opengraph_settings_tag\";s:0:\"\";s:34:\"aioseop_opengraph_settings_setcard\";s:7:\"summary\";s:44:\"aioseop_opengraph_settings_customimg_twitter\";s:0:\"\";}'),(1269,193,'accordion_0_itm_txt_0_texto_heading','REGULAMENTO DO PROGRAMA DE PROTEÇÃO DE MOTOCICLETAS – GASP'),(1270,193,'_accordion_0_itm_txt_0_texto_heading','field_588f76e9cb9cf'),(1271,193,'accordion_0_itm_txt_0_cor_de_fundo',''),(1272,193,'_accordion_0_itm_txt_0_cor_de_fundo','field_588f91138c9fa'),(1273,193,'accordion_0_itm_txt_0_cor_do_texto',''),(1274,193,'_accordion_0_itm_txt_0_cor_do_texto','field_588f91eaa6afb'),(1275,193,'accordion_0_itm_txt_0_cor_do_icone',''),(1276,193,'_accordion_0_itm_txt_0_cor_do_icone','field_588f923ef5376'),(1277,193,'accordion_0_itm_txt_0_txt_flex','1. - O presente regulamento tem como objetivo estabelecer as normas e regras do Programa de Proteção Automotiva da GASP, conforme art. 2 do estatuto social, devendo ser meticulosamente cumprido e observado pelos órgãos estatutários, dirigentes, funcionários e associados aderentes ao programa.\r\n\r\n1.1 - A GASP é dotado de personalidade jurídica, constituído na forma de associa- ção, não devendo ser tratado em hipótese alguma como uma sociedade empresária, consideradas as peculiaridades do programa de proteção automotiva, especialmente no que tange ao rateio das despesas com eventos entre os associados e a completa ausência de finalidade lucrativa.'),(1278,193,'_accordion_0_itm_txt_0_txt_flex','field_588f82b779e0d'),(1279,193,'accordion_0_itm_txt_1_texto_heading','ADESÃO AO PROGRAMA DE PROTEÇÃO DE MOTOCICLETAS (PPM)'),(1280,193,'_accordion_0_itm_txt_1_texto_heading','field_588f76e9cb9cf'),(1281,193,'accordion_0_itm_txt_1_cor_de_fundo',''),(1282,193,'_accordion_0_itm_txt_1_cor_de_fundo','field_588f91138c9fa'),(1283,193,'accordion_0_itm_txt_1_cor_do_texto',''),(1284,193,'_accordion_0_itm_txt_1_cor_do_texto','field_588f91eaa6afb'),(1285,193,'accordion_0_itm_txt_1_cor_do_icone',''),(1286,193,'_accordion_0_itm_txt_1_cor_do_icone','field_588f923ef5376'),(1287,193,'accordion_0_itm_txt_1_txt_flex','2 – O Programa de Proteção Automotiva (PPM) da GASP tem como objetivo primordial conferir proteção e segurança aos automóveis de seus associados aderentes ao programa, através do rateio dos danos materiais eventualmente sofridos e protegidos pelo programa, na forma deste regulamento, bem como através da prevenção ativa de acidentes, pela veiculação de material educativo pertinente às normas de segurança no trânsito.\r\n\r\n2.1 - Para aderir ao PPM da GASP, o associado deverá encaminhar à Diretoria da Associação os seguintes documentos, além de pagar a taxa de adesão:\r\n\r\n2.1.1 – Requerimento de adesão em modelo próprio;\r\n\r\n2.1.2 – Carteira Nacional de Habilitação ou CPF e RG, caso associado não for habilitado.\r\n\r\n2.1.3 – CRV da motocicleta, ou nota fiscal em caso de 0km;\r\n\r\n2.1.4 – Contrato Social ou Estatuto Social, caso seja pessoa jurídica.\r\n\r\n2.1.5 – Inspeção com fotos, realizada por profissional credenciado à GASP.\r\n\r\n2.2 - O período mínimo de participação no PPM da GASP é de 2 (dois) meses, contados a partir da adesão ao programa e, caso o associado venha a usufruir do benefício da repartição de prejuízos materiais conferido pelo PPM, haverá uma nova fidelização de 6 (Seis) meses a contar da data do acionamento.\r\n\r\n2.3 – O associado que desejar se desligar do PPM deverá encaminhar um requerimento escrito à diretoria da associação, devendo o associado estar adimplente com todas as suas obrigações relativas ao PPM. O requerimento deverá conter as seguintes informações: Nome completo, CPF, modelo da motocicleta, placa, motivo do desligamento.\r\n\r\n2.3.1 – O pedido de desligamento deverá ser realizado até o 20º dia do mês, ressaltada a responsabilidade pelo pagamento do próximo mês.\r\n\r\n2.3.2 – O associado que requerer o desligamento em violação ao disposto no item 2.2, incorrerá em multa correspondente ao valor mensal médio do rateio apurado nos seis meses anteriores ao pedido, multiplicado pelo número de meses faltantes para o cumprimento do prazo designado no referido item.\r\n\r\n2.3.3 - Será permitida a transferência de titularidade de um veículo cadastrado no PPM, desde que o novo associado titular pague uma taxa relativa a transferência e que não tenha nenhum impedimento quanto a sua inclusão no programa, ou caso não seja associado, ao quadro de associados da GASP. Este procedimento estará condicionado a aprovação expressa da diretoria da Associação.\r\n\r\n2.3.4 - Será permitida a substituição de um veículo cadastrado no PPM, desde que o associado pague uma taxa relativa a substituição e que o veículo não tenha nenhum impedimento quanto a sua inclusão na referida proteção. Este procedimento estará condicionado a aprovação expressa da diretoria da Associação.\r\n\r\n2.4 – Caso o associado ou o veículo cadastrado se envolva em mais de 2 (dois) acidentes de trânsito no período de 12 (doze) meses, haverá incidência de multa correspondente a duas vezes o valor da participação obrigatória do associado. Este poderá ser excluído compulsoriamente do PPM, a critério da Diretoria Executiva, e assegurado o direito a recurso administrativo e após este, pedido de reconsideração.\r\n\r\n2.5 - Os associados aderentes ao PPM da GASP deverão pagar a taxa administrativa do PPM, por cada automóvel cadastrado, correspondente ao custeio de despesas administrativas do PPM.\r\n\r\n2.5.1 - O valor da taxa administrativa do PPM, calculado de acordo com o valor da motocicleta, terá como referência o perfil da motocicleta de acordo com os seus respectivos valores de mercado, tendo em vista o índice da tabela FIPE (www. FIPE.com.br) ou outro critério justificado, aplicado pela Diretoria Executiva\r\n\r\n2.5.1.1 – Caso a motocicleta cadastrada seja de ano de fabricação e de modelo diferentes (Ex: 2008/2009), a avaliação será feita pela média entre os valores fornecidos pela tabela FIPE de cada um dos anos.\r\n\r\n2.5.2 - Enquanto o associado estiver participando do PPM, ele pagará uma tax associativa de R$10,00 ( dez reais) referentes à contribuição associativa da GASP mais o rateio do mês anterior. Caso ele queira se desligar do PPM, o associado voltará a pagar somente a contribuição associativa, nos termos do regimento interno da GASP.\r\n\r\n2.5.3 – É de inteira responsabilidade do associado o monitoramento do valor da motocicleta, e seu remanejamento entre os perfis da cláusula 2.5.1. Salienta-se que o ressarcimento será sempre feito com base no valor de tabela da motocicleta na data do evento danoso, independente de seu valor da época da adesão.\r\n\r\n2.6 - Os valores citados na cláusula 2.5.1 serão administrados pela Diretoria Executiva da GASP, e aplicados na manutenção das despesas administrativas do PPM, e não confundem com a contribuição associativa, que se destina ao custeio da associação.\r\n\r\n2.7 – Em caso de inadimplência, o associado não poderá usufruir de nenhum dos benefícios oferecidos pelo PPM da GASP, além de estar sujeito à eliminação do PPM, do quadro de associados da GASP, e ainda de ter seu CPF inscrito nos serviços de proteção ao crédito (SPC e SERASA).\r\n\r\n2.8 - A eliminação do associado do corpo social obedecerá ao disposto no art. 9º do Estatuto Social da GASP, cabendo à Diretoria Executiva ratificá-la, sempre resguardado o direito à ampla defesa e à interposição de recurso administrativo com efeito suspensivo à Assembléia Geral subseqüente à deliberação, o prazo para interposição do recurso, para as finalidades previstas nesta cláusula é de 5 (cinco) dias corridos, a partir da notificação formal do associado.\r\n\r\n2.9 - Os veículos deverão ser previamente cadastrados junto ao PPM da GASP, através de vistoria a ser realizada, arquivando-se fotos dos mesmos e todos os documentos elencados na cláusula de número 2.1.\r\n\r\n2.9.1 - A GASP não efetua na vistoria nenhuma avaliação do valor de mercado da motocicleta (tal avaliação se dará previamente através de consulta à tabela FIPE),nem da legalidade de sua procedência, sendo esta de inteira responsabilidade do associado.'),(1288,193,'_accordion_0_itm_txt_1_txt_flex','field_588f82b779e0d'),(1289,193,'accordion_0_itm_txt_2_texto_heading','ACEITAÇÃO E INÍCIO DO BENEFÍCIO DA PROTEÇÃO AUTOMOTIVA'),(1290,193,'_accordion_0_itm_txt_2_texto_heading','field_588f76e9cb9cf'),(1291,193,'accordion_0_itm_txt_2_cor_de_fundo',''),(1292,193,'_accordion_0_itm_txt_2_cor_de_fundo','field_588f91138c9fa'),(1293,193,'accordion_0_itm_txt_2_cor_do_texto',''),(1294,193,'_accordion_0_itm_txt_2_cor_do_texto','field_588f91eaa6afb'),(1295,193,'accordion_0_itm_txt_2_cor_do_icone',''),(1296,193,'_accordion_0_itm_txt_2_cor_do_icone','field_588f923ef5376'),(1297,193,'accordion_0_itm_txt_2_txt_flex','3.1 – Os benefícios do PPM para veículo do associado cadastrado tem início a partir da data e hora de pagamento da taxa de adesão e inspeção veicular.\r\n\r\n3.1.1 - A vistoria veicular poderá ser dispensada por até 5 (cinco) dias, com cobertura normal, quando o veículo for 0 (zero) km e for enviado a GASP, por fax ou outra forma, Nota Fiscal da motocicleta antes dela sair da concessionária ou revenda. Após esse período a proteção estará suspensa até que seja feita a vistoria.\r\n\r\n3.2 - A Proposta de adesão ao PPM poderá ser recusada em até 15 (quinze) dias pela Diretoria da GASP, contados a partir da data do seu recebimento. A eventual recusa e os motivos desta serão informados ao pretendente através de carta com AR, enviada ao endereço constante na proposta de adesão. Na hipótese de recusa, os valores das taxas discriminadas no item acima serão ressarcidos em até 10 (dez) dias, restando válida a proteção do PPM, contudo, até a hora e data de entrega do AR que informar o associado da recusa, ou a quem receba o AR no endereço indicado pelo associado.\r\n\r\n3.3 - A diretoria da GASP se resguarda no direito de indeferir a inclusão de qualquer associado ao PPM, caso a sua motocicleta se encontre em más condições de conservação ou tenha alterações, modificações e assessórios que possam afetar sua segurança ou desempenho.\r\n\r\n3.3.1 – A Diretoria Executiva da GASP poderá ainda proceder à eliminação do PPM de qualquer um dos associados a qualquer tempo, caso este aja contra os interesses coletivos dos associados, ou viole qualquer uma das normas estatutárias ou regulamentares da associação, assegurado o direito a ampla defesa e contraditório, nos termos da cláusula 2.8.\r\n\r\n3.4 – A GASP exige ainda, para motocicletas com valor acima de 300 cilindradas, ou, a critério da Diretoria, a instalação e manutenção de equipamentos rastreadores ou bloqueadores, visando diminuir o índice de furto/roubo. Para estes veículos, os benefícios para casos de furto e roubo somente valerão após a instalação do rastreador ou bloqueador, e caso estes estejam em pleno funcionamento. A obrigatoriedade de instalação constará no laudo de inspeção.\r\n\r\n3.4.1 - É de inteira responsabilidade do associado a instalação do equipamento de rastreamento, localização e bloqueio, bem como o acompanhamento de seu funcionamento no caso do equipamento de rastreador. A não instalação desses equipamentos implica na não cobertura no caso de Furto ou Roubo da Moto.\r\n\r\n3.5 - A motocicleta deverá estar em dia com os impostos, taxas e toda a documentação necessária para a sua circulação, caso contrário, o associado não terá nenhum direito aos benefícios oferecidos pela GASP aos quais faz jus em caso de acidentes, tendo em vista que o mesmo não se encontrava apto para transitar em via pública.\r\n\r\n3.6 - O não pagamento do boleto mensal na data de vencimento, determina a perda automática de todos os benefícios oferecidos pelo PPM da GASP.\r\n\r\n3.7 - Para reativação dos benefícios do PPM, deverá o associado em atraso solicitar uma nova guia de cobrança e passar por uma nova vistoria, seja ela em um dos pontos autorizados sem custo para o associado, ou através da visita de um vistoriador sendo que neste caso o associado pagará uma taxa de deslocamento a ser determinada pela diretoria executiva da GASP.\r\n\r\n3.8 - Após 30 (trinta) dias de atraso no pagamento do boleto bancário, o Associado inadimplente poderá ter seu nome encaminhado aos órgãos de proteção ao crédito (tais como SPC, SERASA, etc.), podendo ainda o título ser protestado, sem prejuízo da propositura da Ação Judicial competente para recebimento do débito.\r\n\r\n3.9 - Se o Associado não quitar seu boleto até o último dia útil do mês vigente, seu veículo será automaticamente EXCLUÍDO da Proteção Automotiva da GASP, ficando sua re-inclusão condicionada:\r\n\r\nI. Ao pagamento do débito;\r\n\r\nII. A nova vistoria da motocicleta;\r\n\r\nIII. A parecer favorável da Diretoria.\r\n\r\n3.10 - O não recebimento do boleto e a exclusão do associado do PPM ou da GASP não o exime da responsabilidade pelo seu pagamento, visto que a cobrança se trata sempre do mês anterior, período em que o associado usufruiu dos benefícios do PPM.'),(1298,193,'_accordion_0_itm_txt_2_txt_flex','field_588f82b779e0d'),(1299,193,'accordion_0_itm_txt','a:3:{i:0;s:5:\"txt_2\";i:1;s:5:\"txt_2\";i:2;s:5:\"txt_2\";}'),(1300,193,'_accordion_0_itm_txt','field_588f7649cb9ce'),(1303,81,'texto_diferenciado','Regulamento de Motos'),(1304,81,'_texto_diferenciado','field_58862a7dd9d12'),(1305,81,'accordion_0_itm_txt_0_texto_heading','REGULAMENTO DO PROGRAMA DE PROTEÇÃO DE MOTOCICLETAS – GASP'),(1306,81,'_accordion_0_itm_txt_0_texto_heading','field_588f76e9cb9cf'),(1307,81,'accordion_0_itm_txt_0_cor_de_fundo',''),(1308,81,'_accordion_0_itm_txt_0_cor_de_fundo','field_588f91138c9fa'),(1309,81,'accordion_0_itm_txt_0_cor_do_texto',''),(1310,81,'_accordion_0_itm_txt_0_cor_do_texto','field_588f91eaa6afb'),(1311,81,'accordion_0_itm_txt_0_cor_do_icone',''),(1312,81,'_accordion_0_itm_txt_0_cor_do_icone','field_588f923ef5376'),(1313,81,'accordion_0_itm_txt_0_txt_flex','1. - O presente regulamento tem como objetivo estabelecer as normas e regras do Programa de Proteção Automotiva da GASP, conforme art. 2 do estatuto social, devendo ser meticulosamente cumprido e observado pelos órgãos estatutários, dirigentes, funcionários e associados aderentes ao programa.\r\n\r\n1.1 - A GASP é dotado de personalidade jurídica, constituído na forma de associa- ção, não devendo ser tratado em hipótese alguma como uma sociedade empresária, consideradas as peculiaridades do programa de proteção automotiva, especialmente no que tange ao rateio das despesas com eventos entre os associados e a completa ausência de finalidade lucrativa.'),(1314,81,'_accordion_0_itm_txt_0_txt_flex','field_588f82b779e0d'),(1315,81,'accordion_0_itm_txt_1_texto_heading','ADESÃO AO PROGRAMA DE PROTEÇÃO DE MOTOCICLETAS (PPM)'),(1316,81,'_accordion_0_itm_txt_1_texto_heading','field_588f76e9cb9cf'),(1317,81,'accordion_0_itm_txt_1_cor_de_fundo',''),(1318,81,'_accordion_0_itm_txt_1_cor_de_fundo','field_588f91138c9fa'),(1319,81,'accordion_0_itm_txt_1_cor_do_texto',''),(1320,81,'_accordion_0_itm_txt_1_cor_do_texto','field_588f91eaa6afb'),(1321,81,'accordion_0_itm_txt_1_cor_do_icone',''),(1322,81,'_accordion_0_itm_txt_1_cor_do_icone','field_588f923ef5376'),(1323,81,'accordion_0_itm_txt_1_txt_flex','2 – O Programa de Proteção Automotiva (PPM) da GASP tem como objetivo primordial conferir proteção e segurança aos automóveis de seus associados aderentes ao programa, através do rateio dos danos materiais eventualmente sofridos e protegidos pelo programa, na forma deste regulamento, bem como através da prevenção ativa de acidentes, pela veiculação de material educativo pertinente às normas de segurança no trânsito.\r\n\r\n2.1 - Para aderir ao PPM da GASP, o associado deverá encaminhar à Diretoria da Associação os seguintes documentos, além de pagar a taxa de adesão:\r\n\r\n2.1.1 – Requerimento de adesão em modelo próprio;\r\n\r\n2.1.2 – Carteira Nacional de Habilitação ou CPF e RG, caso associado não for habilitado.\r\n\r\n2.1.3 – CRV da motocicleta, ou nota fiscal em caso de 0km;\r\n\r\n2.1.4 – Contrato Social ou Estatuto Social, caso seja pessoa jurídica.\r\n\r\n2.1.5 – Inspeção com fotos, realizada por profissional credenciado à GASP.\r\n\r\n2.2 - O período mínimo de participação no PPM da GASP é de 2 (dois) meses, contados a partir da adesão ao programa e, caso o associado venha a usufruir do benefício da repartição de prejuízos materiais conferido pelo PPM, haverá uma nova fidelização de 6 (Seis) meses a contar da data do acionamento.\r\n\r\n2.3 – O associado que desejar se desligar do PPM deverá encaminhar um requerimento escrito à diretoria da associação, devendo o associado estar adimplente com todas as suas obrigações relativas ao PPM. O requerimento deverá conter as seguintes informações: Nome completo, CPF, modelo da motocicleta, placa, motivo do desligamento.\r\n\r\n2.3.1 – O pedido de desligamento deverá ser realizado até o 20º dia do mês, ressaltada a responsabilidade pelo pagamento do próximo mês.\r\n\r\n2.3.2 – O associado que requerer o desligamento em violação ao disposto no item 2.2, incorrerá em multa correspondente ao valor mensal médio do rateio apurado nos seis meses anteriores ao pedido, multiplicado pelo número de meses faltantes para o cumprimento do prazo designado no referido item.\r\n\r\n2.3.3 - Será permitida a transferência de titularidade de um veículo cadastrado no PPM, desde que o novo associado titular pague uma taxa relativa a transferência e que não tenha nenhum impedimento quanto a sua inclusão no programa, ou caso não seja associado, ao quadro de associados da GASP. Este procedimento estará condicionado a aprovação expressa da diretoria da Associação.\r\n\r\n2.3.4 - Será permitida a substituição de um veículo cadastrado no PPM, desde que o associado pague uma taxa relativa a substituição e que o veículo não tenha nenhum impedimento quanto a sua inclusão na referida proteção. Este procedimento estará condicionado a aprovação expressa da diretoria da Associação.\r\n\r\n2.4 – Caso o associado ou o veículo cadastrado se envolva em mais de 2 (dois) acidentes de trânsito no período de 12 (doze) meses, haverá incidência de multa correspondente a duas vezes o valor da participação obrigatória do associado. Este poderá ser excluído compulsoriamente do PPM, a critério da Diretoria Executiva, e assegurado o direito a recurso administrativo e após este, pedido de reconsideração.\r\n\r\n2.5 - Os associados aderentes ao PPM da GASP deverão pagar a taxa administrativa do PPM, por cada automóvel cadastrado, correspondente ao custeio de despesas administrativas do PPM.\r\n\r\n2.5.1 - O valor da taxa administrativa do PPM, calculado de acordo com o valor da motocicleta, terá como referência o perfil da motocicleta de acordo com os seus respectivos valores de mercado, tendo em vista o índice da tabela FIPE (www. FIPE.com.br) ou outro critério justificado, aplicado pela Diretoria Executiva\r\n\r\n2.5.1.1 – Caso a motocicleta cadastrada seja de ano de fabricação e de modelo diferentes (Ex: 2008/2009), a avaliação será feita pela média entre os valores fornecidos pela tabela FIPE de cada um dos anos.\r\n\r\n2.5.2 - Enquanto o associado estiver participando do PPM, ele pagará uma tax associativa de R$10,00 ( dez reais) referentes à contribuição associativa da GASP mais o rateio do mês anterior. Caso ele queira se desligar do PPM, o associado voltará a pagar somente a contribuição associativa, nos termos do regimento interno da GASP.\r\n\r\n2.5.3 – É de inteira responsabilidade do associado o monitoramento do valor da motocicleta, e seu remanejamento entre os perfis da cláusula 2.5.1. Salienta-se que o ressarcimento será sempre feito com base no valor de tabela da motocicleta na data do evento danoso, independente de seu valor da época da adesão.\r\n\r\n2.6 - Os valores citados na cláusula 2.5.1 serão administrados pela Diretoria Executiva da GASP, e aplicados na manutenção das despesas administrativas do PPM, e não confundem com a contribuição associativa, que se destina ao custeio da associação.\r\n\r\n2.7 – Em caso de inadimplência, o associado não poderá usufruir de nenhum dos benefícios oferecidos pelo PPM da GASP, além de estar sujeito à eliminação do PPM, do quadro de associados da GASP, e ainda de ter seu CPF inscrito nos serviços de proteção ao crédito (SPC e SERASA).\r\n\r\n2.8 - A eliminação do associado do corpo social obedecerá ao disposto no art. 9º do Estatuto Social da GASP, cabendo à Diretoria Executiva ratificá-la, sempre resguardado o direito à ampla defesa e à interposição de recurso administrativo com efeito suspensivo à Assembléia Geral subseqüente à deliberação, o prazo para interposição do recurso, para as finalidades previstas nesta cláusula é de 5 (cinco) dias corridos, a partir da notificação formal do associado.\r\n\r\n2.9 - Os veículos deverão ser previamente cadastrados junto ao PPM da GASP, através de vistoria a ser realizada, arquivando-se fotos dos mesmos e todos os documentos elencados na cláusula de número 2.1.\r\n\r\n2.9.1 - A GASP não efetua na vistoria nenhuma avaliação do valor de mercado da motocicleta (tal avaliação se dará previamente através de consulta à tabela FIPE),nem da legalidade de sua procedência, sendo esta de inteira responsabilidade do associado.');
INSERT INTO `wp_postmeta` VALUES (1324,81,'_accordion_0_itm_txt_1_txt_flex','field_588f82b779e0d'),(1325,81,'accordion_0_itm_txt_2_texto_heading','ACEITAÇÃO E INÍCIO DO BENEFÍCIO DA PROTEÇÃO AUTOMOTIVA'),(1326,81,'_accordion_0_itm_txt_2_texto_heading','field_588f76e9cb9cf'),(1327,81,'accordion_0_itm_txt_2_cor_de_fundo',''),(1328,81,'_accordion_0_itm_txt_2_cor_de_fundo','field_588f91138c9fa'),(1329,81,'accordion_0_itm_txt_2_cor_do_texto',''),(1330,81,'_accordion_0_itm_txt_2_cor_do_texto','field_588f91eaa6afb'),(1331,81,'accordion_0_itm_txt_2_cor_do_icone',''),(1332,81,'_accordion_0_itm_txt_2_cor_do_icone','field_588f923ef5376'),(1333,81,'accordion_0_itm_txt_2_txt_flex','3.1 – Os benefícios do PPM para veículo do associado cadastrado tem início a partir da data e hora de pagamento da taxa de adesão e inspeção veicular.\r\n\r\n3.1.1 - A vistoria veicular poderá ser dispensada por até 5 (cinco) dias, com cobertura normal, quando o veículo for 0 (zero) km e for enviado a GASP, por fax ou outra forma, Nota Fiscal da motocicleta antes dela sair da concessionária ou revenda. Após esse período a proteção estará suspensa até que seja feita a vistoria.\r\n\r\n3.2 - A Proposta de adesão ao PPM poderá ser recusada em até 15 (quinze) dias pela Diretoria da GASP, contados a partir da data do seu recebimento. A eventual recusa e os motivos desta serão informados ao pretendente através de carta com AR, enviada ao endereço constante na proposta de adesão. Na hipótese de recusa, os valores das taxas discriminadas no item acima serão ressarcidos em até 10 (dez) dias, restando válida a proteção do PPM, contudo, até a hora e data de entrega do AR que informar o associado da recusa, ou a quem receba o AR no endereço indicado pelo associado.\r\n\r\n3.3 - A diretoria da GASP se resguarda no direito de indeferir a inclusão de qualquer associado ao PPM, caso a sua motocicleta se encontre em más condições de conservação ou tenha alterações, modificações e assessórios que possam afetar sua segurança ou desempenho.\r\n\r\n3.3.1 – A Diretoria Executiva da GASP poderá ainda proceder à eliminação do PPM de qualquer um dos associados a qualquer tempo, caso este aja contra os interesses coletivos dos associados, ou viole qualquer uma das normas estatutárias ou regulamentares da associação, assegurado o direito a ampla defesa e contraditório, nos termos da cláusula 2.8.\r\n\r\n3.4 – A GASP exige ainda, para motocicletas com valor acima de 300 cilindradas, ou, a critério da Diretoria, a instalação e manutenção de equipamentos rastreadores ou bloqueadores, visando diminuir o índice de furto/roubo. Para estes veículos, os benefícios para casos de furto e roubo somente valerão após a instalação do rastreador ou bloqueador, e caso estes estejam em pleno funcionamento. A obrigatoriedade de instalação constará no laudo de inspeção.\r\n\r\n3.4.1 - É de inteira responsabilidade do associado a instalação do equipamento de rastreamento, localização e bloqueio, bem como o acompanhamento de seu funcionamento no caso do equipamento de rastreador. A não instalação desses equipamentos implica na não cobertura no caso de Furto ou Roubo da Moto.\r\n\r\n3.5 - A motocicleta deverá estar em dia com os impostos, taxas e toda a documentação necessária para a sua circulação, caso contrário, o associado não terá nenhum direito aos benefícios oferecidos pela GASP aos quais faz jus em caso de acidentes, tendo em vista que o mesmo não se encontrava apto para transitar em via pública.\r\n\r\n3.6 - O não pagamento do boleto mensal na data de vencimento, determina a perda automática de todos os benefícios oferecidos pelo PPM da GASP.\r\n\r\n3.7 - Para reativação dos benefícios do PPM, deverá o associado em atraso solicitar uma nova guia de cobrança e passar por uma nova vistoria, seja ela em um dos pontos autorizados sem custo para o associado, ou através da visita de um vistoriador sendo que neste caso o associado pagará uma taxa de deslocamento a ser determinada pela diretoria executiva da GASP.\r\n\r\n3.8 - Após 30 (trinta) dias de atraso no pagamento do boleto bancário, o Associado inadimplente poderá ter seu nome encaminhado aos órgãos de proteção ao crédito (tais como SPC, SERASA, etc.), podendo ainda o título ser protestado, sem prejuízo da propositura da Ação Judicial competente para recebimento do débito.\r\n\r\n3.9 - Se o Associado não quitar seu boleto até o último dia útil do mês vigente, seu veículo será automaticamente EXCLUÍDO da Proteção Automotiva da GASP, ficando sua re-inclusão condicionada:\r\n\r\nI. Ao pagamento do débito;\r\n\r\nII. A nova vistoria da motocicleta;\r\n\r\nIII. A parecer favorável da Diretoria.\r\n\r\n3.10 - O não recebimento do boleto e a exclusão do associado do PPM ou da GASP não o exime da responsabilidade pelo seu pagamento, visto que a cobrança se trata sempre do mês anterior, período em que o associado usufruiu dos benefícios do PPM.'),(1334,81,'_accordion_0_itm_txt_2_txt_flex','field_588f82b779e0d'),(1335,81,'accordion_0_itm_txt_3_texto_heading','BENEFÍCIOS DO PROGRAMA DE PROTEÇÃO AUTOMOTIVA'),(1336,81,'_accordion_0_itm_txt_3_texto_heading','field_588f76e9cb9cf'),(1337,81,'accordion_0_itm_txt_3_cor_de_fundo',''),(1338,81,'_accordion_0_itm_txt_3_cor_de_fundo','field_588f91138c9fa'),(1339,81,'accordion_0_itm_txt_3_cor_do_texto',''),(1340,81,'_accordion_0_itm_txt_3_cor_do_texto','field_588f91eaa6afb'),(1341,81,'accordion_0_itm_txt_3_cor_do_icone',''),(1342,81,'_accordion_0_itm_txt_3_cor_do_icone','field_588f923ef5376'),(1343,81,'accordion_0_itm_txt_3_txt_flex','4 – A cobertura do PPM se aplica aos seguintes eventos: Roubo, furto, colisão, capotamento, abalroamento, incêndio, chuvas de granizo, submersão por inundação ou alagamento de água doce, impacto de objetos externos sobre o veículo, queda (acidente durante transporte por meio apropriado e autorizado pelas autoridades de trânsito).\r\n\r\n4.1 – Não serão inclusos no benefício os acessórios da motocicleta, constando ou não no momento da inspeção inicial (a cláusula se aplica aos equipamentos de baú, rodas de liga e pneus [exceto originais], não são cobertos em hipótese alguma);\r\n\r\n4.1.1 – As garantias contra roubo e furto não se confundem com fraudes, estelionato e apropriação indébita\r\n\r\n4.1.2 - Não haverá benefício da cobertura para casos de roubo ou furto de veículos que não possuem o “rastreador via satélite”, conforme cláusula 3.4.\r\n\r\n4.1.3 - Na hipótese de indenizações de pneus que forem afetados pelo evento, a GASP pagará o valor correspondente ao estado do mesmo, seguindo o seguinte parâmetro: Pneus com até 6 (seis) meses de uso, ressarcimento de 100% (cem por cento) do valor. Pneus com mais de 6 (seis) meses de uso, ressarcimento de 50% cinquenta por cento) do valor.\r\n\r\n4.1.3.1 – Serão sempre adotados para aplicação das bases acima, os valores dos pneus novos à época do evento danoso. Caso este tenha saído de linha, observar- -se-á o valor do substituto ou equivalente.\r\n\r\n4.1.4 - Veículos com alíquotas, taxas ou impostos reduzidos ou isentos, tais como táxis, produtor rural e frotistas, serão ressarcidos pelo valor constante na Nota Fiscal da motocicleta, no caso de veículo 0 (zero) KM.\r\n\r\n4.2 - Não serão inclusos no benefício do Programa de Proteção Automotiva os seguintes casos:\r\n\r\n4.2.1 - Responsabilidade civil facultativa, danos materiais, pessoais, corporais e morais, a terceiros e aos ocupantes da motocicleta (exceto nos casos em que forem expressamente contratados à parte);\r\n\r\n4.2.2 - Eventos danosos decorrentes da inobservância das leis em vigor, como dirigir sem possuir carteira de habilitação ou estar com a mesma suspensa, ou ainda, não ter habilitação adequada conforme categoria da motocicleta, rebocar ou transportar o veículo inadequadamente;\r\n\r\n4.2.3 - Negligência na utilização ou manutenção da motocicleta (itens de segurança, pneus, direção perigosa ou sob efeitos de substâncias alcoólicas ou entorpecentes, etc.),\r\n\r\n4.2.4 - Utilizar inadequadamente a motocicleta com relação a lotações de passageiros, dimensão, peso e acondicionamento de carga transportada.\r\n\r\n4.2.5 – Veículos que tiveram alteradas as características originais, de modo a comprometer a segurança (Veículos com molas cortadas ou adulteradas,ou, com qualquer outra alteração na estrutura original), ainda que com preparação especializada ou laudo do INMETRO, somente terão a parte da lataria reparada em caso de acidente. A parte mecânica fica descoberta, em função do agravamento de risco por conta das alterações.\r\n\r\n4.2.6 - Desgaste natural ou pelo uso, deterioração gradativa e vício próprio, defeito fabricação, defeito mecânico, da instalação elétrica da motocicleta, vibrações, corrosão, ferrugem, umidade e chuva;\r\n\r\n4.2.7 - Quaisquer atos de hostilidade, tumultos, motins, sabotagem, vandalismo;\r\n\r\n4.2.8 - Atos de autoridade pública salvo para evitar propagação de danos inclusos no benefício;\r\n\r\n4.2.9 - Negligência do associado, arrendatário ou cessionário na utilização, bem como na adoção de todos os meios razoáveis para salva-los e preservá-los durante ou após a ocorrência de qualquer evento (danos no motor após colisão em parte distinta desta);\r\n\r\n4.2.10 - Atos praticados em estado de insanidade mental e /ou sob efeito de bebi- das alcoólicas e /ou tóxicas. Também não terá cobertura para o associado que se envolver em evento, e estando sob suspeita de embriaguez, se recuse a realizar exames de etilômetro ou de sangue.\r\n\r\n4.2.11 - Danos emergentes;\r\n\r\n4.2.12 - Lucros cessantes e danos emergentes direta ou indiretamente da paralisação da motocicleta associada, mesmo sendo em conseqüência do benefício do PPM;\r\n\r\n4.2.13 - Perdas ou danos ocorridos quando em trânsito por estradas ou caminhos impedidos, inadequados, não abertos ao tráfego ou de areias fofas ou movediças;\r\n\r\n4.2.14 - Danos causados a carga transportada;\r\n\r\n4.2.15 - Danos sofridos por pessoas transportadas em locais não especificamente destinados e apropriados a tal fim, ou mesmo em local apropriado;\r\n\r\n4.2.16 - Danos ocorridos com o veículo fora do território nacional;\r\n\r\n4.2.17 - Perdas e danos ocorridos durante a participação da motocicleta em competições, apostas, provas de velocidade, inclusive treinos preparatórios;\r\n\r\n4.2.18 - Multas impostas ao associado e despesas de qualquer natureza relativa a ações e processos criminais;\r\n\r\n4.2.19 - As avarias que forem previamente constatadas e relacionadas na inspe- ção inicial da motocicleta associada, nos eventos de danos materiais parciais (em caso de ressarcimento integral, tais avarias serão descontadas do valor a ser beneficiado);\r\n\r\n4.2.20 - Reparos de avarias sofridas no veículo cadastrado promovidos sem a autorização da GASP,\r\n\r\n4.2.21 - Danos causados por guerra, revolução e ocorrências semelhantes, ou seja, contingências que atinjam de forma maciça a população regional ou nacional;\r\n\r\n4.2.22 – Furto ou roubo nos casos de motocicletas equipadas com rastreador via satélite, caso o rastreador não esteja em perfeito funcionamento.\r\n\r\n4.2.23 – Veículos turbinados (que não sejam originais de fábrica) não podem fazer parte da proteção, em hipótese alguma. Caso o associado turbine sua motocicleta após a adesão, perderá todas as coberturas.\r\n\r\n4.2.24 – Não haverá cobertura ainda para os danos sofridos pelo veículo devido ao período fora de funcionamento, tais como bateria descarregada, acumulação de borra no motor, etc.'),(1344,81,'_accordion_0_itm_txt_3_txt_flex','field_588f82b779e0d'),(1345,81,'accordion_0_itm_txt_4_texto_heading','PARÂMETROS DA PROTEÇÃO AUTOMOTIVA'),(1346,81,'_accordion_0_itm_txt_4_texto_heading','field_588f76e9cb9cf'),(1347,81,'accordion_0_itm_txt_4_cor_de_fundo',''),(1348,81,'_accordion_0_itm_txt_4_cor_de_fundo','field_588f91138c9fa'),(1349,81,'accordion_0_itm_txt_4_cor_do_texto',''),(1350,81,'_accordion_0_itm_txt_4_cor_do_texto','field_588f91eaa6afb'),(1351,81,'accordion_0_itm_txt_4_cor_do_icone',''),(1352,81,'_accordion_0_itm_txt_4_cor_do_icone','field_588f923ef5376'),(1353,81,'accordion_0_itm_txt_4_txt_flex','5 – A repartição dos prejuízos será limitada aos valores abaixo para cada item cadastrado junto ao PPM da GASP. Estes valores poderão ser revistos pela Diretoria Executiva, observando em regra o valor de mercado dos veículos fornecido pela tabela FIPE (www.FIPE.com.br), e excepcionalmente a critério da Diretoria Executiva, outra tabela de valores.\r\n\r\na) R$ 75.000,00 (setenta e cinco mil reais) para itens da tabela 1 e 2 da cláusula 2.5.1;\r\n\r\n5.1 – Casos de redução do valor a ser ressarcido:\r\n\r\n5.1.1 - As motocicletas com a numeração do chassi remarcada, sofrerão depreciação de 25% (vinte e cinco por cento) em relação ao valor fornecido pela tabela FIPE.\r\n\r\n5.1.2 – Caso o veículo a ser ressarcido integralmente for proveniente de Leilão, ou caso já tenha sido pago integralmente por alguma outra entidade, o valor da tabela FIPE sofrerá uma redução de 25% (vinte e cinco por cento).\r\n\r\n5.2 - Em caso de ressarcimento integral, roubo ou furto qualificado dos veículos objeto dos benefícios, a GASP tem em regra 90 (noventa) dias para ressarcir ao associado prejudicado o prejuízo correspondente, a contar do resultado da sindicância e da apresentação de todos os documentos requeridos pela GASP, observada a ressalva do item 9.1.\r\n\r\n5.2.1 – Não haverá contudo, estipulação de prazo para entrega da motocicleta em caso de reparos de sinistros, visto que a disponibilidade de oficinas e a disponibilidade de peças no mercado, etc, fogem do controle da GASP.\r\n\r\n5.3 - Quando a motocicleta sofrer danos materiais parciais, o ressarcimento será feito com base nos custos das partes, peças e materiais a substituir, bem como da mão-de-obra necessária para reparação ou substituição. A GASP providenciará o conserto da motocicleta danificada, em oficina previamente credenciada, o pagamento será efetuado com apresentação de nota fiscal do serviço.\r\n\r\n5.4 – A disponibilização dos benefícios citada no item anterior será feita obrigatoriamente com a reposição de peças originais somente quando o veículo estiver coberto pela garantia total do fabricante, e poderá ser feita a substituição das pe- ças danificadas pelas similares produzidas no mercado paralelo ou usadas, desde que não comprometam a segurança e a utilização da motocicleta.\r\n\r\n5.5 - Na eventualidade do associado escolher outra oficina que não seja uma das credenciadas pela GASP, o valor do conserto total da motocicleta não poderá ultrapassar o valor do menor dos orçamentos providenciados pela GASP. Sendo o conserto do veículo efetivado em oficina sugerida pelo associado e diversa das credenciadas, o associado pagará a diferença do valor do conserto (caso haja) e a GASP não se responsabilizará pela qualidade do(s) reparo(s) visto que efetuados em oficina desconhecida e da preferência do associado, sendo assim, de responsabilidade deste.\r\n\r\n5.6 - Haverá ressarcimento integral do valor da motocicleta, em regra, quando o montante para reparação do bem ultrapassar 75% (setenta e cinco por cento) do valor da tabela FIPE (observada a ressalva da cláusula abaixo).\r\n\r\n5.7 - Em caso de veículos novos (“0” Km), a indenização corresponderá ao valor especificado na nota da motocicleta cadastrada, desde que satisfeitas todos os incisos “A”,”B” e “C” abaixo:\r\n\r\na) O cadastramento tenha sido realizado antes da retirada da motocicleta das dependências da revendedora ou concessionária autorizada pelo fabricante;\r\n\r\nb) Tratar-se de primeiro evento com o veículo;\r\n\r\nc) O evento tenha ocorrido dentro do prazo de 90 (noventa) dias, contados a partir da data de retirada da motocicleta.\r\n\r\n5.8 - Caberá à Diretoria Executiva a opção de proceder ao ressarcimento correspondente ao valor integral da motocicleta ou de promover o conserto do mesmo em caso de danos parciais, sempre observando a forma que, aplicada, implique em menor valor a ser rateado e segurança para o associado.\r\n\r\n5.9 - No caso de ressarcimento integral ou de substituição de peças, os materiais remanescentes (peças ou salvado) pertencerão à GASP, que poderá vendê-los para diminuir o valor do rateio para os associados.\r\n\r\n5.10 - A GASP reserva o direito de contratar investigação especializada (sindicância) a fim de levantar eventuais irregularidades a respeito da natureza do acidente e eventuais fraudes ou irregularidades.'),(1354,81,'_accordion_0_itm_txt_4_txt_flex','field_588f82b779e0d'),(1355,81,'accordion_0_itm_txt_5_texto_heading',' RATEIO DOS PREJUÍZOS NO PPM'),(1356,81,'_accordion_0_itm_txt_5_texto_heading','field_588f76e9cb9cf'),(1357,81,'accordion_0_itm_txt_5_cor_de_fundo',''),(1358,81,'_accordion_0_itm_txt_5_cor_de_fundo','field_588f91138c9fa'),(1359,81,'accordion_0_itm_txt_5_cor_do_texto',''),(1360,81,'_accordion_0_itm_txt_5_cor_do_texto','field_588f91eaa6afb'),(1361,81,'accordion_0_itm_txt_5_cor_do_icone',''),(1362,81,'_accordion_0_itm_txt_5_cor_do_icone','field_588f923ef5376'),(1363,81,'accordion_0_itm_txt_5_txt_flex','6.1 – Os prejuízos auferidos pelos associados aderentes ao PPM serão apurados mensalmente, sendo rateados entre todos os associados participantes do PPM a partir do dia 25 (vinte e cinco) do mês anterior, devendo o valor do rateio ser pago na data do vencimento, sob pena de perda imediata da proteção.\r\n\r\n6.1.1 – O valor do rateio deverá ser pago através de boleto bancário, Cartão de Crédito e Debito (obedecendo as regras do Banco emitente), com vencimento todo dia 10 (dez), 15 (quinze), 20 (vinte) ou 25 (vinte e cinco), a critério do associado, cumprindo ao associado reclamar o envio do boleto, na hipótese do mesmo não ser recebido até o correspondente dia de vencimento.\r\n\r\n6.2 - A partir do dia primeiro dia útil de cada mês, os boletos ficarão disponíveis no site oficial da GASP, (www.linhafacil.com.br) , além disso, serão enviados pelos Correios, e-mail e SMS. Caso o associado não receba o boleto impresso até a data de vencimento, o mesmo poderá retirá-lo no site ou entrar em contato com o GASP e solicitar a 2º via.\r\n\r\n6.3 - A repartição dos prejuízos será feita pelo rateio do valor correspondente, entre todos os associados participantes do PPM, obedecendo ao índice de rateio da motocicleta, especificado no item 6.4, de acordo com o estabelecido abaixo:\r\n\r\n6.4 - ÍNDICES DE RATEIO\r\n\r\n<a href=\"http://www.linhafacil.com.br/v2/wp-content/uploads/2017/01/referenciaderatio1.jpg\"><img class=\"alignnone size-full wp-image-194\" src=\"http://www.linhafacil.com.br/v2/wp-content/uploads/2017/01/referenciaderatio1.jpg\" alt=\"\" width=\"512\" height=\"415\" /></a>'),(1364,81,'_accordion_0_itm_txt_5_txt_flex','field_588f82b779e0d'),(1365,81,'accordion_0_itm_txt_6_texto_heading','PARTICIPAÇÃO DO ASSOCIADO EM CASO DE ACIONAMENTO DO PPM'),(1366,81,'_accordion_0_itm_txt_6_texto_heading','field_588f76e9cb9cf'),(1367,81,'accordion_0_itm_txt_6_cor_de_fundo',''),(1368,81,'_accordion_0_itm_txt_6_cor_de_fundo','field_588f91138c9fa'),(1369,81,'accordion_0_itm_txt_6_cor_do_texto',''),(1370,81,'_accordion_0_itm_txt_6_cor_do_texto','field_588f91eaa6afb'),(1371,81,'accordion_0_itm_txt_6_cor_do_icone',''),(1372,81,'_accordion_0_itm_txt_6_cor_do_icone','field_588f923ef5376'),(1373,81,'accordion_0_itm_txt_6_txt_flex','7.1 - Motocicletas\r\n\r\nEm qualquer hipótese de uso das coberturas do PPM, o associado responsável pela motocicleta danificada participará dos custos decorrentes com a importância abaixo especificada em relação ao valor de sua motocicleta (tabela FIPE), além de sua mensalidade devida:\r\n\r\na) Para motos de 50cc a 400cc corresponderá a 5% do valor do veículo (Ta- bela FIPE) com um mínimo de R$ 700,00 (Setecentos reais);\r\n\r\n7.2 – Motocicletas do Grupo Especial\r\n\r\nEm qualquer hipótese de uso das coberturas do PPM, o associado responsável pela motocicleta danificada participará dos custos decorrentes com a importância de 8% (Oito por cento) do valor de seu veículo (tabela FIPE), não podendo este ser inferior R$ 2.000,00 (dois mil reais), além de sua mensalidade devida. Este valor deve sermpre ser pago na sede da associação.\r\n\r\n7.3 - Cobertura diferenciada em autódromos e pistas.\r\n\r\nMotos do grupo especial que participarem de Track day, provas e ou competições amadoras dentro de autódromos e pistas regulamentadas e credenciadas à confederação brasileira de automobilismo (http://www.cba.org.br/site/circuitos.php), terão cobertura em caso de acidente, sendo, em qualquer hipótese de uso das coberturas do PPM, o associado responsável pelo veículo danificado participará dos custos decorrentes com a importância de 12% (doze por cento) do valor de seu veículo (tabela FIPE), não podendo este ser inferior R$ 4.000,00 (quatro mil reais), além de sua mensalidade devida.\r\n\r\n7.4 – Os valores dispostos na cláusula 7.1 deverão ser pagos no ato da entrada da motocicleta junto à oficina, para o início dos reparos. O veículo somente será reparado mediante a quitação da participação do associado. Já no caso da cláusula 7.2, o pagamento é sempre na sede da associação ou a critério da diretoria.\r\n\r\n8 - Somente serão aceitas no PPM motos com no máximo 15 (Quinze) anos de uso e com o valor máximo de cobertura de R$ 75.000,00 (setenta e cinco mil reais) .\r\n\r\n8.1 - Na falta de peças de reposição originais ou similares, importadas ou nacionais à disposição no mercado, o prazo para os reparos na motocicleta poderá se estender por tempo indeterminado, até que as peças em questão estejam novamente a disposição para a aquisição.'),(1374,81,'_accordion_0_itm_txt_6_txt_flex','field_588f82b779e0d'),(1375,81,'accordion_0_itm_txt_7_texto_heading','OBRIGAÇÕES DO ASSOCIADO PARTICIPANTE DO PPM'),(1376,81,'_accordion_0_itm_txt_7_texto_heading','field_588f76e9cb9cf'),(1377,81,'accordion_0_itm_txt_7_cor_de_fundo',''),(1378,81,'_accordion_0_itm_txt_7_cor_de_fundo','field_588f91138c9fa'),(1379,81,'accordion_0_itm_txt_7_cor_do_texto',''),(1380,81,'_accordion_0_itm_txt_7_cor_do_texto','field_588f91eaa6afb'),(1381,81,'accordion_0_itm_txt_7_cor_do_icone',''),(1382,81,'_accordion_0_itm_txt_7_cor_do_icone','field_588f923ef5376'),(1383,81,'accordion_0_itm_txt_7_txt_flex','8.1 - Agir com lealdade a boa fé com os demais associados e com a Associação, sempre velando pelo seu regular funcionamento e sua boa imagem e buscando alcançar os fins institucionais, sob pena de ser automaticamente excluído do PPM e do quadro de associados, sem prejuízo das sanções legais cabíveis.\r\n\r\n8.2 - Cumprir todas as normas estabelecidas no estatuto social e neste regulamento, bem como outras a serem expedidas formalmente pela Diretoria Executiva;\r\n\r\n8.3 - Pagar em dia os valores das mensalidades devidas pelos associados, além de contribuir no prazo e na forma estabelecida pela Diretoria Executiva;\r\n\r\n8.3.1 – Ressalta-se que os pagamentos do associado serão devidos e obrigatórios, ainda que seu veículo esteja fora de uso, guardado ou sofrendo reparos em fun- ção de eventos danosos.\r\n\r\n8.4 - Manter a motocicleta em bom estado de conservação;\r\n\r\n8.5 - Dar imediato conhecimento o GASP caso haja algum dos casos abaixo, sob pena de perda de todas as coberturas:\r\n\r\nA) Mudança de domicílio fiscal, ou qualquer dado pessoal informado no cadastro;\r\n\r\nB) Alteração na forma de utilização da motocicleta;\r\n\r\nC) Transferência de propriedade;\r\n\r\nD) Alteração das características da motocicleta.\r\n\r\n8.6 - O associado deve tomar todas as providências ao seu alcance para proteger o veículo acidentado e evitar a agravação dos prejuízos, sob pena de ser considerado responsável pelos mesmos.\r\n\r\n8.7 - Empenhar todos os esforços para ser ressarcido de prejuízos causados por terceiros.\r\n\r\n8.8 – Informar imediatamente as autoridades policiais em caso de evento, desaparecimento, roubo ou furto da motocicleta associada.\r\n\r\n8.9 - Na ocorrência de qualquer dos eventos previstos para ressarcimento neste regulamento, o associado deve tomar as seguintes providencias:\r\n\r\nI. Acionar a GASP imediatamente;\r\n\r\nII. Acionar a polícia militar, para que seja realizada a ocorrência po- licial, no local e na hora que tenha ocorrido o acidente, roubo ou furto, relatando completa e minuciosamente o fato no BOLETIM DE OCORRÊNCIA, mencionando dia, hora, local, circunstância do acidente, nome de quem dirigia o veículo, nome e endereço de testemunhas e providências de ordem policial tomadas.;\r\n\r\nIII. Não fazer acordos sem comunicar a GASP;\r\n\r\nIV. Em acidentes com envolvimentos de terceiros, identificá-los, quando possível, no registro policial juntamente com os dados de duas testemunhas do acidente;\r\n\r\nV. No caso de roubo ou furto, se o veículo possuir rastreador ou localizador, acionar a empresa prestadora de serviço que deverá tomar as devidas providências para a localização, rastreamento e bloqueio da motocicleta;\r\n\r\nVI. Exigir da empresa prestadora de serviço de guincho o Laudo de Vistoria da motocicleta acidentada, feito no local do acidente, antes do deslocamento do mesmo.\r\n\r\n8.9.1 - Avisar imediatamente ao GASP e às AUTORIDADES POLICIAIS sobre qualquer acidente com o veículo, incluindo furto ou roubo, relatando completa e minuciosamente o fato no BOLETIM DE OCORRÊNCIA, mencionando dia, hora, local, circunstância do acidente, nome de quem dirigia o veículo, nome e endereço de testemunhas e providências de ordem policial tomadas.\r\n\r\n8.9.2 – Somente serão beneficiados os prejuízos em que o boletim de ocorrência for lavrado no dia e na hora do evento, sem ressalvas.\r\n\r\n8.9.3 – Para fazer o acionamento do PPM, o associado deverá comparecer pessoalmente ou por representante legalmente constituído, na sede da GASP, para lavrar termo de Acionamento e Sub Rogação de Direitos, com informações sobre o ocorrido. A diretoria poderá ainda solicitar o comparecimento do associado na sede GASP para prestar esclarecimentos do ocorrido.\r\n\r\n8.10 - Aguardar a autorização do GASP para iniciar a reparação de quaisquer danos, sob pena de arcar com os prejuízos sem o benefício do rateio entre associados.\r\n\r\n8.11 – Sempre observar e ler atentamente espaço reservado para mensagens no boleto de pagamento mensal e o site (www.linhafacil.com.br), que são os instrumentos oficiais de comunicação da GASP com seu associado participante do PPM. Qualquer alteração do presente regulamento será informada aos associados atra- vés destes dois instrumentos, e o vincularão a partir do pagamento do boleto, ou da postagem da mensagem no site.'),(1384,81,'_accordion_0_itm_txt_7_txt_flex','field_588f82b779e0d'),(1385,81,'accordion_0_itm_txt_8_texto_heading','RESSARCIMENTO AO ASSOCIADO PARTICIPANTE DO PPM'),(1386,81,'_accordion_0_itm_txt_8_texto_heading','field_588f76e9cb9cf'),(1387,81,'accordion_0_itm_txt_8_cor_de_fundo',''),(1388,81,'_accordion_0_itm_txt_8_cor_de_fundo','field_588f91138c9fa'),(1389,81,'accordion_0_itm_txt_8_cor_do_texto',''),(1390,81,'_accordion_0_itm_txt_8_cor_do_texto','field_588f91eaa6afb'),(1391,81,'accordion_0_itm_txt_8_cor_do_icone',''),(1392,81,'_accordion_0_itm_txt_8_cor_do_icone','field_588f923ef5376'),(1393,81,'accordion_0_itm_txt_8_txt_flex','9.1 – Em Caso de ressarcimento integral (furto qualificado, roubo ou ressarcimento integral), o ressarcimento ao associado será feito em regra através da substitui- ção da motocicleta por outro equivalente. O ressarcimento poderá ser feito ainda, excepcionalmente, através do ressarcimento do valor do bem de uma só vez ou parcelado, de acordo com as condições econômicas da associação e mediante decisão fundamentada da Diretoria Executiva.\r\n\r\n9.1.1 - O pagamento em caso de Ressarcimento Integral somente será efetuado mediante a apuração do rateio integral do veiculo, respeitando o prazo mínimo de 90 (noventa) dias a contar da apresentação de todos os documentos exigidos.\r\n\r\n9.1.2 – O referido prazo será suspenso a partir do momento em que for solicitada documentação complementar no caso de dúvida fundada e justificável ou no caso que for instaurado inquérito policial para apurar as causas do acidente, do furto e/ou do roubo.\r\n\r\n9.2 - Para poder usufruir dos benefícios oferecidos pelo PPM do GASP, o associado deverá estar rigorosamente quites com todas as suas obrigações perante a Associação e ao PPM, além de cumprir as demais obrigações estabelecidas neste regulamento, no regimento interno e no estatuto social.\r\n\r\n9.2.1 - Caso o associado esteja com seu boleto de pagamento em atraso, o mesmo não estará com seu veículo protegido, necessitando de nova inspeção, e pagamento do boleto para reativar os benefícios. Não será aceito em hipótese alguma depósito bancário como forma de pagamento.\r\n\r\n9.3 - O ressarcimento dos prejuízos sofridos pelos associados somente ocorrerá depois de esgotadas todas as possibilidades de recebimento imediato dos valores do terceiro causador do dano.\r\n\r\n9.4 - Qualquer ressarcimento somente será pago mediante apresentação de TODOS os documentos requeridos pela GASP.\r\n\r\n9.5 – Caso o veículo seja inalienável e haja saldo devedor, a GASP entregará outro bem mediante a transferência da alienação, ou pagará o valor correspondente diretamente ao credor, e, havendo saldo remanescente, ao associado.\r\n\r\n9.5.1 – Caso o débito junto ao credor seja superior ao valor da ressarcimento, o pagamento ao credor somente será efetuado mediante o pagamento conjunto por parte do associado de sua parte, liberando o gravame.\r\n\r\n9.6 - O ressarcimento ao associado será efetuado somente após a apresentação de todos os documentos requeridos pela GASP. As indenizações serão pagas em cheque nominal e cruzado, ou através da reposição do bem por outro da mesma espécie e tipo, conforme acordado entre as partes, sempre deduzindo a participa- ção do associado prevista nas cláusulas 7.1 e 7.2.\r\n\r\n9.7 - Para fazer jus ao ressarcimento integral, o veículo deverá estar livre e desembaraçado de qualquer gravame ou impedimento, seja judicial, administrativo ou qualquer outro. Para ter direito ao ressarcimento, deverá o associado regularizar a situação e após apresentar toda a documentação regularizada à GASP.\r\n\r\n9.8 - Quando o veículo a ser indenizado fizer parte do conjunto de bens de um espólio ou massa falida, a indenização será realizada em nome do espólio ou da massa, mediante recibo assinado pelo inventariante e/ou síndico legalmente constituídos, respectivamente.\r\n\r\n9.9 - Caso o Associado faça a opção aderir ao PPM, em hipótese alguma será admitida a participação da motocicleta incluso nesta modalidade em outra associa- ção ou ainda em modalidade similar a esta e, inclusive a participação em seguro particular de casco, sob pena de tornar-se nula a presente proteção.'),(1394,81,'_accordion_0_itm_txt_8_txt_flex','field_588f82b779e0d'),(1395,81,'accordion_0_itm_txt_9_texto_heading','DOCUMENTOS NECESSÁRIOS PARA O RESSARCIMENTO'),(1396,81,'_accordion_0_itm_txt_9_texto_heading','field_588f76e9cb9cf'),(1397,81,'accordion_0_itm_txt_9_cor_de_fundo',''),(1398,81,'_accordion_0_itm_txt_9_cor_de_fundo','field_588f91138c9fa'),(1399,81,'accordion_0_itm_txt_9_cor_do_texto',''),(1400,81,'_accordion_0_itm_txt_9_cor_do_texto','field_588f91eaa6afb'),(1401,81,'accordion_0_itm_txt_9_cor_do_icone',''),(1402,81,'_accordion_0_itm_txt_9_cor_do_icone','field_588f923ef5376'),(1403,81,'accordion_0_itm_txt_9_txt_flex','0 - Caso o associado venha sofrer prejuízo material no seu veículo cadastrado, o ressarcimento dos valores correspondentes ou a reposição do bem ficará condicionada à apresentação dos seguintes documentos:\r\n\r\n10.1 - Em caso de danos parciais (acidente):\r\n\r\nBoletim de ocorrência feito no momento do acidente;\r\n\r\nXerox da Carteira de Habilitação do condutor da motocicleta;\r\n\r\nXerox do CRVL (Certificado de registro e licenciamento da motocicleta).\r\n\r\n10.2 - Em caso de ressarcimento integral decorrente de acidente ou incêndio:\r\n\r\n10.2.1 - Em se tratando de associado pessoa física:\r\n\r\nCópia do CPF e RG do associado;\r\n\r\nCRV Certificado de Registro de Veículo original (documento de transferência) devidamente preenchido a favor da GASP ou de quem esta indicar, assinado e com firma reconhecida por autenticidade;\r\n\r\nCRLV (Certificado de Registro e Licenciamento da motocicleta) original, com a prova de quitação Seguro obrigatório e IPVA dos dois últimos anos de licenciamento;\r\n\r\nBoletim de Ocorrência original ou cópia autêntica; Xerox da Carteira de habilitação do condutor da motocicleta;\r\n\r\nChaves da motocicleta;\r\n\r\nCertidão negativa de furto e multa da motocicleta;\r\n\r\n10.2.2 - Em se tratando de associado pessoa jurídica:\r\n\r\nCRV Certificado de Registro de veículo original (documento de transferência) devidamente preenchido a favor da GASP ou de quem esta indicar, assinado e com firma reconhecida por autenticidade;\r\n\r\nCRVL (Certificado de Registro e Licenciamento da motocicleta) original, com a prova de quitação Seguro Obrigatório e IPVA dos dois últimos anos de licenciamento;\r\n\r\nBoletim de Ocorrência original ou cópia autêntica; Xerox da Carteira de habilitação do condutor da motocicleta;\r\n\r\nChaves da motocicleta; Certidão negativa de furto e multa da motocicleta;\r\n\r\nCópia do Contrato ou Estatuto Social, com alterações, autenticadas em cartório;\r\n\r\nNota fiscal de venda a GASP, quando o objetivo social da empresa for indústria, comércio, importação, exportação etc. (Prestação de serviço e leasing não necessitam emitir esta nota fiscal).\r\n\r\n10.4 - Em caso de ressarcimento Integral decorrente de Roubo ou Furto: -Todos os documentos exigidos na cláusula 10.2.1 e 10.2.2, exceto quando à nota fiscal;\r\n\r\n-Extrato do DETRAN (débitos e restrições) constando queixa de roubo/furto;\r\n\r\n-Certidão negativa de multas da motocicleta.'),(1404,81,'_accordion_0_itm_txt_9_txt_flex','field_588f82b779e0d'),(1405,81,'accordion_0_itm_txt_10_texto_heading','DISPOSIÇÕES FINAIS'),(1406,81,'_accordion_0_itm_txt_10_texto_heading','field_588f76e9cb9cf'),(1407,81,'accordion_0_itm_txt_10_cor_de_fundo',''),(1408,81,'_accordion_0_itm_txt_10_cor_de_fundo','field_588f91138c9fa'),(1409,81,'accordion_0_itm_txt_10_cor_do_texto',''),(1410,81,'_accordion_0_itm_txt_10_cor_do_texto','field_588f91eaa6afb'),(1411,81,'accordion_0_itm_txt_10_cor_do_icone',''),(1412,81,'_accordion_0_itm_txt_10_cor_do_icone','field_588f923ef5376'),(1413,81,'accordion_0_itm_txt_10_txt_flex','11.1 - Com o ressarcimento ao associado, a GASP ficará sub-rogada em todos os direitos e ações do associado contra aquele que por ato, fato ou omissão tenham causado os prejuízos ou para eles contribuído.\r\n\r\n11.2 - Fica eleito da comarca onde estiver localizada a sede da GASP para dirimir quaisquer dúvidas que surgirem relativas ao PPM, afastando quaisquer outros foros por mais privilegiados que sejam.\r\n\r\n11.3 - O associado declara que todas as informações prestadas por ele a GASP serão verdadeiras e, caso fique comprovada a inveracidade de qualquer informa- ção ou declaração emitida pelo associado, o mesmo será imediatamente excluído do PPM bem como eliminado no quadro social da GASP, nos termos do Estatuto Social, sem prejuízo das sanções legais.\r\n\r\n11.4 - Todos os associados declaram que leram e têm pleno conhecimento de todas as normas contidas no regulamento PPM e no estatuto social da GASP, e que aceitam todas as condições estabelecidas neste documento para associarem-se.\r\n\r\n11.5 - O presente regulamento entra em vigor na data da Assembléia Geral que o instituiu, revogando todas as disposições anteriores em contrário.\r\n\r\n11.6 - Os casos omissos no presente regulamento serão analisados pela Diretoria Executiva, sendo a decisão levada ao conhecimento da Assembléia Geral subseqüente ao saneamento da omissão, após a ciência e ratificação, as decisões terão força normativa e deverão ser aplicadas a todos os casos semelhantes e análogos, no que for aplicável.'),(1414,81,'_accordion_0_itm_txt_10_txt_flex','field_588f82b779e0d'),(1415,81,'accordion_0_itm_txt','a:11:{i:0;s:5:\"txt_2\";i:1;s:5:\"txt_2\";i:2;s:5:\"txt_2\";i:3;s:5:\"txt_2\";i:4;s:5:\"txt_2\";i:5;s:5:\"txt_2\";i:6;s:5:\"txt_2\";i:7;s:5:\"txt_2\";i:8;s:5:\"txt_2\";i:9;s:5:\"txt_2\";i:10;s:5:\"txt_2\";}'),(1416,81,'_accordion_0_itm_txt','field_588f7649cb9ce'),(1417,81,'accordion','1'),(1418,81,'_accordion','field_588f7627cb9cd'),(1424,195,'_accordion_0_itm_txt_0_texto_heading','field_588f76e9cb9cf'),(1425,195,'accordion_0_itm_txt_0_cor_de_fundo',''),(1426,195,'_accordion_0_itm_txt_0_cor_de_fundo','field_588f91138c9fa'),(1427,195,'accordion_0_itm_txt_0_cor_do_texto',''),(1428,195,'_accordion_0_itm_txt_0_cor_do_texto','field_588f91eaa6afb'),(1429,195,'accordion_0_itm_txt_0_cor_do_icone',''),(1430,195,'_accordion_0_itm_txt_0_cor_do_icone','field_588f923ef5376'),(1431,195,'accordion_0_itm_txt_0_txt_flex','1. - O presente regulamento tem como objetivo estabelecer as normas e regras do Programa de Proteção Automotiva da GASP, conforme art. 2 do estatuto social, devendo ser meticulosamente cumprido e observado pelos órgãos estatutários, dirigentes, funcionários e associados aderentes ao programa.\r\n\r\n1.1 - A GASP é dotado de personalidade jurídica, constituído na forma de associa- ção, não devendo ser tratado em hipótese alguma como uma sociedade empresária, consideradas as peculiaridades do programa de proteção automotiva, especialmente no que tange ao rateio das despesas com eventos entre os associados e a completa ausência de finalidade lucrativa.'),(1432,195,'_accordion_0_itm_txt_0_txt_flex','field_588f82b779e0d'),(1433,195,'accordion_0_itm_txt_1_texto_heading','ADESÃO AO PROGRAMA DE PROTEÇÃO DE MOTOCICLETAS (PPM)'),(1434,195,'_accordion_0_itm_txt_1_texto_heading','field_588f76e9cb9cf'),(1435,195,'accordion_0_itm_txt_1_cor_de_fundo',''),(1436,195,'_accordion_0_itm_txt_1_cor_de_fundo','field_588f91138c9fa'),(1437,195,'accordion_0_itm_txt_1_cor_do_texto',''),(1438,195,'_accordion_0_itm_txt_1_cor_do_texto','field_588f91eaa6afb'),(1439,195,'accordion_0_itm_txt_1_cor_do_icone',''),(1440,195,'_accordion_0_itm_txt_1_cor_do_icone','field_588f923ef5376'),(1441,195,'accordion_0_itm_txt_1_txt_flex','2 – O Programa de Proteção Automotiva (PPM) da GASP tem como objetivo primordial conferir proteção e segurança aos automóveis de seus associados aderentes ao programa, através do rateio dos danos materiais eventualmente sofridos e protegidos pelo programa, na forma deste regulamento, bem como através da prevenção ativa de acidentes, pela veiculação de material educativo pertinente às normas de segurança no trânsito.\r\n\r\n2.1 - Para aderir ao PPM da GASP, o associado deverá encaminhar à Diretoria da Associação os seguintes documentos, além de pagar a taxa de adesão:\r\n\r\n2.1.1 – Requerimento de adesão em modelo próprio;\r\n\r\n2.1.2 – Carteira Nacional de Habilitação ou CPF e RG, caso associado não for habilitado.\r\n\r\n2.1.3 – CRV da motocicleta, ou nota fiscal em caso de 0km;\r\n\r\n2.1.4 – Contrato Social ou Estatuto Social, caso seja pessoa jurídica.\r\n\r\n2.1.5 – Inspeção com fotos, realizada por profissional credenciado à GASP.\r\n\r\n2.2 - O período mínimo de participação no PPM da GASP é de 2 (dois) meses, contados a partir da adesão ao programa e, caso o associado venha a usufruir do benefício da repartição de prejuízos materiais conferido pelo PPM, haverá uma nova fidelização de 6 (Seis) meses a contar da data do acionamento.\r\n\r\n2.3 – O associado que desejar se desligar do PPM deverá encaminhar um requerimento escrito à diretoria da associação, devendo o associado estar adimplente com todas as suas obrigações relativas ao PPM. O requerimento deverá conter as seguintes informações: Nome completo, CPF, modelo da motocicleta, placa, motivo do desligamento.\r\n\r\n2.3.1 – O pedido de desligamento deverá ser realizado até o 20º dia do mês, ressaltada a responsabilidade pelo pagamento do próximo mês.\r\n\r\n2.3.2 – O associado que requerer o desligamento em violação ao disposto no item 2.2, incorrerá em multa correspondente ao valor mensal médio do rateio apurado nos seis meses anteriores ao pedido, multiplicado pelo número de meses faltantes para o cumprimento do prazo designado no referido item.\r\n\r\n2.3.3 - Será permitida a transferência de titularidade de um veículo cadastrado no PPM, desde que o novo associado titular pague uma taxa relativa a transferência e que não tenha nenhum impedimento quanto a sua inclusão no programa, ou caso não seja associado, ao quadro de associados da GASP. Este procedimento estará condicionado a aprovação expressa da diretoria da Associação.\r\n\r\n2.3.4 - Será permitida a substituição de um veículo cadastrado no PPM, desde que o associado pague uma taxa relativa a substituição e que o veículo não tenha nenhum impedimento quanto a sua inclusão na referida proteção. Este procedimento estará condicionado a aprovação expressa da diretoria da Associação.\r\n\r\n2.4 – Caso o associado ou o veículo cadastrado se envolva em mais de 2 (dois) acidentes de trânsito no período de 12 (doze) meses, haverá incidência de multa correspondente a duas vezes o valor da participação obrigatória do associado. Este poderá ser excluído compulsoriamente do PPM, a critério da Diretoria Executiva, e assegurado o direito a recurso administrativo e após este, pedido de reconsideração.\r\n\r\n2.5 - Os associados aderentes ao PPM da GASP deverão pagar a taxa administrativa do PPM, por cada automóvel cadastrado, correspondente ao custeio de despesas administrativas do PPM.\r\n\r\n2.5.1 - O valor da taxa administrativa do PPM, calculado de acordo com o valor da motocicleta, terá como referência o perfil da motocicleta de acordo com os seus respectivos valores de mercado, tendo em vista o índice da tabela FIPE (www. FIPE.com.br) ou outro critério justificado, aplicado pela Diretoria Executiva\r\n\r\n2.5.1.1 – Caso a motocicleta cadastrada seja de ano de fabricação e de modelo diferentes (Ex: 2008/2009), a avaliação será feita pela média entre os valores fornecidos pela tabela FIPE de cada um dos anos.\r\n\r\n2.5.2 - Enquanto o associado estiver participando do PPM, ele pagará uma tax associativa de R$10,00 ( dez reais) referentes à contribuição associativa da GASP mais o rateio do mês anterior. Caso ele queira se desligar do PPM, o associado voltará a pagar somente a contribuição associativa, nos termos do regimento interno da GASP.\r\n\r\n2.5.3 – É de inteira responsabilidade do associado o monitoramento do valor da motocicleta, e seu remanejamento entre os perfis da cláusula 2.5.1. Salienta-se que o ressarcimento será sempre feito com base no valor de tabela da motocicleta na data do evento danoso, independente de seu valor da época da adesão.\r\n\r\n2.6 - Os valores citados na cláusula 2.5.1 serão administrados pela Diretoria Executiva da GASP, e aplicados na manutenção das despesas administrativas do PPM, e não confundem com a contribuição associativa, que se destina ao custeio da associação.\r\n\r\n2.7 – Em caso de inadimplência, o associado não poderá usufruir de nenhum dos benefícios oferecidos pelo PPM da GASP, além de estar sujeito à eliminação do PPM, do quadro de associados da GASP, e ainda de ter seu CPF inscrito nos serviços de proteção ao crédito (SPC e SERASA).\r\n\r\n2.8 - A eliminação do associado do corpo social obedecerá ao disposto no art. 9º do Estatuto Social da GASP, cabendo à Diretoria Executiva ratificá-la, sempre resguardado o direito à ampla defesa e à interposição de recurso administrativo com efeito suspensivo à Assembléia Geral subseqüente à deliberação, o prazo para interposição do recurso, para as finalidades previstas nesta cláusula é de 5 (cinco) dias corridos, a partir da notificação formal do associado.\r\n\r\n2.9 - Os veículos deverão ser previamente cadastrados junto ao PPM da GASP, através de vistoria a ser realizada, arquivando-se fotos dos mesmos e todos os documentos elencados na cláusula de número 2.1.\r\n\r\n2.9.1 - A GASP não efetua na vistoria nenhuma avaliação do valor de mercado da motocicleta (tal avaliação se dará previamente através de consulta à tabela FIPE),nem da legalidade de sua procedência, sendo esta de inteira responsabilidade do associado.'),(1442,195,'_accordion_0_itm_txt_1_txt_flex','field_588f82b779e0d'),(1443,195,'accordion_0_itm_txt_2_texto_heading','ACEITAÇÃO E INÍCIO DO BENEFÍCIO DA PROTEÇÃO AUTOMOTIVA'),(1444,195,'_accordion_0_itm_txt_2_texto_heading','field_588f76e9cb9cf'),(1445,195,'accordion_0_itm_txt_2_cor_de_fundo',''),(1446,195,'_accordion_0_itm_txt_2_cor_de_fundo','field_588f91138c9fa'),(1447,195,'accordion_0_itm_txt_2_cor_do_texto',''),(1448,195,'_accordion_0_itm_txt_2_cor_do_texto','field_588f91eaa6afb'),(1449,195,'accordion_0_itm_txt_2_cor_do_icone',''),(1450,195,'_accordion_0_itm_txt_2_cor_do_icone','field_588f923ef5376'),(1451,195,'accordion_0_itm_txt_2_txt_flex','3.1 – Os benefícios do PPM para veículo do associado cadastrado tem início a partir da data e hora de pagamento da taxa de adesão e inspeção veicular.\r\n\r\n3.1.1 - A vistoria veicular poderá ser dispensada por até 5 (cinco) dias, com cobertura normal, quando o veículo for 0 (zero) km e for enviado a GASP, por fax ou outra forma, Nota Fiscal da motocicleta antes dela sair da concessionária ou revenda. Após esse período a proteção estará suspensa até que seja feita a vistoria.\r\n\r\n3.2 - A Proposta de adesão ao PPM poderá ser recusada em até 15 (quinze) dias pela Diretoria da GASP, contados a partir da data do seu recebimento. A eventual recusa e os motivos desta serão informados ao pretendente através de carta com AR, enviada ao endereço constante na proposta de adesão. Na hipótese de recusa, os valores das taxas discriminadas no item acima serão ressarcidos em até 10 (dez) dias, restando válida a proteção do PPM, contudo, até a hora e data de entrega do AR que informar o associado da recusa, ou a quem receba o AR no endereço indicado pelo associado.\r\n\r\n3.3 - A diretoria da GASP se resguarda no direito de indeferir a inclusão de qualquer associado ao PPM, caso a sua motocicleta se encontre em más condições de conservação ou tenha alterações, modificações e assessórios que possam afetar sua segurança ou desempenho.\r\n\r\n3.3.1 – A Diretoria Executiva da GASP poderá ainda proceder à eliminação do PPM de qualquer um dos associados a qualquer tempo, caso este aja contra os interesses coletivos dos associados, ou viole qualquer uma das normas estatutárias ou regulamentares da associação, assegurado o direito a ampla defesa e contraditório, nos termos da cláusula 2.8.\r\n\r\n3.4 – A GASP exige ainda, para motocicletas com valor acima de 300 cilindradas, ou, a critério da Diretoria, a instalação e manutenção de equipamentos rastreadores ou bloqueadores, visando diminuir o índice de furto/roubo. Para estes veículos, os benefícios para casos de furto e roubo somente valerão após a instalação do rastreador ou bloqueador, e caso estes estejam em pleno funcionamento. A obrigatoriedade de instalação constará no laudo de inspeção.\r\n\r\n3.4.1 - É de inteira responsabilidade do associado a instalação do equipamento de rastreamento, localização e bloqueio, bem como o acompanhamento de seu funcionamento no caso do equipamento de rastreador. A não instalação desses equipamentos implica na não cobertura no caso de Furto ou Roubo da Moto.\r\n\r\n3.5 - A motocicleta deverá estar em dia com os impostos, taxas e toda a documentação necessária para a sua circulação, caso contrário, o associado não terá nenhum direito aos benefícios oferecidos pela GASP aos quais faz jus em caso de acidentes, tendo em vista que o mesmo não se encontrava apto para transitar em via pública.\r\n\r\n3.6 - O não pagamento do boleto mensal na data de vencimento, determina a perda automática de todos os benefícios oferecidos pelo PPM da GASP.\r\n\r\n3.7 - Para reativação dos benefícios do PPM, deverá o associado em atraso solicitar uma nova guia de cobrança e passar por uma nova vistoria, seja ela em um dos pontos autorizados sem custo para o associado, ou através da visita de um vistoriador sendo que neste caso o associado pagará uma taxa de deslocamento a ser determinada pela diretoria executiva da GASP.\r\n\r\n3.8 - Após 30 (trinta) dias de atraso no pagamento do boleto bancário, o Associado inadimplente poderá ter seu nome encaminhado aos órgãos de proteção ao crédito (tais como SPC, SERASA, etc.), podendo ainda o título ser protestado, sem prejuízo da propositura da Ação Judicial competente para recebimento do débito.\r\n\r\n3.9 - Se o Associado não quitar seu boleto até o último dia útil do mês vigente, seu veículo será automaticamente EXCLUÍDO da Proteção Automotiva da GASP, ficando sua re-inclusão condicionada:\r\n\r\nI. Ao pagamento do débito;\r\n\r\nII. A nova vistoria da motocicleta;\r\n\r\nIII. A parecer favorável da Diretoria.\r\n\r\n3.10 - O não recebimento do boleto e a exclusão do associado do PPM ou da GASP não o exime da responsabilidade pelo seu pagamento, visto que a cobrança se trata sempre do mês anterior, período em que o associado usufruiu dos benefícios do PPM.'),(1452,195,'_accordion_0_itm_txt_2_txt_flex','field_588f82b779e0d'),(1453,195,'accordion_0_itm_txt_3_texto_heading','BENEFÍCIOS DO PROGRAMA DE PROTEÇÃO AUTOMOTIVA'),(1454,195,'_accordion_0_itm_txt_3_texto_heading','field_588f76e9cb9cf'),(1455,195,'accordion_0_itm_txt_3_cor_de_fundo',''),(1456,195,'_accordion_0_itm_txt_3_cor_de_fundo','field_588f91138c9fa'),(1457,195,'accordion_0_itm_txt_3_cor_do_texto',''),(1458,195,'_accordion_0_itm_txt_3_cor_do_texto','field_588f91eaa6afb'),(1459,195,'accordion_0_itm_txt_3_cor_do_icone',''),(1460,195,'_accordion_0_itm_txt_3_cor_do_icone','field_588f923ef5376'),(1461,195,'accordion_0_itm_txt_3_txt_flex','4 – A cobertura do PPM se aplica aos seguintes eventos: Roubo, furto, colisão, capotamento, abalroamento, incêndio, chuvas de granizo, submersão por inundação ou alagamento de água doce, impacto de objetos externos sobre o veículo, queda (acidente durante transporte por meio apropriado e autorizado pelas autoridades de trânsito).\r\n\r\n4.1 – Não serão inclusos no benefício os acessórios da motocicleta, constando ou não no momento da inspeção inicial (a cláusula se aplica aos equipamentos de baú, rodas de liga e pneus [exceto originais], não são cobertos em hipótese alguma);\r\n\r\n4.1.1 – As garantias contra roubo e furto não se confundem com fraudes, estelionato e apropriação indébita\r\n\r\n4.1.2 - Não haverá benefício da cobertura para casos de roubo ou furto de veículos que não possuem o “rastreador via satélite”, conforme cláusula 3.4.\r\n\r\n4.1.3 - Na hipótese de indenizações de pneus que forem afetados pelo evento, a GASP pagará o valor correspondente ao estado do mesmo, seguindo o seguinte parâmetro: Pneus com até 6 (seis) meses de uso, ressarcimento de 100% (cem por cento) do valor. Pneus com mais de 6 (seis) meses de uso, ressarcimento de 50% cinquenta por cento) do valor.\r\n\r\n4.1.3.1 – Serão sempre adotados para aplicação das bases acima, os valores dos pneus novos à época do evento danoso. Caso este tenha saído de linha, observar- -se-á o valor do substituto ou equivalente.\r\n\r\n4.1.4 - Veículos com alíquotas, taxas ou impostos reduzidos ou isentos, tais como táxis, produtor rural e frotistas, serão ressarcidos pelo valor constante na Nota Fiscal da motocicleta, no caso de veículo 0 (zero) KM.\r\n\r\n4.2 - Não serão inclusos no benefício do Programa de Proteção Automotiva os seguintes casos:\r\n\r\n4.2.1 - Responsabilidade civil facultativa, danos materiais, pessoais, corporais e morais, a terceiros e aos ocupantes da motocicleta (exceto nos casos em que forem expressamente contratados à parte);\r\n\r\n4.2.2 - Eventos danosos decorrentes da inobservância das leis em vigor, como dirigir sem possuir carteira de habilitação ou estar com a mesma suspensa, ou ainda, não ter habilitação adequada conforme categoria da motocicleta, rebocar ou transportar o veículo inadequadamente;\r\n\r\n4.2.3 - Negligência na utilização ou manutenção da motocicleta (itens de segurança, pneus, direção perigosa ou sob efeitos de substâncias alcoólicas ou entorpecentes, etc.),\r\n\r\n4.2.4 - Utilizar inadequadamente a motocicleta com relação a lotações de passageiros, dimensão, peso e acondicionamento de carga transportada.\r\n\r\n4.2.5 – Veículos que tiveram alteradas as características originais, de modo a comprometer a segurança (Veículos com molas cortadas ou adulteradas,ou, com qualquer outra alteração na estrutura original), ainda que com preparação especializada ou laudo do INMETRO, somente terão a parte da lataria reparada em caso de acidente. A parte mecânica fica descoberta, em função do agravamento de risco por conta das alterações.\r\n\r\n4.2.6 - Desgaste natural ou pelo uso, deterioração gradativa e vício próprio, defeito fabricação, defeito mecânico, da instalação elétrica da motocicleta, vibrações, corrosão, ferrugem, umidade e chuva;\r\n\r\n4.2.7 - Quaisquer atos de hostilidade, tumultos, motins, sabotagem, vandalismo;\r\n\r\n4.2.8 - Atos de autoridade pública salvo para evitar propagação de danos inclusos no benefício;\r\n\r\n4.2.9 - Negligência do associado, arrendatário ou cessionário na utilização, bem como na adoção de todos os meios razoáveis para salva-los e preservá-los durante ou após a ocorrência de qualquer evento (danos no motor após colisão em parte distinta desta);\r\n\r\n4.2.10 - Atos praticados em estado de insanidade mental e /ou sob efeito de bebi- das alcoólicas e /ou tóxicas. Também não terá cobertura para o associado que se envolver em evento, e estando sob suspeita de embriaguez, se recuse a realizar exames de etilômetro ou de sangue.\r\n\r\n4.2.11 - Danos emergentes;\r\n\r\n4.2.12 - Lucros cessantes e danos emergentes direta ou indiretamente da paralisação da motocicleta associada, mesmo sendo em conseqüência do benefício do PPM;\r\n\r\n4.2.13 - Perdas ou danos ocorridos quando em trânsito por estradas ou caminhos impedidos, inadequados, não abertos ao tráfego ou de areias fofas ou movediças;\r\n\r\n4.2.14 - Danos causados a carga transportada;\r\n\r\n4.2.15 - Danos sofridos por pessoas transportadas em locais não especificamente destinados e apropriados a tal fim, ou mesmo em local apropriado;\r\n\r\n4.2.16 - Danos ocorridos com o veículo fora do território nacional;\r\n\r\n4.2.17 - Perdas e danos ocorridos durante a participação da motocicleta em competições, apostas, provas de velocidade, inclusive treinos preparatórios;\r\n\r\n4.2.18 - Multas impostas ao associado e despesas de qualquer natureza relativa a ações e processos criminais;\r\n\r\n4.2.19 - As avarias que forem previamente constatadas e relacionadas na inspe- ção inicial da motocicleta associada, nos eventos de danos materiais parciais (em caso de ressarcimento integral, tais avarias serão descontadas do valor a ser beneficiado);\r\n\r\n4.2.20 - Reparos de avarias sofridas no veículo cadastrado promovidos sem a autorização da GASP,\r\n\r\n4.2.21 - Danos causados por guerra, revolução e ocorrências semelhantes, ou seja, contingências que atinjam de forma maciça a população regional ou nacional;\r\n\r\n4.2.22 – Furto ou roubo nos casos de motocicletas equipadas com rastreador via satélite, caso o rastreador não esteja em perfeito funcionamento.\r\n\r\n4.2.23 – Veículos turbinados (que não sejam originais de fábrica) não podem fazer parte da proteção, em hipótese alguma. Caso o associado turbine sua motocicleta após a adesão, perderá todas as coberturas.\r\n\r\n4.2.24 – Não haverá cobertura ainda para os danos sofridos pelo veículo devido ao período fora de funcionamento, tais como bateria descarregada, acumulação de borra no motor, etc.'),(1462,195,'_accordion_0_itm_txt_3_txt_flex','field_588f82b779e0d'),(1463,195,'accordion_0_itm_txt_4_texto_heading','PARÂMETROS DA PROTEÇÃO AUTOMOTIVA'),(1464,195,'_accordion_0_itm_txt_4_texto_heading','field_588f76e9cb9cf'),(1465,195,'accordion_0_itm_txt_4_cor_de_fundo',''),(1466,195,'_accordion_0_itm_txt_4_cor_de_fundo','field_588f91138c9fa'),(1467,195,'accordion_0_itm_txt_4_cor_do_texto',''),(1468,195,'_accordion_0_itm_txt_4_cor_do_texto','field_588f91eaa6afb'),(1469,195,'accordion_0_itm_txt_4_cor_do_icone',''),(1470,195,'_accordion_0_itm_txt_4_cor_do_icone','field_588f923ef5376'),(1471,195,'accordion_0_itm_txt_4_txt_flex','5 – A repartição dos prejuízos será limitada aos valores abaixo para cada item cadastrado junto ao PPM da GASP. Estes valores poderão ser revistos pela Diretoria Executiva, observando em regra o valor de mercado dos veículos fornecido pela tabela FIPE (www.FIPE.com.br), e excepcionalmente a critério da Diretoria Executiva, outra tabela de valores.\r\n\r\na) R$ 75.000,00 (setenta e cinco mil reais) para itens da tabela 1 e 2 da cláusula 2.5.1;\r\n\r\n5.1 – Casos de redução do valor a ser ressarcido:\r\n\r\n5.1.1 - As motocicletas com a numeração do chassi remarcada, sofrerão depreciação de 25% (vinte e cinco por cento) em relação ao valor fornecido pela tabela FIPE.\r\n\r\n5.1.2 – Caso o veículo a ser ressarcido integralmente for proveniente de Leilão, ou caso já tenha sido pago integralmente por alguma outra entidade, o valor da tabela FIPE sofrerá uma redução de 25% (vinte e cinco por cento).\r\n\r\n5.2 - Em caso de ressarcimento integral, roubo ou furto qualificado dos veículos objeto dos benefícios, a GASP tem em regra 90 (noventa) dias para ressarcir ao associado prejudicado o prejuízo correspondente, a contar do resultado da sindicância e da apresentação de todos os documentos requeridos pela GASP, observada a ressalva do item 9.1.\r\n\r\n5.2.1 – Não haverá contudo, estipulação de prazo para entrega da motocicleta em caso de reparos de sinistros, visto que a disponibilidade de oficinas e a disponibilidade de peças no mercado, etc, fogem do controle da GASP.\r\n\r\n5.3 - Quando a motocicleta sofrer danos materiais parciais, o ressarcimento será feito com base nos custos das partes, peças e materiais a substituir, bem como da mão-de-obra necessária para reparação ou substituição. A GASP providenciará o conserto da motocicleta danificada, em oficina previamente credenciada, o pagamento será efetuado com apresentação de nota fiscal do serviço.\r\n\r\n5.4 – A disponibilização dos benefícios citada no item anterior será feita obrigatoriamente com a reposição de peças originais somente quando o veículo estiver coberto pela garantia total do fabricante, e poderá ser feita a substituição das pe- ças danificadas pelas similares produzidas no mercado paralelo ou usadas, desde que não comprometam a segurança e a utilização da motocicleta.\r\n\r\n5.5 - Na eventualidade do associado escolher outra oficina que não seja uma das credenciadas pela GASP, o valor do conserto total da motocicleta não poderá ultrapassar o valor do menor dos orçamentos providenciados pela GASP. Sendo o conserto do veículo efetivado em oficina sugerida pelo associado e diversa das credenciadas, o associado pagará a diferença do valor do conserto (caso haja) e a GASP não se responsabilizará pela qualidade do(s) reparo(s) visto que efetuados em oficina desconhecida e da preferência do associado, sendo assim, de responsabilidade deste.\r\n\r\n5.6 - Haverá ressarcimento integral do valor da motocicleta, em regra, quando o montante para reparação do bem ultrapassar 75% (setenta e cinco por cento) do valor da tabela FIPE (observada a ressalva da cláusula abaixo).\r\n\r\n5.7 - Em caso de veículos novos (“0” Km), a indenização corresponderá ao valor especificado na nota da motocicleta cadastrada, desde que satisfeitas todos os incisos “A”,”B” e “C” abaixo:\r\n\r\na) O cadastramento tenha sido realizado antes da retirada da motocicleta das dependências da revendedora ou concessionária autorizada pelo fabricante;\r\n\r\nb) Tratar-se de primeiro evento com o veículo;\r\n\r\nc) O evento tenha ocorrido dentro do prazo de 90 (noventa) dias, contados a partir da data de retirada da motocicleta.\r\n\r\n5.8 - Caberá à Diretoria Executiva a opção de proceder ao ressarcimento correspondente ao valor integral da motocicleta ou de promover o conserto do mesmo em caso de danos parciais, sempre observando a forma que, aplicada, implique em menor valor a ser rateado e segurança para o associado.\r\n\r\n5.9 - No caso de ressarcimento integral ou de substituição de peças, os materiais remanescentes (peças ou salvado) pertencerão à GASP, que poderá vendê-los para diminuir o valor do rateio para os associados.\r\n\r\n5.10 - A GASP reserva o direito de contratar investigação especializada (sindicância) a fim de levantar eventuais irregularidades a respeito da natureza do acidente e eventuais fraudes ou irregularidades.'),(1472,195,'_accordion_0_itm_txt_4_txt_flex','field_588f82b779e0d'),(1473,195,'accordion_0_itm_txt_5_texto_heading',' RATEIO DOS PREJUÍZOS NO PPM'),(1474,195,'_accordion_0_itm_txt_5_texto_heading','field_588f76e9cb9cf'),(1475,195,'accordion_0_itm_txt_5_cor_de_fundo',''),(1476,195,'_accordion_0_itm_txt_5_cor_de_fundo','field_588f91138c9fa'),(1477,195,'accordion_0_itm_txt_5_cor_do_texto',''),(1478,195,'_accordion_0_itm_txt_5_cor_do_texto','field_588f91eaa6afb'),(1479,195,'accordion_0_itm_txt_5_cor_do_icone',''),(1480,195,'_accordion_0_itm_txt_5_cor_do_icone','field_588f923ef5376'),(1481,195,'accordion_0_itm_txt_5_txt_flex','6.1 – Os prejuízos auferidos pelos associados aderentes ao PPM serão apurados mensalmente, sendo rateados entre todos os associados participantes do PPM a partir do dia 25 (vinte e cinco) do mês anterior, devendo o valor do rateio ser pago na data do vencimento, sob pena de perda imediata da proteção.\r\n\r\n6.1.1 – O valor do rateio deverá ser pago através de boleto bancário, Cartão de Crédito e Debito (obedecendo as regras do Banco emitente), com vencimento todo dia 10 (dez), 15 (quinze), 20 (vinte) ou 25 (vinte e cinco), a critério do associado, cumprindo ao associado reclamar o envio do boleto, na hipótese do mesmo não ser recebido até o correspondente dia de vencimento.\r\n\r\n6.2 - A partir do dia primeiro dia útil de cada mês, os boletos ficarão disponíveis no site oficial da GASP, (www.linhafacil.com.br) , além disso, serão enviados pelos Correios, e-mail e SMS. Caso o associado não receba o boleto impresso até a data de vencimento, o mesmo poderá retirá-lo no site ou entrar em contato com o GASP e solicitar a 2º via.\r\n\r\n6.3 - A repartição dos prejuízos será feita pelo rateio do valor correspondente, entre todos os associados participantes do PPM, obedecendo ao índice de rateio da motocicleta, especificado no item 6.4, de acordo com o estabelecido abaixo:\r\n\r\n6.4 - ÍNDICES DE RATEIO\r\n\r\n<a href=\"http://www.linhafacil.com.br/v2/wp-content/uploads/2017/01/referenciaderatio1.jpg\"><img class=\"alignnone size-full wp-image-194\" src=\"http://www.linhafacil.com.br/v2/wp-content/uploads/2017/01/referenciaderatio1.jpg\" alt=\"\" width=\"512\" height=\"415\" /></a>'),(1482,195,'_accordion_0_itm_txt_5_txt_flex','field_588f82b779e0d'),(1483,195,'accordion_0_itm_txt_6_texto_heading','PARTICIPAÇÃO DO ASSOCIADO EM CASO DE ACIONAMENTO DO PPM'),(1484,195,'_accordion_0_itm_txt_6_texto_heading','field_588f76e9cb9cf'),(1485,195,'accordion_0_itm_txt_6_cor_de_fundo',''),(1486,195,'_accordion_0_itm_txt_6_cor_de_fundo','field_588f91138c9fa'),(1487,195,'accordion_0_itm_txt_6_cor_do_texto',''),(1488,195,'_accordion_0_itm_txt_6_cor_do_texto','field_588f91eaa6afb'),(1489,195,'accordion_0_itm_txt_6_cor_do_icone',''),(1490,195,'_accordion_0_itm_txt_6_cor_do_icone','field_588f923ef5376'),(1491,195,'accordion_0_itm_txt_6_txt_flex','7.1 - Motocicletas\r\n\r\nEm qualquer hipótese de uso das coberturas do PPM, o associado responsável pela motocicleta danificada participará dos custos decorrentes com a importância abaixo especificada em relação ao valor de sua motocicleta (tabela FIPE), além de sua mensalidade devida:\r\n\r\na) Para motos de 50cc a 400cc corresponderá a 5% do valor do veículo (Ta- bela FIPE) com um mínimo de R$ 700,00 (Setecentos reais);\r\n\r\n7.2 – Motocicletas do Grupo Especial\r\n\r\nEm qualquer hipótese de uso das coberturas do PPM, o associado responsável pela motocicleta danificada participará dos custos decorrentes com a importância de 8% (Oito por cento) do valor de seu veículo (tabela FIPE), não podendo este ser inferior R$ 2.000,00 (dois mil reais), além de sua mensalidade devida. Este valor deve sermpre ser pago na sede da associação.\r\n\r\n7.3 - Cobertura diferenciada em autódromos e pistas.\r\n\r\nMotos do grupo especial que participarem de Track day, provas e ou competições amadoras dentro de autódromos e pistas regulamentadas e credenciadas à confederação brasileira de automobilismo (http://www.cba.org.br/site/circuitos.php), terão cobertura em caso de acidente, sendo, em qualquer hipótese de uso das coberturas do PPM, o associado responsável pelo veículo danificado participará dos custos decorrentes com a importância de 12% (doze por cento) do valor de seu veículo (tabela FIPE), não podendo este ser inferior R$ 4.000,00 (quatro mil reais), além de sua mensalidade devida.\r\n\r\n7.4 – Os valores dispostos na cláusula 7.1 deverão ser pagos no ato da entrada da motocicleta junto à oficina, para o início dos reparos. O veículo somente será reparado mediante a quitação da participação do associado. Já no caso da cláusula 7.2, o pagamento é sempre na sede da associação ou a critério da diretoria.\r\n\r\n8 - Somente serão aceitas no PPM motos com no máximo 15 (Quinze) anos de uso e com o valor máximo de cobertura de R$ 75.000,00 (setenta e cinco mil reais) .\r\n\r\n8.1 - Na falta de peças de reposição originais ou similares, importadas ou nacionais à disposição no mercado, o prazo para os reparos na motocicleta poderá se estender por tempo indeterminado, até que as peças em questão estejam novamente a disposição para a aquisição.');
INSERT INTO `wp_postmeta` VALUES (1492,195,'_accordion_0_itm_txt_6_txt_flex','field_588f82b779e0d'),(1493,195,'accordion_0_itm_txt_7_texto_heading','OBRIGAÇÕES DO ASSOCIADO PARTICIPANTE DO PPM'),(1494,195,'_accordion_0_itm_txt_7_texto_heading','field_588f76e9cb9cf'),(1495,195,'accordion_0_itm_txt_7_cor_de_fundo',''),(1496,195,'_accordion_0_itm_txt_7_cor_de_fundo','field_588f91138c9fa'),(1497,195,'accordion_0_itm_txt_7_cor_do_texto',''),(1498,195,'_accordion_0_itm_txt_7_cor_do_texto','field_588f91eaa6afb'),(1499,195,'accordion_0_itm_txt_7_cor_do_icone',''),(1500,195,'_accordion_0_itm_txt_7_cor_do_icone','field_588f923ef5376'),(1501,195,'accordion_0_itm_txt_7_txt_flex','8.1 - Agir com lealdade a boa fé com os demais associados e com a Associação, sempre velando pelo seu regular funcionamento e sua boa imagem e buscando alcançar os fins institucionais, sob pena de ser automaticamente excluído do PPM e do quadro de associados, sem prejuízo das sanções legais cabíveis.\r\n\r\n8.2 - Cumprir todas as normas estabelecidas no estatuto social e neste regulamento, bem como outras a serem expedidas formalmente pela Diretoria Executiva;\r\n\r\n8.3 - Pagar em dia os valores das mensalidades devidas pelos associados, além de contribuir no prazo e na forma estabelecida pela Diretoria Executiva;\r\n\r\n8.3.1 – Ressalta-se que os pagamentos do associado serão devidos e obrigatórios, ainda que seu veículo esteja fora de uso, guardado ou sofrendo reparos em fun- ção de eventos danosos.\r\n\r\n8.4 - Manter a motocicleta em bom estado de conservação;\r\n\r\n8.5 - Dar imediato conhecimento o GASP caso haja algum dos casos abaixo, sob pena de perda de todas as coberturas:\r\n\r\nA) Mudança de domicílio fiscal, ou qualquer dado pessoal informado no cadastro;\r\n\r\nB) Alteração na forma de utilização da motocicleta;\r\n\r\nC) Transferência de propriedade;\r\n\r\nD) Alteração das características da motocicleta.\r\n\r\n8.6 - O associado deve tomar todas as providências ao seu alcance para proteger o veículo acidentado e evitar a agravação dos prejuízos, sob pena de ser considerado responsável pelos mesmos.\r\n\r\n8.7 - Empenhar todos os esforços para ser ressarcido de prejuízos causados por terceiros.\r\n\r\n8.8 – Informar imediatamente as autoridades policiais em caso de evento, desaparecimento, roubo ou furto da motocicleta associada.\r\n\r\n8.9 - Na ocorrência de qualquer dos eventos previstos para ressarcimento neste regulamento, o associado deve tomar as seguintes providencias:\r\n\r\nI. Acionar a GASP imediatamente;\r\n\r\nII. Acionar a polícia militar, para que seja realizada a ocorrência po- licial, no local e na hora que tenha ocorrido o acidente, roubo ou furto, relatando completa e minuciosamente o fato no BOLETIM DE OCORRÊNCIA, mencionando dia, hora, local, circunstância do acidente, nome de quem dirigia o veículo, nome e endereço de testemunhas e providências de ordem policial tomadas.;\r\n\r\nIII. Não fazer acordos sem comunicar a GASP;\r\n\r\nIV. Em acidentes com envolvimentos de terceiros, identificá-los, quando possível, no registro policial juntamente com os dados de duas testemunhas do acidente;\r\n\r\nV. No caso de roubo ou furto, se o veículo possuir rastreador ou localizador, acionar a empresa prestadora de serviço que deverá tomar as devidas providências para a localização, rastreamento e bloqueio da motocicleta;\r\n\r\nVI. Exigir da empresa prestadora de serviço de guincho o Laudo de Vistoria da motocicleta acidentada, feito no local do acidente, antes do deslocamento do mesmo.\r\n\r\n8.9.1 - Avisar imediatamente ao GASP e às AUTORIDADES POLICIAIS sobre qualquer acidente com o veículo, incluindo furto ou roubo, relatando completa e minuciosamente o fato no BOLETIM DE OCORRÊNCIA, mencionando dia, hora, local, circunstância do acidente, nome de quem dirigia o veículo, nome e endereço de testemunhas e providências de ordem policial tomadas.\r\n\r\n8.9.2 – Somente serão beneficiados os prejuízos em que o boletim de ocorrência for lavrado no dia e na hora do evento, sem ressalvas.\r\n\r\n8.9.3 – Para fazer o acionamento do PPM, o associado deverá comparecer pessoalmente ou por representante legalmente constituído, na sede da GASP, para lavrar termo de Acionamento e Sub Rogação de Direitos, com informações sobre o ocorrido. A diretoria poderá ainda solicitar o comparecimento do associado na sede GASP para prestar esclarecimentos do ocorrido.\r\n\r\n8.10 - Aguardar a autorização do GASP para iniciar a reparação de quaisquer danos, sob pena de arcar com os prejuízos sem o benefício do rateio entre associados.\r\n\r\n8.11 – Sempre observar e ler atentamente espaço reservado para mensagens no boleto de pagamento mensal e o site (www.linhafacil.com.br), que são os instrumentos oficiais de comunicação da GASP com seu associado participante do PPM. Qualquer alteração do presente regulamento será informada aos associados atra- vés destes dois instrumentos, e o vincularão a partir do pagamento do boleto, ou da postagem da mensagem no site.'),(1502,195,'_accordion_0_itm_txt_7_txt_flex','field_588f82b779e0d'),(1503,195,'accordion_0_itm_txt_8_texto_heading','RESSARCIMENTO AO ASSOCIADO PARTICIPANTE DO PPM'),(1504,195,'_accordion_0_itm_txt_8_texto_heading','field_588f76e9cb9cf'),(1505,195,'accordion_0_itm_txt_8_cor_de_fundo',''),(1506,195,'_accordion_0_itm_txt_8_cor_de_fundo','field_588f91138c9fa'),(1507,195,'accordion_0_itm_txt_8_cor_do_texto',''),(1508,195,'_accordion_0_itm_txt_8_cor_do_texto','field_588f91eaa6afb'),(1509,195,'accordion_0_itm_txt_8_cor_do_icone',''),(1510,195,'_accordion_0_itm_txt_8_cor_do_icone','field_588f923ef5376'),(1511,195,'accordion_0_itm_txt_8_txt_flex','9.1 – Em Caso de ressarcimento integral (furto qualificado, roubo ou ressarcimento integral), o ressarcimento ao associado será feito em regra através da substitui- ção da motocicleta por outro equivalente. O ressarcimento poderá ser feito ainda, excepcionalmente, através do ressarcimento do valor do bem de uma só vez ou parcelado, de acordo com as condições econômicas da associação e mediante decisão fundamentada da Diretoria Executiva.\r\n\r\n9.1.1 - O pagamento em caso de Ressarcimento Integral somente será efetuado mediante a apuração do rateio integral do veiculo, respeitando o prazo mínimo de 90 (noventa) dias a contar da apresentação de todos os documentos exigidos.\r\n\r\n9.1.2 – O referido prazo será suspenso a partir do momento em que for solicitada documentação complementar no caso de dúvida fundada e justificável ou no caso que for instaurado inquérito policial para apurar as causas do acidente, do furto e/ou do roubo.\r\n\r\n9.2 - Para poder usufruir dos benefícios oferecidos pelo PPM do GASP, o associado deverá estar rigorosamente quites com todas as suas obrigações perante a Associação e ao PPM, além de cumprir as demais obrigações estabelecidas neste regulamento, no regimento interno e no estatuto social.\r\n\r\n9.2.1 - Caso o associado esteja com seu boleto de pagamento em atraso, o mesmo não estará com seu veículo protegido, necessitando de nova inspeção, e pagamento do boleto para reativar os benefícios. Não será aceito em hipótese alguma depósito bancário como forma de pagamento.\r\n\r\n9.3 - O ressarcimento dos prejuízos sofridos pelos associados somente ocorrerá depois de esgotadas todas as possibilidades de recebimento imediato dos valores do terceiro causador do dano.\r\n\r\n9.4 - Qualquer ressarcimento somente será pago mediante apresentação de TODOS os documentos requeridos pela GASP.\r\n\r\n9.5 – Caso o veículo seja inalienável e haja saldo devedor, a GASP entregará outro bem mediante a transferência da alienação, ou pagará o valor correspondente diretamente ao credor, e, havendo saldo remanescente, ao associado.\r\n\r\n9.5.1 – Caso o débito junto ao credor seja superior ao valor da ressarcimento, o pagamento ao credor somente será efetuado mediante o pagamento conjunto por parte do associado de sua parte, liberando o gravame.\r\n\r\n9.6 - O ressarcimento ao associado será efetuado somente após a apresentação de todos os documentos requeridos pela GASP. As indenizações serão pagas em cheque nominal e cruzado, ou através da reposição do bem por outro da mesma espécie e tipo, conforme acordado entre as partes, sempre deduzindo a participa- ção do associado prevista nas cláusulas 7.1 e 7.2.\r\n\r\n9.7 - Para fazer jus ao ressarcimento integral, o veículo deverá estar livre e desembaraçado de qualquer gravame ou impedimento, seja judicial, administrativo ou qualquer outro. Para ter direito ao ressarcimento, deverá o associado regularizar a situação e após apresentar toda a documentação regularizada à GASP.\r\n\r\n9.8 - Quando o veículo a ser indenizado fizer parte do conjunto de bens de um espólio ou massa falida, a indenização será realizada em nome do espólio ou da massa, mediante recibo assinado pelo inventariante e/ou síndico legalmente constituídos, respectivamente.\r\n\r\n9.9 - Caso o Associado faça a opção aderir ao PPM, em hipótese alguma será admitida a participação da motocicleta incluso nesta modalidade em outra associa- ção ou ainda em modalidade similar a esta e, inclusive a participação em seguro particular de casco, sob pena de tornar-se nula a presente proteção.'),(1512,195,'_accordion_0_itm_txt_8_txt_flex','field_588f82b779e0d'),(1513,195,'accordion_0_itm_txt_9_texto_heading','DOCUMENTOS NECESSÁRIOS PARA O RESSARCIMENTO'),(1514,195,'_accordion_0_itm_txt_9_texto_heading','field_588f76e9cb9cf'),(1515,195,'accordion_0_itm_txt_9_cor_de_fundo',''),(1516,195,'_accordion_0_itm_txt_9_cor_de_fundo','field_588f91138c9fa'),(1517,195,'accordion_0_itm_txt_9_cor_do_texto',''),(1518,195,'_accordion_0_itm_txt_9_cor_do_texto','field_588f91eaa6afb'),(1519,195,'accordion_0_itm_txt_9_cor_do_icone',''),(1520,195,'_accordion_0_itm_txt_9_cor_do_icone','field_588f923ef5376'),(1521,195,'accordion_0_itm_txt_9_txt_flex','0 - Caso o associado venha sofrer prejuízo material no seu veículo cadastrado, o ressarcimento dos valores correspondentes ou a reposição do bem ficará condicionada à apresentação dos seguintes documentos:\r\n\r\n10.1 - Em caso de danos parciais (acidente):\r\n\r\nBoletim de ocorrência feito no momento do acidente;\r\n\r\nXerox da Carteira de Habilitação do condutor da motocicleta;\r\n\r\nXerox do CRVL (Certificado de registro e licenciamento da motocicleta).\r\n\r\n10.2 - Em caso de ressarcimento integral decorrente de acidente ou incêndio:\r\n\r\n10.2.1 - Em se tratando de associado pessoa física:\r\n\r\nCópia do CPF e RG do associado;\r\n\r\nCRV Certificado de Registro de Veículo original (documento de transferência) devidamente preenchido a favor da GASP ou de quem esta indicar, assinado e com firma reconhecida por autenticidade;\r\n\r\nCRLV (Certificado de Registro e Licenciamento da motocicleta) original, com a prova de quitação Seguro obrigatório e IPVA dos dois últimos anos de licenciamento;\r\n\r\nBoletim de Ocorrência original ou cópia autêntica; Xerox da Carteira de habilitação do condutor da motocicleta;\r\n\r\nChaves da motocicleta;\r\n\r\nCertidão negativa de furto e multa da motocicleta;\r\n\r\n10.2.2 - Em se tratando de associado pessoa jurídica:\r\n\r\nCRV Certificado de Registro de veículo original (documento de transferência) devidamente preenchido a favor da GASP ou de quem esta indicar, assinado e com firma reconhecida por autenticidade;\r\n\r\nCRVL (Certificado de Registro e Licenciamento da motocicleta) original, com a prova de quitação Seguro Obrigatório e IPVA dos dois últimos anos de licenciamento;\r\n\r\nBoletim de Ocorrência original ou cópia autêntica; Xerox da Carteira de habilitação do condutor da motocicleta;\r\n\r\nChaves da motocicleta; Certidão negativa de furto e multa da motocicleta;\r\n\r\nCópia do Contrato ou Estatuto Social, com alterações, autenticadas em cartório;\r\n\r\nNota fiscal de venda a GASP, quando o objetivo social da empresa for indústria, comércio, importação, exportação etc. (Prestação de serviço e leasing não necessitam emitir esta nota fiscal).\r\n\r\n10.4 - Em caso de ressarcimento Integral decorrente de Roubo ou Furto: -Todos os documentos exigidos na cláusula 10.2.1 e 10.2.2, exceto quando à nota fiscal;\r\n\r\n-Extrato do DETRAN (débitos e restrições) constando queixa de roubo/furto;\r\n\r\n-Certidão negativa de multas da motocicleta.'),(1522,195,'_accordion_0_itm_txt_9_txt_flex','field_588f82b779e0d'),(1523,195,'accordion_0_itm_txt_10_texto_heading','DISPOSIÇÕES FINAIS'),(1524,195,'_accordion_0_itm_txt_10_texto_heading','field_588f76e9cb9cf'),(1525,195,'accordion_0_itm_txt_10_cor_de_fundo',''),(1526,195,'_accordion_0_itm_txt_10_cor_de_fundo','field_588f91138c9fa'),(1527,195,'accordion_0_itm_txt_10_cor_do_texto',''),(1528,195,'_accordion_0_itm_txt_10_cor_do_texto','field_588f91eaa6afb'),(1529,195,'accordion_0_itm_txt_10_cor_do_icone',''),(1530,195,'_accordion_0_itm_txt_10_cor_do_icone','field_588f923ef5376'),(1531,195,'accordion_0_itm_txt_10_txt_flex','11.1 - Com o ressarcimento ao associado, a GASP ficará sub-rogada em todos os direitos e ações do associado contra aquele que por ato, fato ou omissão tenham causado os prejuízos ou para eles contribuído.\r\n\r\n11.2 - Fica eleito da comarca onde estiver localizada a sede da GASP para dirimir quaisquer dúvidas que surgirem relativas ao PPM, afastando quaisquer outros foros por mais privilegiados que sejam.\r\n\r\n11.3 - O associado declara que todas as informações prestadas por ele a GASP serão verdadeiras e, caso fique comprovada a inveracidade de qualquer informa- ção ou declaração emitida pelo associado, o mesmo será imediatamente excluído do PPM bem como eliminado no quadro social da GASP, nos termos do Estatuto Social, sem prejuízo das sanções legais.\r\n\r\n11.4 - Todos os associados declaram que leram e têm pleno conhecimento de todas as normas contidas no regulamento PPM e no estatuto social da GASP, e que aceitam todas as condições estabelecidas neste documento para associarem-se.\r\n\r\n11.5 - O presente regulamento entra em vigor na data da Assembléia Geral que o instituiu, revogando todas as disposições anteriores em contrário.\r\n\r\n11.6 - Os casos omissos no presente regulamento serão analisados pela Diretoria Executiva, sendo a decisão levada ao conhecimento da Assembléia Geral subseqüente ao saneamento da omissão, após a ciência e ratificação, as decisões terão força normativa e deverão ser aplicadas a todos os casos semelhantes e análogos, no que for aplicável.'),(1532,195,'_accordion_0_itm_txt_10_txt_flex','field_588f82b779e0d'),(1533,195,'accordion_0_itm_txt','a:11:{i:0;s:5:\"txt_2\";i:1;s:5:\"txt_2\";i:2;s:5:\"txt_2\";i:3;s:5:\"txt_2\";i:4;s:5:\"txt_2\";i:5;s:5:\"txt_2\";i:6;s:5:\"txt_2\";i:7;s:5:\"txt_2\";i:8;s:5:\"txt_2\";i:9;s:5:\"txt_2\";i:10;s:5:\"txt_2\";}'),(1534,195,'_accordion_0_itm_txt','field_588f7649cb9ce'),(1535,195,'accordion','1'),(1536,195,'_accordion','field_588f7627cb9cd'),(1537,85,'_aioseop_opengraph_settings','a:13:{s:32:\"aioseop_opengraph_settings_title\";s:0:\"\";s:31:\"aioseop_opengraph_settings_desc\";s:0:\"\";s:36:\"aioseop_opengraph_settings_customimg\";s:0:\"\";s:37:\"aioseop_opengraph_settings_imagewidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_imageheight\";s:0:\"\";s:32:\"aioseop_opengraph_settings_video\";s:0:\"\";s:37:\"aioseop_opengraph_settings_videowidth\";s:0:\"\";s:38:\"aioseop_opengraph_settings_videoheight\";s:0:\"\";s:35:\"aioseop_opengraph_settings_category\";s:8:\"activity\";s:34:\"aioseop_opengraph_settings_section\";s:0:\"\";s:30:\"aioseop_opengraph_settings_tag\";s:0:\"\";s:34:\"aioseop_opengraph_settings_setcard\";s:7:\"summary\";s:44:\"aioseop_opengraph_settings_customimg_twitter\";s:0:\"\";}'),(1538,85,'_disabel_wpdevart_facebook_comment','enable'),(1539,85,'_rdscriptcontenttop',''),(1540,85,'_rdscriptcontentbottom',''),(1541,85,'_rdscriptcontentinhead',''),(1542,85,'_rdscriptcontentinfooter',''),(1543,85,'_at_widget','1'),(1544,85,'texto_diferenciado','Regulamento de Veículos Leve'),(1545,85,'_texto_diferenciado','field_58862a7dd9d12'),(1546,85,'accordion_0_itm_txt_0_texto_heading','DAS CONDIÇÕES GERAIS DE PARTICIPAÇÃO'),(1547,85,'_accordion_0_itm_txt_0_texto_heading','field_588f76e9cb9cf'),(1548,85,'accordion_0_itm_txt_0_cor_de_fundo',''),(1549,85,'_accordion_0_itm_txt_0_cor_de_fundo','field_588f91138c9fa'),(1550,85,'accordion_0_itm_txt_0_cor_do_texto',''),(1551,85,'_accordion_0_itm_txt_0_cor_do_texto','field_588f91eaa6afb'),(1552,85,'accordion_0_itm_txt_0_cor_do_icone',''),(1553,85,'_accordion_0_itm_txt_0_cor_do_icone','field_588f923ef5376'),(1554,85,'accordion_0_itm_txt_0_txt_flex','1 – O Programa de Auxílio Mútuo (PAM) da GASP tem como objetivo primordial conferir proteção e segurança aos automóveis de seus associados aderentes ao programa, através do rateio dos danos materiais eventualmente sofridos e acobertados pelo programa, na forma deste regulamento, bem como através da prevenção ativa de acidentes, pela veiculação de material educativo pertinente às normas de segurança no trânsito.\r\n\r\n1.2 - Para participar do Programa de Auxílio Mútuo (PAM) o associado deve estar devidamente filiado a GASP e, voluntariamente, indicar seu interesse na participação do referido programa, através de termo de adesão próprio. Ao aderir voluntariamente aos programas, o associado se compromete a contribuir com as cotas necessária referente às despesas apuradas para a consecução dos benefí- cios através do MUTUALISMO, ou seja, repartição proporcional dos programas de assistência de eventos danosos já ocorridos através de rateio de despesas.'),(1555,85,'_accordion_0_itm_txt_0_txt_flex','field_588f82b779e0d'),(1556,85,'accordion_0_itm_txt','a:12:{i:0;s:5:\"txt_2\";i:1;s:5:\"txt_2\";i:2;s:5:\"txt_2\";i:3;s:5:\"txt_2\";i:4;s:5:\"txt_2\";i:5;s:5:\"txt_2\";i:6;s:5:\"txt_2\";i:7;s:5:\"txt_2\";i:8;s:5:\"txt_2\";i:9;s:5:\"txt_2\";i:10;s:5:\"txt_2\";i:11;s:5:\"txt_2\";}'),(1557,85,'_accordion_0_itm_txt','field_588f7649cb9ce'),(1558,85,'accordion','1'),(1559,85,'_accordion','field_588f7627cb9cd'),(1560,196,'acordions',''),(1561,196,'_acordions','field_5887501a480ec'),(1562,196,'texto_diferenciado','Regulamento de Motos'),(1563,196,'_texto_diferenciado','field_58862a7dd9d12'),(1564,196,'accordion_0_itm_txt_0_texto_heading','BENEFÍCIOS DO PROGRAMA DE AUXÍLIO MÚTUO'),(1565,196,'_accordion_0_itm_txt_0_texto_heading','field_588f76e9cb9cf'),(1566,196,'accordion_0_itm_txt_0_cor_de_fundo',''),(1567,196,'_accordion_0_itm_txt_0_cor_de_fundo','field_588f91138c9fa'),(1568,196,'accordion_0_itm_txt_0_cor_do_texto',''),(1569,196,'_accordion_0_itm_txt_0_cor_do_texto','field_588f91eaa6afb'),(1570,196,'accordion_0_itm_txt_0_cor_do_icone',''),(1571,196,'_accordion_0_itm_txt_0_cor_do_icone','field_588f923ef5376'),(1572,196,'accordion_0_itm_txt_0_txt_flex',''),(1573,196,'_accordion_0_itm_txt_0_txt_flex','field_588f82b779e0d'),(1574,196,'accordion_0_itm_txt','a:1:{i:0;s:5:\"txt_2\";}'),(1575,196,'_accordion_0_itm_txt','field_588f7649cb9ce'),(1576,196,'accordion','1'),(1577,196,'_accordion','field_588f7627cb9cd'),(1578,85,'accordion_0_itm_txt_1_texto_heading','ADESÃO AO PROGRAMA DE AUXÍLIO MÚTUO (PAM)'),(1579,85,'_accordion_0_itm_txt_1_texto_heading','field_588f76e9cb9cf'),(1580,85,'accordion_0_itm_txt_1_cor_de_fundo',''),(1581,85,'_accordion_0_itm_txt_1_cor_de_fundo','field_588f91138c9fa'),(1582,85,'accordion_0_itm_txt_1_cor_do_texto',''),(1583,85,'_accordion_0_itm_txt_1_cor_do_texto','field_588f91eaa6afb'),(1584,85,'accordion_0_itm_txt_1_cor_do_icone',''),(1585,85,'_accordion_0_itm_txt_1_cor_do_icone','field_588f923ef5376'),(1586,85,'accordion_0_itm_txt_1_txt_flex','2 - Para aderir ao PAM da GASP, o associado deverá encaminhar à Diretoria da Associação os seguintes documentos, além de pagar a taxa de adesão e submeter seu veículo à aprovação da vistoria:\r\n\r\n2.1 – Termo de adesão em modelo próprio;\r\n\r\nCarteira nacional de habilitação atualizada;\r\nCRV do veículo, ou nota fiscal em caso de 0km;\r\nContrato social ou estatuto social, caso seja pessoa jurídica;\r\nComprovante de residência atualizado.\r\n2.2 - O período mínimo de participação no PAM da GASP é de 6 (seis) meses, contados a partir da adesão ao programa e em caso de evento com o veículo.\r\n\r\n2.2.1 - Será permitida a transferência de titularidade de um veículo cadastrado no PAM, desde que o novo associado titular pague os custos de uma nova vistoria. Caso o proponente não seja associado, deverá propor sua admissão ao quadro de associados da GASP. Este procedimento estará condicionado ao pagamento de uma nova taxa de adesão, efetuar uma nova vistoria prévia e aprovação expressa da diretoria da Associação.\r\n\r\n2.2.2 - Será permitida a substituição de um veículo cadastrado no PAM, desde que o associado pague uma taxa relativa a substituição e que o veículo não tenha nenhum impedimento quanto a sua aceitação no programa. Este procedimento estará condicionado a aprovação expressa da diretoria da Associação.\r\n\r\n2.3 – O associado que desejar se desligar do PAM deverá solicitar formulário de cancelamento da associação, devendo o associado estar adimplente com todas as suas obrigações relativas ao PAM. O requerimento deverá conter as seguintes informações: Nome completo, CPF, modelo do veículo, placa, e motivo do desligamento.\r\n\r\n2.3.1 – O pedido de desligamento do PAM poderá ser realizado em qualquer dia do mês, ficando clara a responsabilidade pelo pagamento do próximo mês independente do dia em que for realizado o pedido de desligamento, inexistindo cobrança pro-rata.\r\n\r\n2.4 – Caso o associado ou o veículo cadastrado se envolva em mais de 1 (um) evento danoso no período de 12 (doze) meses, este poderá ser excluído compulsoriamente do PAM, a critério da Diretoria Executiva, e assegurado o direito a recurso administrativo e após este, pedido de reconsideração.\r\n\r\n2.4.1 - No caso do segundo acionamento no período de 1 (um) ano, o segundo acionamento terá a incidência do valor da participação do associado prevista na cláusula 8 e seguintes, em dobro. No caso de terceiro acionamento no período de 1 (um) ano, o valor será triplicado, e assim por diante.\r\n\r\n2.5 – Após a aceitação da adesão, associados participantes do PAM deverão pagar os valores abaixo identificados:\r\n\r\na) Contribuição associativa mensal da GASP, no valor mensal de R$ 10,00 (dez reais);\r\n\r\nb) Taxa administrativa mensal do PAM, conforme tabela da associação, por cada veículo cadastrado;\r\n\r\n2.5.1 – A contribuição associativa mensal da GASP já é de obrigação de cada associado, conforme previsto na proposta de admissão e no estatuto social, independente da adesão ao PAM. Caso se desligue do PAM, o associado voltará a pagar somente a contribuição associativa, nos termos do regimento interno da GASP'),(1587,85,'_accordion_0_itm_txt_1_txt_flex','field_588f82b779e0d'),(1588,85,'accordion_0_itm_txt_2_texto_heading','ACEITAÇÃO E VIGÊNCIA DO PROGRAMA DE AUXÍLIO MÚTUO (PAM)'),(1589,85,'_accordion_0_itm_txt_2_texto_heading','field_588f76e9cb9cf'),(1590,85,'accordion_0_itm_txt_2_cor_de_fundo',''),(1591,85,'_accordion_0_itm_txt_2_cor_de_fundo','field_588f91138c9fa'),(1592,85,'accordion_0_itm_txt_2_cor_do_texto',''),(1593,85,'_accordion_0_itm_txt_2_cor_do_texto','field_588f91eaa6afb'),(1594,85,'accordion_0_itm_txt_2_cor_do_icone',''),(1595,85,'_accordion_0_itm_txt_2_cor_do_icone','field_588f923ef5376'),(1596,85,'accordion_0_itm_txt_2_txt_flex','3 – Os benefícios do PAM para veículo do associado cadastrado tem início as 00:00 hs do próximo dia útil após a data de realização da vistoria do veículo e do pagamento da taxa de adesão, condicionado no que for aplicável.\r\n\r\n3.1 - Poderá haver dispensa da vistoria a veículos 0km, desde que este, esteja no pátio da concessionária ou revenda e a emissão da nota fiscal por parte do associado não seja superior a 30 dias e que haja o carimbo da concessionaria atestando que o veiculo se encontra no pátio da mesma.\r\n\r\n3.2 - A Proposta de adesão ao PAM poderá ser recusada em até 15 (quinze) dias pela Diretoria da GASP, contados a partir da data do seu recebimento. A eventual recusa e os motivos desta serão informados ao pretendente através de carta com AR, enviada ao endereço constante na proposta. Na hipótese de recusa, os valores das taxas discriminadas no item acima serão ressarcidos, restando válida a prote- ção do PAM até a hora e data da informação da recusa.\r\n\r\n3.3 - A diretoria da GASP se resguarda no direito de indeferir a inclusão de qualquer veículo ao PAM, caso o mesmo se encontre em más condições de conservação ou tenha alterações, modificações e acessórios que possam afetar sua segurança ou desempenho.\r\n\r\n3.4 – A Diretoria Executiva da GASP poderá ainda proceder à eliminação do PAM de qualquer um dos associados a qualquer tempo, caso este aja contra os interesses coletivos dos associados, ou viole qualquer uma das normas estatutárias ou regulamentares da associação, assegurado o direito a ampla defesa e contraditório.\r\n\r\n3.5 – A GASP exige para todos os veículos com valor superior a R$ 40.000,00 (quarenta mil reais) a instalação de equipamentos rastreadores, e sua contínua manutenção em perfeito estado de funcionamento. O mesmo vale para todos os veículos do Grupo Especial (assim identificados no laudo de vistoria) e do grupo Diesel / Vans / Caminhonetes, podendo aumentar ou diminuir o valor do veículo com uso de equipamento de rastreador, de acordo com os índices de sinistros apurados pela associação.Caso a associação se utilize desse preceito, o mesmo valerá apenas para as novas adesões.\r\n\r\n3.5.1 – Para todos estes veículos, as despesas reparáveis e irreparáveis os benefí- cios de furto e roubo somente serão ativadas após a instalação do equipamento.\r\n\r\n3.5.2 - A escolha da empresa de rastreamento será feita pelo associado, e a taxa de monitoramento, bem como a taxa de instalação do equipamento, é um serviço a ser pago pelo associado à referida empresa.\r\n\r\n3.5.2.1 - A responsabilidade da fiscalização de funcionamento e manutenção do equipamento é inteira do associado. Se porventura na data o evento o equipamento estiver sem funcionamento, o associado não terá direito aos benefícios de Furto e Roubo contratados.\r\n\r\n3.6 - Caso o associado opte por uma outra empresa de rastreamento que não seja previamente homologada pela GASP, o mesmo deverá antes homologar a empresa, e caso esta seja aceita, deve ainda disponibilizar à GASP senha e login de acesso ao sistema atualizados.\r\n\r\n3.7 - As empresas homologadas ao instalar o rastreador são obrigados a fazer uma análise (elétrica e mecânica) do veículo para averiguar defeitos antes da instala- ção do equipamento. O associado ou responsável pelo veículo será avisado sobre os possíveis defeitos do veículo e assinará o laudo técnico dando autorização para a instalação, caso os defeitos diagnosticados não atrapalhem o bom funcionamento do antifurto bloqueador ou rastreador\r\n\r\n3.8 – No caso de uma indenização integral, veículo deverá estar em dia com os impostos, taxas e toda a documentação necessária para a sua circulação, livre de multas e ou qualquer impedimento que impeça a sua transferência, podendo a associação regularizar tais débitos e descontar no valor a ser ressarcido ao associado.\r\n\r\n3.9 - O não pagamento do boleto mensal até a data de vencimento determina a perda automática de todos os benefícios oferecidos pelo PAM da GASP.\r\n\r\n3.10 - Para reativação dos benefícios do PAM em caso de atraso no pagamento, deverá o associado solicitar uma nova guia de cobrança (acrescida das despesas de nova vistoria) e providenciar a vistoria, seja ela em um dos pontos autorizados, ou através da visita de um vistoriador. Os benefícios somente retornarão na 00:00 hrs seguinte ao pagamento e a vistoria.\r\n\r\n3.11 - Após 30 (trinta) dias de atraso no pagamento do boleto bancário, o associado inadimplente poderá ter seu nome encaminhado aos órgãos de proteção ao crédito (tais como SPC, SERASA, etc.), podendo ainda o título ser protestado, sem prejuízo da propositura da Ação Judicial competente para recebimento do débito.\r\n\r\n3.12 - Se o Associado atrasar o pagamento do seu boleto bancário por mais de 15 (quinze) dias, fica a sua re-inclusão ao PAM condicionada também a parecer favorável da Diretoria.\r\n\r\n3.13 - O não recebimento do boleto ou a exclusão do associado do PAM ou da GASP não o exime da responsabilidade pelo seu pagamento, visto que a cobrança se trata sempre do rateio referente ao mês anterior, período em que o associado usufruiu dos benefícios do PAM.\r\n\r\n3.14 – Caso o associado seja excluído da base do PAM ou da GASP, após devidamente comunicado o associado não terá mais direito a nenhum dos benefícios, assim, o mesmo não deverá pagar mais nenhum dos boletos que eventualmente tenha em seu poder, devendo descartá‐los imediatamente.'),(1597,85,'_accordion_0_itm_txt_2_txt_flex','field_588f82b779e0d'),(1598,85,'accordion_0_itm_txt_3_texto_heading','OS BENEFÍCIOS DO PROGRAMA DE AUXÍLIO MÚTUO'),(1599,85,'_accordion_0_itm_txt_3_texto_heading','field_588f76e9cb9cf'),(1600,85,'accordion_0_itm_txt_3_cor_de_fundo',''),(1601,85,'_accordion_0_itm_txt_3_cor_de_fundo','field_588f91138c9fa'),(1602,85,'accordion_0_itm_txt_3_cor_do_texto',''),(1603,85,'_accordion_0_itm_txt_3_cor_do_texto','field_588f91eaa6afb'),(1604,85,'accordion_0_itm_txt_3_cor_do_icone',''),(1605,85,'_accordion_0_itm_txt_3_cor_do_icone','field_588f923ef5376'),(1606,85,'accordion_0_itm_txt_3_txt_flex','4 – Os benefícios do PAM se aplicam aos seguintes eventos:\r\n\r\nRoubo; b) Furto; c) Colisão;\r\nCapotamento; e) Abalroamento;\r\nIncêndio;\r\nQueda de objetos externos sobre o veículo;\r\nChuvas de granizo;\r\nSubmersão por inundação ou alagamento de água doce;\r\n4.1 – Serão incluídos nos benefícios os acessórios que fizerem parte do veículo no momento da inspeção inicial, desde que originais de fábrica e constantes na nota fiscal de compra do veículo. Os mesmos não serão ressarcidos caso sejam atingidos isoladamente nos eventos danosos. (a cláusula se aplica aos equipamentos de som, rodas e pneus, kit gás, DVD, e acessórios em geral).\r\n\r\n4.2 – Os benefícios de danos irreparáveis provenientes de roubo e furto não se confundem com fraudes e apropriação indébita, além de outras práticas delituosas, que não são objeto da proteção.\r\n\r\n4.3 - Não haverá benefício de danos reparáveis e irreparáveis provenientes de roubo ou furto nos casos dos veículos que não instalaram o “rastreador” solicitados pela GASP, conforme especificado no item 3.5.\r\n\r\n4.4 – Serão concedidos benefícios em eventos desde que o condutor seja habilitado, podendo ou não ser o próprio associado.\r\n\r\n4.5 - Veículos com alíquotas, taxas ou impostos reduzidos ou isentos, tais como táxis, produtor rural e frotistas, serão ressarcidos com abatimento dos impostos, conforme ocorrido quando da aquisição por parte do associado, evitando assim enriquecimento ilícito. Tais serão ressarcidos com base de cálculo em 80% (oitenta por cento) da Tabela FIPE.'),(1607,85,'_accordion_0_itm_txt_3_txt_flex','field_588f82b779e0d'),(1608,85,'accordion_0_itm_txt_4_texto_heading','5 Os benefícios do PAM NÃO se aplicam aos seguintes eventos:'),(1609,85,'_accordion_0_itm_txt_4_texto_heading','field_588f76e9cb9cf'),(1610,85,'accordion_0_itm_txt_4_cor_de_fundo',''),(1611,85,'_accordion_0_itm_txt_4_cor_de_fundo','field_588f91138c9fa'),(1612,85,'accordion_0_itm_txt_4_cor_do_texto',''),(1613,85,'_accordion_0_itm_txt_4_cor_do_texto','field_588f91eaa6afb'),(1614,85,'accordion_0_itm_txt_4_cor_do_icone',''),(1615,85,'_accordion_0_itm_txt_4_cor_do_icone','field_588f923ef5376'),(1616,85,'accordion_0_itm_txt_4_txt_flex','<ul>\r\n 	<li>a) Responsabilidade civil facultativa, danos materiais, pessoais, corporais e morais aos ocupantes do veículo;\r\nb) Eventos danosos decorrentes da inobservância das leis em vigor, como dirigir sem possuir carteira de habilitação ou estar com a mesma suspensa, ou ainda, não ter habilitação adequada conforme categoria do veículo, dentre outras previstas na legislação vigente.\r\nc) Negligência na utilização ou manutenção do veículo (itens de segurança, pneus, dentre outras previstas na legislação vigente).\r\nd) Utilizar inadequadamente o veículo com relação a lotações de passageiros, dimensão, peso e acondicionamento de carga transportada.\r\ne) Alterar as características originais do veículo de modo a comprometer a segurança (veículos rebaixados, com molas cortadas, turbinados ou com qualquer outra alteração na estrutura original).\r\nf) Desgaste natural ou pelo uso, deterioração gradativa e vício próprio, defeito fabricação, defeito mecânico, da instalação elétrica do veículo, vibrações, corrosão, ferrugem, umidade e chuva;\r\ng) Quaisquer atos de hostilidade, tumultos, motins, sabotagem, vandalismo.\r\nh) Atos de autoridade pública salvo para evitar propagação de danos ocorridos;\r\ni) Negligência do associado, arrendatário ou cessionário na utilização, bem como na adoção de todos os meios razoáveis para salva-los e preservá-los durante ou após a ocorrência de qualquer evento;\r\nj) Atos praticados em estado de insanidade mental e /ou sob efeito de bebidas alcoólicas e /ou tóxicas. Também não usufruirão dos benefícios para o associado que se envolver em eventos, e estando sob suspeita de embriaguez, e se recuse a realizar exames de etilômetro ou de sangue.\r\nk) Danos emergentes;\r\nl) Lucros cessantes e danos emergentes direta ou indiretamente da paralisação do veículo associado ou mesmo de terceiro, mesmo sendo em conseqüência de risco coberto pela proteção do(s) veículo(s);\r\nm) Perdas ou danos ocorridos quando em trânsito por estradas ou caminhos impedidos, inadequados, não abertos ao tráfego ou de areias fofas ou movediças;\r\nn) Danos causados a carga transportada;\r\no) Danos sofridos por pessoas transportadas em locais não especificamente destinados e apropriados a tal fim, ou mesmo em local apropriado;\r\np) Danos ocorridos com o veículo fora do território nacional; q) Perdas e danos ocorridos durante a participação do veículo em competições, apostas, provas de velocidade, inclusive treinos preparatórios;\r\nr) Multas impostas ao associado e despesas de qualquer natureza relativa a ações e processos criminais;\r\ns) As avarias que forem previamente constatadas e relacionadas na inspeção inicial do veículo do associado, nos eventos de danos reparáveis (em caso de danos irreparáveis, tais avarias serão descontadas do valor a ser ressarcido); Em caso de reparo das avarias preexistentes anteriores à inspeção inicial, o associado deverá solicitar nova inspeção, contraindo o onus de pagamento de todas as despesas referentes à nova inspeção.\r\nt) Reparos de avarias sofridas no veículo cadastrado promovidos sem a autorização da GASP,\r\nu) Danos causados por guerra, revolução e ocorrências semelhantes, ou seja, contingências que atinjam de forma maciça a população regional ou nacional;\r\nv) No caso de veículos equipados com rastreador via satélite, caso o equipamento não esteja em perfeito funcionamento.\r\nPARÂMETROS DO PROGRAMA DE AUXÍLIO MÚTUO</li>\r\n</ul>'),(1617,85,'_accordion_0_itm_txt_4_txt_flex','field_588f82b779e0d'),(1618,85,'accordion_0_itm_txt_5_texto_heading','6 – A repartição dos prejuízos será limitada ao valor máximo de R$ 150.000,00 (cento e cinquenta mil reais) para cada veículo cadastrado no PAM. Este valor poderá ser revisto pela Diretoria Executiva, observando em regra o valor de mercado dos veículos fornecido pela tabela FIPE (www.FIPE.com.br), e excepcionalmente a critério da Diretoria Executiva, outra tabela de valores.'),(1619,85,'_accordion_0_itm_txt_5_texto_heading','field_588f76e9cb9cf'),(1620,85,'accordion_0_itm_txt_5_cor_de_fundo',''),(1621,85,'_accordion_0_itm_txt_5_cor_de_fundo','field_588f91138c9fa'),(1622,85,'accordion_0_itm_txt_5_cor_do_texto',''),(1623,85,'_accordion_0_itm_txt_5_cor_do_texto','field_588f91eaa6afb'),(1624,85,'accordion_0_itm_txt_5_cor_do_icone',''),(1625,85,'_accordion_0_itm_txt_5_cor_do_icone','field_588f923ef5376'),(1626,85,'accordion_0_itm_txt_5_txt_flex','6.1 – Casos de redução do valor a ser ressarcido:\r\na) Os veículos com a numeração do chassi remarcada, poderão ser aceitos e sofrerão depreciação de 30% (trinta por cento) em relação ao valor fornecido pela tabela FIPE.\r\nb) Os veículos utilizados como Táxi serão protegidos, com uma depreciação de 20% (vinte por cento) em relação ao valor fornecido pela tabela FIPE.\r\nc) Caso o veículo a ser ressarcido integralmente for proveniente de Leilão, ou já tenha sido objeto de ressarcimento integral poderão ser aceitos e sofrerão depreciação de 30% (trinta por cento) da Tabela Fipe.\r\n6.2 - Em caso de ressarcimento integral (roubo, furto, e dano irreparável) dos veí- culos objeto dos benefícios, a GASP tem em regra 90 (noventa) dias para ressarcir ao associado a contar da apresentação de todos os documentos requeridos pela GASP, observada a ressalva do item 9.1.\r\n\r\n6.3 - Quando o veículo sofrer danos reparáveis, a indenização será feita com base nos custos das partes, peças e materiais a substituir, bem como da mão-de-obra necessária para reparação ou substituição. A GASP providenciará o conserto do veículo danificado, em oficina previamente homologada.\r\n\r\n6.3.1 – A reparação dos danos citada no item anterior será feita obrigatoriamente com a reposição de peças originais dentro do período da garantia de fábrica do veículo 0km, e poderá ser feita a substituição das peças danificadas pelas similares produzidas no mercado paralelo ou usadas, desde que não comprometam a segurança e a utilização do veículo.\r\n\r\n6.3.2 - Na eventualidade de o associado escolher outra oficina que não seja uma das homologadas pela GASP, o valor do conserto total do(s) veículo(s) não poderá ultrapassar o valor do menor dos orçamentos providenciados pela GASP. Sendo o conserto do(s) veículo(s) efetivado em oficina sugerida pelo associado e diversa das homologadas, o associado pagará a diferença do valor do conserto (caso haja).\r\n\r\n6.3.3 – Em nenhuma hipótese a GASP, se responsabiliza pela qualidade e prazo dos reparos, sendo estes de exclusiva responsabilidade do reparador.\r\n\r\n6.4 - Haverá ressarcimento integral (danos irreparáveis), em regra, quando o orçamento do montante para reparação do bem ultrapassar 75% (setenta e cinco por cento) do valor da tabela FIPE, observada a ressalva da cláusula abaixo.\r\n\r\n6.4.1 - Caberá à Diretoria Executiva a opção de proceder o ressarcimento integral do veículo ou de promover o conserto do mesmo em caso de danos reparáveis, sempre observando a forma que, aplicada, implique em menor valor a ser rateado e segurança para o associado.\r\n\r\n6.5 - Nos casos de danos irreparáveis ou mesmo de danos reparáveis, os materiais remanescentes (peças ou salvado) pertencerão à GASP, que poderá vendê-los para diminuir o valor do rateio para os associados.\r\n\r\n6.6 - A GASP reserva o direito de contratar investigação especializada (sindicância) a fim de levantar eventuais irregularidades a respeito da natureza do acidente e eventuais fraudes ou irregularidades. Caso seja contratada, o associado deverá colaborar de todas as formas com a condução da investigação, sob pena de ter seu auxílio negado.'),(1627,85,'_accordion_0_itm_txt_5_txt_flex','field_588f82b779e0d'),(1628,85,'accordion_0_itm_txt_6_texto_heading','RATEIO DOS PREJUÍZOS NO PROGRAMA DE AUXÍLIO MÚTUO'),(1629,85,'_accordion_0_itm_txt_6_texto_heading','field_588f76e9cb9cf'),(1630,85,'accordion_0_itm_txt_6_cor_de_fundo',''),(1631,85,'_accordion_0_itm_txt_6_cor_de_fundo','field_588f91138c9fa'),(1632,85,'accordion_0_itm_txt_6_cor_do_texto',''),(1633,85,'_accordion_0_itm_txt_6_cor_do_texto','field_588f91eaa6afb'),(1634,85,'accordion_0_itm_txt_6_cor_do_icone',''),(1635,85,'_accordion_0_itm_txt_6_cor_do_icone','field_588f923ef5376'),(1636,85,'accordion_0_itm_txt_6_txt_flex','7 – Os prejuízos aferidos pelos associados aderentes ao PAM serão apurados mensalmente, sendo rateados entre todos os associados participantes do PAM no mês de referência.\r\n\r\n7.1 – O valor do rateio poderá ser pago através de boleto bancário, Cartão de Crédito e Débito (obedecendo as regras do Banco emitente), juntamente com os demais valores. A data de vencimento será estipulada no ato da adesão ao programa (dias 10, 15, 20 e 25 ), cumprindo ao associado reclamar o envio do boleto, na hipótese do mesmo não ser recebido até o correspondente dia de vencimento.\r\n\r\n7.1.1 – A critério da diretoria executiva e mediante a aceitação do associado, a GASP poderá emitir carnês de pagamento com 11 (onze) parcelas no valor da média dos boletos mensais dos últimos exercícios, para comodidade dos associados. Neste caso, o décimo segundo pagamento será realizado através de boleto bancário, onde o valor será composto pela cobrança do respectivo mês, além do acerto das contas dos meses anteriores (diferença para maior ou para menor do valor estimativo cobrado e do valor real de cada mês). A opção por parte do associado por boletos mensais e carnê constará no termo de adesão, ou documento equivalente.\r\n\r\n7.2 - Os boletos ficarão disponíveis no site oficial da GASP, (www.linhafacil.com. br). Caso o associado não receba o boleto impresso até a data de vencimento, deverá retirá-lo no site ou entrar em contato com a GASP e solicitar a 2º via, podendo ainda solicitar o código de barras via mensagem de texto (SMS).\r\n\r\n7.3 - A repartição dos prejuízos será feita pelo rateio do valor correspondente, entre todos os associados participantes do PAM, obedecendo ao índice de rateio do veículo, de acordo com o estabelecido na tabela de índice de rateio que segue abaixo.'),(1637,85,'_accordion_0_itm_txt_6_txt_flex','field_588f82b779e0d'),(1638,85,'accordion_0_itm_txt_7_texto_heading','PARTICIPAÇÃO DO ASSOCIADO EM CASO DE ACIONAMENTO DO PAM'),(1639,85,'_accordion_0_itm_txt_7_texto_heading','field_588f76e9cb9cf'),(1640,85,'accordion_0_itm_txt_7_cor_de_fundo',''),(1641,85,'_accordion_0_itm_txt_7_cor_de_fundo','field_588f91138c9fa'),(1642,85,'accordion_0_itm_txt_7_cor_do_texto',''),(1643,85,'_accordion_0_itm_txt_7_cor_do_texto','field_588f91eaa6afb'),(1644,85,'accordion_0_itm_txt_7_cor_do_icone',''),(1645,85,'_accordion_0_itm_txt_7_cor_do_icone','field_588f923ef5376'),(1646,85,'accordion_0_itm_txt_7_txt_flex','8 – Em caso de Colisão, Roubo ou Furto será exigido a Participação do Associado\r\n\r\n8.1 - Veículos Particulares:\r\n\r\nEm qualquer hipótese de uso dos benefícios do PAM, o associado responsável pelo veículo danificado participará dos custos decorrentes com a importância de 3% (três por cento)* do valor de seu veículo (tabela FIPE), não podendo este ser inferior à R$ 800,00 (oitocentos reais), além de sua mensalidade devida. Para Estados fora da sede da GASP os percentuais e valores de participação poderão ser diferentes.\r\n\r\n8.2 - Veículos de passeio de uso Aluguel, Táxi, fretamento ou comerciais/ Grupo Especial\r\n\r\nEm qualquer hipótese de uso dos benefícios do PAM, o associado responsável pelo veículo danificado participará dos custos decorrentes com a importância de 4,0% (quatro por cento)* do valor de seu veículo (tabela FIPE), não podendo este ser inferior à R$ 1.200,00 (hum mil e duzentos reais), além de sua mensalidade devida.\r\n\r\n8.3 - Veículos de Diesel / Vans / Caminhonetes / Importados\r\n\r\nEm qualquer hipótese de uso dos benefícios do PAM, o associado responsável pelo veículo danificado participará dos custos decorrentes com a importância de 4,0% (quatro por cento)* do valor de seu veículo (tabela FIPE), não podendo este ser inferior à R$ 1.800,00 (hum mil e oitocentos reais), além de sua mensalidade devida.\r\n\r\n8.4 – Os valores aqui dispostos deverão ser pagos no ato da autorização dos reparos. Os reparos somente serão iniciados mediante a quitação da participação do associado.\r\n\r\n* Pode haver variação de percentual por região, consulte tabela.'),(1647,85,'_accordion_0_itm_txt_7_txt_flex','field_588f82b779e0d'),(1648,85,'accordion_0_itm_txt_8_texto_heading','OBRIGAÇÕES DO ASSOCIADO PARTICIPANTE DO PAM'),(1649,85,'_accordion_0_itm_txt_8_texto_heading','field_588f76e9cb9cf'),(1650,85,'accordion_0_itm_txt_8_cor_de_fundo',''),(1651,85,'_accordion_0_itm_txt_8_cor_de_fundo','field_588f91138c9fa'),(1652,85,'accordion_0_itm_txt_8_cor_do_texto',''),(1653,85,'_accordion_0_itm_txt_8_cor_do_texto','field_588f91eaa6afb'),(1654,85,'accordion_0_itm_txt_8_cor_do_icone',''),(1655,85,'_accordion_0_itm_txt_8_cor_do_icone','field_588f923ef5376'),(1656,85,'accordion_0_itm_txt_8_txt_flex','9 - São obrigações do Associado\r\n\r\n9.1 - Agir com lealdade a boa fé com os demais associados e com a Associação, sempre velando pelo seu regular funcionamento e sua boa imagem e buscando alcançar os fins institucionais, sob pena de ser automaticamente excluído do PAM e do quadro de associados da GASP, sem prejuízo das sanções legais cabíveis.\r\n\r\n9.2 - Cumprir todas as normas estabelecidas no estatuto social e neste regulamento, bem como outras a serem expedidas formalmente pela Diretoria Executiva;\r\n\r\n9.3 - Pagar em dia os valores das mensalidades devidas, além de contribuir no prazo e na forma estabelecida pela Diretoria Executiva;\r\n\r\n9.3.1 – Ressalta-se que os pagamentos do associado serão devidos e obrigatórios, ainda que seu veículo esteja fora de uso, guardado ou sofrendo reparos em fun- ção de eventos danosos.\r\n\r\n9.4 - Manter o veículo em bom estado de conservação;\r\n\r\n9.5 - Dar imediato conhecimento a GASP caso ocorram as condições abaixo, sob pena de perda dos benefícios:\r\n\r\na) Mudança de domicílio fiscal, ou qualquer dado pessoal informado no cadastro;\r\nb) Alteração na forma de utilização do veículo;\r\nc) Transferência de propriedade;\r\nd) Alteração das características do veículo.\r\n9.6 - O associado deve tomar todas as providências ao seu alcance para proteger o veículo acidentado e evitar o agravamento dos prejuízos, sob pena de ser considerado responsável pelos mesmos.\r\n\r\n9.7 - Empenhar todos os esforços para ser ressarcido de prejuízos causados por terceiros, e caso haja o ressarcimento pelo PAM, a colaborar para que a associa- ção seja ressarcida junto aos terceiros causadores dos prejuízos.\r\n\r\n9.8 – Informar imediatamente as autoridades policiais em caso de evento, desaparecimento, roubo ou furto do veículo do associado.\r\n\r\n9.9 - Na ocorrência de qualquer dos eventos previstos para ressarcimento neste regulamento, o associado deve tomar as seguintes providencias:\r\n\r\nI. Acionar a GASP imediatamente;\r\nII. Acionar a polícia militar, para que seja realizada a ocorrência policial, no local e na hora que tenha ocorrido o acidente, roubo ou furto, relatando completa e minuciosamente o fato no BOLETIM DE OCORRÊNCIA, mencionando dia, hora, local, circunstância do acidente, nome de quem dirigia o veículo, nome e endereço de testemunhas e providências de ordem policial tomadas.;\r\nIII. Não fazer acordos sem comunicar a GASP;\r\nIV. Em acidentes com envolvimentos de terceiros, identificá-los, quando possível, no registro policial juntamente com os dados de duas testemunhas do acidente;\r\nV. No caso de roubo ou furto, se o veículo possuir rastreador ou localizador, acionar a empresa prestadora de serviço que deverá tomar as devidas providências para a localização, rastreamento e bloqueio do veículo;\r\nVI. Exigir da empresa prestadora de serviço de guincho o Laudo de Vistoria do veículo acidentado, feito no local do acidente, antes do deslocamento do mesmo.\r\n9.9.1 – Somente serão beneficiados os prejuízos em que o boletim de ocorrência for lavrado no dia e na hora do evento, sem ressalvas.\r\n\r\n9.9.2 – Para fazer o acionamento do PAM, o associado deverá entrar em contato diretamente com a sede da GASP, para lavrar termo de Acionamento e Sub Roga- ção de Direitos, com informações sobre o ocorrido. A diretoria poderá ainda solicitar o comparecimento do associado na sede GASP para prestar esclarecimentos do ocorrido.\r\n\r\n9.10 - Aguardar a autorização da GASP para iniciar a reparação de quaisquer danos, sob pena de arcar com os prejuízos sem o benefício do rateio entre associados.\r\n\r\n9.11 – Sempre observar e ler atentamente espaço reservado para mensagens no boleto de pagamento mensal e o site (www.linhafacil.com.br), que são os instrumentos oficiais de comunicação da GASP com seu associado participante do PAM. Qualquer alteração do presente regulamento será informada aos associados através destes dois instrumentos, e o vincularão a partir do pagamento do boleto, ou da postagem da mensagem no site.'),(1657,85,'_accordion_0_itm_txt_8_txt_flex','field_588f82b779e0d'),(1658,85,'accordion_0_itm_txt_9_texto_heading','RESSARCIMENTO AO ASSOCIADO PARTICIPANTE DO PAM'),(1659,85,'_accordion_0_itm_txt_9_texto_heading','field_588f76e9cb9cf'),(1660,85,'accordion_0_itm_txt_9_cor_de_fundo',''),(1661,85,'_accordion_0_itm_txt_9_cor_de_fundo','field_588f91138c9fa'),(1662,85,'accordion_0_itm_txt_9_cor_do_texto',''),(1663,85,'_accordion_0_itm_txt_9_cor_do_texto','field_588f91eaa6afb'),(1664,85,'accordion_0_itm_txt_9_cor_do_icone',''),(1665,85,'_accordion_0_itm_txt_9_cor_do_icone','field_588f923ef5376'),(1666,85,'accordion_0_itm_txt_9_txt_flex','10 – Em caso de ressarcimento integral, a associação poderá fazê-lo de uma só vez, parcelado ou através da compra de outro bem com as mesmas características de marca/modelo e ano do veículo cadastrado, de acordo com as condições econômicas da associação e mediante decisão fundamentada da Diretoria Executiva.\r\n\r\n10.1 - O pagamento em caso de Ressarcimento Integral somente será efetuado mediante a apuração do rateio integral do veiculo, respeitando o prazo mínimo de 90 (noventa) dias a contar da apresentação de todos os documentos exigidos, respeitada a norma anterior.\r\n\r\n10.2 – O referido prazo será suspenso a partir do momento em que for solicitada documentação complementar no caso de dúvida fundada e justificável ou no caso que for instaurado inquérito policial, perícia ou sindicância para apurar as causas do acidente, do furto e/ou do roubo.\r\n\r\n10.3 - Para poder usufruir dos benefícios oferecidos pelo PAM da GASP, o associado deverá estar rigorosamente quites com todas as suas obrigações perante a Associação e ao PAM, além de cumprir as demais obrigações estabelecidas neste regulamento, no regimento interno e no estatuto social.\r\n\r\n10.4 - Qualquer ressarcimento somente será realizado mediante apresentação de TODOS os documentos requeridos pela GASP.\r\n\r\n10.5 – Caso o veículo seja inalienável e haja saldo devedor, a GASP entregará outro bem mediante a transferência da alienação, ou pagará o valor correspondente diretamente ao credor, e havendo saldo remanescente, ao associado.\r\n\r\n10.5.1 – Caso o débito junto ao credor seja superior ao valor do bem, com base na Tabela FIpe, o pagamento ao credor somente será efetuado mediante o pagamento conjunto por parte do associado de sua parte, liberando o gravame.\r\n\r\n10.6 - O ressarcimento ao associado será efetuado somente após a apresentação de todos os documentos requeridos pela GASP. As indenizações serão pagas em cheque nominal e cruzado, ou através da reposição do bem por outro da mesma espécie e tipo, conforme acordado entre as partes, sempre deduzindo a participa- ção do associado prevista nas cláusulas 8.1, 8.2 e 8.3.\r\n\r\n10.7 - Para fazer jus ao ressarcimento integral, o veículo deverá estar livre e desembaraçado de qualquer gravame ou impedimento, seja judicial, administrativo ou qualquer outro. Para ter direito ao ressarcimento, deverá o associado regulari- zar a situação e após apresentar toda a documentação regularizada à GASP.\r\n\r\n10.8 - Quando o veículo do associado a ser ressarcido fizer parte do conjunto de bens de um espólio ou massa falida, a indenização será realizada em nome do espólio ou da massa, mediante recibo assinado pelo inventariante e/ou síndico legalmente constituídos, respectivamente.\r\n\r\n10.9 - Caso o Associado faça a opção aderir ao PAM, em hipótese alguma será admitida a participação do veículo incluso nesta modalidade em outra associação ou ainda em modalidade similar a esta e, inclusive a participação em seguro particular de casco, sob pena de tornar-se nula a presente proteção.'),(1667,85,'_accordion_0_itm_txt_9_txt_flex','field_588f82b779e0d'),(1668,85,'accordion_0_itm_txt_10_texto_heading','DOCUMENTOS NECESSÁRIOS PARA O RESSARCIMENTO'),(1669,85,'_accordion_0_itm_txt_10_texto_heading','field_588f76e9cb9cf'),(1670,85,'accordion_0_itm_txt_10_cor_de_fundo',''),(1671,85,'_accordion_0_itm_txt_10_cor_de_fundo','field_588f91138c9fa'),(1672,85,'accordion_0_itm_txt_10_cor_do_texto',''),(1673,85,'_accordion_0_itm_txt_10_cor_do_texto','field_588f91eaa6afb'),(1674,85,'accordion_0_itm_txt_10_cor_do_icone',''),(1675,85,'_accordion_0_itm_txt_10_cor_do_icone','field_588f923ef5376'),(1676,85,'accordion_0_itm_txt_10_txt_flex','11 - Caso o associado venha sofrer danos no seu veículo cadastrado, o ressarcimento dos valores correspondentes ou a reposição do bem ficará condicionada à apresentação dos seguintes documentos:\r\n\r\n11.1 - Em caso de danos reparáveis:\r\n\r\nBoletim de ocorrência\r\nXerox da Carteira de Habilitação do condutor do veículo; .\r\nXerox do CRLV (Certificado de registro e licenciamento do veículo).\r\n11.2 - Em caso de danos irreparáveis:\r\n\r\n11.2.1 - Em se tratando de associado pessoa física:\r\n\r\nCópia do CPF e RG do associado;\r\nCRV Certificado de Registro de Veículo original (documento de transferência) devidamente preenchido a favor da GASP ou de quem esta indicar, assinado e com firma reconhecida por autenticidade;\r\nCRLV (Certificado de Registro e Licenciamento do Veículo) original, com a prova de quitação Seguro obrigatório e IPVA dos dois últimos anos de licenciamento;\r\nBoletim de Ocorrência original ou cópia autêntica;\r\nXerox da Carteira de habilitação do condutor do veículo;\r\nChaves do veículo;\r\nCertidão negativa de furto e multa do veículo\r\nDemais documentos que possam ser solicitados;\r\n11.2.2 - Em se tratando de associado pessoa jurídica:\r\n\r\nCRV Certificado de Registro de veículo original (documento de transferência) devidamente preenchido a favor da GASP ou de quem esta indicar, assinado e com firma reconhecida por autenticidade;\r\nCRLV (Certificado de Registro e Licenciamento do Veículo) original, com a prova de quitação Seguro Obrigatório e IPVA dos dois últimos anos de licenciamento;\r\nBoletim de Ocorrência original ou cópia autêntica;\r\nXerox da Carteira de habilitação do condutor do veículo;\r\nChaves do veículo; . Certidão negativa de furto e multa do veículo;\r\nCópia do Contrato ou Estatuto Social, com alterações;\r\nNota fiscal de venda a GASP, quando o objetivo social da empresa for indústria, comércio, importação, exportação etc. (Prestação de serviço e leasing não necessitam emitir esta nota fiscal).\r\n11.3 - Em caso de Ressarcimento Integral decorrente de Roubo ou Furto:\r\n\r\nTodos os documentos exigidos na cláusula 11.2.1 e 11.2.2, exceto nota fiscal;\r\nExtrato do DETRAN (débitos e restrições) constando queixa de roubo/furto;\r\nCertidão negativa de multas do veículo.'),(1677,85,'_accordion_0_itm_txt_10_txt_flex','field_588f82b779e0d'),(1678,85,'accordion_0_itm_txt_11_texto_heading','DISPOSIÇÕES FINAIS'),(1679,85,'_accordion_0_itm_txt_11_texto_heading','field_588f76e9cb9cf'),(1680,85,'accordion_0_itm_txt_11_cor_de_fundo',''),(1681,85,'_accordion_0_itm_txt_11_cor_de_fundo','field_588f91138c9fa'),(1682,85,'accordion_0_itm_txt_11_cor_do_texto',''),(1683,85,'_accordion_0_itm_txt_11_cor_do_texto','field_588f91eaa6afb'),(1684,85,'accordion_0_itm_txt_11_cor_do_icone',''),(1685,85,'_accordion_0_itm_txt_11_cor_do_icone','field_588f923ef5376'),(1686,85,'accordion_0_itm_txt_11_txt_flex','12 - Com o pagamento do ressarcimento, a GASP ficará sub-rogada em todos os direitos e ações do associado contra aquele que por ato, fato ou omissão tenham causado os prejuízos ou para eles contribuído.\r\n\r\n12.1 - Fica eleito a comarca onde estiver localizada a sede da GASP para dirimir quaisquer dúvidas que surgirem relativas ao PAM, afastando quaisquer outros foros por mais privilegiados que sejam.\r\n\r\n12.2 - O associado declara que todas as informações prestadas por ele a GASP serão verdadeiras e, caso fique comprovada a inveracidade de qualquer informa- ção ou declaração emitida pelo associado, o mesmo será imediatamente excluído do PAM bem como eliminado do quadro social da GASP, nos termos do Estatuto Social, sem prejuízo das sanções legais.\r\n\r\n12.3 - O associado declara ter lido este regulamento e ter pleno conhecimento de todas as normas contidas no regulamento PAM e no estatuto social da GASP, e que aceitam todas as condições estabelecidas neste documento para associarem-se.\r\n\r\n12.4 - O presente regulamento entra em vigor na data da Assembléia Geral que o instituiu, revogando todas as disposições anteriores em contrário.\r\n\r\n12.5 - Os casos omissos no presente regulamento serão analisados pela Diretoria Executiva, sendo a decisão levada ao conhecimento da Assembléia Geral subseqüente ao saneamento da omissão, após a ciência e ratificação, as decisões terão força normativa e deverão ser aplicadas a todos os casos semelhantes e análogos, no que for aplicável.'),(1687,85,'_accordion_0_itm_txt_11_txt_flex','field_588f82b779e0d'),(1688,198,'acordions',''),(1689,198,'_acordions','field_5887501a480ec'),(1690,198,'texto_diferenciado','Regulamento de Veículos Leve'),(1691,198,'_texto_diferenciado','field_58862a7dd9d12'),(1692,198,'accordion_0_itm_txt_0_texto_heading','DAS CONDIÇÕES GERAIS DE PARTICIPAÇÃO'),(1693,198,'_accordion_0_itm_txt_0_texto_heading','field_588f76e9cb9cf'),(1694,198,'accordion_0_itm_txt_0_cor_de_fundo',''),(1695,198,'_accordion_0_itm_txt_0_cor_de_fundo','field_588f91138c9fa'),(1696,198,'accordion_0_itm_txt_0_cor_do_texto',''),(1697,198,'_accordion_0_itm_txt_0_cor_do_texto','field_588f91eaa6afb'),(1698,198,'accordion_0_itm_txt_0_cor_do_icone',''),(1699,198,'_accordion_0_itm_txt_0_cor_do_icone','field_588f923ef5376'),(1700,198,'accordion_0_itm_txt_0_txt_flex','1 – O Programa de Auxílio Mútuo (PAM) da GASP tem como objetivo primordial conferir proteção e segurança aos automóveis de seus associados aderentes ao programa, através do rateio dos danos materiais eventualmente sofridos e acobertados pelo programa, na forma deste regulamento, bem como através da prevenção ativa de acidentes, pela veiculação de material educativo pertinente às normas de segurança no trânsito.\r\n\r\n1.2 - Para participar do Programa de Auxílio Mútuo (PAM) o associado deve estar devidamente filiado a GASP e, voluntariamente, indicar seu interesse na participação do referido programa, através de termo de adesão próprio. Ao aderir voluntariamente aos programas, o associado se compromete a contribuir com as cotas necessária referente às despesas apuradas para a consecução dos benefí- cios através do MUTUALISMO, ou seja, repartição proporcional dos programas de assistência de eventos danosos já ocorridos através de rateio de despesas.'),(1701,198,'_accordion_0_itm_txt_0_txt_flex','field_588f82b779e0d'),(1702,198,'accordion_0_itm_txt','a:12:{i:0;s:5:\"txt_2\";i:1;s:5:\"txt_2\";i:2;s:5:\"txt_2\";i:3;s:5:\"txt_2\";i:4;s:5:\"txt_2\";i:5;s:5:\"txt_2\";i:6;s:5:\"txt_2\";i:7;s:5:\"txt_2\";i:8;s:5:\"txt_2\";i:9;s:5:\"txt_2\";i:10;s:5:\"txt_2\";i:11;s:5:\"txt_2\";}'),(1703,198,'_accordion_0_itm_txt','field_588f7649cb9ce'),(1704,198,'accordion','1'),(1705,198,'_accordion','field_588f7627cb9cd'),(1706,198,'accordion_0_itm_txt_1_texto_heading','ADESÃO AO PROGRAMA DE AUXÍLIO MÚTUO (PAM)'),(1707,198,'_accordion_0_itm_txt_1_texto_heading','field_588f76e9cb9cf'),(1708,198,'accordion_0_itm_txt_1_cor_de_fundo',''),(1709,198,'_accordion_0_itm_txt_1_cor_de_fundo','field_588f91138c9fa'),(1710,198,'accordion_0_itm_txt_1_cor_do_texto',''),(1711,198,'_accordion_0_itm_txt_1_cor_do_texto','field_588f91eaa6afb'),(1712,198,'accordion_0_itm_txt_1_cor_do_icone',''),(1713,198,'_accordion_0_itm_txt_1_cor_do_icone','field_588f923ef5376'),(1714,198,'accordion_0_itm_txt_1_txt_flex','2 - Para aderir ao PAM da GASP, o associado deverá encaminhar à Diretoria da Associação os seguintes documentos, além de pagar a taxa de adesão e submeter seu veículo à aprovação da vistoria:\r\n\r\n2.1 – Termo de adesão em modelo próprio;\r\n\r\nCarteira nacional de habilitação atualizada;\r\nCRV do veículo, ou nota fiscal em caso de 0km;\r\nContrato social ou estatuto social, caso seja pessoa jurídica;\r\nComprovante de residência atualizado.\r\n2.2 - O período mínimo de participação no PAM da GASP é de 6 (seis) meses, contados a partir da adesão ao programa e em caso de evento com o veículo.\r\n\r\n2.2.1 - Será permitida a transferência de titularidade de um veículo cadastrado no PAM, desde que o novo associado titular pague os custos de uma nova vistoria. Caso o proponente não seja associado, deverá propor sua admissão ao quadro de associados da GASP. Este procedimento estará condicionado ao pagamento de uma nova taxa de adesão, efetuar uma nova vistoria prévia e aprovação expressa da diretoria da Associação.\r\n\r\n2.2.2 - Será permitida a substituição de um veículo cadastrado no PAM, desde que o associado pague uma taxa relativa a substituição e que o veículo não tenha nenhum impedimento quanto a sua aceitação no programa. Este procedimento estará condicionado a aprovação expressa da diretoria da Associação.\r\n\r\n2.3 – O associado que desejar se desligar do PAM deverá solicitar formulário de cancelamento da associação, devendo o associado estar adimplente com todas as suas obrigações relativas ao PAM. O requerimento deverá conter as seguintes informações: Nome completo, CPF, modelo do veículo, placa, e motivo do desligamento.\r\n\r\n2.3.1 – O pedido de desligamento do PAM poderá ser realizado em qualquer dia do mês, ficando clara a responsabilidade pelo pagamento do próximo mês independente do dia em que for realizado o pedido de desligamento, inexistindo cobrança pro-rata.\r\n\r\n2.4 – Caso o associado ou o veículo cadastrado se envolva em mais de 1 (um) evento danoso no período de 12 (doze) meses, este poderá ser excluído compulsoriamente do PAM, a critério da Diretoria Executiva, e assegurado o direito a recurso administrativo e após este, pedido de reconsideração.\r\n\r\n2.4.1 - No caso do segundo acionamento no período de 1 (um) ano, o segundo acionamento terá a incidência do valor da participação do associado prevista na cláusula 8 e seguintes, em dobro. No caso de terceiro acionamento no período de 1 (um) ano, o valor será triplicado, e assim por diante.\r\n\r\n2.5 – Após a aceitação da adesão, associados participantes do PAM deverão pagar os valores abaixo identificados:\r\n\r\na) Contribuição associativa mensal da GASP, no valor mensal de R$ 10,00 (dez reais);\r\n\r\nb) Taxa administrativa mensal do PAM, conforme tabela da associação, por cada veículo cadastrado;\r\n\r\n2.5.1 – A contribuição associativa mensal da GASP já é de obrigação de cada associado, conforme previsto na proposta de admissão e no estatuto social, independente da adesão ao PAM. Caso se desligue do PAM, o associado voltará a pagar somente a contribuição associativa, nos termos do regimento interno da GASP'),(1715,198,'_accordion_0_itm_txt_1_txt_flex','field_588f82b779e0d'),(1716,198,'accordion_0_itm_txt_2_texto_heading','ACEITAÇÃO E VIGÊNCIA DO PROGRAMA DE AUXÍLIO MÚTUO (PAM)'),(1717,198,'_accordion_0_itm_txt_2_texto_heading','field_588f76e9cb9cf'),(1718,198,'accordion_0_itm_txt_2_cor_de_fundo',''),(1719,198,'_accordion_0_itm_txt_2_cor_de_fundo','field_588f91138c9fa'),(1720,198,'accordion_0_itm_txt_2_cor_do_texto',''),(1721,198,'_accordion_0_itm_txt_2_cor_do_texto','field_588f91eaa6afb'),(1722,198,'